/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.access.details;

import com.aem.shelp.proxy.types.LocatedAlert;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.proxy.types.ResourceContainer;
import com.aem.shelp.tech.access.AccessPanelListener;
import com.aem.shelp.tech.access.details.MachineAlertsRenderer;
import com.aem.shelp.tech.alerts.alerts.model.AlertTreeModel;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import utils.swing.components.SHJTable;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.simplelist.SimpleList;
import utils.swing.simplelist.jtable.SimpleTableModel;
import utils.swing.simplelist.jtable.TableStructure;

public class MachineAlertsTable {
    private SimpleList<LocatedAlert> alertList = new SimpleList();
    private SimpleTableModel model;
    private SHJTable table;
    private AccessPanelListener accessPanelListener;
    private MachineAlertsRenderer alertsRenderer;
    private Machine machine;
    private AlertTreeModel alertModel;
    private static final int BUTTON_COL = 1;

    public MachineAlertsTable(AlertTreeModel alertModel, AccessPanelListener accessPanelListener) {
        this.accessPanelListener = accessPanelListener;
        this.alertModel = alertModel;
        this.initUI();
    }

    public JComponent getRootComponent() {
        return this.table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTriggeredAlerts(Machine machine) {
        this.machine = machine;
        this.alertList.startBatch();
        this.alertList.clear();
        try {
            ArrayList<String> triggeredIDs = machine.getMachineInfo().getTriggeredAlertIDs();
            for (String alertID : triggeredIDs) {
                ResourceContainer alert = (ResourceContainer)this.alertModel.getElementWithID(alertID);
                if (!(alert instanceof LocatedAlert) || alert == null) continue;
                this.alertList.add((LocatedAlert)alert);
            }
        }
        finally {
            this.alertList.endBatch();
        }
    }

    public static void main(String[] args) {
        SimpleHelpFrame frame = SimpleHelpFrame.getTestFrame();
        MachineAlertsTable table = new MachineAlertsTable(null, null);
        ArrayList<LocatedAlert> list = new ArrayList<LocatedAlert>();
        list.add(LocatedAlert.createTestAlert());
        list.add(LocatedAlert.createTestAlert());
        table.setAllAlerts(list);
        JScrollPane pane = new JScrollPane(table.getRootComponent());
        frame.getContentPane().add(pane);
        frame.setVisible(true);
    }

    private void initUI() {
        ConnectListener listener = new ConnectListener();
        TableStructure ts = TableStructure.createTableStructure(LocatedAlert.class, new String[]{"", ""}, new String[]{"", ""});
        ts.setAlignment(new int[]{2, 4});
        this.model = new SimpleTableModel(this.alertList, ts);
        this.table = new SHJTable(this.model);
        this.table.addMouseMotionListener(listener);
        this.table.addMouseListener(listener);
        this.table.setRowHeight(SimpleHelpLookAndFeel.scale(26));
        this.table.setAutoResizeMode(4);
        this.alertsRenderer = new MachineAlertsRenderer();
        this.table.setDefaultRenderer(Object.class, this.alertsRenderer);
        this.table.setDefaultRenderer(Long.class, this.alertsRenderer);
        ts.setMinWidths(this.alertsRenderer.getFixedColumnSizes());
        ts.setMaxWidths(this.alertsRenderer.getFixedColumnSizes());
        ts.initTableDimensions(this.table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAllAlerts(ArrayList<LocatedAlert> alerts) {
        Collections.sort(alerts, new AlertComparator());
        this.alertList.startBatch();
        try {
            this.alertList.clear();
            for (LocatedAlert alert : alerts) {
                this.alertList.add(alert);
            }
        }
        finally {
            this.alertList.endBatch();
        }
    }

    class AlertComparator
    implements Comparator<LocatedAlert> {
        AlertComparator() {
        }

        @Override
        public int compare(LocatedAlert o1, LocatedAlert o2) {
            if (o1.isTriggered() && !o2.isTriggered()) {
                return -1;
            }
            if (o2.isTriggered() && !o1.isTriggered()) {
                return 1;
            }
            return o1.getName().compareTo(o2.getName());
        }
    }

    class ConnectListener
    implements MouseMotionListener,
    MouseListener {
        int hoverRow = -1;

        ConnectListener() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            try {
                if (e.getSource() == MachineAlertsTable.this.table) {
                    int previousRow = this.hoverRow;
                    this.hoverRow = MachineAlertsTable.this.table.rowAtPoint(e.getPoint());
                    if (this.hoverRow == previousRow) {
                        return;
                    }
                    this.repaintRows(this.hoverRow, previousRow);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }

        private void repaintRows(int hoverRow, int previousRow) {
            MachineAlertsTable.this.alertsRenderer.setHoverRow(hoverRow);
            if (hoverRow != -1) {
                MachineAlertsTable.this.table.repaint(MachineAlertsTable.this.table.getCellRect(hoverRow, 1, false));
            }
            if (previousRow != -1) {
                MachineAlertsTable.this.table.repaint(MachineAlertsTable.this.table.getCellRect(previousRow, 1, false));
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            LocatedAlert alert;
            Rectangle rect;
            int row = MachineAlertsTable.this.table.rowAtPoint(e.getPoint());
            if (row == this.hoverRow && (rect = MachineAlertsTable.this.table.getCellRect(row, 1, false)).contains(e.getPoint()) && e.getX() < rect.x + ((MachineAlertsTable)MachineAlertsTable.this).alertsRenderer.getButtonSize().width && (alert = (LocatedAlert)MachineAlertsTable.this.alertList.get(row)) != null) {
                MachineAlertsTable.this.accessPanelListener.showAlertInUI(alert);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            int previousRow = this.hoverRow;
            this.hoverRow = -1;
            this.repaintRows(this.hoverRow, previousRow);
        }
    }
}

