/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.access.details;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.types.LocatedAlert;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import utils.swing.RetinaImageIcon;
import utils.swing.SwingUtil;
import utils.swing.images.ImageLoader;

public class MachineAlertsRenderer
extends DefaultTableCellRenderer {
    private Color background;
    private int hoverRow = -1;
    private Image hoverImage;
    private Image nonHoverImage;
    private BufferedImage technicianImage;
    private ImageIcon hoverIcon;
    private ImageIcon nonHoverIcon;

    public MachineAlertsRenderer() {
        if (this.hoverImage == null) {
            this.hoverImage = SwingUtil.getButtonImage(Language.get("MACHINE_DETAILS_VIEW_ALERT"), true);
            this.nonHoverImage = SwingUtil.getButtonImage(Language.get("MACHINE_DETAILS_VIEW_ALERT"), false);
            this.technicianImage = new BufferedImage(this.hoverImage.getWidth(null), this.hoverImage.getHeight(null), 2);
            Graphics2D g2d = this.technicianImage.createGraphics();
            Icon imageIcon = ImageLoader.getImageIcon("images/svg/technology/screen.svg,16");
            imageIcon.paintIcon(null, g2d, this.hoverImage.getWidth(null) - imageIcon.getIconWidth(), (this.hoverImage.getHeight(null) - imageIcon.getIconHeight()) / 2);
            g2d.dispose();
            this.hoverIcon = new RetinaImageIcon(this.hoverImage);
            this.nonHoverIcon = new RetinaImageIcon(this.nonHoverImage);
        }
    }

    public Dimension getButtonSize() {
        return new Dimension(this.nonHoverImage.getWidth(null), this.nonHoverImage.getHeight(null));
    }

    public void setRowBackground(Color c) {
        this.background = c;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        label.setIcon(null);
        LocatedAlert alert = (LocatedAlert)value;
        if (column == 0) {
            label.setText(alert.getName().getName());
            if (alert.isTriggered()) {
                label.setIcon(ImageLoader.getImageIcon("images/svg/alert-flags/yellow.svg,16"));
            } else {
                label.setIcon(ImageLoader.getImageIcon("images/svg/alert-flags/blue-down.svg,24"));
            }
        } else if (column == 1) {
            label.setText("");
            if (this.hoverRow == row) {
                label.setIcon(this.hoverIcon);
            } else {
                label.setIcon(this.nonHoverIcon);
            }
        }
        return label;
    }

    public int[] getFixedColumnSizes() {
        return new int[]{-1, this.hoverIcon.getIconWidth() + 2};
    }

    @Override
    public void paintComponent(Graphics g) {
        this.setBackground(this.background);
        super.paintComponent(g);
    }

    public void setHoverRow(int row) {
        this.hoverRow = row;
    }
}

