/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.access.details;

import com.aem.shelp.common.Language;
import com.aem.shelp.common.toolbox.ToolBox;
import com.aem.shelp.common.toolbox.ToolBoxItem;
import com.aem.shelp.proxy.TechGroupPermissions;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.tech.access.AccessPanelListener;
import com.aem.shelp.tech.access.details.AddRemoveURLDialog;
import com.aem.shelp.tech.access.utils.MachineSelection;
import com.aem.shelp.tech.gstarted.TrialUtils;
import com.aem.shelp.tech.utils.tools.AbstractToolPopup;
import com.aem.shelp.tech.utils.tools.PickAndRunToolPopup;
import java.awt.Color;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import utils.swing.SwingUtil;
import utils.swing.components.JWrapLabel;
import utils.swing.components.LeftRightButton;
import utils.swing.components.LeftRightButtonInterface;
import utils.swing.components.LeftRightToggleButton;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;
import utils.switches.Switches;

public class AdvancedPanel
extends GbPanel
implements ActionListener {
    private LeftRightButton stopButton;
    private LeftRightButton blockButton;
    private LeftRightButton forgetButton;
    private LeftRightButton configureButton;
    private LeftRightButton migrateButton;
    private LeftRightButton runToolButton;
    private LeftRightButton upgradeButton;
    private LeftRightButton notifyButton;
    private AccessPanelListener accessPanelListener;
    private MachineSelection machines;
    private LeftRightToggleButton autoUpdateButton;
    private LeftRightToggleButton monitorButton;
    private LeftRightToggleButton stopWhenNextOnline;
    private LeftRightToggleButton autoUpdateWhenNextOnline;
    private LeftRightToggleButton migrateWhenNextOnline;
    private LeftRightToggleButton runToolWhenNextOnline;
    private JLabel summaryLabel;
    private JLabel advancedLabel;
    private JLabel offlineLabel;

    public AdvancedPanel(AccessPanelListener accessPanelListener) {
        super(new ScaledInsets(3, 3, 3, 3));
        this.setBorder(SHBorderFactory.createEmptyBorder(3, 0, 0, 0));
        this.accessPanelListener = accessPanelListener;
        this.initUI();
    }

    private JLabel getDescLabel(String text) {
        JWrapLabel descLabel = new JWrapLabel("<html>" + text);
        descLabel.setFont(SHStyle.smallerFont);
        descLabel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        return descLabel;
    }

    public void initUI() {
        this.stopButton = new LeftRightButton(Language.get("ACCESS_STOP"), ImageLoader.getImageIcon("images/svg/general/remove.svg,16"));
        this.stopWhenNextOnline = new LeftRightToggleButton(Language.get("ACCESS_STOP_NEXT_ONLINE"), ImageLoader.getImageIcon("images/svg/general/remove.svg,16"));
        this.blockButton = new LeftRightButton(Language.get("ACCESS_BLOCK"), ImageLoader.getImageIcon("images/svg/general/accessdenied.svg,16"));
        this.forgetButton = new LeftRightButton(Language.get("ACCESS_FORGET"), ImageLoader.getImageIcon("images/svg/general/eraser.svg,16"));
        this.autoUpdateButton = new LeftRightToggleButton(Language.get("SG_RESTART_SERVICE_SHORT"), ImageLoader.getImageIcon("images/svg/machine-state/restart.svg,16"));
        this.autoUpdateWhenNextOnline = new LeftRightToggleButton(Language.get("SG_RESTART_SERVICE_SHORT"), ImageLoader.getImageIcon("images/svg/machine-state/restart.svg,16"));
        this.upgradeButton = new LeftRightButton(Language.get("ACCESS_UPDATE"), ImageLoader.getImageIcon("images/svg/machine-state/upgrade.svg,16"));
        this.monitorButton = new LeftRightToggleButton(Language.get("MONITOR"), ImageLoader.getImageIcon("images/svg/charts/meter.svg,16"));
        this.configureButton = new LeftRightButton(Language.get("SG_CONFIGURE_SERVICE_SHORT"), ImageLoader.getImageIcon("images/svg/general/spanner-dark.svg,16"));
        this.runToolButton = new LeftRightButton(Language.get("TOOLBOX_RUN"), ImageLoader.getImageIcon("images/svg/general/box.svg,16"));
        this.runToolWhenNextOnline = new LeftRightToggleButton(Language.get("TOOLBOX_RUN"), ImageLoader.getImageIcon("images/svg/general/box.svg,16"));
        this.migrateButton = new LeftRightButton(Language.get("SG_CONFIGURE_MIGRATE"), ImageLoader.getImageIcon("images/svg/general/truck.svg,16"));
        this.migrateWhenNextOnline = new LeftRightToggleButton(Language.get("SG_CONFIGURE_MIGRATE"), ImageLoader.getImageIcon("images/svg/general/truck.svg,16"));
        this.notifyButton = new LeftRightButton(Language.get("RANOTIFY_BUTTON"), ImageLoader.getImageIcon("images/svg/chat/chat.svg,16"));
        this.summaryLabel = new JLabel(Language.get("ADVANCED_MACHINE_SETTINGS"));
        this.summaryLabel.setBorder(SHBorderFactory.createEmptyBorder(3, 0, 5, 0));
        this.summaryLabel.setFont(SHStyle.largeFont);
        this.summaryLabel.setVisible(false);
        this.advancedLabel = new JLabel(Language.get("ADVANCED_MACHINE_SETTINGS"));
        this.advancedLabel.setBorder(SHBorderFactory.createEmptyBorder(3, 0, 5, 0));
        this.advancedLabel.setFont(SHStyle.largeFont);
        this.offlineLabel = new JLabel(Language.get("ADVANCED_QUEUE_ACTIONS"));
        this.offlineLabel.setBorder(SHBorderFactory.createEmptyBorder(3, 0, 5, 0));
        this.offlineLabel.setFont(SHStyle.largeFont);
        int Y = 0;
        this.add(this.summaryLabel, 0, Y++, 2, 1, 1, 0, 11, 2);
    }

    public void initUIWithPermissions(TechGroupPermissions permissions) {
        boolean allowsMassNotify = this.accessPanelListener.getTechClient().allowsMassNotify();
        boolean allowsMassToolbox = this.accessPanelListener.getTechClient().allowsMassToolbox();
        int advancedPanelIndex = -1;
        int offlinePanelIndex = -1;
        if (TrialUtils.amTriallingBizOrEnt()) {
            allowsMassNotify = true;
            allowsMassToolbox = true;
        }
        ArrayList<AbstractButton> buttons = new ArrayList<AbstractButton>();
        ArrayList<String> descriptions = new ArrayList<String>();
        int Y = this.getComponentCount();
        if (permissions.canManageMonitoring()) {
            buttons.add(this.monitorButton);
            descriptions.add(Language.get("ACCESS_MONITOR_DESC"));
        }
        if (permissions.canManagePersistentConnections()) {
            buttons.add(this.upgradeButton);
            descriptions.add(Language.get("ACCESS_UPDATE_DESC"));
            buttons.add(this.autoUpdateButton);
            descriptions.add(Language.get("ACCESS_RESTART_DESC") + " " + Language.get("ACCESS_RESTART_DESC2"));
            buttons.add(this.configureButton);
            descriptions.add(Language.get("SG_CONFIGURE_SERVICE_DESC"));
        }
        if (allowsMassToolbox && permissions.canRunTools()) {
            buttons.add(this.runToolButton);
            descriptions.add(Language.get("TOOLBOX_DESCRIPTION"));
        }
        if (Switches.SH_remoteAccessNotify && permissions.canRunTools()) {
            buttons.add(this.notifyButton);
            descriptions.add(Language.get("RANOTIFY_DESCRIPTION"));
        }
        if (permissions.canManagePersistentConnections()) {
            advancedPanelIndex = buttons.size();
            buttons.add(this.forgetButton);
            descriptions.add(Language.get("ACCESS_FORGET_DESC"));
            buttons.add(this.stopButton);
            descriptions.add(Language.get("ACCESS_STOP_DESC"));
            buttons.add(this.blockButton);
            descriptions.add(Language.get("ACCESS_BLOCK_DESC"));
            buttons.add(this.migrateButton);
            descriptions.add(Language.get("ACCESS_MIGRATE_DESC"));
        }
        if (permissions.canManagePersistentConnections()) {
            offlinePanelIndex = buttons.size();
            buttons.add(this.autoUpdateWhenNextOnline);
            descriptions.add(Language.get("ACCESS_RESTART_DESC") + " " + Language.get("ACCESS_RESTART_DESC2"));
        }
        if (allowsMassToolbox && permissions.canRunTools()) {
            if (offlinePanelIndex == -1) {
                offlinePanelIndex = buttons.size();
            }
            buttons.add(this.runToolWhenNextOnline);
            descriptions.add(Language.get("TOOLBOX_DESCRIPTION"));
        }
        if (permissions.canManagePersistentConnections()) {
            if (offlinePanelIndex == -1) {
                offlinePanelIndex = buttons.size();
            }
            buttons.add(this.stopWhenNextOnline);
            descriptions.add(Language.get("ACCESS_STOP_DESC"));
            buttons.add(this.migrateWhenNextOnline);
            descriptions.add(Language.get("ACCESS_MIGRATE_DESC"));
        }
        for (int i = 0; i < buttons.size(); ++i) {
            AbstractButton button = (AbstractButton)buttons.get(i);
            if (button instanceof LeftRightButtonInterface) {
                ((LeftRightButtonInterface)((Object)button)).setRightColour(Color.GRAY);
            }
            button.addActionListener(this);
            button.setHorizontalAlignment(2);
            JLabel descLabel = this.getDescLabel((String)descriptions.get(i));
            if (advancedPanelIndex != -1 && i == advancedPanelIndex) {
                this.add(this.advancedLabel, 0, Y++, 2, 1, 1, 0, 11, 2);
            } else if (offlinePanelIndex != -1 && i == offlinePanelIndex) {
                this.add(this.offlineLabel, 0, Y++, 2, 1, 1, 0, 11, 2);
            }
            this.add(button, 0, Y, 1, 1, 0, 0, 10, 2, new Insets(3, 5, 3, 10));
            this.add(descLabel, 1, Y++, 1, 1, 1000, 0, 17, 2);
        }
        this.add(new JPanel(), 0, Y++, 1, 1, 1, 1, 10, 1);
    }

    public void runToolPopup(Machine machine, JComponent sourceButton) {
        this.runToolPopup(machine, sourceButton, this.accessPanelListener.getCurrentToolBox());
    }

    private void runToolPopup(Machine machine, JComponent sourceButton, ToolBox toolBox) {
        this.runToolPopup(new Machine[]{machine}, null, true, AbstractToolPopup.getOSFor(machine), machine.allowScripting() ? 1 : 0, sourceButton, toolBox);
    }

    private void runToolPopup(final Machine[] onlineMachines, final Machine[] offlineMachines, boolean enable, int[] operatingSystemsIncluded, int allowScriptingCount, JComponent sourceButton, ToolBox toolBox) {
        if (enable) {
            PickAndRunToolPopup toolPopup = new PickAndRunToolPopup(allowScriptingCount, operatingSystemsIncluded){

                @Override
                protected void executeTool(ToolBoxItem item, int sessionsToUse) {
                    if (onlineMachines != null && onlineMachines.length > 0) {
                        AdvancedPanel.this.accessPanelListener.runToolBoxItem(onlineMachines, item, sessionsToUse);
                    }
                    if (offlineMachines != null && offlineMachines.length > 0) {
                        AdvancedPanel.this.accessPanelListener.setRunToolBoxWhenNextOnline(offlineMachines, true, item, sessionsToUse);
                    }
                }
            };
            toolPopup.show(toolBox, sourceButton);
        } else if (offlineMachines != null) {
            this.accessPanelListener.setRunToolBoxWhenNextOnline(offlineMachines, false, null, 0);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.stopButton) {
            this.accessPanelListener.stopOrForgetMachines(this.machines.getAvailableMachines());
            this.accessPanelListener.setStopWhenNextOnline(this.machines.getOfflineMachines(), true);
        } else if (e.getSource() == this.stopWhenNextOnline) {
            this.accessPanelListener.setStopWhenNextOnline(this.machines.getOfflineMachines(), this.stopWhenNextOnline.isSelected());
        } else if (e.getSource() == this.notifyButton) {
            if (!this.accessPanelListener.getTechClient().allowsMassNotify() && !TrialUtils.amTriallingBizOrEnt()) {
                TrialUtils.massNotifyDisallowedPopup(SwingUtil.getRootPaneContainer(this), this, this.accessPanelListener.getTechClient());
            } else {
                this.accessPanelListener.configureRemoteMachinesNotification(this.machines.getAvailableMachines());
            }
        } else if (e.getSource() == this.runToolButton) {
            if (!this.accessPanelListener.getTechClient().allowsMassToolbox() && !TrialUtils.amTriallingBizOrEnt()) {
                TrialUtils.toolboxDisallowedPopup(SwingUtil.getRootPaneContainer(this), this, this.accessPanelListener.getTechClient());
            } else {
                this.runToolPopup(this.machines.getScriptableMachines(true), this.machines.getScriptableMachines(false), true, AbstractToolPopup.getOSFor(this.machines, false), this.machines.allowsScripting, this.runToolButton, this.accessPanelListener.getCurrentToolBox());
            }
        } else if (e.getSource() == this.runToolWhenNextOnline) {
            if (!this.accessPanelListener.getTechClient().allowsMassToolbox() && !TrialUtils.amTriallingBizOrEnt()) {
                TrialUtils.toolboxDisallowedPopup(SwingUtil.getRootPaneContainer(this), this, this.accessPanelListener.getTechClient());
            } else {
                this.runToolPopup(this.machines.getScriptableMachines(true), this.machines.getScriptableMachines(false), this.runToolWhenNextOnline.isSelected(), AbstractToolPopup.getOSFor(this.machines, false), this.machines.allowsScripting, this.runToolWhenNextOnline, this.accessPanelListener.getCurrentToolBox());
            }
        } else if (e.getSource() == this.blockButton) {
            this.accessPanelListener.setBlockMachine((Machine[])this.machines.getAllElements());
        } else if (e.getSource() == this.forgetButton) {
            this.accessPanelListener.stopOrForgetMachines(this.machines.getOfflineMachines());
        } else if (e.getSource() == this.autoUpdateButton || e.getSource() == this.autoUpdateWhenNextOnline) {
            boolean enable = e.getSource() == this.autoUpdateButton ? this.autoUpdateButton.isSelected() : this.autoUpdateWhenNextOnline.isSelected();
            this.accessPanelListener.setAutoUpdating(this.machines.getMachinesAutoUpdating(!enable), enable);
        } else if (e.getSource() == this.upgradeButton) {
            this.accessPanelListener.upgradeMachines(this.machines.getUpgradeMachines());
        } else if (e.getSource() == this.monitorButton) {
            boolean enable = this.monitorButton.isSelected();
            this.accessPanelListener.setMonitoring(this.machines, enable);
        } else if (e.getSource() == this.configureButton) {
            this.accessPanelListener.configureRemoteMachine(((Machine[])this.machines.getAllElements())[0]);
        } else if (e.getSource() == this.migrateButton) {
            this.migrate(this.machines.getAvailableMachines(), this.machines.getOfflineMachines(), true);
        } else if (e.getSource() == this.migrateWhenNextOnline) {
            this.migrate(null, this.machines.getOfflineMachines(), this.migrateWhenNextOnline.isSelected());
        }
    }

    private void migrate(Machine[] onlineMachines, Machine[] offlineMachines, boolean enableOffline) {
        if (!enableOffline) {
            this.accessPanelListener.setMigrateWhenNextOnline(offlineMachines, false, null, null);
        } else {
            AddRemoveURLDialog dialog = new AddRemoveURLDialog();
            dialog.showDialog(SwingUtil.getRootPaneContainer(this));
            if (dialog.isOK()) {
                String add = dialog.getAddURL();
                String remove = dialog.getRemoveURL();
                if (add != null || remove != null) {
                    if (onlineMachines != null) {
                        this.accessPanelListener.migrateServices(onlineMachines, add, remove);
                    }
                    if (offlineMachines != null) {
                        this.accessPanelListener.setMigrateWhenNextOnline(offlineMachines, true, add, remove);
                    }
                }
            }
        }
    }

    private void setButtonAndDescVisible(AbstractButton button, boolean visible) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            if (this.getComponent(i) != button) continue;
            this.getComponent(i).setVisible(visible);
            this.getComponent(i + 1).setVisible(visible);
            return;
        }
    }

    public void initSelectedMachines(MachineSelection machines) {
        this.machines = machines;
        if (machines.getMachineCount() == 1) {
            this.summaryLabel.setVisible(false);
        } else {
            this.summaryLabel.setText(machines.getMachineCount() + " " + Language.get("ACCESS_MACHINES"));
            this.summaryLabel.setVisible(true);
        }
        int offline = machines.offlineCount;
        int available = machines.availableCount;
        int monitorable = machines.allowsMonitoring;
        int updatable = machines.needRestartCount;
        int scriptable = machines.allowsScripting;
        int upgradable = machines.needUpgradeCount;
        int migratable = machines.availableCount - updatable - upgradable;
        boolean singleSelection = machines.machineCount == 1;
        this.setButtonAndDescVisible(this.configureButton, singleSelection && available == 1);
        this.setButtonAndDescVisible(this.stopButton, available > 0);
        this.setButtonAndDescVisible(this.stopWhenNextOnline, offline > 0);
        this.setButtonAndDescVisible(this.blockButton, true);
        this.setButtonAndDescVisible(this.forgetButton, machines.offlineCount > 0);
        this.setButtonAndDescVisible(this.runToolButton, scriptable > 0);
        this.setButtonAndDescVisible(this.runToolWhenNextOnline, offline > 0);
        this.setButtonAndDescVisible(this.monitorButton, monitorable > 0);
        this.setButtonAndDescVisible(this.upgradeButton, upgradable > 0);
        this.setButtonAndDescVisible(this.autoUpdateButton, updatable > 0);
        this.setButtonAndDescVisible(this.autoUpdateWhenNextOnline, offline > 0);
        this.setButtonAndDescVisible(this.migrateButton, migratable > 0);
        this.setButtonAndDescVisible(this.migrateWhenNextOnline, offline > 0);
        this.setButtonAndDescVisible(this.notifyButton, available > 0);
        this.offlineLabel.setVisible(this.autoUpdateWhenNextOnline.isVisible() || this.runToolWhenNextOnline.isVisible() || this.migrateWhenNextOnline.isVisible() || this.stopWhenNextOnline.isVisible());
        if (machines.autoUpdating == 0) {
            this.autoUpdateButton.setSelected(false);
        } else {
            this.autoUpdateButton.setSelected(true);
        }
        if (machines.monitored == 0) {
            this.monitorButton.setSelected(false);
        } else {
            this.monitorButton.setSelected(true);
        }
        this.stopWhenNextOnline.setSelected(machines.queuedStop > 0);
        this.migrateWhenNextOnline.setSelected(machines.queuedMigrate > 0);
        this.runToolWhenNextOnline.setSelected(machines.queuedRunTool > 0);
        if (!singleSelection || this.accessPanelListener.getTechClient().amOverMachineLimit()) {
            this.runToolButton.setLeftRightText(Language.get("TOOLBOX_RUN"), "" + monitorable);
            this.stopButton.setLeftRightText(Language.get("ACCESS_STOP"), "" + available);
            this.blockButton.setLeftRightText(Language.get("ACCESS_BLOCK"), "" + machines.machineCount);
            this.forgetButton.setLeftRightText(Language.get("ACCESS_FORGET"), "" + machines.machineCount);
            this.autoUpdateButton.setLeftRightText(Language.get("SG_RESTART_SERVICE_SHORT"), "" + updatable);
            this.upgradeButton.setLeftRightText(Language.get("ACCESS_UPDATE"), "" + upgradable);
            this.monitorButton.setLeftRightText(Language.get("MONITOR"), "" + monitorable);
            this.stopWhenNextOnline.setLeftRightText(Language.get("ACCESS_STOP_NEXT_ONLINE"), "" + available);
            this.migrateButton.setLeftRightText(Language.get("SG_CONFIGURE_MIGRATE"), "" + migratable);
        }
        if (this.accessPanelListener.getTechClient().amOverMachineLimit()) {
            this.advancedLabel.setVisible(false);
            this.setButtonAndDescVisible(this.monitorButton, false);
            this.setButtonAndDescVisible(this.autoUpdateButton, false);
            this.setButtonAndDescVisible(this.runToolButton, false);
            this.setButtonAndDescVisible(this.notifyButton, false);
        } else {
            this.advancedLabel.setVisible(true);
        }
    }
}

