/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.access.details;

import com.aem.sdesktop.SessionPerformance;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.config.TransientTechUser;
import com.aem.shelp.proxy.techclient.ClientFeatures;
import com.aem.shelp.proxy.types.AbstractSession;
import com.aem.shelp.tech.access.AccessPanelListener;
import com.aem.shelp.tech.access.details.ActiveSessionRenderer;
import com.aem.shelp.tech.access.model.machine.MachineTreeModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import utils.swing.components.ColorPropagatingPanel;
import utils.swing.components.SHJTable;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.simplelist.SimpleList;
import utils.swing.simplelist.jtable.SimpleTableModel;
import utils.swing.simplelist.jtable.TableStructure;

public class ActiveSessionTable {
    private final SimpleList<AbstractSession> sessionList = new SimpleList();
    private SimpleTableModel model;
    private ActiveSessionTableQueryThread queryThread;
    private JPanel rootComponent = new ColorPropagatingPanel(new BorderLayout()){

        @Override
        public void setBackground(Color c) {
            super.setBackground(c);
            if (ActiveSessionTable.this.table != null) {
                ActiveSessionTable.this.table.setBackground(c);
                ActiveSessionTable.this.table.getTableHeader().setBackground(c);
            }
        }
    };
    private SHJTable table;
    private AccessPanelListener accessPanelListener;
    private ActiveSessionRenderer activeSessionRenderer;
    private int terminateButtonIndex = 5;
    private final Object PERF_LOCK = new Object();

    public ActiveSessionTable(MachineTreeModel model, AccessPanelListener accessPanelListener) {
        this.accessPanelListener = accessPanelListener;
        this.initUI();
    }

    public static boolean canTerminateSession(AccessPanelListener accessPanelListener, AbstractSession session, int row) {
        if (row == -1) {
            return false;
        }
        TransientTechUser techUser = accessPanelListener.getTechClient().getTechUser();
        return techUser.canTerminateSession(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getPerformanceStats() throws Exception {
        String[] allIDS;
        System.out.println("[ActiveSessionTable] Querying session performance metrics...");
        SimpleList<AbstractSession> simpleList = this.sessionList;
        synchronized (simpleList) {
            allIDS = new String[this.sessionList.size()];
            for (int i = 0; i < allIDS.length; ++i) {
                allIDS[i] = this.sessionList.get(i).getSessionID();
            }
        }
        SessionPerformance[] stats = this.accessPanelListener.getPerformanceStatsFor(allIDS);
        if (stats == null) {
            return;
        }
        SimpleList<AbstractSession> simpleList2 = this.sessionList;
        synchronized (simpleList2) {
            for (int i = 0; i < allIDS.length; ++i) {
                if (stats[i] == null) continue;
                AbstractSession abstractSession = this.sessionList.get(i);
                abstractSession.setTransientStats(stats[i]);
                this.sessionList.notifyElementUpdate(abstractSession);
            }
        }
    }

    public JComponent getRootComponent() {
        return this.rootComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSessions(ArrayList<AbstractSession> sessions) {
        if (this.queryThread == null) {
            this.queryThread = new ActiveSessionTableQueryThread();
            if (ClientFeatures.showPerformanceMetricsInAccessTab) {
                this.queryThread.start();
                this.rootComponent.add((Component)this.table.getTableHeader(), "North");
                this.rootComponent.revalidate();
                this.rootComponent.repaint();
            } else {
                for (int i = 2; i <= 4; ++i) {
                    this.table.getColumnModel().getColumn(i).setMinWidth(1);
                    this.table.getColumnModel().getColumn(i).setPreferredWidth(1);
                    this.table.getColumnModel().getColumn(i).setWidth(1);
                }
                this.table.doLayout();
                this.table.revalidate();
                this.table.repaint();
            }
        }
        Object object = this.sessionList;
        synchronized (object) {
            this.sessionList.startBatch();
            this.sessionList.clear();
            try {
                if (sessions != null) {
                    for (AbstractSession session : sessions) {
                        this.sessionList.add(session);
                    }
                }
            }
            finally {
                this.sessionList.endBatch();
            }
        }
        object = this.PERF_LOCK;
        synchronized (object) {
            this.PERF_LOCK.notify();
        }
    }

    private void initUI() {
        DisconnectListener listener = new DisconnectListener();
        TableStructure ts = TableStructure.createTableStructure(AbstractSession.class, new String[]{"", "getIncrementedElapsedTime", "getPerformanceColourDepth", "getPerformanceFPS", "getPerformanceConnetionType", ""}, new String[]{"", "", "", "", "", ""});
        this.model = new SimpleTableModel(this.sessionList, ts);
        this.table = new SHJTable(this.model);
        this.table.addMouseMotionListener(listener);
        this.table.addMouseListener(listener);
        this.table.setRowHeight(SimpleHelpLookAndFeel.scale(26));
        this.table.getColumnModel().getColumn(2).setHeaderValue(Language.get("COLOUR"));
        this.table.getColumnModel().getColumn(3).setHeaderValue(Language.get("UPDATES_FREQUENCY_FPS"));
        this.table.getColumnModel().getColumn(4).setHeaderValue(Language.get("CONNECTION_TYPE"));
        this.rootComponent.add((Component)this.table, "Center");
        this.activeSessionRenderer = new ActiveSessionRenderer(this.accessPanelListener, this.terminateButtonIndex);
        this.table.setDefaultRenderer(Object.class, this.activeSessionRenderer);
        this.table.setDefaultRenderer(Long.class, this.activeSessionRenderer);
        this.table.setDefaultRenderer(String.class, this.activeSessionRenderer);
        ts.setMinWidths(this.activeSessionRenderer.getMinColumnSizes());
        ts.setMaxWidths(this.activeSessionRenderer.getMaxColumnSizes());
        ts.setWidths(this.activeSessionRenderer.getMaxColumnSizes());
        ts.initTableDimensions(this.table);
    }

    class DisconnectListener
    implements MouseMotionListener,
    MouseListener {
        int hoverRow = -1;

        DisconnectListener() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            try {
                if (e.getSource() == ActiveSessionTable.this.table) {
                    int previousRow = this.hoverRow;
                    this.hoverRow = ActiveSessionTable.this.table.rowAtPoint(e.getPoint());
                    if (this.hoverRow == previousRow) {
                        return;
                    }
                    this.repaintRows(this.hoverRow, previousRow);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }

        private void repaintRows(int hoverRow, int previousRow) {
            ActiveSessionTable.this.activeSessionRenderer.setHoverRow(hoverRow);
            if (hoverRow != -1) {
                ActiveSessionTable.this.table.repaint(ActiveSessionTable.this.table.getCellRect(hoverRow, ActiveSessionTable.this.terminateButtonIndex, false));
            }
            if (previousRow != -1) {
                ActiveSessionTable.this.table.repaint(ActiveSessionTable.this.table.getCellRect(previousRow, ActiveSessionTable.this.terminateButtonIndex, false));
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseReleased(MouseEvent e) {
            int row = ActiveSessionTable.this.table.rowAtPoint(e.getPoint());
            SimpleList simpleList = ActiveSessionTable.this.sessionList;
            synchronized (simpleList) {
                Rectangle rect;
                if (row == this.hoverRow && ActiveSessionTable.canTerminateSession(ActiveSessionTable.this.accessPanelListener, (AbstractSession)ActiveSessionTable.this.sessionList.get(this.hoverRow), this.hoverRow) && (rect = ActiveSessionTable.this.table.getCellRect(row, ActiveSessionTable.this.terminateButtonIndex, false)).contains(e.getPoint()) && e.getX() < rect.x + ((ActiveSessionTable)ActiveSessionTable.this).activeSessionRenderer.getButtonSize().width) {
                    ActiveSessionTable.this.accessPanelListener.terminateSession((AbstractSession)ActiveSessionTable.this.sessionList.remove(row));
                    if (ActiveSessionTable.this.sessionList.size() == 0) {
                        ActiveSessionTable.this.table.getParent().setVisible(false);
                    }
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            int previousRow = this.hoverRow;
            this.hoverRow = -1;
            this.repaintRows(this.hoverRow, previousRow);
        }
    }

    class ActiveSessionTableQueryThread
    extends Thread {
        public boolean die = false;

        ActiveSessionTableQueryThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Object object = ActiveSessionTable.this.PERF_LOCK;
                synchronized (object) {
                    ActiveSessionTable.this.PERF_LOCK.wait(1000L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            while (!this.die) {
                try {
                    ActiveSessionTable.this.getPerformanceStats();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    System.out.println("[ActiveSessionTable] Terminating query thread. It will get restarted if required.");
                    this.die = true;
                }
                try {
                    Object t = ActiveSessionTable.this.PERF_LOCK;
                    synchronized (t) {
                        ActiveSessionTable.this.PERF_LOCK.wait(5000L);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

