/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.access.contents.table;

import com.aem.shelp.proxy.types.AbstractSession;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.tech.access.AccessPanelListener;
import com.aem.shelp.tech.access.HierarchyPanelListener;
import com.aem.shelp.tech.access.contents.MachineGroupPanelLabel;
import com.aem.shelp.tech.access.contents.table.MachineTable;
import com.aem.shelp.tech.access.model.machine.MachineGroup;
import com.aem.shelp.tech.access.model.machine.MachineTreeModel;
import com.aem.shelp.tech.hierarchy.ui.AbstractGroupPanel;
import com.aem.shelp.tech.hierarchy.ui.AbstractGroupsList;
import com.aem.shelp.tech.hierarchy.ui.GroupPanelLabel;
import java.awt.Component;
import javax.swing.ListSelectionModel;

public class TableGroupPanel
extends AbstractGroupPanel<MachineGroup, Machine> {
    private MachineTable machineTable;

    public TableGroupPanel(MachineTreeModel machineModel, MachineGroup group, AccessPanelListener accessPanelListener, boolean isFirstGroupAdded, AbstractGroupsList<MachineGroup, Machine> groupsList, boolean showMachineIcons) {
        super(machineModel, group, accessPanelListener, isFirstGroupAdded, groupsList);
        this.machineTable = new MachineTable(machineModel, group, accessPanelListener, this, showMachineIcons);
        this.rootComponent.add((Component)this.machineTable.getRootComponent(), "Center");
    }

    @Override
    public boolean isEmpty() {
        return this.machineTable.isEmpty();
    }

    public void groupsRemoved(MachineGroup parentGroup, MachineGroup[] removedChildren, int[] removedIndices) {
    }

    public void groupsAdded(MachineGroup parentGroup, MachineGroup[] insertedChildren, int[] insertedIndices) {
    }

    public void groupsChanged(MachineGroup parentGroup, MachineGroup[] insertedChildren, int[] insertedIndices) {
    }

    public void sessionsAdded(MachineGroup parentGroup, Machine machine, AbstractSession[] addedSessions) {
        if (parentGroup == this.group || parentGroup != null && this.group != null && parentGroup.equals(this.group)) {
            this.machineTable.sessionsAdded(parentGroup, machine, addedSessions);
        }
    }

    public void sessionsRemoved(MachineGroup parentGroup, Machine machine, AbstractSession[] removedSessions) {
        if (parentGroup == this.group || parentGroup != null && this.group != null && parentGroup.equals(this.group)) {
            this.machineTable.sessionsRemoved(parentGroup, machine, removedSessions);
        }
    }

    @Override
    protected void selectAllElementsInGroup(MachineGroup machineGroup) {
        this.machineTable.getRootComponent().selectAll();
    }

    @Override
    protected void selectElements(boolean selectAfterAnchorRow) {
        ListSelectionModel selectionModel = this.machineTable.getRootComponent().getSelectionModel();
        int anchorSelectionIndex = selectionModel.getAnchorSelectionIndex();
        if (selectAfterAnchorRow) {
            selectionModel.setSelectionInterval(anchorSelectionIndex, this.machineTable.getRootComponent().getRowCount() - 1);
        } else {
            selectionModel.setSelectionInterval(0, anchorSelectionIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void machinesChanged(MachineGroup parentGroup, Machine[] inserted, Machine[] removed, Machine[] updated, Machine.MachineChanges updateResults) {
        if ((parentGroup == this.group || parentGroup != null && this.group != null && parentGroup.equals(this.group)) && updated != null) {
            ((MachineGroup)this.group).getElements().startBatch();
            try {
                for (Machine m : updated) {
                    ((MachineGroup)this.group).getElements().notifyElementUpdate(m);
                }
            }
            finally {
                ((MachineGroup)this.group).getElements().endBatch();
            }
        }
    }

    @Override
    protected void clearSelection() {
        this.machineTable.getRootComponent().clearSelection();
    }

    @Override
    protected void selectLastElement() {
        int row = this.machineTable.getRootComponent().getRowCount();
        this.machineTable.getRootComponent().getSelectionModel().setSelectionInterval(row - 1, row - 1);
    }

    @Override
    protected void selectFirstElement() {
        this.machineTable.getRootComponent().getSelectionModel().setSelectionInterval(0, 0);
    }

    @Override
    protected boolean allElementsSelected() {
        return this.machineTable.getRootComponent().getSelectedRowCount() == this.machineTable.getRootComponent().getRowCount();
    }

    public Machine[] getSelectedElements() {
        return this.machineTable.getSelectedMachines();
    }

    @Override
    public void ensureElementIsSelected(MachineGroup group, Machine machine) {
        this.machineTable.select(machine);
    }

    @Override
    protected GroupPanelLabel<MachineGroup, Machine> initLabel(HierarchyPanelListener panelListener, MachineGroup group, boolean isFirstGroupAdded) {
        return new MachineGroupPanelLabel((AccessPanelListener)panelListener, group, isFirstGroupAdded);
    }
}

