/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.access.contents.table;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.types.AbstractSession;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.tech.access.AccessPanelListener;
import com.aem.shelp.tech.access.contents.table.MachineTableRenderer;
import com.aem.shelp.tech.access.contents.table.TableGroupPanel;
import com.aem.shelp.tech.access.dnd.MachineTransferable;
import com.aem.shelp.tech.access.dnd.TransferEntry;
import com.aem.shelp.tech.access.model.machine.MachineGroup;
import com.aem.shelp.tech.access.model.machine.MachineModelChangeListener;
import com.aem.shelp.tech.access.model.machine.MachineTreeModel;
import com.aem.shelp.tech.hierarchy.model.TreeElement;
import com.aem.shelp.tech.hierarchy.model.TreeGroup;
import com.aem.shelp.tech.hierarchy.ui.SelectionUtil;
import java.awt.datatransfer.Transferable;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import utils.swing.components.SHJTable;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.mouse.ClickProximityTracker;
import utils.swing.simplelist.SimpleList;
import utils.swing.simplelist.jtable.SimpleTableModel;
import utils.swing.simplelist.jtable.TableStructure;
import utils.switches.Switches;

public class MachineTable
implements MachineModelChangeListener {
    private SimpleTableModel model;
    private SHJTable table;
    private AccessPanelListener accessPanelListener;
    private MachineGroup group;
    private SimpleList<Machine> machineList;
    private TableGroupPanel tableGroupPanel;
    private MachineTableRenderer machineTableRenderer;

    public MachineTable(MachineTreeModel model, MachineGroup group, AccessPanelListener accessPanelListener, TableGroupPanel tableGroupPanel, boolean showMachineIcons) {
        this.accessPanelListener = accessPanelListener;
        this.machineList = group.getElements();
        this.tableGroupPanel = tableGroupPanel;
        this.group = group;
        this.initUI(showMachineIcons);
        this.table.setDragEnabled(true);
        this.table.setTransferHandler(new MachineTableTransferHandler());
    }

    public SHJTable getRootComponent() {
        return this.table;
    }

    private void initUI(boolean showMachineIcons) {
        TableStructure ts = TableStructure.createTableStructure(Machine.class, new String[]{""}, new String[]{Language.get("REMOTE_MACHINE")});
        this.model = new SimpleTableModel(this.machineList, ts);
        this.table = new SHJTable(this.model){

            @Override
            public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
                SelectionUtil<MachineGroup, Machine> model = MachineTable.this.tableGroupPanel.getGroupsList().getSelectionModel();
                model.changeSelection(MachineTable.this.tableGroupPanel, rowIndex, toggle, extend);
                super.changeSelection(rowIndex, columnIndex, toggle, extend);
            }

            @Override
            protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
                boolean result = super.processKeyBinding(ks, e, condition, pressed);
                if (result) {
                    Object binding;
                    InputMap map = this.getInputMap(condition);
                    ActionMap am = this.getActionMap();
                    if (map != null && am != null && this.isEnabled() && (binding = map.get(ks)).equals("selectAll")) {
                        MachineTable.this.tableGroupPanel.getGroupsList().selectAllExceptIn(MachineTable.this.tableGroupPanel);
                    }
                }
                return result;
            }
        };
        this.table.getSelectionModel().addListSelectionListener(new MachineSelectionListener());
        this.table.setRowHeight(SimpleHelpLookAndFeel.scale(26));
        this.machineTableRenderer = new MachineTableRenderer(this.tableGroupPanel, showMachineIcons);
        this.table.setDefaultRenderer(Object.class, this.machineTableRenderer);
        this.table.addMouseListener(new DoubleClickAdapter());
    }

    @Override
    public void sessionsAdded(MachineGroup parentGroup, Machine machine, AbstractSession[] addedSessions) {
    }

    @Override
    public void sessionsRemoved(MachineGroup parentGroup, Machine machine, AbstractSession[] removedSessions) {
    }

    public void groupsRemoved(MachineGroup parentGroup, MachineGroup[] removedChildren, int[] removedIndices) {
    }

    public void groupsAdded(MachineGroup parentGroup, MachineGroup[] insertedChildren, int[] insertedIndices) {
    }

    public void groupsChanged(MachineGroup parentGroup, MachineGroup[] insertedChildren, int[] insertedIndices) {
    }

    public void machinesChanged(MachineGroup parent, Machine[] inserted, Machine[] removed, Machine[] updated, Machine.MachineChanges updateResults) {
    }

    public boolean isEmpty() {
        return this.machineList.size() == 0;
    }

    public static Machine[] getSelectedMachines(JTable table) {
        int[] selectedRows = table.getSelectedRows();
        ArrayList<Machine> selectedMachines = new ArrayList<Machine>();
        for (int i = 0; i < selectedRows.length; ++i) {
            Object selection;
            if (i >= selectedRows.length || !((selection = table.getValueAt(i, 0)) instanceof Machine)) continue;
            selectedMachines.add((Machine)selection);
        }
        return selectedMachines.toArray(new Machine[0]);
    }

    public Machine[] getSelectedMachines() {
        int[] selectedRows = this.table.getSelectedRows();
        ArrayList<Machine> selectedMachines = new ArrayList<Machine>();
        for (int i = 0; i < selectedRows.length; ++i) {
            try {
                Machine selection = this.machineList.get(selectedRows[i]);
                if (!(selection instanceof Machine)) continue;
                selectedMachines.add(selection);
                continue;
            }
            catch (IndexOutOfBoundsException ex) {
                ex.printStackTrace();
            }
        }
        return selectedMachines.toArray(new Machine[0]);
    }

    @Override
    public void filterProcessorChanged() {
    }

    public void select(Machine machine) {
        int index = this.machineList.indexOf(machine);
        this.table.getSelectionModel().setSelectionInterval(index, index);
    }

    class MachineTableTransferHandler
    extends TransferHandler {
        MachineTableTransferHandler() {
        }

        @Override
        public int getSourceActions(JComponent c) {
            if (MachineTable.this.accessPanelListener.getTechClient().getPermissions().canManagePersistentConnections()) {
                return 2;
            }
            return 0;
        }

        @Override
        public Transferable createTransferable(JComponent c) {
            TreeElement[] selectedMachines = MachineTable.this.getSelectedMachines();
            TransferEntry entry = new TransferEntry((TreeGroup)MachineTable.this.group, selectedMachines);
            return new MachineTransferable(new TransferEntry[]{entry});
        }

        @Override
        public void exportDone(JComponent c, Transferable t, int action) {
        }
    }

    class MachineSelectionListener
    implements ListSelectionListener {
        MachineSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            MachineTable.this.tableGroupPanel.getGroupsList().notifySelectionChange();
        }
    }

    class DoubleClickAdapter
    extends MouseAdapter {
        ClickProximityTracker tracker = new ClickProximityTracker();

        DoubleClickAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.tracker.mousePressed(e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Machine machine;
            int row;
            if (e.getClickCount() == 2 && (this.tracker.isValidMultiClick() || !Switches.SH_doubleClickLaunchRequiresProximity) && (row = MachineTable.this.table.rowAtPoint(e.getPoint())) != -1 && (machine = (Machine)MachineTable.this.machineList.get(row)) != null) {
                MachineTable.this.accessPanelListener.connectToMachine(machine);
            }
        }
    }
}

