/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.access.contents.grid;

import com.aem.profiles.keysets.GroupAccessKeyset;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.tech.access.AccessPanelListener;
import com.aem.shelp.tech.access.AccessStyle;
import com.aem.shelp.tech.access.contents.grid.GridMachineRenderer;
import com.aem.shelp.tech.utils.MonitoringSwitch;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.icons.FadeIcon;
import utils.swing.images.ImageLoader;

public class MachineButtonsPanel {
    private JPanel rootComponent = new JPanel(){

        @Override
        public void paintComponent(Graphics g) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            super.paintComponent(g);
        }
    };
    private JLabel connectLabel;
    private JLabel clearLabel;
    private JLabel updateLabel;
    private JLabel restartLabel;
    private MonitoringSwitch monitorButton;
    private AccessPanelListener accessPanelListener;
    private Machine machine;
    private JLabel connectAdvancedLabel;
    private JPanel connectButtonPanel;
    private ActionListener monitorListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            MachineButtonsPanel.this.accessPanelListener.setMonitoring(MachineButtonsPanel.this.machine, MachineButtonsPanel.this.monitorButton.isSelected());
        }
    };

    public MachineButtonsPanel(AccessPanelListener accessPanelListener) {
        this.accessPanelListener = accessPanelListener;
        int width = GridMachineRenderer.WIDTH - 2 * GridMachineRenderer.PADDING - 1;
        int height = 30;
        Dimension size = new Dimension(width, height);
        this.rootComponent.setSize(size);
        this.rootComponent.setPreferredSize(size);
        this.monitorButton = new MonitoringSwitch();
        this.monitorButton.setBackground(SHStyle.PANEL_BACKGROUND_DARK);
        this.monitorButton.addActionListener(this.monitorListener);
        this.connectLabel = new FadeLabel(new FadeIcon(ImageLoader.getImageIcon("images/glyph/glyph_connect.png"), 30, 60, 1, false));
        this.connectLabel.setHorizontalAlignment(4);
        this.connectAdvancedLabel = new JLabel(ImageLoader.getImageIcon("images/glyph/glyph_downarrow.png"));
        this.clearLabel = new FadeLabel(new FadeIcon(ImageLoader.getImageIconDisabled("images/svg/general/remove.svg,16"), 30, 60, 1, false));
        this.clearLabel.setHorizontalAlignment(4);
        this.updateLabel = new FadeLabel(new FadeIcon(ImageLoader.getImageIcon("images/glyph/glyph_upgrade.png"), 30, 60, 1, false));
        this.updateLabel.setHorizontalAlignment(0);
        this.restartLabel = new FadeLabel(new FadeIcon(ImageLoader.getImageIcon("images/glyph/glyph_restart.png"), 30, 60, 1, false));
        this.restartLabel.setHorizontalAlignment(0);
        this.rootComponent.setOpaque(false);
        this.rootComponent.setBackground(new Color(255, 255, 255, 240));
        this.rootComponent.setLayout(new GridLayout(1, 0));
        this.rootComponent.setBorder(SHBorderFactory.createCompoundBorder(SHBorderFactory.createMatteBorder(1, 0, 0, 0, AccessStyle.GROUP_TITLE_BORDER_TOP), SHBorderFactory.createEmptyBorder(0, 5, 3, 5)));
        this.connectButtonPanel = new JPanel(new BorderLayout(5, 0));
        this.connectButtonPanel.add((Component)this.connectLabel, "Center");
        this.connectButtonPanel.add((Component)this.connectAdvancedLabel, "East");
        FadeIconInvokeListener animateListener = new FadeIconInvokeListener();
        this.connectLabel.addMouseListener(animateListener);
        this.clearLabel.addMouseListener(animateListener);
        this.restartLabel.addMouseListener(animateListener);
        this.updateLabel.addMouseListener(animateListener);
        this.connectAdvancedLabel.addMouseListener(animateListener);
        this.connectLabel.setOpaque(false);
        this.monitorButton.setOpaque(false);
    }

    public JPanel getRootComponent() {
        return this.rootComponent;
    }

    public void initFor(Machine machine) {
        this.machine = machine;
        boolean canManageServices = this.accessPanelListener.getTechClient().getTechUser().getPermissions().canManagePersistentConnections();
        if (machine.isAvailable()) {
            this.rootComponent.removeAll();
            boolean allowedToManageMonitoring = this.accessPanelListener.getTechClient().getTechUser().getPermissions().canManageMonitoring();
            if (!GroupAccessKeyset.isEnabled()) {
                if (allowedToManageMonitoring && machine.supportsMonitoring() && machine.allowMonitoring()) {
                    this.rootComponent.add(this.monitorButton);
                } else {
                    this.rootComponent.add(new JLabel());
                }
                if (canManageServices && machine.needsUpgrading()) {
                    this.rootComponent.add(this.updateLabel);
                } else if (canManageServices && machine.needsRestarting()) {
                    this.rootComponent.add(this.restartLabel);
                } else {
                    this.rootComponent.add(new JLabel());
                }
            }
            this.rootComponent.add(this.connectButtonPanel);
            this.monitorButton.setSelected(machine.isMonitored());
        } else {
            this.rootComponent.removeAll();
            if (canManageServices) {
                this.rootComponent.add(this.clearLabel);
            }
        }
        this.rootComponent.revalidate();
        this.rootComponent.repaint();
    }

    private JPopupMenu getCustomerConnectOptionsMenu() {
        return this.accessPanelListener.getMachineConnectionMenu(this.machine);
    }

    class FadeLabel
    extends JLabel
    implements FadeIcon.FadeListener {
        private MouseListener[] listeners;

        public FadeLabel(FadeIcon icon) {
            super(icon);
            icon.setFadeListener(this);
        }

        @Override
        public void animationEnded() {
            for (MouseListener listener : this.listeners) {
                this.addMouseListener(listener);
            }
        }

        public void restart() {
            if (this.getIcon() instanceof FadeIcon) {
                for (MouseListener listener : this.listeners = this.getMouseListeners()) {
                    this.removeMouseListener(listener);
                }
                ((FadeIcon)this.getIcon()).restart();
            }
        }
    }

    class FadeIconInvokeListener
    extends MouseAdapter {
        FadeIconInvokeListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.toggle(e.getSource());
            if (e.getSource() == MachineButtonsPanel.this.connectLabel) {
                MachineButtonsPanel.this.accessPanelListener.connectToMachine(MachineButtonsPanel.this.machine);
            } else if (e.getSource() == MachineButtonsPanel.this.clearLabel) {
                MachineButtonsPanel.this.accessPanelListener.stopOrForgetMachines(new Machine[]{MachineButtonsPanel.this.machine});
            } else if (e.getSource() == MachineButtonsPanel.this.updateLabel) {
                MachineButtonsPanel.this.accessPanelListener.upgradeMachines(new Machine[]{MachineButtonsPanel.this.machine});
            } else if (e.getSource() == MachineButtonsPanel.this.connectAdvancedLabel) {
                JComponent source = (JComponent)e.getSource();
                JPopupMenu menu = MachineButtonsPanel.this.getCustomerConnectOptionsMenu();
                menu.show((Component)e.getSource(), 0, source.getHeight());
            }
            e.consume();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            e.consume();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            e.consume();
        }

        private void toggle(Object source) {
            if (source instanceof FadeLabel) {
                FadeLabel label = (FadeLabel)source;
                label.restart();
            }
        }
    }
}

