/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.access.contents.grid;

import com.aem.shelp.proxy.types.AbstractSession;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.tech.access.AccessPanelListener;
import com.aem.shelp.tech.access.HierarchyPanelListener;
import com.aem.shelp.tech.access.contents.MachineGroupPanelLabel;
import com.aem.shelp.tech.access.contents.grid.GridMachineRenderer;
import com.aem.shelp.tech.access.contents.grid.MachineButtonsPanel;
import com.aem.shelp.tech.access.model.machine.MachineGroup;
import com.aem.shelp.tech.access.model.machine.MachineModelChangeListener;
import com.aem.shelp.tech.access.model.machine.MachineTreeModel;
import com.aem.shelp.tech.hierarchy.model.TreeElement;
import com.aem.shelp.tech.hierarchy.ui.AbstractGroupPanel;
import com.aem.shelp.tech.hierarchy.ui.AbstractGroupsList;
import com.aem.shelp.tech.hierarchy.ui.GroupPanelLabel;
import com.aem.shelp.tech.hierarchy.ui.SelectionUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.AbstractAction;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import utils.ostools.OS;
import utils.swing.customlaf.SHStyle;
import utils.swing.mouse.ClickProximityTracker;
import utils.swing.mouse.SafeMouseAdapter;
import utils.swing.simplelist.SimpleList;
import utils.switches.Switches;

public class GridGroupPanel
extends AbstractGroupPanel<MachineGroup, Machine> {
    private GridMachineRenderer renderer;
    private RenderedMachineGrid machineGrid;
    private ListSelectionModel selectionModel = new DefaultListSelectionModel();
    private AbstractGroupsList<MachineGroup, Machine> paintTracker;

    public GridGroupPanel(MachineTreeModel machineModel, final MachineGroup group, AccessPanelListener accessPanelListener, boolean isFirstGroupAdded, final AbstractGroupsList<MachineGroup, Machine> groupsList, AbstractGroupsList<MachineGroup, Machine> paintTracker) {
        super(machineModel, group, accessPanelListener, isFirstGroupAdded, groupsList);
        this.paintTracker = paintTracker;
        this.renderer = new GridMachineRenderer(this.selectionModel, accessPanelListener.getTechClient().getPermissions());
        this.renderer.setMachineModel(machineModel);
        this.machineGrid = new RenderedMachineGrid(accessPanelListener, group.getElements());
        this.rootComponent.add((Component)this.machineGrid, "Center");
        if (OS.isMacOS()) {
            this.machineGrid.getInputMap(2).put(KeyStroke.getKeyStroke("meta A"), "selectAll");
        } else {
            this.machineGrid.getInputMap(2).put(KeyStroke.getKeyStroke("ctrl A"), "selectAll");
        }
        this.machineGrid.getActionMap().put("selectAll", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                groupsList.selectAllExceptIn(GridGroupPanel.this);
                GridGroupPanel.this.selectAllElementsInGroup(group);
            }
        });
    }

    @Override
    public boolean isEmpty() {
        return this.machineGrid.isEmpty();
    }

    public void groupsRemoved(MachineGroup parentGroup, MachineGroup[] removedChildren, int[] removedIndices) {
    }

    public void groupsAdded(MachineGroup parentGroup, MachineGroup[] insertedChildren, int[] insertedIndices) {
    }

    public void groupsChanged(MachineGroup parentGroup, MachineGroup[] insertedChildren, int[] insertedIndices) {
    }

    public void machinesChanged(MachineGroup parent, Machine[] inserted, Machine[] removed, Machine[] updated, Machine.MachineChanges updateResults) {
        if (parent == this.group || parent != null && this.group != null && parent.equals(this.group)) {
            this.machineGrid.machinesChanged(parent, inserted, removed, updated, updateResults);
        }
    }

    public void sessionsAdded(MachineGroup parentGroup, Machine machine, AbstractSession[] addedSessions) {
        if (parentGroup == this.group || parentGroup != null && this.group != null && parentGroup.equals(this.group)) {
            this.machineGrid.sessionsAdded(parentGroup, machine, addedSessions);
        }
    }

    public void sessionsRemoved(MachineGroup parentGroup, Machine machine, AbstractSession[] removedSessions) {
        if (parentGroup == this.group || parentGroup != null && this.group != null && parentGroup.equals(this.group)) {
            this.machineGrid.sessionsRemoved(parentGroup, machine, removedSessions);
        }
    }

    @Override
    protected void selectAllElementsInGroup(MachineGroup machineGroup) {
        this.selectionModel.setSelectionInterval(0, machineGroup.getElementCount() - 1);
        this.rootComponent.repaint();
    }

    @Override
    protected void clearSelection() {
        this.selectionModel.clearSelection();
        this.rootComponent.repaint();
    }

    @Override
    protected boolean allElementsSelected() {
        if (this.selectionModel.isSelectionEmpty()) {
            return false;
        }
        int selectionCount = this.selectionModel.getMaxSelectionIndex() - this.selectionModel.getMinSelectionIndex() + 1;
        return selectionCount == ((MachineGroup)this.group).getElementCount();
    }

    @Override
    protected void selectElements(boolean selectAfterAnchorRow) {
        if (selectAfterAnchorRow) {
            this.selectionModel.setLeadSelectionIndex(((MachineGroup)this.group).getElementCount() - 1);
        } else {
            this.selectionModel.setLeadSelectionIndex(0);
        }
        this.rootComponent.repaint();
    }

    @Override
    protected void selectLastElement() {
        if (((MachineGroup)this.group).getElementCount() == 0) {
            return;
        }
        int index = ((MachineGroup)this.group).getElementCount() - 1;
        this.selectionModel.setSelectionInterval(index, index);
        this.rootComponent.repaint();
    }

    @Override
    protected void selectFirstElement() {
        if (((MachineGroup)this.group).getElementCount() == 0) {
            return;
        }
        int index = 0;
        this.selectionModel.setSelectionInterval(index, index);
        this.rootComponent.repaint();
    }

    public Machine[] getSelectedElements() {
        if (this.selectionModel.isSelectionEmpty()) {
            return new Machine[0];
        }
        int min = this.selectionModel.getMinSelectionIndex();
        int max = this.selectionModel.getMaxSelectionIndex();
        Machine[] result = new Machine[max - min + 1];
        SimpleList machines = ((MachineGroup)this.group).getElements();
        for (int i = min; i <= max; ++i) {
            result[i - min] = (Machine)machines.get(i);
        }
        return result;
    }

    @Override
    public void ensureElementIsSelected(MachineGroup group, Machine machine) {
        int indexOf = this.machineGrid.machines.indexOf(machine);
        this.selectionModel.setAnchorSelectionIndex(indexOf);
        this.selectionModel.setLeadSelectionIndex(indexOf);
        this.renderer.repaint();
    }

    @Override
    protected GroupPanelLabel<MachineGroup, Machine> initLabel(HierarchyPanelListener panelListener, MachineGroup group, boolean isFirstGroupAdded) {
        return new MachineGroupPanelLabel((AccessPanelListener)panelListener, group, isFirstGroupAdded);
    }

    class RenderedMachineGrid
    extends JComponent
    implements ComponentListener,
    MachineModelChangeListener,
    MouseMotionListener {
        private SimpleList<Machine> machines;
        private AccessPanelListener accessPanelListener;
        private int machinesPerRow;
        private int paddingPerMachine = 0;
        private MachineButtonsPanel panel;
        private int hoveredMachineIndex = -1;

        public RenderedMachineGrid(AccessPanelListener accessPanelListener, SimpleList<Machine> simpleList) {
            this.accessPanelListener = accessPanelListener;
            this.machines = simpleList;
            this.panel = new MachineButtonsPanel(accessPanelListener);
            this.addComponentListener(this);
            this.addMouseListener(new MachineGridMouseAdapter(this));
            this.addMouseMotionListener(this);
            this.add(this.panel.getRootComponent());
            this.panel.getRootComponent().setVisible(false);
            this.setBackground(SHStyle.PANEL_BACKGROUND_DARK);
        }

        public boolean isEmpty() {
            return this.machines.size() == 0;
        }

        @Override
        public void paintComponent(Graphics g) {
            this.relayout();
            super.paintComponent(g);
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            for (int i = 0; i < this.machines.size(); ++i) {
                int yForMachine;
                int xForMachine = this.getXForMachine(i);
                if (!g.hitClip(xForMachine, yForMachine = this.getYForMachine(i), GridMachineRenderer.WIDTH, GridMachineRenderer.HEIGHT)) continue;
                GridGroupPanel.this.paintTracker.justPainted((TreeElement)this.machines.get(i));
                g.translate(xForMachine, yForMachine);
                GridGroupPanel.this.renderer.initRendererFor(i, this.machines.get(i));
                GridGroupPanel.this.renderer.paintComponent(g);
                g.translate(-xForMachine, -yForMachine);
            }
        }

        private void relayout() {
            int width = this.getWidth();
            this.machinesPerRow = width / GridMachineRenderer.WIDTH;
            this.machinesPerRow = Math.max(this.machinesPerRow, 1);
            this.paddingPerMachine = (width - this.machinesPerRow * GridMachineRenderer.WIDTH) / (this.machinesPerRow + 1);
            int requiredRows = (int)Math.ceil((double)this.machines.size() / (double)this.machinesPerRow);
            int requiredHeight = requiredRows * GridMachineRenderer.HEIGHT;
            if (requiredHeight != this.getHeight()) {
                Dimension size = new Dimension(width, requiredHeight);
                this.setPreferredSize(size);
                this.setMinimumSize(size);
                this.setMaximumSize(size);
                this.setSize(width, requiredHeight);
                GridGroupPanel.this.rootComponent.revalidate();
            }
        }

        @Override
        public void componentResized(ComponentEvent e) {
            this.repaint();
        }

        @Override
        public void componentShown(ComponentEvent e) {
            this.relayout();
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }

        public void modelChangedRemove(Object parentGroup, Object[] removedChildren) {
            this.repaint();
        }

        public void modelChangedInsert(Object parentGroup, Object[] insertedChildren) {
            this.repaint();
        }

        @Override
        public void filterProcessorChanged() {
        }

        private int getXForMachine(int machineIndex) {
            return machineIndex % this.machinesPerRow * (GridMachineRenderer.WIDTH + this.paddingPerMachine) + this.paddingPerMachine;
        }

        private int getYForMachine(int machineIndex) {
            return machineIndex / this.machinesPerRow * GridMachineRenderer.HEIGHT;
        }

        private void showButtonsPanelForMachine(int hoveredMachineIndex) {
            int xForMachine = this.getXForMachine(hoveredMachineIndex);
            int yForMachine = this.getYForMachine(hoveredMachineIndex);
            int bottomBuffer = GridMachineRenderer.PADDING;
            Dimension size = this.panel.getRootComponent().getPreferredSize();
            this.panel.getRootComponent().setSize(size);
            this.panel.getRootComponent().setBounds(1 + xForMachine + (GridMachineRenderer.WIDTH - size.width) / 2, yForMachine + GridMachineRenderer.HEIGHT - size.height - bottomBuffer, size.width, size.height);
            this.panel.getRootComponent().revalidate();
        }

        private int getSelectedMachineIndex(int x, int y) {
            int machineIndex = this.machinesPerRow * (y / GridMachineRenderer.HEIGHT);
            int rowMachineIndex = x / (this.getWidth() / this.machinesPerRow);
            if (rowMachineIndex >= this.machinesPerRow) {
                rowMachineIndex = this.machinesPerRow - 1;
            }
            if ((machineIndex += rowMachineIndex) >= this.machines.size()) {
                return -1;
            }
            return machineIndex;
        }

        public void groupsRemoved(MachineGroup parentGroup, MachineGroup[] removedChildren, int[] removedIndices) {
            this.repaint();
        }

        public void groupsAdded(MachineGroup parentGroup, MachineGroup[] insertedChildren, int[] insertedIndices) {
            this.repaint();
        }

        public void groupsChanged(MachineGroup parentGroup, MachineGroup[] insertedChildren, int[] insertedIndices) {
            this.repaint();
        }

        public void machinesChanged(MachineGroup parent, Machine[] inserted, Machine[] removed, Machine[] updated, Machine.MachineChanges updateResults) {
            this.repaint();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            int machineIndex = this.getSelectedMachineIndex(e.getX(), e.getY());
            if (machineIndex == -1) {
                this.hoveredMachineIndex = machineIndex;
                this.panel.getRootComponent().setVisible(false);
                return;
            }
            if (this.hoveredMachineIndex == machineIndex) {
                return;
            }
            this.hoveredMachineIndex = machineIndex;
            Machine machine = this.machines.get(this.hoveredMachineIndex);
            this.panel.initFor(machine);
            this.panel.getRootComponent().setVisible(true);
            this.showButtonsPanelForMachine(this.hoveredMachineIndex);
        }

        @Override
        public void sessionsAdded(MachineGroup parentGroup, Machine machine, AbstractSession[] addedSessions) {
        }

        @Override
        public void sessionsRemoved(MachineGroup parentGroup, Machine machine, AbstractSession[] removedSessions) {
        }
    }

    class MachineGridMouseAdapter
    extends SafeMouseAdapter {
        ClickProximityTracker tracker = new ClickProximityTracker();
        private RenderedMachineGrid grid;

        public MachineGridMouseAdapter(RenderedMachineGrid grid) {
            this.grid = grid;
        }

        @Override
        public void safeMouseReleased(MouseEvent e) {
            this.tracker.mousePressed(e);
            this.handleClick(e);
        }

        @Override
        public void safeMouseClicked(MouseEvent e) {
            this.handleClick(e);
        }

        public void handleClick(MouseEvent e) {
            int machineIndex = this.grid.getSelectedMachineIndex(e.getX(), e.getY());
            if (machineIndex == -1) {
                return;
            }
            int toggleMask = 128;
            int extendMask = 64;
            boolean toggle = (e.getModifiersEx() & toggleMask) == toggleMask;
            boolean extend = (e.getModifiersEx() & extendMask) == extendMask;
            SelectionUtil<MachineGroup, Machine> model = GridGroupPanel.this.getGroupsList().getSelectionModel();
            model.changeSelection(GridGroupPanel.this, machineIndex, toggle, extend);
            if (!toggle && !extend) {
                GridGroupPanel.this.selectionModel.setSelectionInterval(machineIndex, machineIndex);
                GridGroupPanel.this.getGroupsList().clearSelectionsNotInGroup(GridGroupPanel.this);
                if (e.getClickCount() == 2 && (this.tracker.isValidMultiClick() || !Switches.SH_doubleClickLaunchRequiresProximity)) {
                    ((AccessPanelListener)GridGroupPanel.this.panelListener).connectToMachine((Machine)this.grid.machines.get(machineIndex));
                }
            } else if (toggle) {
                if (GridGroupPanel.this.selectionModel.isSelectedIndex(machineIndex)) {
                    GridGroupPanel.this.selectionModel.removeSelectionInterval(machineIndex, machineIndex);
                } else {
                    GridGroupPanel.this.selectionModel.addSelectionInterval(machineIndex, machineIndex);
                }
            } else if (extend) {
                GridGroupPanel.this.selectionModel.setLeadSelectionIndex(machineIndex);
            }
            this.grid.repaint();
            GridGroupPanel.this.getGroupsList().notifySelectionChange();
        }
    }
}

