/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.access.contents;

import com.aem.profiles.keysets.GroupAccessKeyset;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.tech.access.AccessPanelListener;
import com.aem.shelp.tech.access.AccessStyle;
import com.aem.shelp.tech.access.model.machine.MachineGroup;
import com.aem.shelp.tech.access.model.machine.MachineGroupStats;
import com.aem.shelp.tech.hierarchy.ui.GroupPanelLabel;
import com.aem.shelp.tech.utils.MonitoringSwitch;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import utils.swing.customlaf.SimpleHelpLookAndFeel;

public class MachineGroupPanelLabel
extends GroupPanelLabel<MachineGroup, Machine> {
    private MonitoringSwitch monitorButton;
    private AccessPanelListener accessPanelListener;
    private JLabel monitorLabel;

    public MachineGroupPanelLabel(AccessPanelListener accessPanelListener, MachineGroup group, boolean isFirstGroupAdded) {
        this.group = group;
        this.accessPanelListener = accessPanelListener;
        this.initUI(isFirstGroupAdded);
    }

    @Override
    protected void initUI(boolean isFirstGroupAdded) {
        super.initUI(isFirstGroupAdded);
        JPanel monitorPanel = new JPanel(new BorderLayout(SimpleHelpLookAndFeel.scale(5), SimpleHelpLookAndFeel.scale(5)));
        this.monitorButton = new MonitoringSwitch();
        this.monitorButton.setBackground(AccessStyle.GROUP_TITLE_BACKGROUND);
        this.monitorButton.addActionListener(this);
        this.monitorLabel = new JLabel(Language.get("MONITOR"));
        this.monitorLabel.setFont(AccessStyle.GROUP_MONITOR_FONT);
        this.monitorLabel.setBackground(AccessStyle.GROUP_TITLE_BACKGROUND);
        monitorPanel.add((Component)this.monitorButton, "East");
        monitorPanel.add((Component)this.monitorLabel, "Center");
        monitorPanel.setBackground(AccessStyle.GROUP_TITLE_BACKGROUND);
        if (this.accessPanelListener == null) {
            System.out.println("[MachineGroupPanelLabel] accessPanelListener is null");
            return;
        }
        if (this.accessPanelListener.getTechClient() == null) {
            System.out.println("[MachineGroupPanelLabel] techClient is null");
            return;
        }
        if (this.accessPanelListener.getTechClient().getTechUser() == null) {
            System.out.println("[MachineGroupPanelLabel] techUser is null");
            return;
        }
        if (this.accessPanelListener.getTechClient().getTechUser().getPermissions() == null) {
            System.out.println("[MachineGroupPanelLabel] techPermissions is null");
            return;
        }
        if (this.accessPanelListener.getTechClient().getTechUser().getPermissions().canManageMonitoring() && !GroupAccessKeyset.isEnabled()) {
            this.add((Component)monitorPanel, "East");
        }
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        this.accessPanelListener.setMonitoring((MachineGroup)this.group, this.monitorButton.isSelected());
    }

    @Override
    public void updateWithNewStats() {
        MachineGroupStats stats = (MachineGroupStats)((MachineGroup)this.group).getGroupStats();
        if (stats.availableCount == 0 || stats.allowMonitoring == 0) {
            this.monitorButton.setEnabled(false);
        } else {
            this.monitorButton.setEnabled(true);
        }
        if (stats.availableCount == stats.monitored && stats.availableCount > 0) {
            this.monitorButton.setSelected(true);
        } else if (stats.monitored == 0) {
            this.monitorButton.setSelected(false);
        } else {
            this.monitorButton.setUndefined();
        }
    }
}

