/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech;

import com.aem.shelp.licence.License;
import com.aem.shelp.proxy.config.ServerConfig;
import com.aem.shelp.proxy.config.TechGroup;
import com.aem.shelp.proxy.config.TechUser;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.tech.admin.subsections.serversettings.AdminServerLog;
import java.util.ArrayList;
import java.util.Iterator;
import utils.progtools.SaverUtil;

public class TechServerConfig
implements SaverUtil.SaveListener {
    public static final String SOURCE_ID_ADMIN_PANEL = "Admin";
    public static final String SOURCE_ID_PROFILE = "Profile";
    public static TechServerConfig INSTANCE;
    private ArrayList<License> licenseList;
    private TechUser[] usersToAdminister;
    private TechGroup[] groupsToAdminister;
    private static final Object LOAD_LOCK;
    private String sourceID;
    private static final Object SAVE_LOCK;
    private boolean hasBeenFetched = false;
    private final TechClient client;
    private final ServerConfig cachedConfig = new ServerConfig();
    private boolean isWindows;
    private String serverLogSnippet;
    private final SaverUtil saveUtil = new SaverUtil("ServerConfig", 1000, this, false);
    private ArrayList<TechServerConfigListener> listeners = new ArrayList();

    public TechServerConfig(TechClient client) {
        this.client = client;
        INSTANCE = this;
        this.loadConfigFromServer();
    }

    public boolean isWindows() {
        return this.isWindows;
    }

    public ArrayList<License> getLicenseList() {
        return this.licenseList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void blockUntilLoaded() {
        Object object = LOAD_LOCK;
        synchronized (object) {
            while (!this.hasBeenFetched) {
                try {
                    LOAD_LOCK.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public ServerConfig getServerConfig() {
        return this.cachedConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceReload() {
        Object object = LOAD_LOCK;
        synchronized (object) {
            this.hasBeenFetched = false;
        }
        this.loadConfigFromServer();
    }

    public boolean hasBeenFetched() {
        return this.hasBeenFetched;
    }

    public void addTechServerConfigListener(TechServerConfigListener listener) {
        this.listeners.add(listener);
    }

    private void loadConfigFromServer() {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    TechServerConfig.this.licenseList = new ArrayList();
                    TechServerConfig.this.isWindows = TechServerConfig.this.client.fetchServerConfiguration(TechServerConfig.this.cachedConfig, TechServerConfig.this.licenseList);
                    TechServerConfig.this.hasBeenFetched = true;
                    Iterator iterator = LOAD_LOCK;
                    synchronized (iterator) {
                        LOAD_LOCK.notifyAll();
                    }
                    for (TechServerConfigListener listener : TechServerConfig.this.listeners) {
                        listener.serverConfigFetched();
                    }
                    TechServerConfig.this.serverLogSnippet = TechServerConfig.this.client.fetchServerLog();
                    if (TechServerConfig.this.serverLogSnippet != null) {
                        AdminServerLog.getInstance().setServerLog(TechServerConfig.this.serverLogSnippet.trim());
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }.start();
    }

    private void loadTechUserConfigs() {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    TechClient.AdministrationDetails administrationDetails = TechServerConfig.this.client.getTechUsersToAdminister();
                    TechServerConfig.access$802(TechServerConfig.this, administrationDetails.adminUsers);
                    TechServerConfig.access$902(TechServerConfig.this, administrationDetails.groups);
                    TechServerConfig.this.hasBeenFetched = true;
                    Iterator iterator = LOAD_LOCK;
                    synchronized (iterator) {
                        LOAD_LOCK.notifyAll();
                    }
                    for (TechServerConfigListener listener : TechServerConfig.this.listeners) {
                        listener.serverConfigFetched();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }.start();
    }

    public void requestSave(String sourceID) {
        this.saveUtil.queueSave();
        this.sourceID = sourceID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performSave() {
        try {
            Iterator<TechServerConfigListener> iterator = SAVE_LOCK;
            synchronized (iterator) {
                this.client.storeServerConfiguration(this.cachedConfig);
            }
            for (TechServerConfigListener listener : this.listeners) {
                listener.serverConfigChanged(this.sourceID);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Object getLock() {
        return SAVE_LOCK;
    }

    public TechUser[] getUsersToAdminister() {
        return this.usersToAdminister;
    }

    public TechGroup[] getGroupsToAdminister() {
        return this.groupsToAdminister;
    }

    static /* synthetic */ TechUser[] access$802(TechServerConfig x0, TechUser[] x1) {
        x0.usersToAdminister = x1;
        return x1;
    }

    static /* synthetic */ TechGroup[] access$902(TechServerConfig x0, TechGroup[] x1) {
        x0.groupsToAdminister = x1;
        return x1;
    }

    static {
        LOAD_LOCK = new Object();
        SAVE_LOCK = new Object();
    }

    public static interface TechServerConfigListener {
        public void serverConfigFetched();

        public void serverConfigChanged(String var1);
    }
}

