/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech;

import aurelienribon.slidinglayout.DoTransition;
import aurelienribon.slidinglayout.SLAnimator;
import aurelienribon.slidinglayout.SLConfig;
import aurelienribon.slidinglayout.SLKeyframe;
import aurelienribon.slidinglayout.SLPanel;
import aurelienribon.slidinglayout.SLSide;
import aurelienribon.slidinglayout.SLTransition;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.ServerNotificationUtil;
import com.aem.shelp.proxy.common.Notification;
import com.aem.shelp.proxy.common.notifications.AlertNotification;
import com.aem.shelp.proxy.common.notifications.ReportNotification;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.tech.TechUi;
import com.aem.shelp.tech.admin.subsections.gettingstarted.AdminLicense;
import com.aem.shelp.tech.reporting.ReportingClient;
import com.aem.shelp.util.ElapsedTimeFormatter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import java.util.LinkedList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import utils.progtools.TimeUtil;
import utils.swing.SafeJFileChooser;
import utils.swing.SwingUtil;
import utils.swing.browser.Browser;
import utils.swing.components.FadedBorder;
import utils.swing.components.JWrapTextAreaLabel;
import utils.swing.components.NoContentsInfoPanel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;
import utils.swing.simplelist.SimpleList;
import utils.swing.simplelist.jlist.SimpleListModel;

public class SideNotificationPanel
implements ActionListener,
ListSelectionListener {
    public static final Color BACKGROUND_COLOR = Color.white;
    private SimpleList<Notification> allNotifications = new SimpleList();
    private NoContentsInfoPanel rootComponent = new NoContentsInfoPanel(Language.get("NOTIFICATIONS_NONE"), null, false);
    private JPanel slidingPanelParent = new JPanel(new GridLayout(1, 1));
    private JPanel mainContentPanel = new JPanel(new BorderLayout());
    private JScrollPane pane = new JScrollPane();
    private JList notificationList = new JList();
    private JPanel southPanel = new JPanel();
    private JButton clear = new JButton(Language.get("CLEAR_ALL"));
    private JPanel zoomedContentPanel = new JPanel(new BorderLayout());
    private JScrollPane zoomedPane = new JScrollPane();
    private JPanel zoomedSouthPanel = new JPanel();
    private JButton back = new JButton(Language.get("BACK_NOTIFICATIONS"));
    private ElapsedTimeFormatter timeFormatter = new ElapsedTimeFormatter();
    private DateFormat dateTime = DateFormat.getTimeInstance(3);
    private static final Border FADED_BORDER = SHBorderFactory.createCompoundBorder(new FadedBorder(false, true), SHBorderFactory.createEmptyBorder(5, 5, 5, 5));
    private static final Border EMPTY_BORDER = SHBorderFactory.createEmptyBorder(5, 5, 5, 5);
    private LinkedList<NotificationPanel> panels = new LinkedList();
    private Component endBuffer = new JPanel();
    private TechClient tc;
    private SLPanel containerSliding = new SLPanel();
    private SLConfig mainConfig;
    private SLConfig zoomedConfig;
    private int unreadCount = 0;
    final int mode_MAIN = 0;
    final int mode_ZOOMED = 1;
    float modeTime = 0.5f;
    int modeCurrent = 0;
    private TechUi techUI;

    private void initSlidingConfigs() {
        this.mainConfig = new SLConfig(this.containerSliding).gap(0, 0).col(1.0f).row(1.0f).place(0, 0, this.mainContentPanel);
        this.zoomedConfig = new SLConfig(this.containerSliding).gap(0, 0).col(1.0f).row(1.0f).place(0, 0, this.zoomedContentPanel);
        this.containerSliding.setTweenManager(SLAnimator.createTweenManager());
        this.containerSliding.initialize(this.mainConfig);
    }

    private void switchToNewView(SLConfig myConfig, int myMode, Component myComponent) {
        if (this.modeCurrent != myMode) {
            SLSide mySide = myMode > this.modeCurrent ? SLSide.RIGHT : SLSide.LEFT;
            SLTransition trans = this.containerSliding.createTransition().push(new SLKeyframe(myConfig, 0.5f).setStartSide(mySide, myComponent));
            new DoTransition(trans).start();
            this.modeCurrent = myMode;
        }
    }

    public void switchToZoomedView() {
        this.switchToNewView(this.zoomedConfig, 1, this.zoomedContentPanel);
    }

    public void switchToMainView() {
        this.switchToNewView(this.mainConfig, 0, this.mainContentPanel);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        final Notification notification = (Notification)this.notificationList.getSelectedValue();
        if (!notification.read) {
            notification.read = true;
            --this.unreadCount;
            this.techUI.updateUnreadNotificationCount();
        }
        this.showNotificationZoomed(notification);
        new Thread(){

            @Override
            public void run() {
                try {
                    SideNotificationPanel.this.tc.markNotificationRead(notification);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }.start();
    }

    public void setTechClient(TechClient tc) {
        this.tc = tc;
    }

    public void showNotificationZoomed(Notification notification) {
        NotificationPanel largePanel = new NotificationPanel(notification, true);
        this.zoomedPane.setViewportView(largePanel);
        this.zoomedPane.revalidate();
        this.switchToZoomedView();
    }

    public JPanel getRootComponent() {
        return this.rootComponent;
    }

    public SideNotificationPanel(TechUi techUI) {
        this.techUI = techUI;
        this.initUI();
    }

    private void initUI() {
        this.initSlidingConfigs();
        this.notificationList.setBackground(BACKGROUND_COLOR);
        this.notificationList.setModel(new SimpleListModel<Notification>(this.allNotifications));
        this.notificationList.setCellRenderer(new NotificationCellRenderer());
        this.notificationList.addListSelectionListener(this);
        this.pane.setViewportView(this.notificationList);
        this.pane.setHorizontalScrollBarPolicy(31);
        this.pane.getVerticalScrollBar().setUnitIncrement(SHStyle.SCROLL_UNIT_INCREMENT);
        this.pane.getVerticalScrollBar().setBlockIncrement(SHStyle.SCROLL_BLOCK_INCREMENT);
        this.pane.setBorder(SHBorderFactory.createEmptyBorder());
        this.zoomedPane.setHorizontalScrollBarPolicy(31);
        this.zoomedPane.getVerticalScrollBar().setUnitIncrement(SHStyle.SCROLL_UNIT_INCREMENT);
        this.zoomedPane.getVerticalScrollBar().setBlockIncrement(SHStyle.SCROLL_BLOCK_INCREMENT);
        this.zoomedPane.setBorder(SHBorderFactory.createEmptyBorder());
        this.slidingPanelParent.add(this.containerSliding);
        this.mainContentPanel.add((Component)this.pane, "Center");
        this.mainContentPanel.add((Component)this.southPanel, "South");
        this.southPanel.setLayout(new FlowLayout());
        this.southPanel.add(this.clear);
        this.clear.addActionListener(this);
        this.zoomedContentPanel.add((Component)this.zoomedPane, "Center");
        this.zoomedContentPanel.add((Component)this.zoomedSouthPanel, "South");
        this.zoomedSouthPanel.setLayout(new FlowLayout());
        this.zoomedSouthPanel.add(this.back);
        this.back.addActionListener(this);
        this.rootComponent.setContentsPanel(this.slidingPanelParent);
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        int i;
        Language.loadTranslations();
        Notification[] testData = Notification.createTestNotifications(1);
        SimpleHelpFrame frame = SimpleHelpFrame.getTestFrame();
        SideNotificationPanel notificationPanel = new SideNotificationPanel(null);
        notificationPanel.load(testData);
        frame.getContentPane().add(notificationPanel.getRootComponent());
        frame.setVisible(true);
        Thread.sleep(1000L);
        Notification[] tests = new Notification[100];
        for (i = 0; i < 100; ++i) {
            tests[i] = ServerNotificationUtil.getAlertExceededLimitNotification(i, 100);
        }
        notificationPanel.load(tests);
        for (i = 0; i < 100; ++i) {
            notificationPanel.addNotification(ServerNotificationUtil.getAlertExceededLimitNotification(100 + i, 200));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(Notification[] notifications) {
        this.allNotifications.startBatch();
        try {
            for (int i = notifications.length - 1; i >= 0; --i) {
                Notification notification = notifications[i];
                this.allNotifications.add(notification);
                if (notification.read) continue;
                ++this.unreadCount;
            }
            this.rootComponent.setHasContents(this.allNotifications.size() > 0);
            if (this.techUI != null) {
                this.techUI.updateUnreadNotificationCount();
            }
        }
        finally {
            this.allNotifications.endBatch();
        }
    }

    public void addNotification(Notification newNotification) {
        if (newNotification == null) {
            return;
        }
        this.allNotifications.add(newNotification);
        if (!newNotification.read) {
            ++this.unreadCount;
            if (this.techUI != null) {
                this.techUI.updateUnreadNotificationCount();
            }
        }
        this.rootComponent.setHasContents(this.allNotifications.size() > 0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.clear) {
            try {
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            SideNotificationPanel.this.tc.clearAllNotifications();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }.start();
                this.panels.clear();
                this.notificationList.removeAll();
                this.notificationList.revalidate();
                this.notificationList.repaint();
                this.rootComponent.setHasContents(false);
                this.unreadCount = 0;
                this.techUI.updateUnreadNotificationCount();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        } else if (e.getSource() == this.back) {
            this.switchToMainView();
        }
    }

    public int getUnreadCount() {
        return this.unreadCount;
    }

    class NotificationCellRenderer
    implements ListCellRenderer {
        NotificationPanel notificationPanel;

        NotificationCellRenderer() {
            this.notificationPanel = new NotificationPanel();
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof Notification) {
                this.notificationPanel.setNotification((Notification)value);
            }
            return this.notificationPanel;
        }
    }

    private class DownloadReportThread
    extends Thread {
        private final JButton button;
        private final ReportNotification notification;

        public DownloadReportThread(Notification notification, JButton button) {
            this.notification = (ReportNotification)notification;
            this.button = button;
            this.start();
        }

        @Override
        public void run() {
            try {
                File saveDir = SafeJFileChooser.saveDirectory(SideNotificationPanel.this.rootComponent);
                if (saveDir != null) {
                    ReportingClient.fetchReport(SwingUtil.getRootPaneContainer(SideNotificationPanel.this.rootComponent), SideNotificationPanel.this.tc, saveDir, this.notification.getMetadata().filename, this.notification.getMetadata().creationTime);
                }
            }
            finally {
                this.button.setEnabled(true);
            }
        }
    }

    class NotificationPanel
    extends GbPanel
    implements ActionListener {
        Notification notification;
        private JLabel title;
        private boolean large;
        private JButton[] moreInfoButtons;
        private JWrapTextAreaLabel message;
        private JLabel ago;
        private GbPanel buttonsPanel;

        public NotificationPanel() {
            this(null, false);
        }

        public NotificationPanel(Notification notification, boolean large) {
            super(new Insets(5, 5, 5, 5));
            this.moreInfoButtons = null;
            this.buttonsPanel = new GbPanel();
            this.large = large;
            this.initUI();
            this.setNotification(notification);
        }

        public void setNotification(Notification n) {
            if (n == null) {
                return;
            }
            this.notification = n;
            this.title.setText(this.notification.title);
            if (!this.notification.read) {
                this.title.setIcon(ImageLoader.getImageIcon("images/svg/bulbs/bulb-blue.svg,12"));
            } else {
                this.title.setIcon(null);
            }
            String msg = this.notification.message;
            this.message.setText(msg);
            if (this.notification.timestamp > 0L) {
                if (TimeUtil.isToday(this.notification.timestamp)) {
                    this.ago.setText(SideNotificationPanel.this.dateTime.format(new Date(this.notification.timestamp)));
                } else {
                    this.ago.setText(SideNotificationPanel.this.timeFormatter.getFormattedTimeAgo(System.currentTimeMillis() - this.notification.timestamp));
                }
            }
            if (this.large) {
                if (this.notification.isSupportFinishedNotification()) {
                    if (SideNotificationPanel.this.tc.isSimpleHelpAdminUser()) {
                        this.moreInfoButtons = new JButton[1];
                        this.moreInfoButtons[0] = new JButton(Language.get("RENEW_SUPPORT"));
                    }
                } else if (this.notification.isNewReleaseNotification()) {
                    if (SideNotificationPanel.this.tc.isSimpleHelpAdminUser()) {
                        this.moreInfoButtons = new JButton[2];
                        this.moreInfoButtons[0] = new JButton(Language.get("NOTIFICATIONS_VIEW_LICENSE"));
                        this.moreInfoButtons[1] = new JButton(Language.get("DOWNLOAD_LATEST_VERSION"));
                    } else {
                        this.moreInfoButtons = new JButton[1];
                        this.moreInfoButtons[0] = new JButton(Language.get("DOWNLOAD_LATEST_VERSION"));
                    }
                } else if (this.notification.isAlertLimitExceeded()) {
                    this.moreInfoButtons = new JButton[1];
                    this.moreInfoButtons[0] = new JButton(Language.get("ALERT_LIMIT_ACTION"));
                } else if (this.notification.isReportNotification()) {
                    this.moreInfoButtons = new JButton[1];
                    this.moreInfoButtons[0] = new JButton(Language.get("DOWNLOAD"));
                } else if (this.notification.isAlertNotification() && this.notification.hasMetadata()) {
                    this.moreInfoButtons = new JButton[1];
                    this.moreInfoButtons[0] = new JButton(Language.get("VIEW_MACHINE"));
                }
            }
            if (this.moreInfoButtons != null) {
                this.buttonsPanel.removeAll();
                int Y = 0;
                for (JButton b : this.moreInfoButtons) {
                    b.addActionListener(this);
                    this.buttonsPanel.add(b, 0, Y++, 3, 1, 1, 0, 10, 2, new Insets(10, 0, 0, 0));
                }
                this.buttonsPanel.revalidate();
                this.buttonsPanel.repaint();
            }
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            if (!this.large && d.height > SimpleHelpLookAndFeel.scale(80)) {
                d.height = SimpleHelpLookAndFeel.scale(80);
            }
            return d;
        }

        private void initUI() {
            if (this.large) {
                this.setBorder(EMPTY_BORDER);
            } else {
                this.setBorder(FADED_BORDER);
            }
            this.setBackground(BACKGROUND_COLOR);
            this.buttonsPanel.setBackground(BACKGROUND_COLOR);
            this.title = new JLabel();
            SwingUtil.setWidth(this.title, SimpleHelpLookAndFeel.scale(10));
            this.message = new JWrapTextAreaLabel();
            if (!this.large) {
                SwingUtil.setHeight(this.message, SimpleHelpLookAndFeel.scale(30));
            }
            this.ago = new JLabel();
            this.title.setFont(this.title.getFont().deriveFont(1));
            this.message.setForeground(SHStyle.EXAMPLE_TEXT_COLOR_DARKER);
            this.ago.setForeground(SHStyle.EXAMPLE_TEXT_COLOR_DARKER);
            int Y = 0;
            this.add(this.title, 0, Y, 1, 1, 1, 0, 17, 1);
            this.add(this.ago, 1, Y++, 1, 1, 0, 0, 13, 0);
            this.add(this.message, 0, Y++, 2, 1, 1, 0, 17, 1);
            if (this.large) {
                this.add(this.buttonsPanel, 0, Y++, 2, 2, 1, 0, 10, 1);
                this.add(new JPanel(), 0, Y++, 2, 2, 1, 1, 10, 0);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.notification.isSupportFinishedNotification()) {
                AdminLicense.showUpdateInBrowser(SideNotificationPanel.this.tc);
            } else if (this.notification.isAlertNotification()) {
                SideNotificationPanel.this.techUI.showMachine(((AlertNotification)this.notification).getMetadata().getMachineID());
            } else if (this.notification.isAlertLimitExceeded()) {
                AdminLicense.showUpdateInBrowser(SideNotificationPanel.this.tc);
            } else if (this.notification.isReportNotification()) {
                JButton source = (JButton)e.getSource();
                source.setEnabled(false);
                new DownloadReportThread(this.notification, source);
            } else if (this.notification.isNewReleaseNotification()) {
                if (SideNotificationPanel.this.tc.isSimpleHelpAdminUser() && e.getSource() == this.moreInfoButtons[0]) {
                    AdminLicense.showUpdateInBrowser(SideNotificationPanel.this.tc);
                } else {
                    try {
                        Browser.openURL(new URL("https://simple-help.com/downloads"));
                    }
                    catch (MalformedURLException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }
    }
}

