/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech;

import com.aem.sdesktop.ClientBranding;
import com.aem.shelp.common.Language;
import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.RootPaneContainer;
import utils.swing.JFixedWidthPasswordField;
import utils.swing.JFixedWidthTextField;
import utils.swing.SwingUtil;
import utils.swing.components.JWrapLabel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.dialog.glassdialog.ScaledGlassDialog;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public class ElevationGlassDialog
extends ScaledGlassDialog
implements ActionListener,
KeyListener {
    private JCheckBox requestRemote = new JCheckBox();
    private JTextField login = new JFixedWidthTextField();
    private JPasswordField pass = new JFixedWidthPasswordField();
    private JLabel llogin;
    private JLabel lpass;
    private JPanel main = new JPanel();
    private JPanel panel = new JPanel();
    private GbPanel buttons = new GbPanel();
    private JButton bok;
    private JButton bcancel;
    private String defaultUsername = "";
    String spass = null;
    String slogin = null;
    boolean spromptRemote = false;

    public ElevationGlassDialog(RootPaneContainer frame, String defaultUsername) {
        super(frame, 400, 250, true, true, false);
        this.defaultUsername = defaultUsername;
        this.setModal(true);
        this.initUI(false);
        this.initFocus();
        this.setVisible(true);
    }

    private void initFocus() {
        this.login.setText(this.defaultUsername);
        if (this.defaultUsername == null || this.defaultUsername.length() == 0) {
            this.setFocusComponent(this.login);
        } else {
            this.setFocusComponent(this.pass);
        }
    }

    private void initUI(boolean showHost) {
        JLabel icon = new JLabel(ImageLoader.getImageIcon("images/svg/general/lock.svg,48"));
        JWrapLabel description = new JWrapLabel("<html>" + Language.get("ELEVATION_DESCRIPTION") + "</html>");
        description.setHorizontalAlignment(0);
        this.llogin = new JLabel(Language.get("SERVER_USERNAME") + ": ");
        this.llogin.setHorizontalAlignment(4);
        this.lpass = new JLabel(Language.get("SERVER_PASSWORD") + ": ");
        this.lpass.setHorizontalAlignment(4);
        this.bok = new JButton(Language.get("ELEVATE"), ImageLoader.getImageIcon("images/svg/arrows/right-moving.svg,16"));
        this.bcancel = new JButton(Language.get("CANCEL"), ImageLoader.getImageIcon("images/svg/general/cancel.svg,16"));
        SHButtonUI.makeButtonBlue(this.bok);
        GridBagLayout gbl = new GridBagLayout();
        this.panel.setLayout(gbl);
        int Y = 1;
        int X = 0;
        int buffer = 5;
        int leftBuffer = 30;
        this.requestRemote.setSelected(false);
        this.requestRemote.setText(Language.get("ELEVATE_REMOTE"));
        gbl.setConstraints(this.requestRemote, new GridBagConstraints(X, Y++, 2, 1, 300.0, 100.0, 17, 2, new Insets(buffer, buffer, 3, 3), 0, 0));
        gbl.setConstraints(this.llogin, new GridBagConstraints(X, Y, 1, 1, 0.0, 100.0, 13, 0, new Insets(buffer, buffer, 3, 3), 0, 0));
        gbl.setConstraints(this.login, new GridBagConstraints(X + 1, Y++, 1, 1, 300.0, 100.0, 10, 2, new Insets(buffer, 2, 3, leftBuffer), 0, 0));
        gbl.setConstraints(this.lpass, new GridBagConstraints(X, Y, 1, 1, 0.0, 100.0, 13, 0, new Insets(3, leftBuffer, 3, 3), 0, 0));
        gbl.setConstraints(this.pass, new GridBagConstraints(X + 1, Y++, 1, 1, 300.0, 100.0, 10, 2, new Insets(3, 2, 3, leftBuffer), 0, 0));
        buffer = 3;
        JPanel panel2 = new JPanel();
        GridBagLayout gbl1 = new GridBagLayout();
        panel2.setLayout(gbl1);
        gbl1.setConstraints(icon, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(buffer, buffer, buffer, buffer), 0, 0));
        gbl1.setConstraints(description, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(buffer, buffer, buffer, buffer), 0, 0));
        panel2.add(icon);
        panel2.add(description);
        gbl.setConstraints(panel2, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 2, new Insets(buffer, buffer, buffer, buffer), 0, 0));
        this.panel.add(panel2);
        this.panel.add(this.requestRemote);
        this.panel.add(this.login);
        this.panel.add(this.pass);
        this.panel.add(this.llogin);
        this.panel.add(this.lpass);
        this.getContentPane().add(this.main);
        this.main.setLayout(new BorderLayout());
        this.main.add("Center", this.panel);
        this.main.add("South", this.buttons);
        SwingUtil.setSizesToWidest(this.bok, this.bcancel);
        this.buttons.add(this.bcancel, 0, 0, 1, 1, 1, 1, 13, 0, new Insets(0, 0, 0, 10));
        this.buttons.add(this.bok, 1, 0, 1, 1, 0, 1, 13, 0, new Insets(0, 10, 0, 0));
        this.buttons.setBorder(SHBorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.bok.addActionListener(this);
        this.bcancel.addActionListener(this);
        this.login.addKeyListener(this);
        this.pass.addKeyListener(this);
        this.requestRemote.addActionListener(this);
        this.setTitle(ClientBranding.get().getApplicationName(false) + " " + Language.get("ELEVATION_TITLE"));
    }

    public boolean mustPromptRemote() {
        return this.spromptRemote;
    }

    public String getPass() {
        return this.spass;
    }

    public String getUName() {
        return this.slogin;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        this.actionPerformed(o);
    }

    public void actionPerformed(Object o) {
        if (o == this.bok) {
            this.spromptRemote = this.requestRemote.isSelected();
            try {
                this.spass = new String(this.pass.getPassword());
            }
            catch (Exception e) {
                e.printStackTrace();
                this.spass = "";
            }
            this.slogin = this.login.getText();
            this.setVisible(false);
        } else if (o == this.bcancel) {
            this.spass = null;
            this.slogin = null;
            this.setVisible(false);
        } else if (o == this.requestRemote) {
            boolean on = !this.requestRemote.isSelected();
            this.login.setEnabled(on);
            this.llogin.setEnabled(on);
            this.pass.setEnabled(on);
            this.lpass.setEnabled(on);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.actionPerformed(this.bok);
        } else if (e.getKeyCode() == 27) {
            this.actionPerformed(this.bcancel);
        }
    }

    @Override
    public void keyReleased(KeyEvent arg0) {
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }

    public static void main(String[] args) {
        SimpleHelpFrame frame = new SimpleHelpFrame();
        frame.setDefaultCloseOperation(3);
        frame.setSize(500, 500);
        frame.setVisible(true);
        ElevationGlassDialog dialog = new ElevationGlassDialog(frame, Language.get("ADMINISTRATOR"));
    }
}

