/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.types.filters;

import com.aem.shelp.proxy.types.AbstractMachine;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.proxy.types.filters.Filter;
import utils.message.Message;

public class MachineFilter
extends Filter {
    public static String FIELD_NAME = "Filter_Name";
    public static String FIELD_GROUP = "Filter_Group";
    public static String FIELD_ANCESTOR = "Filter_Ancestor";
    public static String FIELD_DETAILS = "Filter_FullDetails";

    public MachineFilter() {
        super(true);
    }

    public MachineFilter(boolean isShow, String field, int checkAction, String text) {
        super(true, isShow, field, checkAction, text);
    }

    @Override
    public boolean include(AbstractMachine customerOrMachine) {
        if (!(customerOrMachine instanceof Machine)) {
            return false;
        }
        Machine machine = (Machine)customerOrMachine;
        if (this.fieldNameToFilter.equals(FIELD_NAME)) {
            return this.checkIsIncludedByFilter(machine.getMachineName().getName());
        }
        if (this.fieldNameToFilter.equals(FIELD_GROUP)) {
            String parent = machine.getMachineName().getParentGroup();
            return this.checkIsIncludedByFilter(parent);
        }
        if (this.fieldNameToFilter.equals(FIELD_ANCESTOR)) {
            String groups = machine.getMachineName().getGroupString();
            return this.checkIsIncludedByFilter(groups);
        }
        if (this.fieldNameToFilter.equals(FIELD_DETAILS)) {
            return this.checkIsIncludedByFilter(machine.toComparisonString());
        }
        return false;
    }

    @Override
    protected String getRootTag() {
        return "MachineFilter";
    }

    public static Message toMessage(Filter[] filters) {
        Message top = new Message();
        for (Filter genfilter : filters) {
            MachineFilter filter = (MachineFilter)genfilter;
            top.append(MachineFilter.filterToMessage(filter));
        }
        return top;
    }

    public static Message filterToMessage(MachineFilter filter) {
        Message m = new Message();
        m.append(filter.isShow);
        m.append(filter.fieldNameToFilter);
        m.append(filter.checkActionText);
        m.append(filter.checkAction);
        return m;
    }

    public static MachineFilter filterFromMessage(Message m) {
        MachineFilter filter = new MachineFilter();
        filter.isShow = m.getNextBoolean();
        filter.fieldNameToFilter = m.getNextString();
        filter.checkActionText = m.getNextString();
        filter.checkAction = m.getNextInt();
        return filter;
    }

    public static MachineFilter[] filtersFromMessage(Message m) {
        MachineFilter[] filters = new MachineFilter[m.length()];
        int i = 0;
        while (m.hasNext()) {
            Message sub = m.getNextMessage();
            filters[i++] = MachineFilter.filterFromMessage(sub);
        }
        return filters;
    }
}

