/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.types.filters;

import com.aem.shelp.proxy.types.AbstractMachine;
import com.aem.shelp.util.SimpleRegex;
import java.util.regex.Pattern;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import utils.xml.XML14Util;

public abstract class Filter {
    public static final int CHECK_ACTION_EQUALS = 0;
    public static final int CHECK_ACTION_NEQUALS = 1;
    public static final int CHECK_ACTION_CONTAINS = 2;
    public static final int CHECK_ACTION_NCONTAINS = 3;
    public static final int CHECK_ACTION_MATCHES = 4;
    protected boolean isRemoteAccess = false;
    protected boolean isShow = true;
    protected String fieldNameToFilter;
    protected int checkAction;
    protected String checkActionText;
    private Pattern checkActionPattern = null;

    public abstract boolean include(AbstractMachine var1);

    protected Filter(boolean isRemoteAccess) {
        this.isRemoteAccess = isRemoteAccess;
    }

    public Filter(boolean isRemoteAccess, boolean isShow, String fieldNameToFilter, int checkAction, String checkActionText) {
        this.isShow = isShow;
        this.isRemoteAccess = isRemoteAccess;
        this.fieldNameToFilter = fieldNameToFilter;
        this.checkAction = checkAction;
        this.checkActionText = checkActionText;
        this.reloadPattern();
    }

    private void reloadPattern() {
        try {
            if (this.checkAction == 4) {
                this.checkActionPattern = SimpleRegex.simpleToPattern(this.checkActionText, false);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.checkActionPattern = null;
        }
    }

    public boolean isShow() {
        return this.isShow;
    }

    public String getFieldNameToFilter() {
        return this.fieldNameToFilter;
    }

    public int getCheckAction() {
        return this.checkAction;
    }

    public String getCheckActionText() {
        return this.checkActionText;
    }

    protected boolean checkIsIncludedByFilter(String variableValue) {
        switch (this.checkAction) {
            case 0: {
                if (variableValue == null) {
                    return this.checkActionText.length() == 0;
                }
                return variableValue.equals(this.checkActionText);
            }
            case 1: {
                if (variableValue == null) {
                    return true;
                }
                return !variableValue.equals(this.checkActionText);
            }
            case 2: {
                if (this.checkActionText.length() == 0) {
                    return true;
                }
                if (variableValue == null) {
                    return false;
                }
                return variableValue.indexOf(this.checkActionText) != -1;
            }
            case 3: {
                if (variableValue == null) {
                    return true;
                }
                return variableValue.indexOf(this.checkActionText) == -1;
            }
            case 4: {
                if (variableValue == null) {
                    return false;
                }
                if (this.checkActionPattern == null) {
                    return false;
                }
                return this.checkActionPattern.matcher(variableValue).matches();
            }
        }
        return false;
    }

    private String indentation(int size) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < size; ++i) {
            buffer.append("\t");
        }
        return buffer.toString();
    }

    protected abstract String getRootTag();

    public void saveToXML(StringBuffer buffer, int indentationTabs) {
        buffer.append(this.indentation(indentationTabs)).append("<" + this.getRootTag() + ">\n");
        buffer.append(this.indentation(indentationTabs + 1)).append("<RemoteAccess>" + Boolean.toString(this.isRemoteAccess) + "</RemoteAccess>\n");
        buffer.append(this.indentation(indentationTabs + 1)).append("<IsShow>" + Boolean.toString(this.isShow) + "</IsShow>\n");
        buffer.append(this.indentation(indentationTabs + 1)).append("<FieldNameToFilter>" + XML14Util.escape(this.fieldNameToFilter) + "</FieldNameToFilter>\n");
        buffer.append(this.indentation(indentationTabs + 1)).append("<CheckAction>" + this.checkAction + "</CheckAction>\n");
        buffer.append(this.indentation(indentationTabs + 1)).append("<CheckActionText>" + XML14Util.escape(this.checkActionText) + "</CheckActionText>\n");
        buffer.append(this.indentation(indentationTabs)).append("</" + this.getRootTag() + ">\n");
    }

    public void loadFromXML(Element childElement) {
        this.isRemoteAccess = Boolean.parseBoolean(childElement.getElementsByTagName("RemoteAccess").item(0).getTextContent());
        this.isShow = Boolean.parseBoolean(childElement.getElementsByTagName("IsShow").item(0).getTextContent());
        NodeList childList = childElement.getElementsByTagName("FieldNameToFilter");
        this.fieldNameToFilter = childList.getLength() > 0 ? childList.item(0).getTextContent() : null;
        this.checkActionText = childElement.getElementsByTagName("CheckActionText").item(0).getTextContent();
        this.checkAction = Integer.parseInt(childElement.getElementsByTagName("CheckAction").item(0).getTextContent());
        try {
            if (this.checkAction == 4) {
                this.checkActionPattern = SimpleRegex.simpleToPattern(this.checkActionText, false);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.checkActionPattern = null;
        }
    }
}

