/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.types.alerts.threshold;

import com.aem.nodelink.utils.SafeClock;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.types.Alert;
import java.io.InputStream;
import java.net.URL;
import utils.message.Message;

public class WebsiteResponseTimeThreshold
extends Alert {
    public static final Object ID = "WebsiteResponseTimeTrigger";
    String site = "http://www.example.com";
    long responseTimeMS = 5000L;
    boolean over = true;
    long lastChecked = 0L;

    @Override
    public boolean canCreateCorollary() {
        return true;
    }

    @Override
    public String getTypeNameKey() {
        return "ALERT_NET_WEBRT_NAME";
    }

    @Override
    public String getTypeDescKey() {
        return "ALERT_NET_WEBRT_DESC";
    }

    @Override
    public String getTypeIconKey() {
        return "images/svg/computing/network.svg,48";
    }

    @Override
    public String getTypeOverlayKey() {
        return "images/svg/general/clock-simple.svg,24";
    }

    @Override
    public String getDefaultName() {
        if (this.over) {
            return Language.get("ALERT_WEBRT_OVER", new Object[]{this.site, this.getResponseTimeSecs() + "s"});
        }
        return Language.get("ALERT_WEBRT_UNDER", new Object[]{this.site, this.getResponseTimeSecs() + "s"});
    }

    private double getResponseTimeSecs() {
        return (double)this.responseTimeMS / 1000.0;
    }

    @Override
    public Alert createCorollary() {
        WebsiteResponseTimeThreshold clone = (WebsiteResponseTimeThreshold)this.cloneWithNewID();
        clone.over = !clone.over;
        return clone;
    }

    public void setTriggerOn(String site, long responseTime, boolean over) {
        this.site = site;
        this.over = over;
        this.responseTimeMS = responseTime;
    }

    public String getSite() {
        return this.site;
    }

    public long getResponseTimeMS() {
        return this.responseTimeMS;
    }

    public boolean getTriggerIfOver() {
        return this.over;
    }

    @Override
    public boolean isServerSideOnly() {
        return false;
    }

    @Override
    public void toMessage(Message m) {
        super.toMessage(m);
        m.append(this.site);
        m.append(this.responseTimeMS);
        m.append(this.over);
    }

    @Override
    public void fromMessage(Message m) {
        super.fromMessage(m);
        this.site = m.getNextString();
        this.responseTimeMS = m.getNextLong();
        this.over = m.getNextBoolean();
    }

    @Override
    public void timePassed() {
        long now = SafeClock.currentTimeMillis();
        if (now - this.lastChecked > 60000L) {
            this.lastChecked = now;
            boolean overlimit = false;
            try {
                long T = SafeClock.currentTimeMillis();
                URL url = new URL(this.site);
                InputStream in = url.openStream();
                byte[] buf = new byte[50000];
                while (in.read(buf) != -1) {
                }
                in.close();
                if (SafeClock.currentTimeMillis() - T > this.responseTimeMS) {
                    overlimit = true;
                }
            }
            catch (Exception x) {
                return;
            }
            boolean state = false;
            if (overlimit && this.over) {
                state = true;
            }
            if (!overlimit && !this.over) {
                state = true;
            }
            this.updateTriggeredState(state);
        }
    }
}

