/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.types.alerts.threshold;

import com.aem.CentralDebugging;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.types.Alert;
import java.util.regex.Pattern;
import utils.message.Message;
import utils.osstats.Stats;
import utils.string.SimpleRegex;

public class ProcRunningThreshold
extends Alert {
    public static final Object ID = "ProcRunningTrigger";
    String nameMatch = "virus*.exe";
    boolean running = true;

    @Override
    public boolean canCreateCorollary() {
        return true;
    }

    @Override
    public String getTypeNameKey() {
        return "ALERT_PROC_RUN_NAME";
    }

    @Override
    public String getTypeDescKey() {
        return "ALERT_PROC_RUN_DESC";
    }

    @Override
    public String getTypeIconKey() {
        return "images/svg/computing/window.svg,48";
    }

    @Override
    public String getTypeOverlayKey() {
        return "images/svg/users/runner.svg,24";
    }

    @Override
    public String getDefaultName() {
        if (this.running) {
            return Language.get("ALERT_PROC_RUNNING", new Object[]{this.nameMatch});
        }
        return Language.get("ALERT_PROC_NOTRUNNING", new Object[]{this.nameMatch});
    }

    @Override
    public Alert createCorollary() {
        ProcRunningThreshold clone = (ProcRunningThreshold)this.cloneWithNewID();
        clone.running = !clone.running;
        return clone;
    }

    public void setTriggerOnProcess(String nameMatch, boolean running) {
        this.running = running;
        this.nameMatch = nameMatch;
    }

    public String getProcessName() {
        return this.nameMatch;
    }

    public boolean getTriggerIfRunning() {
        return this.running;
    }

    @Override
    public boolean isServerSideOnly() {
        return false;
    }

    @Override
    public void toMessage(Message m) {
        super.toMessage(m);
        m.append(this.nameMatch);
        m.append(this.running);
    }

    @Override
    public void fromMessage(Message m) {
        super.fromMessage(m);
        this.nameMatch = m.getNextString();
        this.running = m.getNextBoolean();
    }

    @Override
    public void machineStats(Stats stats) {
        if (CentralDebugging.ALERT_PROC_RUNNING_DEBUG) {
            System.out.println("[ProcRunningThreshold] Checking to see if process " + this.nameMatch + " running=" + this.running);
        }
        Stats.ProcessStatistic[] procs = stats.getProcessStatistics();
        boolean isRunning = false;
        Pattern pattern = SimpleRegex.simpleToPattern(this.nameMatch, false);
        for (Stats.ProcessStatistic proc : procs) {
            if (CentralDebugging.ALERT_PROC_RUNNING_DEBUG) {
                System.out.println("\tFound process:'" + proc.name + "'");
            }
            if (!pattern.matcher(proc.name).matches()) continue;
            if (CentralDebugging.ALERT_PROC_RUNNING_DEBUG) {
                System.out.println("\tMatched the above process!");
            }
            isRunning = true;
            break;
        }
        boolean state = this.running && isRunning ? true : !this.running && !isRunning;
        if (CentralDebugging.ALERT_PROC_RUNNING_DEBUG) {
            System.out.println("\tResult is running=" + this.running + " and isRunning=" + isRunning + ". Final state=" + state);
        }
        this.updateTriggeredState(state);
    }
}

