/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.types.alerts.threshold;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.types.Alert;
import com.aem.shelp.proxy.types.alerts.threshold.generic.SimpleProcessThreshold;
import java.util.regex.Pattern;
import utils.message.Message;
import utils.osstats.Stats;
import utils.string.SimpleRegex;

public class ProcCpuUsageThreshold
extends Alert
implements SimpleProcessThreshold {
    public static final Object ID = "ProcCpuUsageTrigger";
    double trig = 90.0;
    boolean over = true;
    String procMatch = null;

    @Override
    public boolean canCreateCorollary() {
        return true;
    }

    @Override
    public String getTypeNameKey() {
        return "ALERT_PROC_CPU_NAME";
    }

    @Override
    public String getTypeDescKey() {
        return "ALERT_PROC_CPU_DESC";
    }

    @Override
    public String getTypeIconKey() {
        return "images/svg/computing/window.svg,48";
    }

    @Override
    public String getTypeOverlayKey() {
        return "images/svg/charts/meter.svg,24";
    }

    @Override
    public String getResourceKey() {
        return "ALERT_CONFIG_TRIGGER_CPU_LVL";
    }

    @Override
    public String getResourceUnit() {
        return "%";
    }

    private String getProcName() {
        if (this.procMatch == null) {
            this.procMatch = "";
        }
        if (this.procMatch.length() == 0) {
            return Language.get("ALERT_ANY");
        }
        return "'" + this.procMatch + "'";
    }

    @Override
    public String getDefaultName() {
        if (this.over) {
            return Language.get("ALERT_PROC_CPU_OVER", new Object[]{this.getProcName(), this.trig + "%"});
        }
        return Language.get("ALERT_PROC_CPU_UNDER", new Object[]{this.getProcName(), this.trig + "%"});
    }

    @Override
    public Alert createCorollary() {
        ProcCpuUsageThreshold clone = (ProcCpuUsageThreshold)this.cloneWithNewID();
        clone.over = !clone.over;
        return clone;
    }

    @Override
    public void setTriggerOnOver(boolean b) {
        this.over = b;
    }

    @Override
    public void setTriggerPercent(double d) {
        this.trig = d;
    }

    @Override
    public double getTriggerPercent() {
        return this.trig;
    }

    @Override
    public boolean getTriggerOnOver() {
        return this.over;
    }

    @Override
    public void setMatchString(String s) {
        this.procMatch = s;
    }

    @Override
    public String getMatchString() {
        return this.procMatch;
    }

    @Override
    public boolean isServerSideOnly() {
        return false;
    }

    @Override
    public void toMessage(Message m) {
        super.toMessage(m);
        m.append(this.trig);
        m.append(this.over);
        m.append(this.procMatch);
    }

    @Override
    public void fromMessage(Message m) {
        super.fromMessage(m);
        this.trig = m.getNextDouble();
        this.over = m.getNextBoolean();
        this.procMatch = m.getNextString();
    }

    @Override
    public void machineStats(Stats stats) {
        Stats.ProcessStatistic[] procs = stats.getProcessStatistics();
        double max = 0.0;
        if (this.procMatch == null) {
            this.procMatch = "";
        }
        Pattern pattern = null;
        if (this.procMatch.length() > 0) {
            pattern = SimpleRegex.simpleToPattern(this.procMatch, false);
        }
        for (Stats.ProcessStatistic proc : procs) {
            if (pattern == null) {
                max = Math.max(max, (double)proc.cpuPercentage);
                continue;
            }
            if (!pattern.matcher(proc.name).matches()) continue;
            max = Math.max(max, (double)proc.cpuPercentage);
        }
        boolean state = this.over && max > this.trig ? true : !this.over && max < this.trig;
        this.updateTriggeredState(state);
    }
}

