/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.types.alerts.threshold;

import com.aem.CentralDebugging;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.types.Alert;
import com.aem.shelp.proxy.types.alerts.threshold.generic.SimplePercentThreshold;
import utils.message.Message;
import utils.osstats.Stats;

public class MemoryUsageThreshold
extends Alert
implements SimplePercentThreshold {
    public static final Object ID = "MemoryUsageTrigger";
    double trig = 90.0;
    boolean over = true;

    @Override
    public boolean canCreateCorollary() {
        return true;
    }

    @Override
    public String getTypeNameKey() {
        return "ALERT_MEM_NAME";
    }

    @Override
    public String getTypeDescKey() {
        return "ALERT_MEM_DESC";
    }

    @Override
    public String getTypeIconKey() {
        return "images/svg/technology/screen.svg,48";
    }

    @Override
    public String getTypeOverlayKey() {
        return "images/svg/computing/memory.svg,24";
    }

    @Override
    public String getResourceKey() {
        return "ALERT_CONFIG_TRIGGER_MEMORY_LVL";
    }

    @Override
    public String getResourceUnit() {
        return "%";
    }

    @Override
    public String getDefaultName() {
        if (this.over) {
            return Language.get("ALERT_MEM_OVER", new Object[]{this.trig + "%"});
        }
        return Language.get("ALERT_MEM_UNDER", new Object[]{this.trig + "%"});
    }

    @Override
    public Alert createCorollary() {
        MemoryUsageThreshold clone = (MemoryUsageThreshold)this.cloneWithNewID();
        clone.over = !clone.over;
        return clone;
    }

    @Override
    public void setTriggerOnOver(boolean b) {
        this.over = b;
    }

    @Override
    public void setTriggerPercent(double d) {
        this.trig = d;
    }

    @Override
    public boolean getTriggerOnOver() {
        return this.over;
    }

    @Override
    public double getTriggerPercent() {
        return this.trig;
    }

    @Override
    public boolean isServerSideOnly() {
        return false;
    }

    @Override
    public void toMessage(Message m) {
        super.toMessage(m);
        m.append(this.trig);
        m.append(this.over);
    }

    @Override
    public void fromMessage(Message m) {
        super.fromMessage(m);
        this.trig = m.getNextDouble();
        this.over = m.getNextBoolean();
    }

    @Override
    public void machineStats(Stats stats) {
        double memoryUsedPercent = stats.getMemoryUsedPercent();
        if (CentralDebugging.ALERT_MEMORY_DEBUG) {
            System.out.println("[MemoryUsageThreshold] Memory usage is currently " + memoryUsedPercent);
        }
        boolean state = this.over && memoryUsedPercent > this.trig ? true : !this.over && memoryUsedPercent < this.trig;
        this.updateTriggeredState(state);
    }
}

