/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.types.alerts.threshold;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.types.Alert;
import java.io.File;
import utils.message.Message;

public class FileLengthThreshold
extends Alert {
    public static final Object ID = "FileLengthTrigger";
    String path = null;
    long maxKB = 1000L;
    boolean over;

    @Override
    public boolean canCreateCorollary() {
        return true;
    }

    @Override
    public String getTypeNameKey() {
        return "ALERT_FILE_LENGTH_NAME";
    }

    @Override
    public String getTypeDescKey() {
        return "ALERT_FILE_LENGTH_DESC";
    }

    @Override
    public String getTypeIconKey() {
        return "images/svg/files-folders/files.svg,48";
    }

    @Override
    public String getTypeOverlayKey() {
        return "images/svg/general/compass-measure.svg,24";
    }

    @Override
    public String getDefaultName() {
        if (this.over) {
            return Language.get("ALERT_FILE_LARGER", new Object[]{this.maxKB + "kb"});
        }
        return Language.get("ALERT_FILE_SMALLER", new Object[]{this.maxKB + "kb"});
    }

    @Override
    public Alert createCorollary() {
        FileLengthThreshold clone = (FileLengthThreshold)this.cloneWithNewID();
        clone.over = !clone.over;
        return clone;
    }

    public void setTriggerOnFileLength(String path, long maxKB, boolean over) {
        this.path = path;
        this.maxKB = maxKB;
        this.over = over;
    }

    public boolean getTriggerIfOver() {
        return this.over;
    }

    public String getFilePath() {
        return this.path;
    }

    public long getThresholdKB() {
        return this.maxKB;
    }

    @Override
    public boolean isServerSideOnly() {
        return false;
    }

    @Override
    public void toMessage(Message m) {
        super.toMessage(m);
        m.append(this.path);
        m.append(this.maxKB);
        m.append(this.over);
    }

    @Override
    public void fromMessage(Message m) {
        super.fromMessage(m);
        this.path = m.getNextString();
        this.maxKB = m.getNextLong();
        this.over = m.getNextBoolean();
    }

    @Override
    public void timePassed() {
        boolean fileBigger;
        File f = new File(this.path);
        long len = 0L;
        if (f.exists()) {
            len = f.length();
        }
        boolean bl = fileBigger = len > this.maxKB * 1024L;
        boolean state = fileBigger && this.over ? true : !fileBigger && !this.over;
        this.updateTriggeredState(state);
    }
}

