/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.types.alerts.threshold;

import com.aem.nodelink.utils.SafeClock;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.types.Alert;
import java.io.File;
import utils.message.Message;
import utils.string.SimpleRegex;

public class FileAccessibleThreshold
extends Alert {
    private long lastSearched = 0L;
    private String searchFolder = "";
    private String nameMatch = null;
    private boolean exists = true;
    public static final Object ID = "FileAccessibleTrigger";

    @Override
    public boolean canCreateCorollary() {
        return true;
    }

    @Override
    public String getTypeNameKey() {
        return "ALERT_FILE_ACCESS_NAME";
    }

    @Override
    public String getTypeDescKey() {
        return "ALERT_FILE_ACCESS_DESC";
    }

    @Override
    public String getTypeIconKey() {
        return "images/svg/files-folders/files.svg,48";
    }

    @Override
    public String getTypeOverlayKey() {
        return "images/svg/general/ok.svg,24";
    }

    @Override
    public String getDefaultName() {
        if (this.exists) {
            return Language.get("ALERT_FILE_EXISTS", new Object[]{this.nameMatch, this.searchFolder});
        }
        return Language.get("ALERT_FILE_NOTEXISTS", new Object[]{this.nameMatch, this.searchFolder});
    }

    @Override
    public Alert createCorollary() {
        FileAccessibleThreshold clone = (FileAccessibleThreshold)this.cloneWithNewID();
        clone.exists = !clone.exists;
        return clone;
    }

    public void setTriggerOnFileExists(String searchFolder, String nameMatch, boolean exists) {
        this.searchFolder = searchFolder;
        this.nameMatch = nameMatch;
        this.exists = exists;
        if (this.nameMatch != null) {
            this.nameMatch = this.nameMatch.trim();
        }
    }

    public boolean getTriggerIfExists() {
        return this.exists;
    }

    public String getSearchFolder() {
        return this.searchFolder;
    }

    public String getNameMatch() {
        return this.nameMatch;
    }

    @Override
    public boolean isServerSideOnly() {
        return false;
    }

    @Override
    public void toMessage(Message m) {
        super.toMessage(m);
        m.append(this.searchFolder);
        m.append(this.nameMatch);
        m.append(this.exists);
    }

    @Override
    public void fromMessage(Message m) {
        super.fromMessage(m);
        this.searchFolder = m.getNextString();
        this.nameMatch = m.getNextString();
        this.exists = m.getNextBoolean();
    }

    @Override
    public void timePassed() {
        boolean STATE;
        boolean doSearch;
        long now = SafeClock.currentTimeMillis();
        boolean bl = doSearch = this.nameMatch.contains("*") || this.nameMatch.contains("?");
        if (doSearch) {
            if (now - this.lastSearched < 120000L) {
                return;
            }
            this.lastSearched = now;
            boolean found = this.search(new File(this.searchFolder));
            STATE = found && this.exists ? true : !found && !this.exists;
        } else {
            File fileToCheck = this.nameMatch.length() == 0 ? new File(this.searchFolder) : new File(this.searchFolder, this.nameMatch);
            STATE = fileToCheck.exists() ? this.exists : !this.exists;
        }
        this.updateTriggeredState(STATE);
    }

    private boolean search(File folder) {
        File[] files = folder.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!(file.isDirectory() ? this.search(file) : SimpleRegex.simpleToPattern(this.nameMatch, false).matcher(file.getName()).matches())) continue;
                return true;
            }
        }
        return false;
    }
}

