/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.types.alerts.threshold;

import com.aem.CentralDebugging;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.types.Alert;
import com.aem.shelp.proxy.types.alerts.threshold.generic.SimplePercentThreshold;
import utils.message.Message;
import utils.osstats.Stats;

public class DiskSpaceThreshold
extends Alert
implements SimplePercentThreshold {
    public static final byte MODE_PERCENTAGE = 0;
    public static final byte MODE_FREE_SPACE = 1;
    private byte mode = 0;
    private double diskSpacePercentageThreshold = 90.0;
    private double freeSpaceThresholdValue;
    private long freeSpaceThresholdUnits;
    private boolean over = true;
    private double minimumDiskSize;
    private long minimumDiskSizeUnits;
    public static final String ID = "DiskSpaceTrigger";
    private String[] exclusions;

    @Override
    public boolean canCreateCorollary() {
        return true;
    }

    @Override
    public Alert createCorollary() {
        DiskSpaceThreshold clone = (DiskSpaceThreshold)this.cloneWithNewID();
        clone.over = !clone.over;
        return clone;
    }

    @Override
    public String getTypeNameKey() {
        return "ALERT_DISK_SPACE_NAME";
    }

    @Override
    public String getTypeDescKey() {
        return "ALERT_DISK_SPACE_DESC";
    }

    @Override
    public String getTypeIconKey() {
        return "images/svg/technology/screen.svg,48";
    }

    @Override
    public String getTypeOverlayKey() {
        return "images/svg/computing/database.svg,24";
    }

    @Override
    public String getResourceKey() {
        return "ALERT_CONFIG_TRIGGER_DISK_LVL";
    }

    @Override
    public String getResourceUnit() {
        return "%";
    }

    @Override
    public String getDefaultName() {
        if (this.over) {
            return Language.get("ALERT_DISK_SPACE_OVER", new Object[]{this.diskSpacePercentageThreshold + "%"});
        }
        return Language.get("ALERT_DISK_SPACE_UNDER", new Object[]{this.diskSpacePercentageThreshold + "%"});
    }

    public boolean isPercentageMode() {
        return this.mode == 0;
    }

    @Override
    public void setTriggerOnOver(boolean b) {
        this.over = b;
    }

    @Override
    public boolean getTriggerOnOver() {
        return this.over;
    }

    @Override
    public void setTriggerPercent(double d) {
        this.diskSpacePercentageThreshold = d;
    }

    @Override
    public double getTriggerPercent() {
        return this.diskSpacePercentageThreshold;
    }

    public void setFreeSpace(double value, long units) {
        this.freeSpaceThresholdUnits = units;
        this.freeSpaceThresholdValue = value;
    }

    public double getFreeSpaceValue() {
        return this.freeSpaceThresholdValue;
    }

    public long getFreeSpaceUnits() {
        return this.freeSpaceThresholdUnits;
    }

    public double getMinimumDiskSize() {
        return this.minimumDiskSize;
    }

    public long getMinimumDiskSizeUnits() {
        return this.minimumDiskSizeUnits;
    }

    public void setMinimumDiskSize(double size, long units) {
        this.minimumDiskSize = size;
        this.minimumDiskSizeUnits = units;
    }

    public void setMode(byte mode) {
        this.mode = mode;
    }

    @Override
    public boolean isServerSideOnly() {
        return false;
    }

    @Override
    public void toMessage(Message m) {
        super.toMessage(m);
        m.append(this.diskSpacePercentageThreshold);
        m.append(this.over);
        m.append(this.mode);
        m.append(this.freeSpaceThresholdValue);
        m.append(this.freeSpaceThresholdUnits);
        m.append(this.minimumDiskSize);
        m.append(this.minimumDiskSizeUnits);
        if (this.exclusions == null) {
            m.append(new String[0]);
        } else {
            m.append(this.exclusions);
        }
    }

    @Override
    public void fromMessage(Message m) {
        super.fromMessage(m);
        this.diskSpacePercentageThreshold = m.getNextDouble();
        this.over = m.getNextBoolean();
        if (this.version >= 10) {
            this.mode = m.getNextByte();
            this.freeSpaceThresholdValue = m.getNextDouble();
            this.freeSpaceThresholdUnits = m.getNextLong();
            this.minimumDiskSize = m.getNextDouble();
            this.minimumDiskSizeUnits = m.getNextLong();
            this.exclusions = m.getNextStringArray();
        } else {
            this.mode = 0;
        }
    }

    @Override
    public void machineStats(Stats stats) {
        boolean ON;
        long minimumDiskSizeBytes = (long)((double)this.minimumDiskSizeUnits * this.minimumDiskSize);
        if (CentralDebugging.ALERT_DISK_SPACE_DEBUG) {
            if (stats.getDiskSpaceStatistic() != null) {
                for (Stats.DiskSpaceStatistic statistic : stats.getDiskSpaceStatistic()) {
                    System.out.println("[DiskSpaceThreshold] Disk: " + statistic.name + " / used:" + statistic.used + " / free:" + statistic.free + " / perc:" + statistic.getDiskUsagePercent() + " / " + statistic.isRecovery + " / " + statistic.isShared);
                }
            }
            System.out.println("[DiskSpaceThreshold] Minimum size is " + minimumDiskSizeBytes);
            if (this.exclusions != null) {
                for (String s : this.exclusions) {
                    System.out.println("[DiskSpaceThreshold] Excluding '" + (String)s + "'");
                }
            }
        }
        if (this.mode == 0) {
            if (CentralDebugging.ALERT_DISK_SPACE_DEBUG) {
                System.out.println("[DiskSpaceThreshold] Checking percentage " + this.diskSpacePercentageThreshold + " over:" + this.over);
            }
            double max = stats.getMaxDiskUsagePercent(minimumDiskSizeBytes, this.exclusions);
            if (CentralDebugging.ALERT_DISK_SPACE_DEBUG) {
                System.out.println("[DiskSpaceThreshold] Max disk usage percentage is " + max);
            }
            ON = max > this.diskSpacePercentageThreshold ? this.over : !this.over;
        } else {
            Stats.DiskSpaceStatistic[] drives;
            if (CentralDebugging.ALERT_DISK_SPACE_DEBUG) {
                System.out.println("[DiskSpaceThreshold] Checking free space size " + this.freeSpaceThresholdValue + "/" + this.freeSpaceThresholdUnits + " over:" + this.over);
            }
            ON = false;
            long threshold = (long)((double)this.freeSpaceThresholdUnits * this.freeSpaceThresholdValue);
            if (CentralDebugging.ALERT_DISK_SPACE_DEBUG) {
                System.out.println("[DiskSpaceThreshold] Threshold free disk space is " + threshold + " bytes");
            }
            for (Stats.DiskSpaceStatistic drive : drives = stats.getMeaningfulDriveList(this.exclusions)) {
                long free = drive.free;
                if (CentralDebugging.ALERT_DISK_SPACE_DEBUG) {
                    System.out.println("[DiskSpaceThreshold] Disk free is " + free);
                }
                if (this.over && free > threshold) {
                    ON = true;
                    break;
                }
                if (this.over || free >= threshold) continue;
                ON = false;
                break;
            }
        }
        this.updateTriggeredState(ON);
    }

    public String[] getExclusions() {
        return this.exclusions;
    }

    public void setExclusions(String[] exclusions) {
        this.exclusions = exclusions;
    }
}

