/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.types.alertlocs;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.types.AlertLocation;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.proxy.types.interfaces.MachineRegistryInterface;
import java.util.ArrayList;
import utils.message.Message;

public class StaticListAloc
extends AlertLocation {
    public static final Object ID = "StaticListAloc";
    String[] ids;

    @Override
    public void toMessage(Message m) {
        super.toMessage(m);
        if (this.ids == null) {
            m.append(0);
        } else {
            m.append(this.ids.length);
            for (int i = 0; i < this.ids.length; ++i) {
                m.append(this.ids[i]);
            }
        }
    }

    @Override
    public void fromMessage(Message m) {
        super.fromMessage(m);
        int count = m.getNextInt();
        this.ids = new String[count];
        for (int i = 0; i < count; ++i) {
            this.ids[i] = m.getNextString();
        }
    }

    public StaticListAloc(String[] ids) {
        this.ids = ids;
    }

    public StaticListAloc() {
    }

    @Override
    public boolean isServerLocated() {
        return false;
    }

    @Override
    public String[] getTargetMachines(MachineRegistryInterface macreg, ArrayList<Machine> allMachines, long round) {
        return this.ids;
    }

    @Override
    public String getMachineSummary() {
        if (this.ids == null) {
            return Language.get("STATIC_LIST_ALERT_LOCATION", new Object[]{"0"});
        }
        return Language.get("STATIC_LIST_ALERT_LOCATION", new Object[]{this.ids.length});
    }
}

