/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.types;

import bcutil.BCUtil;
import com.aem.shelp.proxy.types.ActionableResourceContainer;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.proxy.types.MachineName;
import com.aem.shelp.tech.hierarchy.model.TreeElement;
import utils.loggingframework.events.LogEvent;
import utils.loggingframework.filters.LogFilter;
import utils.loggingframework.logmapping.LogMapping;
import utils.loggingframework.targets.AbstractTarget;
import utils.message.Message;
import utils.string.StringUtil;

public class ServerEvent
extends ActionableResourceContainer
implements LogMapping {
    public static final String SERIALISATION_ID = "ServerEvent";
    private transient Object uiMetadata = null;
    private String[] logEventIDs;
    private LogFilter[] filters = null;
    private MachineName eventName;
    private String id = ServerEvent.nextID();

    public static String nextID() {
        return "SE-" + Math.abs(BCUtil.getSecureRandom().nextLong());
    }

    @Override
    public String[] getLogEventIDs() {
        return this.logEventIDs;
    }

    public void setLogEventIDs(String[] logIDs) {
        this.logEventIDs = logIDs;
    }

    public void setName(String s) {
        this.eventName = new MachineName(s);
    }

    @Override
    public void setName(MachineName name) {
        this.eventName = name;
    }

    @Override
    public MachineName getName() {
        return this.eventName;
    }

    public static ServerEvent createTestAlert() {
        ServerEvent sea = new ServerEvent();
        return sea;
    }

    @Override
    public Machine.MachineChanges copyStateFrom(TreeElement sourceElement) {
        ServerEvent source = (ServerEvent)sourceElement;
        Machine.MachineChanges changes = new Machine.MachineChanges();
        changes.nameChange = false;
        if (!sourceElement.getName().equals(this.getName())) {
            changes.nameChange = true;
        }
        this.filters = source.getFilters();
        this.logEventIDs = source.logEventIDs;
        this.targets = source.targets;
        return changes;
    }

    @Override
    public AbstractTarget getTarget() {
        if (this.targets != null && this.targets.length > 0) {
            return this.targets[0];
        }
        return null;
    }

    public void setTarget(AbstractTarget target) {
        if (this.targets == null || this.targets.length == 0) {
            this.targets = new AbstractTarget[1];
        }
        this.targets[0] = target;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public boolean matchesFilter(String filter) {
        filter = filter.toLowerCase();
        MachineName name = this.getName();
        return name.toString().toLowerCase().contains(filter);
    }

    public Object getUIMetadata() {
        return this.uiMetadata;
    }

    public void setUIMetadata(Object metadata) {
        this.uiMetadata = metadata;
    }

    public String toString() {
        return this.getName().toString();
    }

    public long getPreviousTriggerTime() {
        return 0L;
    }

    public long getTriggerDuration() {
        return 0L;
    }

    public boolean equals(Object o) {
        if (o instanceof ServerEvent) {
            ServerEvent m = (ServerEvent)o;
            return StringUtil.equal(m.getID(), this.getID());
        }
        return false;
    }

    @Override
    public void fromMessage(byte version, Message m) {
        super.fromMessage(version, m);
        this.id = m.getNextString();
        this.eventName = MachineName.extractFromNameWithGroup(m.getNextString());
        this.logEventIDs = m.getNextStringArray();
        int filterCount = m.getNextInt();
        this.filters = new LogFilter[filterCount];
        for (int i = 0; i < filterCount; ++i) {
            LogFilter f;
            Message filterMessage = m.getNextMessage();
            this.filters[i] = f = LogFilter.newFromMessage(filterMessage);
        }
    }

    @Override
    public void toMessage(Message m) {
        super.toMessage(m);
        m.append(this.id);
        if (this.eventName == null) {
            m.append((String)null);
        } else {
            m.append(this.eventName.toString());
        }
        m.append(this.logEventIDs);
        if (this.filters == null) {
            m.append(0);
        } else {
            m.append(this.filters.length);
            for (LogFilter filter : this.filters) {
                Message filterMessage = new Message();
                filter.toMessage(filterMessage);
                m.append(filterMessage);
            }
        }
    }

    @Override
    public LogFilter[] getFilters() {
        return this.filters;
    }

    @Override
    public String getSerialisationID() {
        return SERIALISATION_ID;
    }

    public void setFilters(LogFilter[] filters) {
        this.filters = filters;
    }

    @Override
    public String getLogMappingDescription() {
        return this.toString();
    }

    @Override
    public boolean canLogEvent(LogEvent event) {
        if (!this.isActive()) {
            return false;
        }
        if (this.logEventIDs != null) {
            for (String supportedID : this.logEventIDs) {
                if (!supportedID.equalsIgnoreCase(event.getID())) continue;
                if (this.filters == null || this.filters.length == 0) {
                    return true;
                }
                for (int ii = 0; ii < this.filters.length; ++ii) {
                    LogFilter filter = this.filters[ii];
                    if (!filter.includeEvent(event)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

