/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.types;

import java.util.ArrayList;
import utils.message.Message;
import utils.string.SafeCmp;

public class MachineName
implements Comparable<MachineName> {
    private String name;
    private String[] group = new String[0];

    public MachineName(String name) {
        this.name = name;
    }

    public MachineName(String name, String[] group) {
        this.name = name;
        this.group = group;
    }

    public String getName() {
        return this.name;
    }

    public String[] getGroup() {
        return this.group;
    }

    public String getParentGroup() {
        if (this.group == null || this.group.length == 0) {
            return null;
        }
        return this.group[this.group.length - 1];
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof MachineName) {
            boolean secondEmpty;
            MachineName mName = (MachineName)o;
            if (!mName.name.equals(this.name)) {
                return false;
            }
            boolean firstEmpty = mName.group == null || mName.group.length == 0;
            boolean bl = secondEmpty = this.group == null || this.group.length == 0;
            if (firstEmpty && secondEmpty) {
                return true;
            }
            if (!firstEmpty && !secondEmpty) {
                return SafeCmp.equal(mName.group, this.group);
            }
            return false;
        }
        return false;
    }

    public static MachineName extractFromNameWithGroup(String nameWithGroup) {
        if (nameWithGroup == null) {
            return null;
        }
        int lastSlash = nameWithGroup.lastIndexOf(47);
        if (lastSlash == -1) {
            return new MachineName(nameWithGroup, null);
        }
        String[] result = nameWithGroup.split("/");
        String[] group = new String[result.length - 1];
        for (int i = 0; i < group.length; ++i) {
            group[i] = result[i];
        }
        return new MachineName(result[result.length - 1], group);
    }

    public String toString() {
        if (this.group == null || this.group.length == 0) {
            return this.name;
        }
        StringBuffer buffer = new StringBuffer();
        for (String g : this.group) {
            buffer.append(g).append("/");
        }
        buffer.append(this.name);
        return buffer.toString();
    }

    public static MachineName fromMessage(Message m) {
        String name = m.getNextString();
        int groupCount = m.getNextByte();
        String[] group = new String[groupCount];
        for (int i = 0; i < groupCount; ++i) {
            group[i] = m.getNextString();
        }
        return new MachineName(name, group);
    }

    public void toMessage(Message m) {
        m.append(this.name);
        if (this.group == null) {
            m.append((byte)0);
        } else {
            m.append((byte)this.group.length);
            for (int i = 0; i < this.group.length; ++i) {
                m.append(this.group[i]);
            }
        }
    }

    @Override
    public int compareTo(MachineName o) {
        return this.toString().toLowerCase().compareTo(o.toString().toLowerCase());
    }

    public boolean isInGroup() {
        return this.group != null && this.group.length > 0;
    }

    public void setGroup(String[] groupPath) {
        this.group = groupPath;
    }

    public String getGroupString() {
        if (this.group == null || this.group.length == 0) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.group.length; ++i) {
            if (i > 0) {
                buffer.append("/");
            }
            buffer.append(this.group[i]);
        }
        return buffer.toString();
    }

    public void setName(String name) {
        this.name = name;
    }

    public static String[] parseGroupList(String groupList) {
        if (groupList == null) {
            return new String[0];
        }
        int startIndex = 0;
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < groupList.length(); ++i) {
            if (groupList.charAt(i) != ',' || i <= 0 || groupList.charAt(i - 1) == '\\') continue;
            String name = groupList.substring(startIndex, i).replaceAll("\\\\,", ",");
            list.add(name);
            startIndex = i + 1;
        }
        String name = groupList.substring(startIndex).replaceAll("\\\\,", ",");
        list.add(name);
        String[] result = new String[list.size()];
        list.toArray(result);
        return result;
    }
}

