/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.types;

import com.aem.VersionUtil;
import com.aem.sdesktop.util.Version;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.MachineChange;
import com.aem.shelp.proxy.types.AbstractMachine;
import com.aem.shelp.proxy.types.AbstractSession;
import com.aem.shelp.proxy.types.AccessSession;
import com.aem.shelp.proxy.types.MachineInfo;
import com.aem.shelp.proxy.types.MachineName;
import com.aem.shelp.proxy.types.TypeUtil;
import com.aem.shelp.tech.access.model.machine.MachineGroupStats;
import com.aem.shelp.tech.hierarchy.model.TreeElement;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Random;
import jwrapper.jwutils.JWWindowsOS;
import utils.message.Message;
import utils.progtools.arrays.BitStore;
import utils.switches.Switches;

public class Machine
extends AbstractMachine
implements TreeElement {
    public static final int IN_USE_YES = 1;
    public static final int IN_USE_NO = 2;
    public static final int IN_USE_HEADLESS = 3;
    public static final int IN_USE_UNKNOWN = 0;
    public static final int MASK_HASH_MISMATCH = 0;
    public static final int MASK_HTTP_1_0 = 1;
    public static final int QUEUED_STOP = 0;
    public static final int QUEUED_RUN_TOOL = 1;
    public static final int QUEUED_MIGRATE = 2;
    public static final byte PROTOCOL_UDP = 1;
    public static final byte PROTOCOL_HTTP = 2;
    public static final byte PROTOCOL_HTTPS = 3;
    private BitStore problemsBitStore = new BitStore();
    private BitStore queuedActions = new BitStore();
    private String machineID;
    private long lastPingTimeMillis;
    private int inUse;
    private String versionWithSub;
    private String build;
    private boolean isAvailable = true;
    private boolean isAutoUpdating = false;
    private MachineInfo info;
    private long lastInUseTimeMillis;
    private byte pollingProtocol;
    private transient ArrayList<AbstractSession> activeSessions = new ArrayList();
    private transient Object uiMetadata = null;
    private transient int transientHashProblemReportCount = 0;

    public void copyTransientDataFrom(Machine machine) {
        this.activeSessions = machine.activeSessions;
        this.uiMetadata = machine.uiMetadata;
    }

    public Machine(String machineID) {
        this.machineID = machineID;
    }

    public Machine(Message m) {
        this((String)null);
        this.fromMessage(m);
    }

    public void setUIMetadata(Object metadata) {
        this.uiMetadata = metadata;
    }

    public Object getUIMetadata() {
        return this.uiMetadata;
    }

    private int booleanMinus(boolean b1, boolean b2) {
        if (b1 == b2) {
            return 0;
        }
        if (b1 && !b2) {
            return 1;
        }
        return -1;
    }

    @Override
    public MachineChanges copyStateFrom(TreeElement sourceElement) {
        Machine source = (Machine)sourceElement;
        MachineChanges changes = new MachineChanges();
        changes.nameChange = false;
        if (this.info == null && source.getMachineInfo() != null) {
            changes.nameChange = true;
        }
        if (this.info != null && source.getMachineInfo() != null && !this.info.getMachineName().equals(source.getMachineInfo().getMachineName())) {
            changes.nameChange = true;
        }
        changes.offlineCount = this.booleanMinus(this.isAvailable(), source.isAvailable());
        changes.availableCount = this.booleanMinus(source.isAvailable(), this.isAvailable());
        if (source.isAvailable) {
            changes.monitored = this.booleanMinus(source.isMonitored(), this.isMonitored());
            changes.autoUpdating = this.booleanMinus(source.isAutoUpdating(), this.isAutoUpdating());
            changes.needRestartCount = this.booleanMinus(source.needsRestarting(), this.needsRestarting());
            changes.needUpgradeCount = this.booleanMinus(source.needsUpgrading(), this.needsUpgrading());
            changes.supportsAutoUpdateCount = this.booleanMinus(source.supportsAutoUpdating(), this.supportsAutoUpdating());
            changes.allowMonitoring = this.booleanMinus(source.allowMonitoring(), this.allowMonitoring());
        }
        this.lastPingTimeMillis = source.lastPingTimeMillis;
        this.inUse = source.inUse;
        this.versionWithSub = source.versionWithSub;
        this.build = source.build;
        this.isAvailable = source.isAvailable;
        this.info = source.info;
        this.isAutoUpdating = source.isAutoUpdating;
        this.lastInUseTimeMillis = source.lastInUseTimeMillis;
        this.problemsBitStore.setStore(source.problemsBitStore.getStore());
        this.pollingProtocol = source.pollingProtocol;
        this.queuedActions.setStore(source.queuedActions.getStore());
        return changes;
    }

    public String toComparisonString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.inUse).append("&");
        sb.append(this.versionWithSub).append("&");
        sb.append(this.build).append("&");
        sb.append(this.isAvailable).append("&");
        sb.append(this.isAutoUpdating).append("&");
        sb.append("SESS").append("&");
        for (int i = 0; i < this.activeSessions.size(); ++i) {
            sb.append(this.activeSessions.get(i)).append("&");
        }
        sb.append("INF").append("&");
        if (this.info != null) {
            sb.append(this.info.toComparisonString());
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o instanceof Machine) {
            Machine m = (Machine)o;
            return m.machineID.equals(this.machineID);
        }
        return false;
    }

    public String getRemoteUsername() {
        if (this.info != null) {
            return this.info.getConsoleUser();
        }
        return null;
    }

    public int hashCode() {
        return this.machineID.hashCode();
    }

    @Override
    public void fromMessage(Message m) {
        super.fromMessage(m);
        this.machineID = m.getNextString();
        this.lastPingTimeMillis = m.getNextLong();
        this.inUse = m.getNextInt();
        this.setAccessServiceVersion(m.getNextString());
        this.isAvailable = m.getNextBoolean();
        if (m.getNextType() == 4) {
            this.info = MachineInfo.fromMessage(m.getNextMessage(), false);
        } else {
            this.info = null;
            m.getNextInt();
        }
        this.isAutoUpdating = m.getNextBoolean();
        this.build = m.getNextString();
        if (this.version >= 2) {
            this.lastInUseTimeMillis = m.getNextLong();
        }
        if (this.version >= 6) {
            this.problemsBitStore = new BitStore(new byte[]{m.getNextByte()});
        }
        if (this.version >= 8) {
            this.pollingProtocol = m.getNextByte();
        }
        if (this.version >= 11) {
            this.queuedActions.setStore(m.getNextByteArray());
        }
    }

    public long getLastInUseTimeMillis() {
        return this.lastInUseTimeMillis;
    }

    public void setLastInUseTimeMillis(long lastInUseTimeMillis) {
        this.lastInUseTimeMillis = lastInUseTimeMillis;
    }

    public String getPollingProtocolAsString() {
        if (this.pollingProtocol == 1) {
            return "udp";
        }
        if (this.pollingProtocol == 2) {
            return "http";
        }
        if (this.pollingProtocol == 3) {
            return "https";
        }
        return "none";
    }

    public byte getPollingProtocol() {
        return this.pollingProtocol;
    }

    public void setPollingProtocol(byte protocol) {
        this.pollingProtocol = protocol;
    }

    public long getLastPingTimeMillis() {
        return this.lastPingTimeMillis;
    }

    public void setLastPingTimeMillis(long lastPingTimeMillis) {
        this.lastPingTimeMillis = lastPingTimeMillis;
    }

    @Override
    public Message toMessage() {
        return this.toMessage(false);
    }

    public Message toMessage(boolean expensive) {
        Message m = new Message();
        super.toMessage(m);
        m.append(this.machineID);
        m.append(this.lastPingTimeMillis);
        m.append(this.inUse);
        m.append(this.versionWithSub);
        m.append(this.isAvailable);
        if (this.info == null) {
            m.append(0);
        } else {
            m.append(this.info.toMessage(expensive, false));
        }
        m.append(this.isAutoUpdating);
        m.append(this.build);
        m.append(this.lastInUseTimeMillis);
        m.append(this.problemsBitStore.getStore()[0]);
        m.append(this.pollingProtocol);
        m.append(this.queuedActions.getStore());
        return m;
    }

    public boolean needsUpgrading() {
        if (this.versionWithSub == null) {
            return false;
        }
        return !VersionUtil.isLaterThan("3.12", this.versionWithSub);
    }

    public boolean needsRestarting() {
        if (this.versionWithSub == null || this.versionWithSub.trim().length() == 0) {
            return false;
        }
        if (this.needsUpgrading()) {
            return false;
        }
        if (this.build == null) {
            return true;
        }
        if (this.build.equals(Version.getSsuiteFullBuildVersion())) {
            return false;
        }
        return VersionUtil.isFullVersionLaterThan(this.build, Version.getSsuiteFullBuildVersion());
    }

    public boolean supportsMonitoring() {
        if (this.versionWithSub == null) {
            return false;
        }
        return VersionUtil.isLaterThan("4.1", this.versionWithSub);
    }

    public boolean supportsAlerts() {
        if (this.versionWithSub == null) {
            return false;
        }
        return VersionUtil.isLaterThan("4.2", this.versionWithSub);
    }

    public boolean supportsAutoUpdating() {
        if (this.versionWithSub == null) {
            return false;
        }
        return VersionUtil.isLaterThan("3.12", this.versionWithSub);
    }

    public String getMachineID() {
        return this.machineID;
    }

    public void setMachineID(String machineID) {
        this.machineID = machineID;
    }

    public void setMachineInfo(MachineInfo info) {
        this.info = info;
    }

    public MachineInfo getMachineInfo() {
        return this.info;
    }

    public MachineName getMachineName() {
        if (this.info != null) {
            return this.info.getMachineName();
        }
        return MachineName.extractFromNameWithGroup(this.machineID);
    }

    public int isInUse() {
        return this.inUse;
    }

    public void setInUse(int inUse) {
        this.inUse = inUse;
    }

    public String getAccessServiceVersion() {
        return this.getAccessServiceVersion(true);
    }

    public String getAccessServiceVersion(boolean includeSub) {
        if (includeSub) {
            return this.versionWithSub;
        }
        int[] parts = VersionUtil.getMajorMinorSubFrom(this.versionWithSub);
        return parts[0] + "." + parts[1];
    }

    public void setAccessServiceVersion(String version) {
        if (version == null) {
            return;
        }
        this.versionWithSub = version.trim();
    }

    public void setAccessServiceBuild(String build) {
        this.build = build;
    }

    public boolean isAvailable() {
        return this.isAvailable;
    }

    public boolean isHeadless() {
        return this.inUse == 3;
    }

    public void setAvailable(boolean isAvailable) {
        boolean isChanged = this.isAvailable != isAvailable;
        this.isAvailable = isAvailable;
        if (MachineChange.exists() && isChanged) {
            if (isAvailable) {
                MachineChange.machineOnline(this.machineID, this);
            } else {
                MachineChange.machineOffline(this.machineID, this);
            }
        }
    }

    public void setMonitored(boolean isMonitored) {
        this.info.setIsMonitoring(isMonitored);
    }

    public boolean isMonitored() {
        return this.info.isMonitoring();
    }

    public boolean isAutoUpdating() {
        return this.isAutoUpdating;
    }

    public void setAutoUpdating(boolean isAutoUpdating) {
        boolean isChanged = this.isAutoUpdating != isAutoUpdating;
        this.isAutoUpdating = isAutoUpdating;
        if (MachineChange.exists() && isChanged) {
            MachineChange.machineDataChanged(this.machineID);
        }
    }

    @Override
    public String toString() {
        if (this.getMachineName() != null) {
            return this.getMachineName().toString();
        }
        return this.machineID;
    }

    public static Machine createTestMachine() {
        return Machine.createTestMachine(false);
    }

    public static Machine[] createMachinesFast(int number) {
        Machine[] machines = new Machine[number];
        for (int count = 0; count < machines.length; ++count) {
            machines[count] = new Machine(count + "");
            if (count % 3 == 0) {
                machines[count].setAvailable(false);
            } else {
                machines[count].setAvailable(true);
            }
            machines[count].versionWithSub = "4.1";
        }
        return machines;
    }

    public void debug_clearSessions() {
        this.activeSessions.clear();
    }

    public static Machine createTestMachine(boolean random) {
        Random r = new Random();
        Machine machine = new Machine(r.nextLong() + " - madeupid");
        machine.setAvailable(r.nextBoolean());
        switch (r.nextInt(3)) {
            case 0: {
                machine.versionWithSub = "3.11";
                break;
            }
            case 1: {
                machine.versionWithSub = "4.1";
                break;
            }
            case 2: {
                machine.versionWithSub = "4.2";
            }
        }
        machine.setMachineInfo(MachineInfo.createTestData(machine.machineID));
        machine.setMonitored(true);
        machine.setLastPingTimeMillis(System.currentTimeMillis() - (long)r.nextInt(60000));
        machine.setInUse(r.nextInt(2) + 1);
        if (machine.isAvailable) {
            int sessionCount = r.nextInt(5);
            ArrayList<AccessSession> list = new ArrayList<AccessSession>();
            for (int i = 0; i < sessionCount; ++i) {
                list.add(AccessSession.createTestSession(machine));
            }
            machine.activeSessions = list;
        }
        if (machine.versionWithSub.equals("4.2")) {
            machine.build = Version.getSsuiteFullBuildVersion();
        }
        return machine;
    }

    public void fromXML(String xml) {
        TypeUtil.fromXML(xml, this);
    }

    @Override
    public String getRootTag() {
        return "Machine";
    }

    @Override
    public void handleXMLElement(String element, String value, String attribute) {
        if (element.equals("MachineID")) {
            this.machineID = value;
        } else if (element.equals("LastPingTimeMillis")) {
            this.lastPingTimeMillis = Long.parseLong(value);
        } else if (element.equals("InUse")) {
            this.inUse = Integer.parseInt(value);
        } else if (element.equals("ServiceVersion")) {
            this.versionWithSub = value;
        } else if (element.equals("IsAvailable")) {
            this.isAvailable = Boolean.parseBoolean(value);
        } else if (element.equals("MachineInfo")) {
            String xml = value;
            if (this.info == null) {
                this.info = new MachineInfo(this.machineID);
            }
            TypeUtil.fromXML(xml, this.info, false);
        } else {
            super.handleXMLElement(element, value, attribute);
        }
    }

    @Override
    public void toXML(StringBuffer buffer, int tabs) {
        String tab = TypeUtil.getTabString(tabs);
        buffer.append(tab).append("<Machine>\n");
        TypeUtil.append(buffer, "MachineID", this.machineID, tabs + 1);
        TypeUtil.append(buffer, "LastPingTimeMillis", this.lastPingTimeMillis, tabs + 1);
        TypeUtil.append(buffer, "InUse", this.inUse, tabs + 1);
        TypeUtil.append(buffer, "ServiceVersion", this.versionWithSub, tabs + 1);
        TypeUtil.append(buffer, "IsAvailable", this.isAvailable, tabs + 1);
        if (this.info != null) {
            this.info.toXML(buffer, tabs + 1);
        }
        super.toXML(buffer, tabs + 1);
        buffer.append(tab).append("</Machine>\n");
    }

    public int getActiveSessionCount() {
        if (this.activeSessions == null) {
            return 0;
        }
        return this.activeSessions.size();
    }

    public JWWindowsOS.RDPSessionInfo[] getRDPSessions() {
        return this.info.getRDPSessions();
    }

    public int getRDPSessionCount() {
        return this.info.getRDPSessionCount();
    }

    public void removeActiveSession(AccessSession session) {
        this.activeSessions.remove(session);
    }

    public void addActiveSession(AbstractSession session) {
        if (!this.activeSessions.contains(session)) {
            this.activeSessions.add(session);
        }
    }

    public ArrayList<AbstractSession> getActiveSessions() {
        return this.activeSessions;
    }

    @Override
    public boolean matchesFilter(String filter) {
        if (super.matchesFilter(filter = filter.toLowerCase())) {
            return true;
        }
        if (this.versionWithSub != null && this.versionWithSub.contains(filter)) {
            return true;
        }
        if (filter.toLowerCase().startsWith("sg_")) {
            String trimmedFilter = filter.substring(3);
            if (this.machineID != null && this.machineID.contains(trimmedFilter)) {
                return true;
            }
        }
        if (this.info != null && this.info.matchesFilter(filter)) {
            return true;
        }
        return this.getLastPingTimeMillis() == 0L && Language.get("UNKNOWN").toLowerCase().contains(filter);
    }

    public static Machine[] createRandomMachines(int count) {
        Machine[] machines = new Machine[count];
        for (int i = 0; i < machines.length; ++i) {
            machines[i] = Machine.createTestMachine(true);
        }
        return machines;
    }

    public static Machine[] createBalancedHierarchyTestData(int width) {
        Machine[] result = new Machine[width * width * width];
        int count = 0;
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < width; ++j) {
                for (int k = 0; k < width; ++k) {
                    Machine machine = Machine.createTestMachine();
                    machine.setMachineID(i + "/" + j + "/" + k);
                    machine.info = MachineInfo.createTestData(machine.getMachineID());
                    result[count++] = machine;
                }
            }
        }
        return result;
    }

    public String getBuild() {
        return this.build;
    }

    @Override
    public String getOsSummary() {
        if (this.info != null) {
            return this.info.getOsNameWithBitness();
        }
        return Language.get("UNKNOWN");
    }

    @Override
    public int getOsBaseType() {
        if (this.info != null) {
            return this.info.getOS();
        }
        return 3;
    }

    @Override
    public int getOsVariant() {
        if (this.info != null) {
            return this.info.getOsVariant();
        }
        return -1;
    }

    @Override
    public int getOsLinuxArch() {
        if (this.info == null) {
            return 1;
        }
        if (this.info.is64bit()) {
            return 2;
        }
        return 1;
    }

    public boolean isLaterThan(int laterThanMajor, int laterThanMinor) {
        String version = this.getAccessServiceVersion();
        if (version == null) {
            return false;
        }
        try {
            int[] parts = VersionUtil.getMajorMinorSubFrom(version);
            int maj = parts[0];
            int min = parts[1];
            if (maj == laterThanMajor && min > laterThanMinor) {
                return true;
            }
            return maj > laterThanMajor;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public boolean allowMonitoring() {
        if (this.info == null) {
            return false;
        }
        return this.info.allowMonitoring();
    }

    public boolean allowScripting() {
        if (this.info == null) {
            return false;
        }
        return this.info.allowScripting();
    }

    public void setMachineGroup(String[] groupPath) {
        MachineName name = this.getMachineName();
        name.setGroup(groupPath);
    }

    @Override
    public String getID() {
        return this.getMachineID();
    }

    @Override
    public void setName(MachineName name) {
        this.getMachineInfo().setOverwriteName(name);
    }

    @Override
    public MachineName getName() {
        return this.getMachineName();
    }

    public boolean isProblemHashMismatch() {
        return this.problemsBitStore.get(0);
    }

    public boolean isProblemHTTP_1_0() {
        return this.problemsBitStore.get(1);
    }

    public void setProblemHashMismatch(boolean problem) {
        if (Switches.SH_noReportTrustWarningsInitially) {
            if (problem) {
                ++this.transientHashProblemReportCount;
                if (this.transientHashProblemReportCount > 100) {
                    this.transientHashProblemReportCount = 100;
                }
            } else {
                this.transientHashProblemReportCount = 0;
            }
        } else {
            this.transientHashProblemReportCount = problem ? 100 : 0;
        }
        this.problemsBitStore.set(0, this.transientHashProblemReportCount >= 4);
    }

    public void setProblemHTTP10Problem(boolean problem) {
        this.problemsBitStore.set(1, problem);
    }

    public boolean hasAnyProblem() {
        return this.problemsBitStore.get(1) || this.problemsBitStore.get(0);
    }

    @Override
    public void toProperties(Properties properties) {
        properties.put("machineName", this.getMachineName().toString());
        properties.put("machineID", this.getMachineID());
    }

    public void clearAllQueuedActions(boolean notify) {
        boolean isChanged = this.queuedActions.get(2) || this.queuedActions.get(0) || this.queuedActions.get(1);
        this.queuedActions.clear();
        if (notify && MachineChange.exists() && isChanged) {
            MachineChange.machineDataChanged(this.machineID);
        }
    }

    public boolean hasRunToolQueued() {
        return this.queuedActions.get(1);
    }

    public boolean hasStopQueued() {
        return this.queuedActions.get(0);
    }

    public boolean hasMigrateQueued() {
        return this.queuedActions.get(2);
    }

    public void setQueuedActionsState(boolean hasMigrate, boolean hasRun, boolean hasStop) {
        boolean isChanged = hasMigrate != this.queuedActions.get(2) || hasStop != this.queuedActions.get(0) || hasRun != this.queuedActions.get(1);
        this.queuedActions.set(1, hasRun);
        this.queuedActions.set(0, hasStop);
        this.queuedActions.set(2, hasMigrate);
        if (MachineChange.exists() && isChanged) {
            MachineChange.machineDataChanged(this.machineID);
        }
    }

    public static class MachineChanges
    extends MachineGroupStats {
        public boolean nameChange = false;
    }
}

