/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.types;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.types.ResourceContainer;
import utils.loggingframework.targets.AbstractTarget;
import utils.message.Message;

public abstract class ActionableResourceContainer
extends ResourceContainer {
    protected AbstractTarget[] targets = null;
    protected boolean isActive = true;

    @Override
    public void toMessage(Message m) {
        super.toMessage(m);
        m.append(this.isActive());
        if (this.targets == null) {
            m.append(0);
        } else {
            m.append(this.targets.length);
            for (int i = 0; i < this.targets.length; ++i) {
                Message targetMessage = new Message();
                if (this.targets[i] != null) {
                    this.targets[i].toMessage(targetMessage);
                }
                m.append(targetMessage);
            }
        }
    }

    @Override
    public void fromMessage(byte version, Message m) {
        super.fromMessage(version, m);
        this.setActive(m.getNextBoolean());
        int targetCount = m.getNextInt();
        this.targets = new AbstractTarget[targetCount];
        for (int i = 0; i < targetCount; ++i) {
            Message targetMessage = m.getNextMessage();
            this.targets[i] = targetMessage.length() == 0 ? null : AbstractTarget.loadFromMessage(targetMessage, Language.DEFLANG);
        }
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }
}

