/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.types;

import com.aem.shelp.proxy.types.AbstractSession;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.proxy.types.SupportSession;
import com.aem.shelp.proxy.types.TypeUtil;
import java.util.Random;
import utils.message.Message;
import utils.xml.XML14Util;

public class AccessSession
extends AbstractSession {
    private boolean isConsoleSession = false;
    private String appTunnelHost = null;
    private int appTunnelPort = -1;

    public AccessSession(Machine machine, String sessionID) {
        super(machine);
        this.setSessionID(sessionID);
    }

    public AccessSession() {
        super(new Machine((String)null));
    }

    public void setAppTunnelSessionInfo(String host, int port) {
        this.appTunnelHost = host;
        this.appTunnelPort = port;
    }

    public String getAppTunnelSummaryString() {
        if (this.appTunnelHost != null && this.appTunnelHost.length() > 0) {
            if (this.appTunnelPort != -1) {
                return this.appTunnelHost + ":" + this.appTunnelPort;
            }
            return this.appTunnelHost;
        }
        return null;
    }

    @Override
    public Message toMessage() {
        Message m = new Message(1);
        super.toMessage(m);
        m.append(this.isConsoleSession);
        if (this.isAppTunnelSession()) {
            m.append(this.appTunnelHost);
            m.append(this.appTunnelPort);
        }
        return m;
    }

    @Override
    public void loadFrom(Message m) {
        super.loadFrom(m);
        if (this.version > 4) {
            this.isConsoleSession = m.getNextBoolean();
        }
        if (this.version >= 9 && this.isAppTunnelSession()) {
            this.appTunnelHost = m.getNextString();
            this.appTunnelPort = m.getNextInt();
        }
    }

    public Machine getMachine() {
        return (Machine)super.getRemoteMachine();
    }

    public static String[] toString(AccessSession[] list) {
        String[] result = new String[list.length];
        for (int i = 0; i < list.length; ++i) {
            result[i] = list[i].toString();
        }
        return result;
    }

    public static AccessSession createTestSession(Machine machine) {
        Random r = new Random();
        AccessSession session = new AccessSession(machine, r.nextInt(100000) + " - session ID");
        String displayName = SupportSession.testTechnicianNames[r.nextInt(SupportSession.testTechnicianNames.length)];
        String username = displayName.replace(' ', '_').toLowerCase();
        if (r.nextBoolean()) {
            username = "george";
        }
        session.setTechnicianDisplayName(displayName);
        session.setTechnicianUsername(username);
        session.setDuration(r.nextInt(86400000));
        String text = "Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum ";
        text = text + " " + text;
        if (r.nextBoolean()) {
            session.setPostSessionChat(text.substring(0, r.nextInt(text.length())).trim() + ".");
        }
        if (r.nextBoolean()) {
            session.setPostSessionComments(text.substring(0, r.nextInt(text.length())).trim() + ".");
        }
        if (r.nextBoolean()) {
            session.setHasSessionRecording(true);
        }
        switch (r.nextInt(4)) {
            case 0: {
                session.setIsTerminal(true);
                break;
            }
            case 1: {
                session.setSessionMode(5);
                break;
            }
            case 2: {
                session.setIsMobile(true);
            }
        }
        return session;
    }

    public static AccessSession createTestSession() {
        Machine machine = Machine.createTestMachine();
        return AccessSession.createTestSession(machine);
    }

    @Override
    public String getDescription() {
        return this.getMachine().getMachineName().getName();
    }

    public static AccessSession fromXML(String xml) {
        AccessSession session = new AccessSession(new Machine((String)null), null);
        TypeUtil.fromXML(xml, session);
        return session;
    }

    @Override
    public void handleXMLElement(String elementName, String content, String attribute) {
        if (elementName.equals("Terminal")) {
            this.isConsoleSession = Boolean.parseBoolean(content);
        } else if (elementName.equals("AppTunnelHost")) {
            this.appTunnelHost = content;
        } else if (elementName.equals("AppTunnelPort")) {
            this.appTunnelPort = Integer.parseInt(content);
        } else {
            super.handleXMLElement(elementName, content, attribute);
        }
    }

    @Override
    public String getRootTag() {
        return "AccessSession";
    }

    public void setIsTerminal(boolean isTerminalSession) {
        this.isConsoleSession = isTerminalSession;
    }

    public boolean isTerminalSession() {
        return this.isConsoleSession;
    }

    @Override
    public void toXML(StringBuffer buffer, int tabCount) {
        super.toXML(buffer, tabCount);
        String tabs = TypeUtil.getTabString(tabCount);
        buffer.append(tabs).append("<Terminal>").append(Boolean.toString(this.isConsoleSession)).append("</Terminal>\n");
        if (this.appTunnelHost != null) {
            buffer.append(tabs).append("<AppTunnelHost>").append(XML14Util.escape(this.appTunnelHost)).append("</AppTunnelHost>\n");
            buffer.append(tabs).append("<AppTunnelPort>").append(Integer.toString(this.appTunnelPort)).append("</AppTunnelPort>\n");
        }
    }
}

