/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.types;

import com.aem.sdesktop.SessionPerformance;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.types.AbstractMachine;
import com.aem.shelp.proxy.types.AccessSession;
import com.aem.shelp.proxy.types.DemoSession;
import com.aem.shelp.proxy.types.FastXMLInterface;
import com.aem.shelp.proxy.types.GenericSessionType;
import com.aem.shelp.proxy.types.SupportSession;
import com.aem.shelp.proxy.types.TypeUtil;
import com.aem.shelp.proxy.types.VersionType;
import com.aem.shelp.util.ElapsedTimeFormatter;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Properties;
import utils.message.Message;
import utils.stream.StreamUtils;
import utils.xml.XML14Util;

public abstract class AbstractSession
extends VersionType
implements GenericSessionType,
FastXMLInterface,
TypeUtil.XMLListener {
    private String technicianDisplayName = null;
    private String technicianUsername = null;
    private int technicianID;
    private long elapsed_time = 0L;
    private long prev_elapsed_time = 0L;
    private long startTime = 0L;
    private transient long receivedTime;
    private transient boolean hasVideoRecording = false;
    private transient SessionPerformance transientStats = null;
    private String sessionID;
    private String postSessionChat;
    private String postSessionComments;
    private AbstractMachine remoteDevice;
    private boolean isMobile;
    private int sessionMode = -1;
    private static final DateFormat dateFormat = DateFormat.getDateTimeInstance(1, 1);
    private static final ElapsedTimeFormatter elapsedTimeFormat = new ElapsedTimeFormatter();

    public boolean isAppTunnelSession() {
        return this.sessionMode == 5;
    }

    public boolean isMobile() {
        return this.isMobile;
    }

    public void setIsMobile(boolean isMobile) {
        this.isMobile = isMobile;
    }

    public String getPostSessionChat() {
        return this.postSessionChat;
    }

    @Override
    public boolean hasSessionRecording() {
        return this.hasVideoRecording;
    }

    public void setHasSessionRecording(boolean hasVideoRecording) {
        this.hasVideoRecording = hasVideoRecording;
    }

    public String getPostSessionComments() {
        return this.postSessionComments;
    }

    @Override
    public abstract String getDescription();

    public String toXML() {
        return this.toXML(0);
    }

    public String toXML(int indents) {
        int i;
        StringBuffer buffer = new StringBuffer();
        for (i = 0; i < indents; ++i) {
            buffer.append("\t");
        }
        buffer.append("<" + this.getRootTag() + ">\n");
        this.toXML(buffer, indents + 1);
        for (i = 0; i < indents; ++i) {
            buffer.append("\t");
        }
        buffer.append("</" + this.getRootTag() + ">\n");
        return buffer.toString();
    }

    public AbstractSession(AbstractMachine remoteDevice) {
        this.remoteDevice = remoteDevice;
        this.receivedTime = this.startTime = System.currentTimeMillis();
    }

    private static final String quoteForCSV(String element) {
        if (element == null) {
            return "\"\"";
        }
        return "\"" + element.replace('\"', '\'').replace("\n", "\\n").replace('\"', '\'') + "\"";
    }

    public String toCSV() {
        return "\"" + this.getRootTag().replace('\"', '\'') + "\"," + AbstractSession.quoteForCSV(this.technicianDisplayName) + "," + AbstractSession.quoteForCSV(this.technicianUsername) + "," + AbstractSession.quoteForCSV(dateFormat.format(new Date(this.startTime))) + "," + AbstractSession.quoteForCSV(elapsedTimeFormat.getAbbreviatedFormattedTime(this.elapsed_time, false)) + "," + AbstractSession.quoteForCSV(this.remoteDevice.toString()) + "," + AbstractSession.quoteForCSV(this.postSessionComments) + "," + AbstractSession.quoteForCSV(this.postSessionChat);
    }

    public static void main(String[] args) {
        AccessSession accessSession = AccessSession.createTestSession();
        SupportSession supportSession = SupportSession.createTestSession();
        System.out.println(accessSession.csvHeaders());
        System.out.println(accessSession.toCSV());
        System.out.println(supportSession.toCSV());
    }

    public String csvHeaders() {
        return AbstractSession.quoteForCSV(Language.get("TECH_SESSION_TITLE")) + "," + AbstractSession.quoteForCSV(Language.get("TECHNICIAN")) + "," + AbstractSession.quoteForCSV(Language.get("USERNAME")) + "," + AbstractSession.quoteForCSV(Language.get("SG_SERVICE_START_LABEL")) + "," + AbstractSession.quoteForCSV(Language.get("DURATION")) + "," + AbstractSession.quoteForCSV(Language.get("SESSION_DETAILS")) + "," + AbstractSession.quoteForCSV(Language.get("ADMIN_NOTIFY_SESSION_TAB")) + "," + AbstractSession.quoteForCSV(Language.get("CHAT_TRANSCRIPT"));
    }

    public void loadFrom(Message m) {
        this.receivedTime = System.currentTimeMillis();
        this.version = m.getNextByte();
        this.sessionID = m.getNextString();
        this.technicianDisplayName = m.getNextString();
        this.technicianUsername = m.getNextString();
        this.elapsed_time = m.getNextLong();
        this.prev_elapsed_time = m.getNextLong();
        this.startTime = m.getNextLong();
        this.postSessionChat = m.getNextString();
        this.postSessionComments = m.getNextString();
        Message mm = m.getNextMessage();
        this.remoteDevice.fromMessage(mm);
        if (this.version >= 3) {
            this.hasVideoRecording = m.getNextBoolean();
        }
        if (this.version >= 4) {
            this.isMobile = m.getNextBoolean();
        }
        if (this.version >= 9) {
            this.sessionMode = m.getNextInt();
        }
        if (this.version >= 11) {
            this.technicianID = m.getNextInt();
        }
    }

    public void toMessage(Message m) {
        m.append((byte)11);
        m.append(this.sessionID);
        m.append(this.technicianDisplayName);
        m.append(this.technicianUsername);
        m.append(this.elapsed_time);
        m.append(this.prev_elapsed_time);
        m.append(this.startTime);
        m.append(this.postSessionChat);
        m.append(this.postSessionComments);
        m.append(this.remoteDevice.toMessage());
        m.append(this.hasVideoRecording);
        m.append(this.isMobile);
        m.append(this.sessionMode);
        m.append(this.technicianID);
    }

    public void setSessionMode(int sessionMode) {
        this.sessionMode = sessionMode;
    }

    public void setPostSessionChat(String chat) {
        this.postSessionChat = chat;
    }

    public void setPostSessionComments(String comments) {
        this.postSessionComments = comments;
    }

    public String toString() {
        return this.remoteDevice.toString() + " " + this.technicianDisplayName + " " + this.technicianUsername + " ";
    }

    public Message toMessage() {
        if (this instanceof SupportSession) {
            return ((SupportSession)this).toMessage();
        }
        if (this instanceof AccessSession) {
            return ((AccessSession)this).toMessage();
        }
        if (this instanceof DemoSession) {
            return ((DemoSession)this).toMessage();
        }
        return null;
    }

    public static AbstractSession fromMessage(Message m) {
        AbstractSession session;
        if (m.getType() == 0) {
            session = new SupportSession();
        } else if (m.getType() == 1) {
            session = new AccessSession();
        } else if (m.getType() == 2) {
            session = new DemoSession();
        } else {
            return null;
        }
        session.loadFrom(m);
        return session;
    }

    @Override
    public int getOsBaseType() {
        return this.remoteDevice.getOsBaseType();
    }

    @Override
    public int getOsVariant() {
        return this.remoteDevice.getOsVariant();
    }

    @Override
    public String getOSSummary() {
        return this.remoteDevice.getOsSummary();
    }

    @Override
    public String getSessionID() {
        return this.sessionID;
    }

    public void setSessionID(String sessionID) {
        this.sessionID = sessionID;
    }

    public AbstractMachine getRemoteMachine() {
        return this.remoteDevice;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    @Override
    public String getTechnicianDisplayName() {
        return this.technicianDisplayName;
    }

    public void setTechnicianDisplayName(String technicianDisplayName) {
        this.technicianDisplayName = technicianDisplayName;
    }

    public String getTechnicianUsername() {
        return this.technicianUsername;
    }

    public void setTechnicianUsername(String technicianUsername) {
        this.technicianUsername = technicianUsername;
    }

    @Override
    public long getDuration() {
        return this.elapsed_time;
    }

    public long getIncrementedElapsedTime() {
        return System.currentTimeMillis() - this.receivedTime + this.elapsed_time;
    }

    public void setDuration(long elapsed_time) {
        this.elapsed_time = elapsed_time;
    }

    public long getPrevElapsedTime() {
        return this.prev_elapsed_time;
    }

    public void setPrevElapsedTime(long prev_elapsed_time) {
        this.prev_elapsed_time = prev_elapsed_time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AbstractSession fromFile(File file) throws IOException {
        BufferedInputStream bin = new BufferedInputStream(new FileInputStream(file));
        try {
            String xml = StreamUtils.readAllAsStringUTF8(bin);
            if (xml.startsWith("<SupportSession")) {
                SupportSession supportSession = SupportSession.fromXML(xml);
                return supportSession;
            }
            if (xml.startsWith("<AccessSession")) {
                AccessSession accessSession = AccessSession.fromXML(xml);
                return accessSession;
            }
            if (xml.startsWith("<DemoSession")) {
                DemoSession demoSession = DemoSession.fromXML(xml);
                return demoSession;
            }
        }
        finally {
            bin.close();
        }
        return null;
    }

    public void toXML(StringBuffer buffer, int tabCount) {
        String tabs = TypeUtil.getTabString(tabCount);
        buffer.append(tabs).append("<Version>").append(11).append("</Version>\n");
        buffer.append(tabs).append("<ID>").append(XML14Util.escape(this.sessionID)).append("</ID>\n");
        buffer.append(tabs).append("<Start>").append(this.startTime).append("</Start>\n");
        buffer.append(tabs).append("<Duration>").append(this.elapsed_time).append("</Duration>\n");
        buffer.append(tabs).append("<Technician>").append(XML14Util.escape(this.technicianUsername)).append("</Technician>\n");
        buffer.append(tabs).append("<TechnicianName>").append(XML14Util.escape(this.technicianDisplayName)).append("</TechnicianName>\n");
        buffer.append(tabs).append("<Mobile>").append(Boolean.toString(this.isMobile)).append("</Mobile>\n");
        buffer.append(tabs).append("<Mode>").append(Integer.toString(this.sessionMode)).append("</Mode>\n");
        if (this.postSessionChat != null) {
            buffer.append(tabs).append("<Chat>").append(XML14Util.escape(this.postSessionChat)).append("</Chat>\n");
        }
        if (this.postSessionComments != null) {
            buffer.append(tabs).append("<Comments>").append(XML14Util.escape(this.postSessionComments)).append("</Comments>\n");
        }
        this.remoteDevice.toXML(buffer, tabCount);
    }

    @Override
    public void handleXMLElement(String elementName, String content, String attribute) {
        if (!elementName.equals("Version")) {
            if (elementName.equals("ID")) {
                this.sessionID = content;
            } else if (elementName.equals("Start")) {
                this.startTime = Long.parseLong(content);
            } else if (elementName.equals("Duration")) {
                this.elapsed_time = Long.parseLong(content);
            } else if (elementName.equals("Technician")) {
                this.technicianUsername = content;
            } else if (elementName.equals("TechnicianName")) {
                this.technicianDisplayName = content;
            } else if (elementName.equals("Chat")) {
                this.postSessionChat = content;
            } else if (elementName.equals("Comments")) {
                this.postSessionComments = content;
            } else if (elementName.equals("Mobile")) {
                this.isMobile = Boolean.parseBoolean(content);
            } else if (elementName.equals("Mode")) {
                this.sessionMode = Integer.parseInt(content);
            } else {
                String xml = content;
                TypeUtil.fromXML(xml, this.remoteDevice, false);
            }
        }
    }

    public boolean isIncludedByFilters(String[] filters) {
        String str = this.toString();
        for (String filter : filters) {
            if (str.toLowerCase().contains(filter)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof AbstractSession)) {
            return false;
        }
        return ((AbstractSession)o).sessionID.equals(this.sessionID);
    }

    public void toProperties(Properties properties) {
        properties.put("technicianDisplayName", this.technicianDisplayName);
        properties.put("technicianUsername", this.technicianUsername);
        properties.put("startTime", (Object)this.startTime);
        properties.put("duration", (Object)this.elapsed_time);
        properties.put("mobile", (Object)this.isMobile);
        properties.put("mode", (Object)this.sessionMode);
        properties.put("sessionID", this.sessionID);
        this.remoteDevice.toProperties(properties);
    }

    public void setTransientStats(SessionPerformance transientStats) {
        this.transientStats = transientStats;
    }

    public SessionPerformance getTransientStats() {
        return this.transientStats;
    }

    public long getPerformanceColourDepth() {
        if (this.transientStats == null) {
            return 0L;
        }
        return this.transientStats.getColourDepth();
    }

    public long getPerformanceFPS() {
        if (this.transientStats == null) {
            return 0L;
        }
        return 1000L / this.transientStats.getUpdateDelayMS();
    }

    public String getPerformanceConnetionType() {
        if (this.transientStats == null) {
            return "";
        }
        return this.transientStats.getLocalConnectionType() + " | " + this.transientStats.getRemoteConnectionType();
    }

    public boolean hasChat() {
        return this.postSessionChat != null && this.postSessionChat.length() > 0;
    }

    public boolean hasComments() {
        return this.postSessionComments != null && this.postSessionComments.length() > 0;
    }
}

