/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.techclient;

import com.aem.shelp.mdupload.fs.AbstractTechFS;
import com.aem.shelp.mdupload.fs.GFile;
import com.aem.shelp.mdupload.fs.LocalFS;
import com.aem.shelp.util.MachineStream;
import java.io.File;
import java.io.IOException;
import utils.files.FileMirror;
import utils.message.BasicMTTransactionClient;
import utils.message.Message;
import utils.progtools.Lock;

public class RAClient
extends AbstractTechFS {
    MachineStream ms;
    BasicMTTransactionClient client;
    Lock fmLOCK = new Lock();
    short nextFM = (short)10000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private short getNextFM() {
        short myChannel;
        Lock lock = this.fmLOCK;
        synchronized (lock) {
            myChannel = this.nextFM;
            this.nextFM = (short)(this.nextFM + 1);
            if (this.nextFM >= 20000) {
                this.nextFM = (short)10000;
            }
        }
        return myChannel;
    }

    public String toString() {
        return "RAClient " + this.ms;
    }

    public RAClient(MachineStream ms) {
        this.ms = ms;
        this.client = new BasicMTTransactionClient(ms.in.getInputStream((short)7770, "RAClientMachineStream"), ms.out.getOutputStream((short)7770));
    }

    public void shutdown(String reason) {
        this.ms.shutdown(reason);
    }

    @Override
    protected void sendMessage(Message m) throws Exception {
        this.client.doSend(m);
    }

    @Override
    protected Message transactMessage(Message m) throws Exception {
        return this.client.doTransaction(m);
    }

    @Override
    public GFile uploadIntoDir(File local, GFile remoteDir) throws IOException {
        System.out.println("[RAClientFS] Upload " + local + " to " + remoteDir.path());
        try {
            GFile remote = GFile.getFileRelativeTo(LocalFS.getFile(local.getParentFile()), LocalFS.getFile(local), remoteDir);
            short chan = this.getNextFM();
            Message m = new Message(1589723191);
            m.append(chan);
            m.append(remoteDir.toMessage(this));
            this.sendMessage(m);
            System.out.println("[RAClientFS] Sent upload request");
            FileMirror mirror = FileMirror.putFileIntoDir(this.ms.in.getInputStream(chan, "RAClientFileUpload"), this.ms.out.getOutputStream(chan), local);
            mirror.waitForFinish();
            return remote;
        }
        catch (Exception x) {
            IOException io = new IOException("Unable to upload file " + local.getName());
            io.initCause(x);
            throw io;
        }
    }

    @Override
    public File downloadIntoDir(File localDir, GFile remoteFileOrDir) throws IOException {
        System.out.println("[RAClientFS] Download " + remoteFileOrDir.path() + " to " + localDir);
        try {
            File localFile = new File(localDir, remoteFileOrDir.name);
            short chan = this.getNextFM();
            Message m = new Message(1589723192);
            m.append(chan);
            m.append(remoteFileOrDir.toMessage(this));
            this.sendMessage(m);
            System.out.println("[RAClientFS] Sent download request");
            FileMirror mirror = FileMirror.getFileIntoDir(this.ms.in.getInputStream(chan, "RAClientFileDownload"), this.ms.out.getOutputStream(chan), localDir, false);
            mirror.waitForFinish();
            return localFile;
        }
        catch (Exception x) {
            IOException io = new IOException("Unable to download file " + remoteFileOrDir.name);
            io.initCause(x);
            throw io;
        }
    }
}

