/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.reporting.csv;

import com.aem.shelp.proxy.config.TechUser;
import com.aem.shelp.proxy.reporting.AccessReport;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.proxy.types.MachineInfo;
import com.aem.shelp.tech.reporting.ReportRequest;
import com.aem.shelp.util.ElapsedTimeFormatter;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import utils.message.Message;
import utils.osstats.types.BasicInfo;
import utils.progtools.DataUtil;

public class CSVAccessReport
extends AccessReport {
    private final Calendar calendar;
    private final DateFormat dateFormat;
    private final ElapsedTimeFormatter elapsedTimeFormatter;
    private final boolean isHardwareReport;
    private OutputStream fout;
    private boolean writtenHeader = false;

    public CSVAccessReport(ReportRequest request) {
        super(request);
        this.isHardwareReport = request.reportType == 0;
        this.calendar = Calendar.getInstance();
        this.dateFormat = DateFormat.getDateTimeInstance(2, 2);
        this.elapsedTimeFormatter = new ElapsedTimeFormatter();
    }

    @Override
    public void initAccessReport(OutputStream fout) {
        this.fout = fout;
    }

    @Override
    public void finishAccessReport() {
    }

    public void addHeader(String creator) throws IOException {
        StringBuilder line = new StringBuilder();
        if (this.isHardwareReport) {
            line.append("CSV Remote Access Service Hardware Report").append("\n");
        } else {
            line.append("CSV Remote Access Service Usage Report").append("\n");
        }
        line.append("Created by: ").append(creator).append("\n");
        line.append("Date: ").append(this.dateFormat.format(new Date(System.currentTimeMillis()))).append("\n");
        line.append("\n");
        if (this.isHardwareReport) {
            line.append("Name, Group, ID, Availability, Uptime, Last Registration, Operating System, Hostname, Remote User, WAN IP, LAN IPs, LAN Macs, LAN Interfaces, Serial, Manufacturer, Model, Processor Count, Processor Details, Processor Speed, Processor 64Bit, Processor Cores, Total Memory, Memory Slots, Memory Type, Memory Capacity, Drive Name, Drive Capacity, Drive Type, BIOS").append("\n");
        } else {
            line.append("Name, Group, ID, Availability, Uptime, Last Registration, Operating System, Hostname, Monitored, CPU Usage (1m), CPU Usage (5m), CPU Usage (15m), Memory Usage, Drive Details, Drive Usage").append("\n");
        }
        this.fout.write(line.toString().getBytes("UTF8"));
    }

    @Override
    public void addMachine(Machine machine, MachineInfo machineInfo) throws IOException {
        if (machine == null) {
            return;
        }
        if (!this.writtenHeader) {
            TechUser user = this.getReportRequest().serverSideRequestingUser;
            this.addHeader(user.displayName + " (" + user.getLogin() + ")");
            this.writtenHeader = true;
        }
        if (this.isHardwareReport) {
            this.addMachineHardware(machine, machineInfo);
        } else {
            this.addMachineAudit(machine, machineInfo);
        }
    }

    private void addMachineHardware(Machine machine, MachineInfo machineInfo) throws IOException {
        BasicInfo hardwareDetails = machineInfo.getHardwareDetails();
        Line line = new Line();
        line.appendToLine(machine.getName().getName());
        line.appendToLine(machine.getMachineName().getGroupString());
        line.appendToLine(machine.getMachineID());
        if (machine.isAvailable()) {
            line.appendToLine("Online");
        } else {
            line.appendToLine("Offline");
        }
        if (hardwareDetails != null && hardwareDetails.getUptime() > 1L) {
            line.appendToLine(this.elapsedTimeFormatter.getAbbreviatedFormattedTime(hardwareDetails.getUptime(), false));
        } else {
            line.appendToLine("");
        }
        if (machine.getLastPingTimeMillis() == 0L) {
            line.appendToLine("");
        } else {
            line.appendToLine(this.dateFormat.format(machine.getLastPingTimeMillis()));
        }
        line.appendToLine(machine.getOsSummary());
        line.appendToLine(machineInfo.getHostname());
        line.appendToLine(machine.getRemoteUsername());
        line.appendToLine(machineInfo.getWanIP());
        int lanIPCell = line.getCellNumber();
        String[] ipsAndMacs = machineInfo.getLocalIpMacs();
        String[] lanIPs = new String[ipsAndMacs.length];
        String[] lanMacs = new String[ipsAndMacs.length];
        String[] lanNics = new String[ipsAndMacs.length];
        for (int i = 0; i < ipsAndMacs.length; ++i) {
            String[] tmp = ipsAndMacs[i].split("/");
            lanIPs[i] = tmp.length > 0 ? tmp[0] : "";
            lanMacs[i] = tmp.length > 1 ? tmp[1] : "";
            lanNics[i] = tmp.length > 2 ? tmp[2] : "";
        }
        line.appendToLine(lanIPs[0]);
        line.appendToLine(lanMacs[0]);
        line.appendToLine(lanNics[0]);
        line.appendToLine(hardwareDetails != null ? hardwareDetails.serial : null);
        line.appendToLine(hardwareDetails != null ? hardwareDetails.computerModelManufacturer : null);
        line.appendToLine(hardwareDetails != null ? hardwareDetails.computerModelIdentifier + " " + hardwareDetails.computerModelName : null);
        int processorCount = 0;
        int processorCell = -1;
        if (hardwareDetails != null) {
            processorCount = hardwareDetails.getProcessorCount();
            line.appendToLine(processorCount);
        } else {
            line.appendToLine(null);
        }
        processorCell = line.getCellNumber();
        if (processorCount > 0) {
            line.appendToLine(hardwareDetails.processorConfig[0].processorName);
            line.appendToLine(DataUtil.getSensibleSpeed(hardwareDetails.processorConfig[0].processorSpeedHz));
            line.appendToLine(hardwareDetails.processorConfig[0].is64bit);
            line.appendToLine(hardwareDetails.processorConfig[0].coreCount);
        } else {
            line.appendToLine("");
            line.appendToLine("");
            line.appendToLine("");
            line.appendToLine("");
        }
        int memoryCount = 0;
        line.appendToLine(hardwareDetails != null ? DataUtil.getSensibleSize(hardwareDetails.memoryTotalBytes) : null);
        if (hardwareDetails != null) {
            memoryCount = hardwareDetails.getMemoryCount();
        }
        line.appendToLine(memoryCount);
        int memoryCell = line.getCellNumber();
        if (memoryCount > 0) {
            line.appendToLine(hardwareDetails.memoryConfig[0].type);
            line.appendToLine(DataUtil.getSensibleSize(hardwareDetails.memoryConfig[0].capacityBytes));
        } else {
            line.appendToLine("");
            line.appendToLine("");
        }
        int diskCount = 0;
        int diskCell = -1;
        if (hardwareDetails != null) {
            diskCount = hardwareDetails.getDiskCount();
        }
        if (diskCount > 0) {
            line.appendToLine(hardwareDetails.diskConfig[0].deviceName + " (" + hardwareDetails.diskConfig[0].disk + ")");
            line.appendToLine(DataUtil.getSensibleSize(hardwareDetails.diskConfig[0].capacityBytes));
            line.appendToLine(hardwareDetails.diskConfig[0].type);
        }
        line.appendToLine(hardwareDetails != null ? hardwareDetails.getBiosSummary() : null);
        line.write(this.fout);
        int maxRows = Math.max(Math.max(Math.max(lanIPs.length, processorCount), memoryCount), diskCount);
        for (int row = 1; row < maxRows; ++row) {
            line = new Line();
            if (lanIPs.length > row) {
                line.skipToCell(lanIPCell);
                line.appendToLine(lanIPs[row]);
                line.appendToLine(lanMacs[row]);
                line.appendToLine(lanNics[row]);
            }
            if (processorCount > row) {
                line.skipToCell(processorCell);
                line.appendToLine(hardwareDetails.processorConfig[row].processorName);
                line.appendToLine(DataUtil.getSensibleSpeed(hardwareDetails.processorConfig[row].processorSpeedHz));
                line.appendToLine(hardwareDetails.processorConfig[row].is64bit);
                line.appendToLine(hardwareDetails.processorConfig[row].coreCount);
            }
            if (memoryCount > row) {
                System.out.println(memoryCell);
                line.skipToCell(memoryCell);
                line.appendToLine(hardwareDetails.memoryConfig[row].type);
                line.appendToLine(DataUtil.getSensibleSize(hardwareDetails.memoryConfig[row].capacityBytes));
            }
            if (diskCount > row) {
                line.skipToCell(diskCell);
                line.appendToLine(hardwareDetails.diskConfig[row].deviceName + " (" + hardwareDetails.diskConfig[row].disk + ")");
                line.appendToLine(DataUtil.getSensibleSize(hardwareDetails.diskConfig[row].capacityBytes));
                line.appendToLine(hardwareDetails.diskConfig[row].type);
            }
            line.write(this.fout);
        }
    }

    private void addMachineAudit(Machine machine, MachineInfo machineInfo) throws IOException {
        BasicInfo hardwareDetails = machineInfo.getHardwareDetails();
        Line line = new Line();
        line.appendToLine(machine.getName().getName());
        line.appendToLine(machine.getMachineName().getGroupString());
        line.appendToLine(machine.getMachineID());
        if (machine.isAvailable()) {
            line.appendToLine("Online");
        } else {
            line.appendToLine("Offline");
        }
        if (hardwareDetails != null) {
            line.appendToLine(this.elapsedTimeFormatter.getAbbreviatedFormattedTime(hardwareDetails.getUptime(), false));
        } else {
            line.appendToLine("");
        }
        if (machine.getLastPingTimeMillis() == 0L) {
            line.appendToLine("");
        } else {
            line.appendToLine(this.dateFormat.format(machine.getLastPingTimeMillis()));
        }
        line.appendToLine(machine.getOsSummary());
        line.appendToLine(machineInfo.getHostname());
        if (!machine.isMonitored()) {
            line.appendToLine(false);
        } else {
            line.appendToLine(true);
            byte[] loadAverages = machineInfo.getLoadAverageData();
            if (loadAverages != null) {
                line.appendToLine(DataUtil.getSensiblePercentage((double)loadAverages[0] / 100.0));
                line.appendToLine(DataUtil.getSensiblePercentage((double)loadAverages[1] / 100.0));
                line.appendToLine(DataUtil.getSensiblePercentage((double)loadAverages[2] / 100.0));
                line.appendToLine(DataUtil.getSensiblePercentage((double)loadAverages[3] / 100.0));
            } else {
                line.appendToLine(DataUtil.getSensiblePercentage(machineInfo.getLatestCPU()));
                line.appendToLine("");
                line.appendToLine("");
                line.appendToLine(DataUtil.getSensiblePercentage(machineInfo.getLatestMem()));
            }
            int diskCount = 0;
            Message m = machineInfo.getDetailedDisks();
            if (m != null) {
                m.resetIndex();
                diskCount = m.length() / 2;
            }
            String[] diskNames = new String[diskCount];
            double[] percentage = new double[diskCount];
            for (int i = 0; i < diskCount; ++i) {
                diskNames[i] = m.getNextString();
                percentage[i] = m.getNextDouble();
            }
            int diskCell = line.getCellNumber();
            if (diskCount > 0) {
                line.appendToLine(diskNames[0]);
                line.appendToLine(DataUtil.getSensiblePercentage(percentage[0] / 100.0));
            }
            line.write(this.fout);
            for (int row = 1; row < diskCount; ++row) {
                line = new Line();
                line.skipToCell(diskCell);
                line.appendToLine(diskNames[row]);
                line.appendToLine(DataUtil.getSensiblePercentage(percentage[row] / 100.0));
                line.write(this.fout);
            }
        }
    }

    private class Line {
        private StringBuilder line = new StringBuilder();
        private int cellNumber = 0;

        private Line() {
        }

        private void appendToLine(String s) {
            if (this.line.length() > 0) {
                this.line.append(", ");
            }
            if (s != null) {
                this.line.append(s.replace(',', ' ').replace('\n', ' ').trim());
            }
            ++this.cellNumber;
        }

        public int getCellNumber() {
            return this.cellNumber;
        }

        private void skipToCell(int targetCell) {
            for (int i = this.cellNumber; i < targetCell - 1; ++i) {
                this.line.append(", ");
                ++this.cellNumber;
            }
        }

        private void appendToLine(int i) {
            this.appendToLine(Integer.toString(i));
        }

        private void appendToLine(boolean b) {
            this.appendToLine(Boolean.toString(b));
        }

        private void appendToLine(long i) {
            this.appendToLine(Long.toString(i));
        }

        public void write(OutputStream fout) throws IOException {
            this.line.append("\n");
            fout.write(this.line.toString().getBytes("UTF8"));
        }
    }
}

