/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.logging.targets.notifytech;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.logging.alerts.LocatedAlertLogEvent;
import com.aem.shelp.proxy.logging.targets.notifytech.NotifyTechTarget;
import com.aem.shelp.proxy.logging.targets.notifytech.VariablePanel;
import com.aem.shelp.tech.utils.TechnicianPickerPanel;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import utils.loggingframework.events.LogEvent;
import utils.loggingframework.targets.AbstractTarget;
import utils.loggingframework.targets.AbstractTargetUI;
import utils.loggingframework.targets.VariableUtil;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.layout.GbPanel;

public class NotifyTechTargetUI
extends AbstractTargetUI {
    private GbPanel rootComponent = new GbPanel(new ScaledInsets(3, 3, 3, 3));
    private TechnicianPickerPanel pickerPanel = new TechnicianPickerPanel(false, Language.get("NOTIFY_TECH_LABEL"), Language.get("NOTIFY_TECH_NONE"), new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            NotifyTechTargetUI.this.notifyIfComplete();
        }
    });
    private JTextField title = new JTextField();
    private JTextField message = new JTextField();
    private VariablePanel variablePanel;
    private boolean isHandlingLocatedAlertEvents = false;

    @Override
    public JComponent getRootComponent() {
        return this.rootComponent;
    }

    @Override
    public void populateTarget(AbstractTarget target) {
        NotifyTechTarget ntt = (NotifyTechTarget)target;
        ntt.setNotify(this.pickerPanel.isNotifyAll(), this.pickerPanel.getTechIDs(), this.pickerPanel.getGroupIDs(), this.pickerPanel.getTechNames(), this.pickerPanel.getGroupNames());
        ntt.setTitle(this.title.getText());
        ntt.setMessage(this.message.getText());
    }

    @Override
    public void setEventsToTarget(LogEvent[] events) {
        if (Arrays.equals(events, this.events)) {
            return;
        }
        super.setEventsToTarget(events);
        if (events != null) {
            this.isHandlingLocatedAlertEvents = false;
            for (LogEvent e : events) {
                if (!(e instanceof LocatedAlertLogEvent)) continue;
                this.isHandlingLocatedAlertEvents = true;
                break;
            }
        }
        LogEvent.LogEventVariable[] commonVariables = VariableUtil.getCommonVariables(events);
        this.variablePanel.setVariables(commonVariables);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.rootComponent.setEnabled(enabled);
        this.pickerPanel.setEnabled(enabled);
    }

    @Override
    public void notifyIfComplete() {
        this.notifyComplete();
    }

    @Override
    public void initWithTarget(AbstractTarget target) {
        if (!(target instanceof NotifyTechTarget)) {
            return;
        }
        NotifyTechTarget ntt = (NotifyTechTarget)target;
        this.pickerPanel.setSettings(ntt.notifyAllTechs(), ntt.notifyGroups(), ntt.notifyTechs(), ntt.getGroupNames(), ntt.getTechNames());
        if (ntt.getTitle() != null) {
            this.title.setText(ntt.getTitle());
        } else if (this.isHandlingLocatedAlertEvents) {
            this.title.setText(Language.get("NOTIFY_ALERT_TITLE"));
        } else {
            this.title.setText(Language.get("NOTIFY_EVENT_TITLE"));
        }
        if (ntt.getMessage() != null) {
            this.message.setText(ntt.getMessage());
        } else if (this.isHandlingLocatedAlertEvents) {
            this.message.setText(Language.get("NOTIFY_ALERT_MSG", new Object[]{"${alertName}", "${machineName}", "${isTrigger}"}));
        } else {
            this.message.setText("");
        }
    }

    @Override
    protected void initUI() {
        this.rootComponent.setBackground(this.style.getInnerBorderColor());
        this.pickerPanel.setBackground(this.style.getInnerBorderColor());
        GbPanel notifyPanel = new GbPanel(new ScaledInsets(0, 0, 3, 0));
        notifyPanel.setBackground(this.style.getInnerBorderColor());
        notifyPanel.add(this.pickerPanel.getRootComponent(), 0, 0, 1, 1, 1, 1, 10, 1);
        this.variablePanel = new VariablePanel(new JTextComponent[]{this.title, this.message}){

            @Override
            protected void notifyChange() {
                NotifyTechTargetUI.this.notifyIfComplete();
            }
        };
        GbPanel messagePanel = new GbPanel(new ScaledInsets(3, 3, 3, 3));
        messagePanel.setBackground(this.style.getInnerBorderColor());
        messagePanel.add(new JLabel(Language.get("NOTIFY_TECH_TITLE")), 0, 0, 1, 1, 1, 1, 13, 0, new Insets(3, 0, 3, 3));
        messagePanel.add(this.title, 1, 0, 1, 1, 100, 1, 17, 2, new Insets(3, 3, 3, 0));
        messagePanel.add(new JLabel(Language.get("NOTIFY_TECH_MESSAGE")), 0, 1, 1, 1, 1, 1, 13, 0, new Insets(3, 0, 3, 3));
        messagePanel.add(this.message, 1, 1, 1, 1, 100, 1, 17, 2, new Insets(3, 3, 3, 0));
        messagePanel.add(this.variablePanel.rootComponent, 1, 2, 1, 1, 100, 1, 17, 0, new Insets(3, 3, 3, 0));
        this.variablePanel.rootComponent.setBackground(this.style.getInnerBorderColor());
        int Y = 0;
        this.rootComponent.add(notifyPanel, 0, Y++, 1, 1, 100, 0, 17, 1);
        this.rootComponent.add(messagePanel, 0, Y++, 1, 1, 100, 0, 17, 1);
        JPanel paddy = new JPanel();
        paddy.setBackground(this.style.getInnerBorderColor());
        this.rootComponent.add(paddy, 0, Y++, 1, 1, 1, 1000, 10, 1);
    }
}

