/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.logging.support;

import com.aem.sdesktop.SessionDescription;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.config.TechUser;
import com.aem.shelp.proxy.logging.SimpleHelpLogEvent;
import com.aem.shelp.proxy.types.Customer;
import java.io.File;
import java.util.Properties;
import utils.xml.XML14Util;

public class SupportSessionSummaryEvent
extends SimpleHelpLogEvent {
    public static final String ID = "SupportSessionSummaryEvent";
    public SessionDescription.SupportSessionDescription sessionDescription;
    public TechUser techUser;

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String getDisplayName() {
        return Language.get("EVENT_SUPPORT_SESSION_ENDS");
    }

    @Override
    public String getDescription() {
        return "A support session ends between a technician and a customer.";
    }

    @Override
    public String getLogText() {
        Customer customerInfo = this.sessionDescription.getCustomerInfo();
        StringBuilder buffer = new StringBuilder();
        buffer.append("[").append(this.getEventID()).append("] Remote support session ended:\n");
        buffer.append("\tTechnician:\n");
        buffer.append(this.techUser.getLogString(2));
        buffer.append("\tCustomer:\n");
        buffer.append(customerInfo.toLogString(2));
        buffer.append("\tDuration:\n");
        buffer.append("\t\t").append(this.sessionDescription.sessionDuration).append(" (").append(this.sessionDescription.sessionDurationMS).append("ms)").append("\n");
        buffer.append("\tTechnician Comments:\n");
        buffer.append("\t\t").append(this.sessionDescription.technicianSummary).append("\n");
        buffer.append("\tChat Transcript:\n");
        buffer.append("\t\t").append(this.sessionDescription.chatTranscript).append("\n");
        return buffer.toString();
    }

    @Override
    public File getEmailTemplateFile() {
        return new File("templates/support/session_summary");
    }

    public static SupportSessionSummaryEvent createEvent(TechUser techUser, SessionDescription.SupportSessionDescription sessionDescription) {
        SupportSessionSummaryEvent event = new SupportSessionSummaryEvent();
        event.sessionDescription = sessionDescription;
        event.techUser = techUser;
        return event;
    }

    @Override
    public String getEventID() {
        return "SupportSessionEnd";
    }

    @Override
    protected void toXML(StringBuffer buffer, int indent) {
        buffer.append(XML14Util.getIndent(indent)).append("<").append(this.getID()).append(">\n");
        super.addToXML(buffer, indent + 1);
        if (this.techUser != null) {
            this.techUser.appendToXML(buffer, indent + 1);
        }
        if (this.sessionDescription != null) {
            this.sessionDescription.appendToXML(buffer, indent + 1);
        }
        buffer.append(XML14Util.getIndent(indent)).append("</").append(this.getID()).append(">\n");
    }

    @Override
    protected void toProperties(Properties properties) {
        super.toProperties(properties);
        this.safePut(properties, "techUser", this.techUser.toString());
        this.sessionDescription.toProperties("sessionDescription", properties);
    }
}

