/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.logging.support;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.config.TechUser;
import com.aem.shelp.proxy.logging.SimpleHelpLogEvent;
import com.aem.shelp.proxy.types.Customer;
import java.io.File;
import java.util.ArrayList;
import java.util.Properties;
import utils.loggingframework.events.LogEvent;
import utils.xml.XML14Util;

public class CustLeaveSessionEvent
extends SimpleHelpLogEvent {
    public static final String ID = "CustLeaveSessionEvent";
    public Customer customerInfo;
    public String sessionDuration;
    public long sessionDurationMS;
    public TechUser techUser;

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String getDisplayName() {
        return Language.get("EVENT_CUST_LEAVES_SESSION");
    }

    @Override
    public String getDescription() {
        return "A customer has left a support session.";
    }

    @Override
    public String getLogText() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[" + this.getEventID() + "] Customer left a remote support session:\n");
        buffer.append("\tCustomer:\n");
        buffer.append(this.customerInfo.toLogString(2));
        buffer.append("\tTechnician:\n");
        buffer.append(this.techUser.getLogString(2));
        buffer.append("\tDuration:\n");
        buffer.append("\t\t").append(this.sessionDuration).append(" (").append(this.sessionDurationMS).append("ms)");
        return buffer.toString();
    }

    @Override
    public File getEmailTemplateFile() {
        return new File("templates/support/customer_leave");
    }

    public static CustLeaveSessionEvent createEvent(Customer customerInfo, TechUser techUser, long sessionDurationMS, String sessionDurationFormatted) {
        CustLeaveSessionEvent event = new CustLeaveSessionEvent();
        event.customerInfo = customerInfo;
        event.techUser = techUser;
        event.sessionDuration = sessionDurationFormatted;
        event.sessionDurationMS = sessionDurationMS;
        return event;
    }

    @Override
    public String getEventID() {
        return "CustomerLeaveSession";
    }

    @Override
    protected void toXML(StringBuffer buffer, int indent) {
        buffer.append(XML14Util.getIndent(indent)).append("<").append(this.getID()).append(">\n");
        super.addToXML(buffer, indent + 1);
        XML14Util.appendTextNode(buffer, indent + 1, "sessionDurationMS", Long.toString(this.sessionDurationMS));
        XML14Util.appendTextNode(buffer, indent + 1, "sessionDuration", this.sessionDuration);
        if (this.customerInfo != null) {
            XML14Util.appendTextNode(buffer, indent + 1, "customerInfo", this.customerInfo.toString(true));
        }
        if (this.techUser != null) {
            this.techUser.appendToXML(buffer, indent + 1);
        }
        buffer.append(XML14Util.getIndent(indent)).append("</").append(this.getID()).append(">\n");
    }

    @Override
    protected void toProperties(Properties properties) {
        super.toProperties(properties);
        this.safePut(properties, "customerInfo", this.customerInfo.toString(true));
        this.safePut(properties, "techUser", this.techUser.toString());
        this.safePut(properties, "sessionDuration", this.sessionDuration);
        this.safePut(properties, "sessionDurationMS", Long.toString(this.sessionDurationMS));
    }

    @Override
    public void appendVariables(ArrayList<LogEvent.LogEventVariable> variableList) {
        super.appendVariables(variableList);
        variableList.add(new LogEvent.LogEventVariable("sessionDuration", null, this.sessionDuration));
        variableList.add(new LogEvent.LogEventVariable("sessionDurationMS", null, this.sessionDurationMS));
    }
}

