/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.logging.support;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.logging.SimpleHelpLogEvent;
import com.aem.shelp.proxy.types.Customer;
import java.io.File;
import java.util.ArrayList;
import java.util.Properties;
import utils.loggingframework.events.LogEvent;
import utils.xml.XML14Util;

public class CustLeaveQueue
extends SimpleHelpLogEvent {
    public static final String ID = "CustLeaveQueue";
    public Customer customerInfo;
    public String timeWaiting;
    public long timeWaitingMS;

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String getDisplayName() {
        return Language.get("EVENT_CUST_LEAVES_QUEUE");
    }

    @Override
    public String getDescription() {
        return "A customer has left the waiting queue.";
    }

    @Override
    public String getLogText() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[" + this.getEventID() + "] Customer left the queue:\n");
        buffer.append("\tCustomer:\n");
        buffer.append(this.customerInfo.toLogString(2));
        buffer.append("\tTime Waiting:\n");
        buffer.append("\t\t").append(this.timeWaiting).append(" (").append(this.timeWaitingMS).append("ms)");
        return buffer.toString();
    }

    @Override
    public File getEmailTemplateFile() {
        return new File("templates/support/customer_logout");
    }

    public static CustLeaveQueue createEvent(Customer customerInfo, long timeWaiting, String timeWaitingFormatted) {
        CustLeaveQueue event = new CustLeaveQueue();
        event.customerInfo = customerInfo;
        event.timeWaiting = timeWaitingFormatted.trim();
        event.timeWaitingMS = timeWaiting;
        return event;
    }

    @Override
    public String getEventID() {
        return "CustomerLeaveQueue";
    }

    @Override
    protected void toXML(StringBuffer buffer, int indent) {
        buffer.append(XML14Util.getIndent(indent)).append("<").append(this.getID()).append(">\n");
        super.addToXML(buffer, indent + 1);
        XML14Util.appendTextNode(buffer, indent + 1, "timeWaitingMS", Long.toString(this.timeWaitingMS));
        XML14Util.appendTextNode(buffer, indent + 1, "timeWaiting", this.timeWaiting);
        if (this.customerInfo != null) {
            XML14Util.appendTextNode(buffer, indent + 1, "customerInfo", this.customerInfo.toString(true));
        }
        buffer.append(XML14Util.getIndent(indent)).append("</").append(this.getID()).append(">\n");
    }

    @Override
    protected void toProperties(Properties properties) {
        super.toProperties(properties);
        this.safePut(properties, "customerInfo", this.customerInfo.toString(true));
        this.safePut(properties, "timeWaitingMS", Long.toString(this.timeWaitingMS));
        this.safePut(properties, "timeWaiting", this.timeWaiting);
    }

    @Override
    public void appendVariables(ArrayList<LogEvent.LogEventVariable> variableList) {
        super.appendVariables(variableList);
        variableList.add(new LogEvent.LogEventVariable("timeWaitingMS", null, this.timeWaitingMS));
        variableList.add(new LogEvent.LogEventVariable("timeWaiting", null, this.timeWaiting));
    }
}

