/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.logging.support;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.config.TechUser;
import com.aem.shelp.proxy.logging.SimpleHelpLogEvent;
import com.aem.shelp.proxy.types.Customer;
import java.io.File;
import java.util.ArrayList;
import java.util.Properties;
import utils.loggingframework.events.LogEvent;
import utils.xml.XML14Util;

public class CustJoinTechniciansQueue
extends SimpleHelpLogEvent {
    public static final String ID = "CustJoinTechniciansQueue";
    public Customer customerInfo;
    public TechUser techUser;

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String getDisplayName() {
        return Language.get("EVENT_CUST_JOINS_TECHS_QUEUE");
    }

    @Override
    public String getDescription() {
        return "A customer has joined the waiting queue for a particular technician.";
    }

    @Override
    public String getLogText() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[" + this.getEventID() + "] Customer entered the technicians queue:\n");
        buffer.append("\tCustomer:\n");
        buffer.append(this.customerInfo.toLogString(2));
        buffer.append("\tTechnician:\n");
        buffer.append(this.techUser.getLogString(2));
        return buffer.toString();
    }

    @Override
    public File getEmailTemplateFile() {
        return new File("templates/support/customer_tech_login");
    }

    public static CustJoinTechniciansQueue createEvent(Customer customerInfo, TechUser techUser) {
        CustJoinTechniciansQueue event = new CustJoinTechniciansQueue();
        event.customerInfo = customerInfo;
        event.techUser = techUser;
        return event;
    }

    @Override
    public String getEventID() {
        return "CustomerJoinTechnicianQueue";
    }

    @Override
    protected void toXML(StringBuffer buffer, int indent) {
        buffer.append(XML14Util.getIndent(indent)).append("<").append(this.getID()).append(">\n");
        super.addToXML(buffer, indent + 1);
        if (this.customerInfo != null) {
            XML14Util.appendTextNode(buffer, indent + 1, "customerInfo", this.customerInfo.toString(true));
        }
        if (this.techUser != null) {
            this.techUser.appendToXML(buffer, indent + 1);
        }
        buffer.append(XML14Util.getIndent(indent)).append("</").append(this.getID()).append(">\n");
    }

    @Override
    protected void toProperties(Properties properties) {
        super.toProperties(properties);
        this.safePut(properties, "customerInfo", this.customerInfo.toString(true));
        this.safePut(properties, "techUser", this.techUser.toString());
    }

    @Override
    public void appendVariables(ArrayList<LogEvent.LogEventVariable> variableList) {
        super.appendVariables(variableList);
    }
}

