/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.logging.server;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.config.TechUser;
import com.aem.shelp.proxy.logging.SimpleHelpLogEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Properties;
import utils.loggingframework.events.LogEvent;
import utils.xml.XML14Util;

public class TechLogoutEvent
extends SimpleHelpLogEvent {
    public static final String ID = "TechLogoutEvent";
    public TechUser techUser;
    public String loggedInTime;
    public String ipAddress;

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String getDisplayName() {
        return Language.get("EVENT_TECH_LOGOUT");
    }

    @Override
    public String getDescription() {
        return "An event generated when a technician logs out of SimpleHelp";
    }

    @Override
    public String getLogText() {
        return "[" + this.getEventID() + "] Technician logged out: " + this.techUser.getLogString(0) + " from " + this.ipAddress;
    }

    @Override
    public File getEmailTemplateFile() {
        return new File("templates/technician/logout");
    }

    public static TechLogoutEvent createEvent(TechUser techUser, String formattedTime, String ipAddress) {
        TechLogoutEvent event = new TechLogoutEvent();
        event.techUser = techUser;
        event.loggedInTime = formattedTime;
        event.ipAddress = ipAddress;
        return event;
    }

    @Override
    public String getEventID() {
        return "TechnicianLogout";
    }

    @Override
    protected void toXML(StringBuffer buffer, int indent) {
        buffer.append(XML14Util.getIndent(indent)).append("<").append(this.getID()).append(">\n");
        super.addToXML(buffer, indent + 1);
        if (this.loggedInTime != null) {
            XML14Util.appendTextNode(buffer, indent + 1, "loggedInTime", this.loggedInTime);
        }
        if (this.techUser != null) {
            this.techUser.appendToXML(buffer, indent + 1);
        }
        if (this.ipAddress != null) {
            XML14Util.appendTextNode(buffer, indent + 1, "ipAddress", this.ipAddress);
        }
        buffer.append(XML14Util.getIndent(indent)).append("</").append(this.getID()).append(">\n");
    }

    @Override
    protected void toProperties(Properties properties) {
        super.toProperties(properties);
        this.safePut(properties, "loggedInTime", this.loggedInTime);
        this.safePut(properties, "ipAddress", this.ipAddress);
        this.safePut(properties, "techUser", this.techUser.toString());
    }

    @Override
    public void appendVariables(ArrayList<LogEvent.LogEventVariable> variableList) {
        super.appendVariables(variableList);
        variableList.add(new LogEvent.LogEventVariable("loggedInTime", null, this.loggedInTime));
        variableList.add(new LogEvent.LogEventVariable("ipAddress", null, this.ipAddress));
    }
}

