/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.logging.server;

import com.aem.shelp.common.Language;
import com.aem.shelp.licence.OemBranding;
import com.aem.shelp.proxy.logging.SimpleHelpLogEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Properties;
import utils.loggingframework.events.LogEvent;
import utils.xml.XML14Util;

public class FailedTechLoginEvent
extends SimpleHelpLogEvent {
    public static final String ID = "FailedTechLoginEvent";
    public String username;
    public String groups;
    public String ipAddress;

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String getDisplayName() {
        return Language.get("EVENT_TECH_FAILED_LOGIN");
    }

    @Override
    public String getDescription() {
        return "An event generated when a technician fails to log in.";
    }

    @Override
    public String getLogText() {
        if (this.groups != null) {
            return "[" + this.getEventID() + "] Failed technician login: " + this.username + " (" + this.groups + ") from " + this.ipAddress;
        }
        return "[" + this.getEventID() + "] Failed technician login: " + this.username + " () from " + this.ipAddress;
    }

    @Override
    public File getEmailTemplateFile() {
        return new File("templates/technician/failed_login");
    }

    @Override
    public String getEventID() {
        return "TechnicianFailedLogin";
    }

    public static FailedTechLoginEvent createEvent(String username, String groups, String ipAddress) {
        FailedTechLoginEvent event = new FailedTechLoginEvent();
        event.username = username != null ? username : OemBranding.OEM_ADMIN_USERNAME;
        event.groups = groups;
        event.ipAddress = ipAddress;
        return event;
    }

    @Override
    protected void toXML(StringBuffer buffer, int indent) {
        buffer.append(XML14Util.getIndent(indent)).append("<").append(this.getID()).append(">\n");
        super.addToXML(buffer, indent + 1);
        if (this.username != null) {
            XML14Util.appendTextNode(buffer, indent + 1, "username", this.username);
        }
        if (this.groups != null) {
            XML14Util.appendTextNode(buffer, indent + 1, "groups", this.groups);
        }
        if (this.ipAddress != null) {
            XML14Util.appendTextNode(buffer, indent + 1, "ipAddress", this.ipAddress);
        }
        buffer.append(XML14Util.getIndent(indent)).append("</").append(this.getID()).append(">\n");
    }

    @Override
    protected void toProperties(Properties properties) {
        super.toProperties(properties);
        this.safePut(properties, "username", this.username);
        this.safePut(properties, "groups", this.groups);
        this.safePut(properties, "ipAddress", this.ipAddress);
    }

    @Override
    public void appendVariables(ArrayList<LogEvent.LogEventVariable> variableList) {
        super.appendVariables(variableList);
        variableList.add(new LogEvent.LogEventVariable("username", null, this.username));
        variableList.add(new LogEvent.LogEventVariable("groups", null, this.groups));
        variableList.add(new LogEvent.LogEventVariable("ipAddress", null, this.ipAddress));
    }
}

