/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.logging.presentation;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.config.TechUser;
import com.aem.shelp.proxy.logging.SimpleHelpLogEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Properties;
import utils.loggingframework.events.LogEvent;
import utils.xml.XML14Util;

public class PresentationRegistered
extends SimpleHelpLogEvent {
    public static final String ID = "PresentationRegistered";
    public TechUser techUser;
    public String presentation;

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String getDisplayName() {
        return Language.get("EVENT_PRESENTATION_REGISTERED");
    }

    @Override
    public String getDescription() {
        return "A presentation has been registered, but not yet started.";
    }

    @Override
    public String getLogText() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[" + this.getEventID() + "] Presentation registered:\n");
        buffer.append("\tTechnician:\n");
        buffer.append(this.techUser.getLogString(2));
        buffer.append("\tPresentation:\n");
        buffer.append("\t\t" + this.presentation);
        return buffer.toString();
    }

    @Override
    public File getEmailTemplateFile() {
        return new File("templates/presentation/register");
    }

    @Override
    public String getEventID() {
        return ID;
    }

    public static PresentationRegistered createEvent(TechUser techUser, String presentation) {
        PresentationRegistered event = new PresentationRegistered();
        event.techUser = techUser;
        event.presentation = presentation;
        return event;
    }

    @Override
    protected void toXML(StringBuffer buffer, int indent) {
        buffer.append(XML14Util.getIndent(indent)).append("<").append(this.getID()).append(">\n");
        super.addToXML(buffer, indent + 1);
        if (this.techUser != null) {
            this.techUser.appendToXML(buffer, indent + 1);
        }
        if (this.presentation != null) {
            XML14Util.appendTextNode(buffer, indent + 1, "presentation", this.presentation);
        }
        buffer.append(XML14Util.getIndent(indent)).append("</").append(this.getID()).append(">\n");
    }

    @Override
    protected void toProperties(Properties properties) {
        super.toProperties(properties);
        this.safePut(properties, "presentation", this.presentation);
        this.safePut(properties, "techUser", this.techUser.toString());
    }

    @Override
    public void appendVariables(ArrayList<LogEvent.LogEventVariable> variableList) {
        super.appendVariables(variableList);
        variableList.add(new LogEvent.LogEventVariable("presentation", null, this.presentation));
    }
}

