/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.logging.presentation;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.config.TechUser;
import com.aem.shelp.proxy.logging.SimpleHelpLogEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Properties;
import utils.loggingframework.events.LogEvent;
import utils.xml.XML14Util;

public class AttendeeJoined
extends SimpleHelpLogEvent {
    public static final String ID = "AttendeeJoined";
    public TechUser techUser;
    public String presentation;
    public int attendeeCount;
    public String attendeeName;
    public String attendeeEmail;

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String getDisplayName() {
        return Language.get("EVENT_PRESENTATION_JOINS");
    }

    @Override
    public String getDescription() {
        return "An attendee has joined a presentation.";
    }

    @Override
    public String getLogText() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[" + this.getEventID() + "] Attendee joined presentation:\n");
        buffer.append("\tAttendee:\n");
        buffer.append("\t\t" + this.attendeeName);
        if (this.attendeeEmail != null) {
            buffer.append(" [").append(this.attendeeEmail).append("]");
        }
        buffer.append("\n");
        buffer.append("\tPresentation:\n");
        buffer.append("\t\t" + this.presentation).append("\n");
        buffer.append("\tTechnician:\n");
        buffer.append(this.techUser.getLogString(2));
        buffer.append("\tAttendee Count:\n");
        buffer.append("\t\t" + this.attendeeCount);
        return buffer.toString();
    }

    @Override
    public File getEmailTemplateFile() {
        return new File("templates/presentation/attendee_join");
    }

    @Override
    public String getEventID() {
        return "AttendeeJoinedPresentation";
    }

    public static AttendeeJoined createEvent(TechUser techUser, String presentation, String attendeeName, String email, int attendeeCount) {
        AttendeeJoined event = new AttendeeJoined();
        event.techUser = techUser;
        event.attendeeEmail = email;
        event.attendeeName = attendeeName;
        event.presentation = presentation;
        event.attendeeCount = attendeeCount;
        return event;
    }

    @Override
    protected void toXML(StringBuffer buffer, int indent) {
        buffer.append(XML14Util.getIndent(indent)).append("<").append(this.getID()).append(">\n");
        super.addToXML(buffer, indent + 1);
        if (this.techUser != null) {
            this.techUser.appendToXML(buffer, indent + 1);
        }
        if (this.presentation != null) {
            XML14Util.appendTextNode(buffer, indent + 1, "presentation", this.presentation);
        }
        XML14Util.appendTextNode(buffer, indent + 1, "attendeeCount", Integer.toString(this.attendeeCount));
        if (this.attendeeName != null) {
            XML14Util.appendTextNode(buffer, indent + 1, "attendeeName", this.attendeeName);
        }
        if (this.attendeeEmail != null) {
            XML14Util.appendTextNode(buffer, indent + 1, "attendeeEmail", this.attendeeEmail);
        }
        buffer.append(XML14Util.getIndent(indent)).append("</").append(this.getID()).append(">\n");
    }

    @Override
    protected void toProperties(Properties properties) {
        super.toProperties(properties);
        this.safePut(properties, "presentation", this.presentation);
        this.safePut(properties, "techUser", this.techUser.toString());
        this.safePut(properties, "attendeeCount", Integer.toString(this.attendeeCount));
        this.safePut(properties, "attendeeName", this.attendeeName);
        this.safePut(properties, "attendeeEmail", this.attendeeEmail);
    }

    @Override
    public void appendVariables(ArrayList<LogEvent.LogEventVariable> variableList) {
        super.appendVariables(variableList);
        variableList.add(new LogEvent.LogEventVariable("presentation", null, this.presentation));
        variableList.add(new LogEvent.LogEventVariable("attendeeCount", null, this.attendeeCount));
        variableList.add(new LogEvent.LogEventVariable("attendeeName", null, this.attendeeName));
        variableList.add(new LogEvent.LogEventVariable("attendeeEmail", null, this.attendeeEmail));
    }
}

