/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.logging.access;

import com.aem.sgateway.SGGroupUtil;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.logging.SimpleHelpLogEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Properties;
import utils.loggingframework.events.LogEvent;
import utils.xml.XML14Util;

public class RemoteMachineOffline
extends SimpleHelpLogEvent {
    public static final String ID = "RemoteMachineOffline";
    public String remoteMachine;
    public String machineName;
    public String machineGroups;
    public String sourceIpAddress;

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String getDisplayName() {
        return Language.get("EVENT_MACHINE_OFFLINE_NAME");
    }

    @Override
    public String getDescription() {
        return "A remote access machine is no longer responding.";
    }

    @Override
    public String getLogText() {
        return "[" + this.getEventID() + "] Remote machine has gone offline: " + this.remoteMachine;
    }

    @Override
    public File getEmailTemplateFile() {
        return new File("templates/access/remote_machine_offline");
    }

    @Override
    public String getEventID() {
        return ID;
    }

    public static RemoteMachineOffline createEvent(String remoteMachine, String sourceIPAddress) {
        RemoteMachineOffline event = new RemoteMachineOffline();
        event.remoteMachine = remoteMachine;
        event.machineName = SGGroupUtil.getMachineName(remoteMachine);
        event.machineGroups = SGGroupUtil.getGroupsString(remoteMachine);
        event.sourceIpAddress = sourceIPAddress;
        return event;
    }

    @Override
    protected void toXML(StringBuffer buffer, int indent) {
        buffer.append(XML14Util.getIndent(indent)).append("<").append(this.getID()).append(">\n");
        super.addToXML(buffer, indent + 1);
        XML14Util.appendTextNode(buffer, indent + 1, "remoteMachine", this.remoteMachine);
        if (this.machineName != null && this.machineName.length() > 0) {
            XML14Util.appendTextNode(buffer, indent + 1, "machineName", this.machineName);
        }
        if (this.machineGroups != null && this.machineGroups.length() > 0) {
            XML14Util.appendTextNode(buffer, indent + 1, "machineGroups", this.machineGroups);
        }
        if (this.sourceIpAddress != null && this.sourceIpAddress.length() > 0) {
            XML14Util.appendTextNode(buffer, indent + 1, "sourceIpAddress", this.sourceIpAddress);
        }
        buffer.append(XML14Util.getIndent(indent)).append("</").append(this.getID()).append(">\n");
    }

    @Override
    protected void toProperties(Properties properties) {
        super.toProperties(properties);
        this.safePut(properties, "remoteMachine", this.remoteMachine);
        this.safePut(properties, "sourceIpAddress", this.sourceIpAddress);
        this.safePut(properties, "machineName", this.machineName);
        this.safePut(properties, "machineGroups", this.machineGroups);
    }

    @Override
    public void appendVariables(ArrayList<LogEvent.LogEventVariable> variableList) {
        super.appendVariables(variableList);
        variableList.add(new LogEvent.LogEventVariable("remoteMachine", null, this.remoteMachine));
        variableList.add(new LogEvent.LogEventVariable("sourceIpAddress", null, this.sourceIpAddress));
        variableList.add(new LogEvent.LogEventVariable("machineName", null, this.machineName));
        variableList.add(new LogEvent.LogEventVariable("machineGroups", null, this.machineGroups));
    }
}

