/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.logging;

import com.aem.sdesktop.SessionDescription;
import com.aem.shelp.proxy.config.TechUser;
import com.aem.shelp.proxy.types.Customer;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Properties;
import utils.loggingframework.events.NowLogEvent;
import utils.loggingframework.targets.email.EmailAddressMap;
import utils.xml.XML14Util;

public abstract class SimpleHelpLogEvent
extends NowLogEvent {
    protected static String[] requestedCustomerDetails = null;

    public abstract File getEmailTemplateFile();

    protected abstract String getEventID();

    public static void setCustomerDetails(String[] details) {
        requestedCustomerDetails = details;
    }

    @Override
    protected void addToXML(StringBuffer buffer, int indent) {
        XML14Util.appendTextNode(buffer, indent, "eventID", this.getEventID());
        super.addToXML(buffer, indent);
    }

    @Override
    public EmailAddressMap getPossibleEmailAddressesInEvent() {
        EmailAddressMap map = new EmailAddressMap();
        Field[] fields = this.getClass().getFields();
        for (int i = 0; i < fields.length; ++i) {
            int ii;
            String[] customerDetailKeys;
            Object value = null;
            try {
                value = fields[i].get(this);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                continue;
            }
            Class<?> type = fields[i].getType();
            if (type.equals(TechUser.class)) {
                if (value == null) {
                    map.addEntry("Technician", "");
                    continue;
                }
                map.addEntry("Technician", ((TechUser)value).emailAddress);
                continue;
            }
            if (type.equals(Customer.class)) {
                if (value != null) {
                    Customer customerInfo = (Customer)value;
                    customerDetailKeys = customerInfo.getDetailsKeys();
                    for (ii = 0; ii < customerDetailKeys.length; ++ii) {
                        map.addEntry(customerDetailKeys[ii], customerInfo.getValue(customerDetailKeys[ii], false));
                    }
                    continue;
                }
                if (requestedCustomerDetails == null) continue;
                for (int ii2 = 0; ii2 < requestedCustomerDetails.length; ++ii2) {
                    map.addEntry(requestedCustomerDetails[ii2], "");
                }
                continue;
            }
            if (type.equals(SessionDescription.SupportSessionDescription.class)) {
                if (value != null) {
                    Customer customerInfo = ((SessionDescription.SupportSessionDescription)value).getCustomerInfo();
                    customerDetailKeys = customerInfo.getDetailsKeys();
                    for (ii = 0; ii < customerDetailKeys.length; ++ii) {
                        map.addEntry(customerDetailKeys[ii], customerInfo.getValue(customerDetailKeys[ii], false));
                    }
                    String customEmailAddress = ((SessionDescription)value).customEmailAddress;
                    map.addEntry("Custom Email Address", customEmailAddress);
                    continue;
                }
                if (requestedCustomerDetails != null) {
                    for (int ii3 = 0; ii3 < requestedCustomerDetails.length; ++ii3) {
                        map.addEntry(requestedCustomerDetails[ii3], "");
                    }
                }
                map.addEntry("Custom Email Address", "");
                continue;
            }
            if (!type.equals(SessionDescription.AccessSessionDescription.class)) continue;
            if (value != null) {
                String customEmailAddress = ((SessionDescription)value).customEmailAddress;
                map.addEntry("Custom Email Address", customEmailAddress);
                continue;
            }
            map.addEntry("Custom Email Address", "");
        }
        return map;
    }

    @Override
    protected void toProperties(Properties properties) {
        super.toProperties(properties);
        properties.put("eventID", this.getEventID());
    }
}

