/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.logging;

import com.aem.sdesktop.SessionDescription;
import com.aem.shelp.common.Language;
import com.aem.shelp.licence.OemBranding;
import com.aem.shelp.proxy.config.ServerConfig;
import com.aem.shelp.proxy.config.TechUser;
import com.aem.shelp.proxy.logging.access.AccessSessionSummaryEvent;
import com.aem.shelp.proxy.logging.access.RemoteMachineOffline;
import com.aem.shelp.proxy.logging.access.RemoteMachineOfflineExtended;
import com.aem.shelp.proxy.logging.access.RemoteMachineOnline;
import com.aem.shelp.proxy.logging.access.TechJoinAccessSessionEvent;
import com.aem.shelp.proxy.logging.access.TechLeaveAccessSessionEvent;
import com.aem.shelp.proxy.logging.presentation.AttendeeJoined;
import com.aem.shelp.proxy.logging.presentation.PresentationEnd;
import com.aem.shelp.proxy.logging.presentation.PresentationRegistered;
import com.aem.shelp.proxy.logging.presentation.PresentationStart;
import com.aem.shelp.proxy.logging.server.FailedTechLoginEvent;
import com.aem.shelp.proxy.logging.server.TechLoginEvent;
import com.aem.shelp.proxy.logging.server.TechLogoutEvent;
import com.aem.shelp.proxy.logging.sessions.SessionPerformanceEvent;
import com.aem.shelp.proxy.logging.support.CustJoinQueue;
import com.aem.shelp.proxy.logging.support.CustJoinSessionEvent;
import com.aem.shelp.proxy.logging.support.CustJoinTechniciansQueue;
import com.aem.shelp.proxy.logging.support.CustLeaveQueue;
import com.aem.shelp.proxy.logging.support.CustLeaveSessionEvent;
import com.aem.shelp.proxy.logging.support.SupportSessionSummaryEvent;
import com.aem.shelp.proxy.logging.support.TechJoinSupportSessionEvent;
import com.aem.shelp.proxy.logging.support.TechLeaveSupportSessionEvent;
import com.aem.shelp.proxy.logging.targets.notifytech.NotifyTechTarget;
import com.aem.shelp.proxy.logging.targets.runtool.RunToolTarget;
import com.aem.shelp.proxy.types.Customer;
import com.aem.shelp.proxy.types.LocatedAlert;
import com.aem.shelp.util.ElapsedTimeFormatter;
import java.util.ArrayList;
import utils.loggingframework.events.EventRepository;
import utils.loggingframework.events.LogEvent;
import utils.loggingframework.events.VariableProcessor;
import utils.loggingframework.targets.TargetRepository;
import utils.switches.Switches;

public class SimpleHelpEventRepository
extends EventRepository {
    private String[] detailsLabelsSetInAdminTab = null;
    public TechUserVariableProcessor techVariableProcessor;
    public CustomerInfoVariableProcessor customerVariableProcessor;
    public SupportSessionDescriptionVariableProcessor supportSessionVariableProcessor;
    public AccessSessionDescriptionVariableProcessor accessSessionVariableProcessor;

    public SimpleHelpEventRepository() {
        EventRepository.INSTANCE = this;
        if (Switches.TECH_NOTIFY_ACTION) {
            TargetRepository.INSTANCE.addTarget("NotifyTechTarget", NotifyTechTarget.class);
        }
        if (Switches.TECH_RUN_TOOL_ACTION) {
            TargetRepository.INSTANCE.addTarget("RunToolTarget", RunToolTarget.class);
        }
        this.addEvent(Language.get("EVENT_GROUP_CUSTOMER"), "CustJoinQueue", CustJoinQueue.class);
        this.addEvent(Language.get("EVENT_GROUP_CUSTOMER"), "CustJoinTechniciansQueue", CustJoinTechniciansQueue.class);
        this.addEvent(Language.get("EVENT_GROUP_CUSTOMER"), "CustLeaveQueue", CustLeaveQueue.class);
        this.addEvent(Language.get("EVENT_GROUP_CUSTOMER"), "CustJoinSessionEvent", CustJoinSessionEvent.class);
        this.addEvent(Language.get("EVENT_GROUP_CUSTOMER"), "CustLeaveSessionEvent", CustLeaveSessionEvent.class);
        this.addEvent(Language.get("EVENT_GROUP_TECHNICIAN"), "TechLoginEvent", TechLoginEvent.class);
        this.addEvent(Language.get("EVENT_GROUP_TECHNICIAN"), "TechLogoutEvent", TechLogoutEvent.class);
        this.addEvent(Language.get("EVENT_GROUP_TECHNICIAN"), "FailedTechLoginEvent", FailedTechLoginEvent.class);
        this.addEvent(Language.get("EVENT_GROUP_TECHNICIAN"), "TechJoinSupportSessionEvent", TechJoinSupportSessionEvent.class);
        this.addEvent(Language.get("EVENT_GROUP_TECHNICIAN"), "TechLeaveSupportSessionEvent", TechLeaveSupportSessionEvent.class);
        this.addEvent(Language.get("EVENT_GROUP_TECHNICIAN"), "TechJoinAccessSessionEvent", TechJoinAccessSessionEvent.class);
        this.addEvent(Language.get("EVENT_GROUP_TECHNICIAN"), "TechLeaveAccessSessionEvent", TechLeaveAccessSessionEvent.class);
        this.addEvent(Language.get("EVENT_GROUP_SESSION_SUMMARY"), "AccessSessionSummaryEvent", AccessSessionSummaryEvent.class);
        this.addEvent(Language.get("EVENT_GROUP_SESSION_SUMMARY"), "SupportSessionSummaryEvent", SupportSessionSummaryEvent.class);
        this.addEvent(Language.get("EVENT_GROUP_REMOTE_MACHINES"), "RemoteMachineOnline", RemoteMachineOnline.class);
        this.addEvent(Language.get("EVENT_GROUP_REMOTE_MACHINES"), "RemoteMachineOffline", RemoteMachineOffline.class);
        this.addEvent(Language.DEFLANG.getString("EVENT_GROUP_REMOTE_MACHINES"), "RemoteMachineOfflineExt", RemoteMachineOfflineExtended.class);
        if (OemBranding.OEM_IS_SH) {
            this.addEvent(Language.get("EVENT_GROUP_PRESENTATION"), "PresentationStart", PresentationStart.class);
            this.addEvent(Language.get("EVENT_GROUP_PRESENTATION"), "PresentationRegistered", PresentationRegistered.class);
            this.addEvent(Language.get("EVENT_GROUP_PRESENTATION"), "AttendeeJoined", AttendeeJoined.class);
            this.addEvent(Language.get("EVENT_GROUP_PRESENTATION"), "PresentationEnd", PresentationEnd.class);
        }
        if (Switches.SLB_perfomanceEventsViaLoggingFramework) {
            this.addEvent(Language.get("EVENT_GROUP_SESSION_SUMMARY"), "SessionPerformanceEvent", SessionPerformanceEvent.class);
        }
        this.techVariableProcessor = new TechUserVariableProcessor();
        this.customerVariableProcessor = new CustomerInfoVariableProcessor();
        this.supportSessionVariableProcessor = new SupportSessionDescriptionVariableProcessor();
        this.accessSessionVariableProcessor = new AccessSessionDescriptionVariableProcessor();
        this.addVariableProcessor(this.customerVariableProcessor);
        this.addVariableProcessor(this.techVariableProcessor);
        this.addVariableProcessor(this.supportSessionVariableProcessor);
        this.addVariableProcessor(this.accessSessionVariableProcessor);
        this.addVariableProcessor(new LocatedAlertVariableProcessor());
    }

    public void setShowPerformanceEvent(boolean showEvent) {
        if (!showEvent) {
            this.removeEvent("SessionPerformanceEvent");
        }
    }

    public static VariableProcessor<Customer> getCustomerVariableProcessor() {
        return ((SimpleHelpEventRepository)SimpleHelpEventRepository.INSTANCE).customerVariableProcessor;
    }

    public static VariableProcessor<TechUser> getTechUserVariableProcessor() {
        return ((SimpleHelpEventRepository)SimpleHelpEventRepository.INSTANCE).techVariableProcessor;
    }

    public static VariableProcessor<SessionDescription.AccessSessionDescription> getAccessSessionVariableProcessor() {
        return ((SimpleHelpEventRepository)SimpleHelpEventRepository.INSTANCE).accessSessionVariableProcessor;
    }

    public static VariableProcessor<SessionDescription.SupportSessionDescription> getSupportSessionVariableProcessor() {
        return ((SimpleHelpEventRepository)SimpleHelpEventRepository.INSTANCE).supportSessionVariableProcessor;
    }

    public void setCustomerDetailsLabels(String[] labels) {
        this.detailsLabelsSetInAdminTab = labels;
    }

    public static SimpleHelpEventRepository getRepository() {
        if (EventRepository.INSTANCE instanceof SimpleHelpEventRepository) {
            return (SimpleHelpEventRepository)EventRepository.INSTANCE;
        }
        return new SimpleHelpEventRepository();
    }

    class AccessSessionDescriptionVariableProcessor
    extends VariableProcessor<SessionDescription.AccessSessionDescription> {
        AccessSessionDescriptionVariableProcessor() {
        }

        @Override
        public Class<SessionDescription.AccessSessionDescription> whichClassCanProcess() {
            return SessionDescription.AccessSessionDescription.class;
        }

        @Override
        public Object getValue(SessionDescription.AccessSessionDescription instance, String variableName) {
            SessionDescription.AccessSessionDescription sd = instance;
            if (variableName.equalsIgnoreCase("technicianSummary")) {
                return sd.technicianSummary;
            }
            if (variableName.equalsIgnoreCase("customEmailAddress")) {
                return sd.customEmailAddress;
            }
            if (variableName.equalsIgnoreCase("chatTranscript")) {
                return sd.chatTranscript;
            }
            if (variableName.equalsIgnoreCase("sessionDurationMS")) {
                return "" + sd.sessionDurationMS;
            }
            if (variableName.equalsIgnoreCase("sessionDuration")) {
                return new ElapsedTimeFormatter().getCompleteFormattedTime(sd.sessionDurationMS);
            }
            if (variableName.equalsIgnoreCase("remoteMachine")) {
                return sd.getRemoteMachineName();
            }
            return "-";
        }

        @Override
        public void appendVariables(SessionDescription.AccessSessionDescription sd, ArrayList<LogEvent.LogEventVariable> variableList) {
            if (sd != null) {
                variableList.add(new LogEvent.LogEventVariable("technicianSummary", null, sd.technicianSummary));
                variableList.add(new LogEvent.LogEventVariable("customEmailAddress", null, sd.customEmailAddress));
                variableList.add(new LogEvent.LogEventVariable("chatTranscript", null, sd.chatTranscript));
                variableList.add(new LogEvent.LogEventVariable("sessionDurationMS", null, sd.sessionDurationMS + ""));
                variableList.add(new LogEvent.LogEventVariable("sessionDuration", null, new ElapsedTimeFormatter().getCompleteFormattedTime(sd.sessionDurationMS)));
                variableList.add(new LogEvent.LogEventVariable("remoteMachine", null, sd.getRemoteMachineName()));
            } else {
                variableList.add(new LogEvent.LogEventVariable("technicianSummary", null, null));
                variableList.add(new LogEvent.LogEventVariable("customEmailAddress", null, null));
                variableList.add(new LogEvent.LogEventVariable("chatTranscript", null, null));
                variableList.add(new LogEvent.LogEventVariable("sessionDurationMS", null, null));
                variableList.add(new LogEvent.LogEventVariable("sessionDuration", null, null));
                variableList.add(new LogEvent.LogEventVariable("remoteMachine", null, null));
            }
        }
    }

    class SupportSessionDescriptionVariableProcessor
    extends VariableProcessor<SessionDescription.SupportSessionDescription> {
        private CustomerInfoVariableProcessor customerInfoProcessor;

        SupportSessionDescriptionVariableProcessor() {
            this.customerInfoProcessor = new CustomerInfoVariableProcessor();
        }

        @Override
        public Class<SessionDescription.SupportSessionDescription> whichClassCanProcess() {
            return SessionDescription.SupportSessionDescription.class;
        }

        @Override
        public Object getValue(SessionDescription.SupportSessionDescription instance, String variableName) {
            SessionDescription.SupportSessionDescription sd = instance;
            if (variableName.equalsIgnoreCase("technicianSummary")) {
                return sd.technicianSummary;
            }
            if (variableName.equalsIgnoreCase("customEmailAddress")) {
                return sd.customEmailAddress;
            }
            if (variableName.equalsIgnoreCase("chatTranscript")) {
                return sd.chatTranscript;
            }
            if (variableName.equalsIgnoreCase("sessionDurationMS")) {
                return "" + sd.sessionDurationMS;
            }
            if (variableName.equalsIgnoreCase("sessionDuration")) {
                return new ElapsedTimeFormatter().getCompleteFormattedTime(sd.sessionDurationMS);
            }
            if (variableName.equalsIgnoreCase("customerInfo")) {
                return sd.getCustomerInfo();
            }
            return this.customerInfoProcessor.getValue(sd.getCustomerInfo(), variableName);
        }

        @Override
        public void appendVariables(SessionDescription.SupportSessionDescription sd, ArrayList<LogEvent.LogEventVariable> variableList) {
            if (sd != null) {
                variableList.add(new LogEvent.LogEventVariable("technicianSummary", null, sd.technicianSummary));
                variableList.add(new LogEvent.LogEventVariable("customEmailAddress", null, sd.customEmailAddress));
                variableList.add(new LogEvent.LogEventVariable("chatTranscript", null, sd.chatTranscript));
                variableList.add(new LogEvent.LogEventVariable("sessionDurationMS", null, sd.sessionDurationMS));
                variableList.add(new LogEvent.LogEventVariable("sessionDuration", null, new ElapsedTimeFormatter().getCompleteFormattedTime(sd.sessionDurationMS)));
                this.customerInfoProcessor.appendVariables(sd.getCustomerInfo(), variableList);
            } else {
                variableList.add(new LogEvent.LogEventVariable("technicianSummary", null, null));
                variableList.add(new LogEvent.LogEventVariable("customEmailAddress", null, null));
                variableList.add(new LogEvent.LogEventVariable("chatTranscript", null, null));
                variableList.add(new LogEvent.LogEventVariable("sessionDurationMS", null, null));
                variableList.add(new LogEvent.LogEventVariable("sessionDuration", null, null));
                this.customerInfoProcessor.appendVariables(null, variableList);
            }
        }
    }

    class LocatedAlertVariableProcessor
    extends VariableProcessor<LocatedAlert> {
        LocatedAlertVariableProcessor() {
        }

        @Override
        public Class<LocatedAlert> whichClassCanProcess() {
            return LocatedAlert.class;
        }

        @Override
        public Object getValue(LocatedAlert alert, String variableName) {
            if (variableName.equalsIgnoreCase("alertName")) {
                return alert.getName().getName();
            }
            if (variableName.equalsIgnoreCase("alertGroups")) {
                return alert.getName().getGroupString();
            }
            return "";
        }

        @Override
        public void appendVariables(LocatedAlert alert, ArrayList<LogEvent.LogEventVariable> variableList) {
            if (alert != null) {
                variableList.add(new LogEvent.LogEventVariable("alertName", null, alert.getName().getName()));
                variableList.add(new LogEvent.LogEventVariable("alertGroups", null, alert.getName().getGroupString()));
            } else {
                variableList.add(new LogEvent.LogEventVariable("alertName", null, null));
                variableList.add(new LogEvent.LogEventVariable("alertGroups", null, null));
            }
        }
    }

    class TechUserVariableProcessor
    extends VariableProcessor<TechUser> {
        TechUserVariableProcessor() {
        }

        @Override
        public Class<TechUser> whichClassCanProcess() {
            return TechUser.class;
        }

        @Override
        public Object getValue(TechUser user, String variableName) {
            if (variableName.equalsIgnoreCase("technicianName")) {
                return user.displayName;
            }
            if (variableName.equalsIgnoreCase("technicianUsername")) {
                return user.login;
            }
            if (variableName.equalsIgnoreCase("technicianEmail")) {
                return user.emailAddress;
            }
            if (variableName.equalsIgnoreCase("technician")) {
                return user.displayName;
            }
            return "";
        }

        @Override
        public void appendVariables(TechUser user, ArrayList<LogEvent.LogEventVariable> variableList) {
            if (user != null) {
                variableList.add(new LogEvent.LogEventVariable("technicianName", null, user.displayName));
                variableList.add(new LogEvent.LogEventVariable("technicianUsername", null, user.login));
                variableList.add(new LogEvent.LogEventVariable("technicianEmail", null, user.emailAddress));
                variableList.add(new LogEvent.LogEventVariable("technician", null, user.displayName));
            } else {
                variableList.add(new LogEvent.LogEventVariable("technicianName", null, null));
                variableList.add(new LogEvent.LogEventVariable("technicianUsername", null, null));
                variableList.add(new LogEvent.LogEventVariable("technicianEmail", null, null));
                variableList.add(new LogEvent.LogEventVariable("technician", null, null));
            }
        }
    }

    class CustomerInfoVariableProcessor
    extends VariableProcessor<Customer> {
        CustomerInfoVariableProcessor() {
        }

        @Override
        public Class<Customer> whichClassCanProcess() {
            return Customer.class;
        }

        @Override
        public Object getValue(Customer instance, String variableName) {
            Customer info = instance;
            if (instance == null) {
                return null;
            }
            String value = info.getValue(variableName, true);
            if (value != null) {
                return value;
            }
            if (variableName.equalsIgnoreCase("Waiting MS")) {
                return Long.toString(info.getWaitingFor());
            }
            if (variableName.equalsIgnoreCase("Remote Username")) {
                return info.getRemoteUsername();
            }
            if (variableName.equalsIgnoreCase("Country")) {
                return info.getCountry();
            }
            if (variableName.equalsIgnoreCase("Request Domain")) {
                return info.getRequestDomain();
            }
            if (variableName.equalsIgnoreCase("Request URL")) {
                return info.getRequestURL();
            }
            if (variableName.equalsIgnoreCase("Public IP")) {
                return info.getWanIP();
            }
            if (variableName.equalsIgnoreCase("Local IPs")) {
                return info.getLocalIPsAsString();
            }
            if (variableName.equalsIgnoreCase("Hostname")) {
                return info.getHostname();
            }
            if (variableName.equalsIgnoreCase("Operating System")) {
                return info.getOsSummary();
            }
            if (variableName.equalsIgnoreCase("CustomerInfo")) {
                return info.toString(true);
            }
            return "-";
        }

        @Override
        public void appendVariables(Customer variableObject, ArrayList<LogEvent.LogEventVariable> variableList) {
            if (SimpleHelpEventRepository.this.detailsLabelsSetInAdminTab == null) {
                Object[] details = ServerConfig.get().getDetails();
                if (details != null) {
                    String[] allDetails = new String[details.length];
                    for (int i = 0; i < details.length; ++i) {
                        allDetails[i] = details[i].getLabel();
                    }
                    String[] stringArray = allDetails;
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        String s = stringArray[i];
                        variableList.add(new LogEvent.LogEventVariable(s, null, this.getValue(variableObject, s)));
                    }
                }
            } else {
                for (String s : SimpleHelpEventRepository.this.detailsLabelsSetInAdminTab) {
                    variableList.add(new LogEvent.LogEventVariable(s, null, this.getValue(variableObject, s)));
                }
            }
            if (variableObject != null && variableObject instanceof Customer) {
                Customer customer = variableObject;
                for (String s : customer.getDetailsKeys()) {
                    LogEvent.LogEventVariable var = new LogEvent.LogEventVariable(s, null, this.getValue(variableObject, s));
                    if (variableList.contains(var)) continue;
                    variableList.add(var);
                }
            }
            if (variableObject != null) {
                variableList.add(new LogEvent.LogEventVariable("Waiting MS", null, Long.toString(variableObject.getWaitingFor())));
                variableList.add(new LogEvent.LogEventVariable("Remote Username", null, variableObject.getRemoteUsername()));
                variableList.add(new LogEvent.LogEventVariable("Country", null, variableObject.getCountry()));
                variableList.add(new LogEvent.LogEventVariable("Request Domain", null, variableObject.getRequestDomain()));
                variableList.add(new LogEvent.LogEventVariable("Request URL", null, variableObject.getRequestURL()));
                variableList.add(new LogEvent.LogEventVariable("Public IP", null, variableObject.getWanIP()));
                variableList.add(new LogEvent.LogEventVariable("Local IPs", null, variableObject.getLocalIPsAsString()));
                variableList.add(new LogEvent.LogEventVariable("Hostname", null, variableObject.getHostname()));
                variableList.add(new LogEvent.LogEventVariable("Operating System", null, variableObject.getOsSummary()));
                variableList.add(new LogEvent.LogEventVariable("CustomerInfo", null, variableObject.toString(true)));
            } else {
                variableList.add(new LogEvent.LogEventVariable("Waiting MS", null, null));
                variableList.add(new LogEvent.LogEventVariable("Remote Username", null, null));
                variableList.add(new LogEvent.LogEventVariable("Country", null, null));
                variableList.add(new LogEvent.LogEventVariable("Request Domain", null, null));
                variableList.add(new LogEvent.LogEventVariable("Request URL", null, null));
                variableList.add(new LogEvent.LogEventVariable("Public IP", null, null));
                variableList.add(new LogEvent.LogEventVariable("Local IPs", null, null));
                variableList.add(new LogEvent.LogEventVariable("Hostname", null, null));
                variableList.add(new LogEvent.LogEventVariable("Operating System", null, null));
                variableList.add(new LogEvent.LogEventVariable("CustomerInfo", null, null));
            }
        }
    }
}

