/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.history;

import com.aem.shelp.proxy.SessionHistoryRepository;
import java.io.File;
import java.util.Calendar;
import java.util.Iterator;

public class MonthFolderIterator
implements Iterator<File> {
    private int startYear;
    private int startMonth;
    private int endYear;
    private int endMonth;
    private boolean reverse = false;
    private File currentResult = null;
    private int currentYear;
    private int currentMonth;

    public MonthFolderIterator(long startTime, long endTime) {
        this.reverse = startTime > endTime;
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(startTime);
        this.startYear = cal.get(1);
        this.startMonth = cal.get(2);
        cal.setTimeInMillis(endTime);
        this.endYear = cal.get(1);
        this.endMonth = cal.get(2);
    }

    @Override
    public boolean hasNext() {
        this.currentResult = this.getNextFolder();
        return this.currentResult != null;
    }

    @Override
    public File next() {
        return this.currentResult;
    }

    @Override
    public void remove() {
    }

    private File getNextFolder() {
        if (!this.reverse ? this.startYear > this.endYear || this.startYear == this.endYear && this.startMonth > this.endMonth : this.startYear < this.endYear || this.startYear == this.endYear && this.startMonth < this.endMonth) {
            return null;
        }
        File monthDir = SessionHistoryRepository.getFolderFor(this.startYear, this.startMonth);
        this.currentMonth = this.startMonth++;
        this.currentYear = this.startYear++;
        if (!this.reverse) {
            if (this.startMonth > 11) {
                this.startMonth = 0;
            }
        } else {
            --this.startMonth;
            if (this.startMonth < 0) {
                this.startMonth = 11;
                --this.startYear;
            }
        }
        if (monthDir.exists()) {
            return monthDir;
        }
        return this.getNextFolder();
    }

    public int getCurrentYear() {
        return this.currentYear;
    }

    public int getCurrentMonth() {
        return this.currentMonth;
    }
}

