/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.history;

import com.aem.shelp.proxy.history.HistoryMetricBlock;
import java.text.DateFormat;
import java.util.ArrayList;
import utils.message.Message;

public class HistoryMetrics {
    private final long start;
    private final long end;
    private final transient long aggregateBlockMS;
    private ArrayList<HistoryMetricBlock> blocks;

    public HistoryMetrics(long start, long end, int blockCount) {
        if (start < end) {
            this.start = start;
            this.end = end;
        } else {
            this.start = end;
            this.end = start;
        }
        this.aggregateBlockMS = (this.end - this.start) / (long)blockCount;
        this.blocks = new ArrayList(blockCount);
        for (int i = 0; i < blockCount; ++i) {
            this.blocks.add(null);
        }
    }

    public Message toMessage() {
        Message m = new Message();
        m.append(this.start);
        m.append(this.end);
        m.append(this.blocks.size());
        for (HistoryMetricBlock block : this.blocks) {
            if (block == null) {
                m.append((Message)null);
                continue;
            }
            m.append(block.toMessage());
        }
        return m;
    }

    public static HistoryMetrics fromMessage(Message m) {
        HistoryMetrics metrics = new HistoryMetrics(m.getNextLong(), m.getNextLong(), m.getNextInt());
        for (int i = 0; i < metrics.blocks.size(); ++i) {
            Message mm = m.getNextMessage();
            if (mm == null) continue;
            metrics.blocks.set(i, HistoryMetricBlock.fromMessage(mm));
        }
        return metrics;
    }

    public HistoryMetricBlock getHistoryMetricBlock(long startTime) {
        HistoryMetricBlock block;
        int blockNumber = (int)((startTime - this.start) / this.aggregateBlockMS);
        blockNumber = Math.min(blockNumber, this.blocks.size() - 1);
        long blockStart = this.start + (long)blockNumber * this.aggregateBlockMS;
        long blockEnd = this.start + (long)(blockNumber + 1) * this.aggregateBlockMS;
        if (blockNumber == this.blocks.size() - 1) {
            blockEnd = this.end;
        }
        if ((block = this.blocks.get(blockNumber)) == null) {
            block = new HistoryMetricBlock(blockStart, blockEnd);
            this.blocks.set(blockNumber, block);
        }
        return block;
    }

    public String toString() {
        DateFormat df = DateFormat.getDateInstance(3);
        StringBuilder builder = new StringBuilder();
        long totalSessions = 0L;
        for (HistoryMetricBlock block : this.blocks) {
            if (block == null) {
                builder.append("NULL\n");
                continue;
            }
            totalSessions += block.supportSessionCount + block.accessSessionCount + block.presentationSessionCount;
            builder.append(df.format(block.startMS)).append(" -> ").append(df.format(block.endMS));
            builder.append(" sessions:").append(block.supportSessionCount).append("/").append(block.accessSessionCount).append("/").append(block.presentationSessionCount);
            builder.append(" duration:").append(block.supportSessionDurations).append("/").append(block.accessSessionDurations).append("/").append(block.presentationSessionDurations);
            builder.append(" machines:").append(block.getMachineSessionCount());
            builder.append(" customers:").append(block.getCustomerSessionCount());
            builder.append("\n");
        }
        return builder.toString();
    }

    public long[] getAllSupportSessionCounts() {
        long[] result = new long[this.blocks.size()];
        for (int i = 0; i < result.length; ++i) {
            HistoryMetricBlock block = this.blocks.get(i);
            if (block == null) continue;
            result[i] = block.supportSessionCount;
        }
        return result;
    }

    public long[] getAllAccessSessionCounts() {
        long[] result = new long[this.blocks.size()];
        for (int i = 0; i < result.length; ++i) {
            HistoryMetricBlock block = this.blocks.get(i);
            if (block == null) continue;
            result[i] = block.accessSessionCount;
        }
        return result;
    }

    public long[] getAllPresentationSessionCounts() {
        long[] result = new long[this.blocks.size()];
        for (int i = 0; i < result.length; ++i) {
            HistoryMetricBlock block = this.blocks.get(i);
            if (block == null) continue;
            result[i] = block.presentationSessionCount;
        }
        return result;
    }

    public long getTotalSupportDuration() {
        long result = 0L;
        for (HistoryMetricBlock block : this.blocks) {
            if (block == null) continue;
            result += block.supportSessionDurations;
        }
        return result;
    }

    public long getTotalAccessDuration() {
        long result = 0L;
        for (HistoryMetricBlock block : this.blocks) {
            if (block == null) continue;
            result += block.accessSessionDurations;
        }
        return result;
    }

    public long getTotalPresentationDuration() {
        long result = 0L;
        for (HistoryMetricBlock block : this.blocks) {
            if (block == null) continue;
            result += block.presentationSessionDurations;
        }
        return result;
    }
}

