/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.config;

import com.aem.CentralDebugging;
import com.aem.shelp.common.login.TechCredentials;
import com.aem.shelp.common.toolbox.ToolBoxGroup;
import com.aem.shelp.proxy.LoginType;
import com.aem.shelp.proxy.config.LazyPassword;
import com.aem.shelp.proxy.config.MergedTechGroup;
import com.aem.shelp.proxy.config.ServerConfig;
import com.aem.shelp.proxy.config.TechGroup;
import com.aem.shelp.proxy.config.TransientTechUser;
import com.aem.shelp.proxy.types.AbstractMachine;
import com.aem.shelp.proxy.types.Customer;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.proxy.types.filters.CustomerFilter;
import com.aem.shelp.proxy.types.filters.Filter;
import com.aem.shelp.proxy.types.filters.MachineFilter;
import com.aem.utils.Debugger;
import com.aem.utils.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import utils.radius.ChallengeHandler;
import utils.stream.StreamUtils;
import utils.xml.XML14Util;

public class TechUser
implements Comparable<TechUser> {
    public static final int ANONYMOUS_ID = -2;
    public static final int UNKNOWN_ID = -1;
    public static final int SIMPLEHELP_ADMIN_ID = 0;
    public static final int SIMPLEHELP_ADMIN_GROUP_ID = 2000001;
    public static final int ADMIN_GROUP_ID = 2000002;
    public int uniqueID;
    public String displayName;
    public String login;
    public LazyPassword techPassword;
    public String emailAddress;
    private CustomerFilter[] customerFilters = new CustomerFilter[0];
    private MachineFilter[] machineFilters = new MachineFilter[0];
    public TechGroup[] groups = new TechGroup[0];
    public TechGroup[] groupsUserCanAdmin = new TechGroup[0];
    public transient byte[] avatarImageBytes = null;
    private boolean isAnonymous;
    private boolean allowLocallyAuthenticatedLogins = true;
    private boolean accountEnabled = true;
    private boolean isForAppProfilesOnly = false;
    private LazyPassword secretKey = null;
    private MergedTechGroup mergedTechGroupInstance;

    public TechUser(int id, String defaultName, String login, LazyPassword password, String email, boolean isAnonymous, boolean allowLocalAuthentication, boolean accountEnabled) {
        this.uniqueID = id;
        this.displayName = defaultName;
        this.login = login;
        this.techPassword = password;
        this.accountEnabled = accountEnabled;
        this.emailAddress = email;
        this.isAnonymous = isAnonymous;
        this.allowLocallyAuthenticatedLogins = allowLocalAuthentication;
    }

    public boolean equals(Object o) {
        return o instanceof TechUser && ((TechUser)o).uniqueID == this.uniqueID;
    }

    public int getUserID() {
        return this.uniqueID;
    }

    public boolean isServerAdmin() {
        return this.uniqueID == 0;
    }

    public boolean isAnonymous() {
        return this.isAnonymous;
    }

    public boolean allowLocallyAuthenticatedLogins() {
        return this.allowLocallyAuthenticatedLogins;
    }

    public boolean isForAppProfilesOnly() {
        return this.isForAppProfilesOnly;
    }

    public void setIsForAppProfilesOnly(boolean b) {
        this.isForAppProfilesOnly = b;
    }

    public CustomerFilter[] getCustomerFilters() {
        return this.customerFilters;
    }

    public MachineFilter[] getMachineFilters() {
        return this.machineFilters;
    }

    public String getDefaultName() {
        if (this.displayName == null) {
            return this.login;
        }
        return this.displayName;
    }

    public boolean canUseSH() {
        boolean canDo = true;
        if (this.groups != null && this.groups.length > 0) {
            canDo = false;
            for (TechGroup group : this.groups) {
                if (!group.getPermissions().canRemoteSupport()) continue;
                return true;
            }
        }
        return canDo;
    }

    public boolean canUseSG() {
        boolean canDo = true;
        if (this.groups != null && this.groups.length > 0) {
            canDo = false;
            for (TechGroup group : this.groups) {
                if (!group.getPermissions().canRemoteAccess()) continue;
                return true;
            }
        }
        return canDo;
    }

    public void setDefaultName(String defaultName) {
        this.displayName = defaultName;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public LazyPassword getPassword() {
        return this.techPassword;
    }

    public void setGroups(TechGroup[] groups) {
        this.groups = groups;
    }

    public TechGroup[] getGroups() {
        return this.groups;
    }

    public void setGroupsToAdmin(TechGroup[] groupsUserCanAdmin) {
        this.groupsUserCanAdmin = groupsUserCanAdmin;
    }

    public TechGroup[] getGroupsToAdmin() {
        return this.groupsUserCanAdmin;
    }

    public boolean canAdministerGroups() {
        return this.groupsUserCanAdmin != null && this.groupsUserCanAdmin.length > 0;
    }

    public TechGroup resolveChosenGroupToNamedGroup(TechGroup loggedInContext) {
        if (this.groups.length == 1) {
            return this.groups[0];
        }
        if (loggedInContext != null && this.isInGroup(loggedInContext)) {
            return loggedInContext;
        }
        if (this.groups.length > 0) {
            return this.groups[0];
        }
        return null;
    }

    public void setPassword(LazyPassword password) {
        this.techPassword = password;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.displayName);
        if (this.login != null) {
            buffer.append(" - ").append(this.login);
        }
        if (this.groups == null || this.groups.length == 0) {
            return buffer.toString();
        }
        buffer.append("  [ ");
        for (int i = 0; i < this.groups.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(this.groups[i].toString());
        }
        buffer.append(" ]");
        return buffer.toString();
    }

    @Override
    public int compareTo(TechUser arg0) {
        return this.toString().compareTo(arg0.toString());
    }

    public String getEmail() {
        return this.emailAddress;
    }

    public void setEmail(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public String getFullEmailAddress() {
        if (this.emailAddress != null) {
            if (this.emailAddress.indexOf(60) == -1) {
                return "\"" + this.displayName + "\" <" + this.getEmail() + ">";
            }
            return this.emailAddress;
        }
        return "\"" + ServerConfig.get().smtpFromName + "\" <" + ServerConfig.get().smtpFromEmail + ">";
    }

    public void addGroup(TechGroup group) {
        if (this.groups == null) {
            this.groups = new TechGroup[0];
        }
        if (!this.isInGroup(group)) {
            TechGroup[] newGroups = new TechGroup[this.groups.length + 1];
            System.arraycopy(this.groups, 0, newGroups, 0, this.groups.length);
            newGroups[this.groups.length] = group;
            this.groups = newGroups;
        }
    }

    public void removeGroup(TechGroup group) {
        if (this.groups == null) {
            return;
        }
        if (this.isInGroup(group)) {
            this.removeGroupToAdminister(group);
            TechGroup[] newGroups = new TechGroup[this.groups.length - 1];
            int count = 0;
            for (TechGroup group1 : this.groups) {
                if (group.equals(group1)) continue;
                newGroups[count++] = group1;
            }
            this.groups = newGroups;
        }
    }

    public boolean isInGroup(MergedTechGroup mergedGroup) {
        if (this.groups == null) {
            return false;
        }
        for (TechGroup group : this.groups) {
            if (!mergedGroup.containsGroupByIntID(group.getGroupID())) continue;
            return true;
        }
        return false;
    }

    public boolean isInGroup(int techGroupID) {
        if (this.groups == null) {
            return false;
        }
        for (TechGroup group : this.groups) {
            if (group.getGroupID() != techGroupID) continue;
            return true;
        }
        return false;
    }

    public boolean isInGroup(TechGroup group) {
        return this.isInGroup(group.getGroupID());
    }

    public boolean authenticate(TechCredentials credentials, LoginType type, ChallengeHandler challengeHandler) {
        TechGroup[] techgroups;
        if (!this.accountEnabled) {
            return false;
        }
        if (!credentials.getUsername().equals(this.getLogin())) {
            return false;
        }
        Debugger.info("[Authentication] Technician '" + credentials + "' found.");
        if (this.allowLocallyAuthenticatedLogins()) {
            if (this.getPassword() != null && this.getPassword().matches(credentials.getPassword())) {
                type.loginType = 1;
                return true;
            }
            Debugger.info("[Authentication] Password mismatch - checking group level authentication.");
        } else {
            System.out.println("[Authentication] Tech user " + credentials + " is not allowed to log in with SimpleHelp credentials - checking group level authentication.");
        }
        for (TechGroup techgroup : techgroups = this.getGroups()) {
            if (!techgroup.authenticate(credentials, type, challengeHandler)) continue;
            return true;
        }
        return false;
    }

    public boolean canTechUserSeeCustomerFromAnyGroup(Customer customer) {
        MergedTechGroup group = this.getMergedTechGroupInstance();
        return this.canLoggedInTechUserSeeCustomer(customer, group);
    }

    public boolean canLoggedInTechUserSeeCustomer(Customer customer, MergedTechGroup loggedInContext) {
        if (customer.hasOneTimeTechFilters() && !customer.includesTechnicianInFilter(this, loggedInContext)) {
            return false;
        }
        return TechUser.canLoggedInTechUserSee(customer, this.customerFilters, loggedInContext);
    }

    private static boolean canLoggedInTechUserSee(AbstractMachine customerOrMachine, Filter[] techFilters, MergedTechGroup group) {
        boolean areAllHide = true;
        int filterCount = 0;
        int groupCountThatAreAllHide = 0;
        int groupCountWithNoFilters = 0;
        int groupCount = 0;
        if (techFilters != null) {
            filterCount = techFilters.length;
            for (Filter filter : techFilters) {
                if (filter.include(customerOrMachine)) {
                    return filter.isShow();
                }
                if (!filter.isShow()) continue;
                areAllHide = false;
            }
        }
        if (group != null) {
            for (TechGroup childGroup : group) {
                Filter[] groupFilters;
                ++groupCount;
                boolean isFilteredByAllowedGroups = false;
                if (customerOrMachine instanceof Customer) {
                    groupFilters = childGroup.getCustomerFilters();
                } else {
                    Machine machine = (Machine)customerOrMachine;
                    groupFilters = childGroup.getMachineFilters();
                    isFilteredByAllowedGroups = childGroup.getFilterByAllowedGroups();
                    if (isFilteredByAllowedGroups) {
                        ArrayList<ArrayList<String>> allowed = childGroup.getRemoteAccessGroupRestrictions();
                        String[] groupArray = machine.getMachineName().getGroup();
                        if (groupArray == null) continue;
                        for (ArrayList<String> check : allowed) {
                            if (check.size() != groupArray.length) continue;
                            boolean matched = true;
                            for (int i = 0; i < check.size(); ++i) {
                                if (check.get(i).equals(groupArray[i])) continue;
                                matched = false;
                                break;
                            }
                            if (!matched) continue;
                            return true;
                        }
                        continue;
                    }
                }
                if (groupFilters != null) {
                    boolean groupAreAllHide = true;
                    for (Filter filter : groupFilters) {
                        if (filter.include(customerOrMachine)) {
                            return filter.isShow();
                        }
                        if (!filter.isShow()) continue;
                        groupAreAllHide = false;
                    }
                    if (groupAreAllHide) {
                        ++groupCountThatAreAllHide;
                    }
                }
                if (groupFilters != null && groupFilters.length != 0) continue;
                ++groupCountWithNoFilters;
            }
        }
        if (filterCount == 0 && (groupCount == 0 || groupCountWithNoFilters > 0)) {
            return true;
        }
        boolean canSee = areAllHide;
        boolean groupCanSee = groupCountThatAreAllHide > 0;
        return canSee && groupCanSee;
    }

    public boolean canLoggedInTechUserSeeMachine(Machine machine, MergedTechGroup loggedInContext) {
        return TechUser.canLoggedInTechUserSee(machine, this.machineFilters, loggedInContext);
    }

    public boolean canInstallSGServices() {
        if (!this.canUseSH()) {
            return false;
        }
        boolean canDo = true;
        if (this.groups != null && this.groups.length > 0) {
            canDo = false;
            for (int i = 0; i < this.groups.length; ++i) {
                TechGroup group = this.groups[i];
                if (!group.getPermissions().canInstallPersistentConnection()) continue;
                return true;
            }
        }
        return canDo;
    }

    public String getGroupsAsString() {
        if (this.groups == null || this.groups.length == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < this.groups.length; ++i) {
            TechGroup group = this.groups[i];
            if (i > 0) {
                buffer.append(",");
            }
            buffer.append(group.getName());
        }
        return buffer.toString();
    }

    public TransientTechUser getTransientProperties(MergedTechGroup loggedInGroup, LoginType loginType) {
        TransientTechUser user = new TransientTechUser();
        user.username = this.getLogin();
        user.uniqueID = this.uniqueID;
        if (loggedInGroup != null) {
            user.loggedInGroupIDs = loggedInGroup.getGroupIDs();
            user.loggedInGroupNames = loggedInGroup.getGroupNames();
            user.permissions = loggedInGroup.getPermissions();
            user.defaultSGMachineName = loggedInGroup.getDefaultSGServiceName();
            user.maxFileTransferSize = loggedInGroup.getMaxFileTransferSize();
            if (loggedInGroup.isSessionLimited()) {
                user.sessionSpeedLimitKbps = loggedInGroup.getSessionLimitKbps();
            }
            if (loggedInGroup.isFPSLimited()) {
                user.fpsDelay = loggedInGroup.getFPSDelay();
            }
            user.requestConnectionTimeout = loggedInGroup.getRequestAccessTimeout();
        }
        if (this.getEmail() != null) {
            user.emailAddress = this.getEmail();
        }
        if (this.getGroupsAsString() != null) {
            user.groupList = this.getGroupsAsString();
        }
        if (this.getDefaultName() != null) {
            user.displayName = this.getDefaultName();
        }
        user.isAnonymousLogin = this.isAnonymous;
        user.loginType = loginType.loginType;
        user.canAdministerGroup = this.groupsUserCanAdmin.length > 0;
        for (TechGroup group : this.groups) {
            if (!group.getPermissions().canAdminServer()) continue;
            user.canAdministerServer = true;
            break;
        }
        return user;
    }

    public String getLogString(int indent) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            buffer.append("\t");
        }
        buffer.append(this.login).append(" (").append(this.displayName).append(")(").append(this.getGroupsAsString()).append(")").append("\n");
        return buffer.toString();
    }

    public void setAvatar(byte[] imageBytes) throws IOException {
        File avatarDirectory = new File("configuration/technicians/" + this.login);
        avatarDirectory.mkdirs();
        File avatar = new File(avatarDirectory, "avatar");
        if (imageBytes == null) {
            avatar.delete();
        } else {
            FileOutputStream fout = new FileOutputStream(avatar);
            fout.write(imageBytes);
            fout.close();
        }
        this.avatarImageBytes = imageBytes;
    }

    public byte[] getAvatar() throws IOException {
        if (this.avatarImageBytes != null) {
            return this.avatarImageBytes;
        }
        File avatarDirectory = new File("configuration/technicians/" + this.login);
        if (!avatarDirectory.exists()) {
            return null;
        }
        File avatar = new File(avatarDirectory, "avatar");
        if (!avatar.exists()) {
            return null;
        }
        this.avatarImageBytes = StreamUtils.readAll(new FileInputStream(avatar));
        return this.avatarImageBytes;
    }

    public void cleanupUsedResources() {
        File techDirectory = new File("configuration/technicians/" + this.login);
        FileUtils.deleteDirectoryAndContents(techDirectory);
    }

    public void setAllowLocallyAuthenicatedLogins(boolean allowLocalLogins) {
        this.allowLocallyAuthenticatedLogins = allowLocalLogins;
    }

    public void setAccountEnabled(boolean enabled) {
        this.accountEnabled = enabled;
    }

    public boolean isAccountEnabled() {
        return this.accountEnabled;
    }

    public void setCustomerFilters(CustomerFilter[] customerFilters) {
        this.customerFilters = customerFilters;
    }

    public void setMachineFilters(MachineFilter[] machineFilters) {
        this.machineFilters = machineFilters;
    }

    public void appendToXML(StringBuffer buffer, int indent) {
        XML14Util.appendTextNode(buffer, indent, "techUser", this.toString());
    }

    public boolean canUseSharedToolbox(ToolBoxGroup sharedToolBox) {
        if (sharedToolBox == null) {
            return false;
        }
        if (CentralDebugging.PX_TOOLBOX) {
            System.out.println("[TechUser] canUseSharedToolbox(" + sharedToolBox + ") - sharedOwnerID:" + sharedToolBox.getSharedOwnerID() + " userID:" + this.getUserID() + " sharingMode:" + sharedToolBox.getSharingMode());
        }
        if (sharedToolBox.getSharedOwnerID() == this.getUserID()) {
            return false;
        }
        if (sharedToolBox.getSharingMode() == 0) {
            return false;
        }
        if (sharedToolBox.getSharingMode() == 2) {
            return true;
        }
        if (sharedToolBox.getSharingMode() == 1) {
            TechUser toolBoxOwner = ServerConfig.get().getTechnicianByID(sharedToolBox.getSharedOwnerID());
            for (TechGroup group : this.groups) {
                if (!toolBoxOwner.isInGroup(group)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public LazyPassword getTOTPKey() {
        return this.secretKey;
    }

    public void setTOTPKey(LazyPassword key) {
        this.secretKey = key;
    }

    public boolean inGroupWithTOTPAuthentication() {
        for (TechGroup group : this.groups) {
            if (!group.isMultiTierApp()) continue;
            return true;
        }
        return false;
    }

    public MergedTechGroup getMergedTechGroupInstance() {
        if (this.groups == null || this.groups.length == 0) {
            return new MergedTechGroup(new TechGroup[0]);
        }
        return new MergedTechGroup(this.groups);
    }

    public boolean isGroupAdminFor(TechGroup group) {
        if (this.groupsUserCanAdmin == null) {
            return false;
        }
        for (TechGroup admin : this.groupsUserCanAdmin) {
            if (admin.getGroupID() != group.getGroupID()) continue;
            return true;
        }
        return false;
    }

    public boolean canAdministerServer() {
        if (this.isServerAdmin()) {
            return true;
        }
        for (TechGroup group : this.groups) {
            if (!group.getPermissions().canAdminServer()) continue;
            return true;
        }
        return false;
    }

    public boolean canAdministerGroup(TechGroup groupToCheck) {
        for (TechGroup group : this.groupsUserCanAdmin) {
            if (!group.equals(groupToCheck)) continue;
            return true;
        }
        return false;
    }

    public void addGroupToAdminister(TechGroup group) {
        if (this.groupsUserCanAdmin == null) {
            this.groupsUserCanAdmin = new TechGroup[0];
        }
        if (!this.canAdministerGroup(group)) {
            TechGroup[] newGroups = new TechGroup[this.groupsUserCanAdmin.length + 1];
            System.arraycopy(this.groupsUserCanAdmin, 0, newGroups, 0, this.groupsUserCanAdmin.length);
            newGroups[this.groupsUserCanAdmin.length] = group;
            this.groupsUserCanAdmin = newGroups;
        }
    }

    public void removeGroupToAdminister(TechGroup group) {
        if (this.groupsUserCanAdmin == null) {
            return;
        }
        if (this.canAdministerGroup(group)) {
            TechGroup[] newGroups = new TechGroup[this.groupsUserCanAdmin.length - 1];
            int count = 0;
            for (TechGroup group1 : this.groupsUserCanAdmin) {
                if (group.equals(group1)) continue;
                newGroups[count++] = group1;
            }
            this.groupsUserCanAdmin = newGroups;
        }
    }
}

