/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.config;

import bcutil.BCUtil;
import com.aem.CentralDebugging;
import com.aem.ServerManagement;
import com.aem.nodelink.utils.SslToTcp;
import com.aem.profiles.model.AppProfile;
import com.aem.shelp.common.Language;
import com.aem.shelp.common.properties.ServerProperties;
import com.aem.shelp.common.toolbox.ToolBox;
import com.aem.shelp.common.toolbox.ToolBoxGroup;
import com.aem.shelp.common.toolbox.ToolBoxGroupRef;
import com.aem.shelp.licence.OemBranding;
import com.aem.shelp.proxy.DefaultConfiguration;
import com.aem.shelp.proxy.MasterLog;
import com.aem.shelp.proxy.TechGroupPermissions;
import com.aem.shelp.proxy.Templates;
import com.aem.shelp.proxy.ToolBoxRegistry;
import com.aem.shelp.proxy.alerts.AlertRegistryAPI;
import com.aem.shelp.proxy.authentication.TOTPConfig;
import com.aem.shelp.proxy.common.ProxyServerAPI;
import com.aem.shelp.proxy.common.TechPrefsFileUtil;
import com.aem.shelp.proxy.config.LazyPassword;
import com.aem.shelp.proxy.config.MergedTechGroup;
import com.aem.shelp.proxy.config.TechGroup;
import com.aem.shelp.proxy.config.TechUser;
import com.aem.shelp.proxy.logging.EmailTemplateLoader;
import com.aem.shelp.proxy.logging.SimpleHelpEventRepository;
import com.aem.shelp.proxy.logging.SimpleHelpLogEvent;
import com.aem.shelp.proxy.logging.access.TechJoinAccessSessionEvent;
import com.aem.shelp.proxy.logging.access.TechLeaveAccessSessionEvent;
import com.aem.shelp.proxy.logging.server.TechLoginEvent;
import com.aem.shelp.proxy.logging.server.TechLogoutEvent;
import com.aem.shelp.proxy.logging.support.TechJoinSupportSessionEvent;
import com.aem.shelp.proxy.logging.support.TechLeaveSupportSessionEvent;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.proxy.types.MachineName;
import com.aem.shelp.proxy.types.ServerEvent;
import com.aem.shelp.proxy.types.filters.CustomerFilter;
import com.aem.shelp.proxy.types.filters.MachineFilter;
import com.aem.shelp.tech.admin.multiserver.MultiServerPanel;
import com.aem.shelp.util.PatternWrapper;
import com.aem.utils.Debugger;
import com.aem.utils.FileCopyUtil;
import com.aem.utils.StreamUtils;
import com.aem.utils.authentication.LDAPProperties;
import com.aem.utils.blowfish.Blowfish;
import com.sun.istack.internal.NotNull;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import utils.email.CommonEmailer;
import utils.email.HtmlEmailer;
import utils.files.AtomicFileOutputStream;
import utils.files.FileUtil;
import utils.loggingframework.events.LogEvent;
import utils.loggingframework.logmapping.LogMapping;
import utils.loggingframework.logmapping.LogMappingImpl;
import utils.loggingframework.targets.AbstractTarget;
import utils.loggingframework.targets.email.EmailTarget;
import utils.loggingframework.targets.email.EventEmailTemplate;
import utils.loggingframework.targets.file.FileTarget;
import utils.message.Message;
import utils.message.TypedMap;
import utils.progtools.time.TimeSet;
import utils.string.HexData;
import utils.string.SimpleRegex;
import utils.swing.cui.types.CUIField;
import utils.swing.cui.types.CUIFieldRepository;
import utils.swing.cui.types.fields.TextField;
import utils.switches.Switches;
import utils.xml.XML14Util;

public class ServerConfig {
    public static boolean TEST_LOAD = false;
    public static String LEGACY_FILENAME = "serverconfig.xml";
    public static final String DEFAULT_FILENAME = "configuration/serverconfig.xml";
    private final Object SAVE_LOCK = new Object();
    private long loadTime = 0L;
    private static ServerConfig CURRENT_INSTANCE = new ServerConfig();
    public boolean enabledRemoteSupport = true;
    public boolean enabledRemoteAccess = true;
    public boolean enabledPresentation = true;
    public boolean enabledMobileAccess = true;
    public boolean enabledServiceRecovery = true;
    private String comment = null;
    private boolean logInfo = false;
    public boolean statusPage = false;
    public boolean statusPageIncludeMachines = false;
    public boolean statusPageIncludeSessions = false;
    public boolean statusPageIncludePerformance = false;
    public PatternWrapper[] statusPageRestrictions = new PatternWrapper[0];
    public boolean emailSettingsEnabled = false;
    public boolean smtpTLS;
    public boolean smtpSSL;
    public String smtpHost;
    public int smtpPort;
    public String smtpUser;
    public LazyPassword smtpPassword = new LazyPassword(null);
    public String smtpFromEmail;
    public String smtpFromName;
    public boolean smtpAuthentication = false;
    private String dateFormat = null;
    public Properties emailProperties = null;
    public boolean remoteMachinesTechPresence;
    public boolean remoteCustomersTechPresence;
    public boolean ldapEnable;
    public boolean ldapEnableSSL;
    public String ldapHostname;
    public int ldapPort;
    public String ldapUsername;
    @NotNull
    public LazyPassword ldapPassword = new LazyPassword(null);
    public String ldapAuthentication;
    public boolean ldapFollowLinks = true;
    public boolean ldapIsAD;
    public String ldapUserClass;
    private String ldapGroupClass;
    private String ldapLoginAttribute;
    private String ldapMemberAttribute;
    private int totpLength = 6;
    private int totpWindowSize = 10;
    private HashMap<String, LazyPassword> deprecated_anonymousUserIDToTOTPKey = new HashMap();
    public boolean sessionSummaryTechComment;
    public boolean sessionSummaryAllowSkip;
    public boolean sessionSummaryCustEmail;
    public String sessionSummaryEmailCustDetail;
    public TechUser[] technicians = new TechUser[0];
    public TechUser[] anonymousTechnicians = new TechUser[0];
    public TechGroup[] groups = new TechGroup[0];
    private boolean simplehelp;
    private boolean simplegateway;
    private boolean simplesuite;
    public PatternWrapper[] techRestrictions;
    public int[] portList;
    public String[] ipList;
    public String[] ipPortPairsList;
    @NotNull
    public LazyPassword serverPassword = new LazyPassword(null);
    public String disclaimer;
    private final Object detailFieldsLock = new Object();
    private CUIField[] detailFields;
    private String detailFieldsXML;
    public boolean enabledQueuePassword;
    public String queuePassword;
    public long appearWaitMS;
    public long connectWaitMS;
    public boolean stopButDontRemoveServices = false;
    @NotNull
    public LazyPassword keystoreStorePassword = new LazyPassword(null);
    @NotNull
    public LazyPassword keystoreKeyPassword = new LazyPassword(null);
    public String keystoreType = "SelfSigned";
    public static final String KEYSTORE_SELF_SIGNED = "SelfSigned";
    public static final String KEYSTORE_LETS_ENCRYPT = "LetsEncrypt";
    public static final String KEYSTORE_UPLOADED = "Uploaded";
    public static final boolean deprecated_forceSslForSessions = false;
    private boolean uPnPPortForwardingEnabled = true;
    public int defaultMachineTimeoutMS = 30000;
    public int secureMessengerRouteMapSize = 10000;
    public String hostname = null;
    public boolean forwardToHTTPS = false;
    public String failoverCheckURL = null;
    public String condenserForURL = null;
    public List<BlockedRemoteMachine> blockedRemoteAccessMachines = null;
    public List<HTTPHeader> httpHeaders = null;
    public List<String> blockedURLs = null;
    public List<Pattern> blockedURLPatterns = null;
    public boolean autoForgetEnabled;
    public long autoForgetTimeoutMS = 600000L;
    public boolean archiveLogs = true;
    public boolean compressLogs = true;
    public long maxLogsFileSize = 0x40000000L;
    private boolean deprecated_logTechToFile = false;
    private boolean deprecated_logFilePerTech = false;
    private boolean deprecated_logTechEmail = false;
    private String deprecated_logTechEmailAddress = null;
    private boolean deprecated_logTechLogins = false;
    private boolean deprecated_logTechLogouts = false;
    private boolean deprecated_logTechJoins = false;
    private boolean deprecated_logTechLeaves = false;
    private boolean deprecated_logTechRemoteJoins = false;
    private boolean deprecated_logTechRemoteLeaves = false;
    private boolean deprecated_logCustToFile = false;
    private boolean deprecated_logFilePerCust = false;
    private boolean deprecated_logCustEmail = false;
    private String deprecated_logCustEmailAddress = null;
    private boolean deprecated_logCustJoinQueue = false;
    private boolean deprecated_logCustLeaveQueue = false;
    private boolean deprecated_logCustJoins = false;
    private boolean deprecated_logCustLeaves = false;
    private LogMapping[] deprecated_logMappings = null;
    public final TechUser serverAdmin = new TechUser(0, OemBranding.OEM_ADMIN_USERNAME, OemBranding.OEM_ADMIN_USERNAME, null, null, false, true, true);
    public final TechGroup serverAdminGroup = new TechGroup(2000001, OemBranding.OEM_ADMIN_USERNAME + "Group");
    public boolean redirectDefaultToWelcomePage = true;
    private String serverLanguage = null;
    public String endOfSessionOption = null;
    public String endOfSessionURL = null;
    public boolean endOfSessionURLAccess = true;
    public boolean endOfSessionURLSupport = true;
    public boolean elevateSupportSessions = true;
    public int defaultMaxAudioBitrate = 0;
    public boolean radiusEnable = false;
    public RadiusConfig[] radiusConfigs = null;
    public int radiusAttempts = 3;
    public long radiusTimeout = 10000L;
    public int radiusStrategy = 1;
    public int radiusStaggeredTimeout = 2000;
    public boolean feature_showPerformanceMetricsTechConsole = false;
    private static TimeSet times = new TimeSet();
    private static final Random random = new Random();

    public static ServerConfig get() {
        return CURRENT_INSTANCE;
    }

    public static void set(ServerConfig newVersion) {
        CURRENT_INSTANCE = newVersion;
    }

    public ServerConfig() {
        this.serverAdmin.setGroups(new TechGroup[]{this.serverAdminGroup});
    }

    private static boolean getElementContentsAsBoolean(Element parentElement, String childTagName, boolean defaultValue) {
        Element endOfSessionElement = XML14Util.getChildByName(parentElement, childTagName);
        if (endOfSessionElement != null) {
            String value = XML14Util.getTextContent(endOfSessionElement);
            return (value = value.toLowerCase().trim()).equals("yes") || value.equals("on") || value.equals("true");
        }
        return defaultValue;
    }

    private static int getElementContentsAsInteger(Element parentElement, String childTagName, int defaultValue) {
        Element endOfSessionElement = XML14Util.getChildByName(parentElement, childTagName);
        if (endOfSessionElement != null) {
            String value = XML14Util.getTextContent(endOfSessionElement);
            try {
                return Integer.parseInt(value.trim());
            }
            catch (NumberFormatException ex) {
                ex.printStackTrace();
                return defaultValue;
            }
        }
        return defaultValue;
    }

    private static long getElementContentsAsLong(Element parentElement, String childTagName, long defaultValue) {
        Element endOfSessionElement = XML14Util.getChildByName(parentElement, childTagName);
        if (endOfSessionElement != null) {
            String value = XML14Util.getTextContent(endOfSessionElement);
            try {
                return Long.parseLong(value.trim());
            }
            catch (NumberFormatException ex) {
                ex.printStackTrace();
                return defaultValue;
            }
        }
        return defaultValue;
    }

    private static String getElementContentsAsString(Element parentElement, String childTagName) {
        Element endOfSessionElement = XML14Util.getChildByName(parentElement, childTagName);
        if (endOfSessionElement != null) {
            return XML14Util.getTextContent(endOfSessionElement);
        }
        return null;
    }

    public static void main(String[] args) throws DOMException, IOException, ParserConfigurationException, SAXException, ServerStartFailureException {
        ServerConfig c = new ServerConfig();
        c.loadConfig(FileUtil.readFileAsStringUTF8("SimpleHelp/configuration/serverconfig.xml"));
        times.dumpMetrics();
    }

    static String decryptPass_legacy(String pword) {
        if (pword == null) {
            return null;
        }
        Blowfish bfish = new Blowfish();
        bfish.init("ADSijlsd709)&*))(*()(*)7ds8a9jkdlasjoa897*())(&*((((((((ujdjksakldnadj, nn   Jhjodsay8ads;''");
        byte[] dat = HexData.hexStringToByteArray(pword);
        dat = bfish.decryptSecure(dat, 0, false);
        try {
            return new String(dat, "UnicodeBig");
        }
        catch (Exception x) {
            return new String(dat);
        }
    }

    private static String getEncryptedPasswordOrNull(LazyPassword lazyPassword) {
        if (lazyPassword == null) {
            return null;
        }
        return lazyPassword.getEncryptedPassword();
    }

    public static String getDecryptedPasswordOrNull(LazyPassword lazyPassword) {
        if (lazyPassword == null) {
            return null;
        }
        return lazyPassword.getDecryptedPassword();
    }

    static String decryptPassv2(String pword) throws IOException {
        if (pword == null) {
            return null;
        }
        return BCUtil.decryptPassword(pword, "!jfjaASJj32jjls00a0alaj1@JaAasjkjkdkVMNa..,kjsdn2lja02jlj2744'';'/Jhjodsay8ads;''");
    }

    static String encryptPassv2(String pword) {
        if (pword == null) {
            return null;
        }
        try {
            return BCUtil.encryptedPassword(pword, "!jfjaASJj32jjls00a0alaj1@JaAasjkjkdkVMNa..,kjsdn2lja02jlj2744'';'/Jhjodsay8ads;''");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static LazyPassword getPlaintextOrEncryptedPassword(Element root, String plainTagName) {
        return ServerConfig.getPassword(root, plainTagName, "Secure" + plainTagName, "Secure" + plainTagName + "v2");
    }

    private static LazyPassword getPassword(Element root, String plainTagName, String legacyTagName, String encryptedTagName) {
        try {
            String password;
            if (plainTagName != null && (password = XML14Util.getChildText(root, plainTagName, null)) != null) {
                return new LazyPassword(password);
            }
            if (legacyTagName != null && (password = XML14Util.getChildText(root, legacyTagName, null)) != null) {
                return new LazyPassword(password, true);
            }
            if (encryptedTagName != null && (password = XML14Util.getChildText(root, encryptedTagName, null)) != null) {
                return new LazyPassword(password, false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new LazyPassword(null);
    }

    private String getComment(String source, String startTagName) {
        int startIndex = source.indexOf(startTagName);
        if (startIndex == -1) {
            return null;
        }
        return source.substring(0, startIndex).trim();
    }

    public void loadConfig(File file) throws IOException, ParserConfigurationException, SAXException, DOMException, ServerStartFailureException {
        BufferedInputStream fin = new BufferedInputStream(new FileInputStream(file));
        String allData = new String(StreamUtils.readAll(fin), "UTF8");
        ((InputStream)fin).close();
        this.loadConfig(allData);
        this.disclaimer = ServerConfig.loadDisclaimer();
        try {
            File serverDirectory = new File("DEPLOY");
            if (!serverDirectory.exists()) {
                serverDirectory = new File("lib");
            }
            if (this.serverLanguage != null) {
                Language.loadTranslationsFrom(serverDirectory, this.serverLanguage);
            } else {
                Language.loadTranslationsFrom(serverDirectory, "en");
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void setServerLanguage(String language) {
        this.serverLanguage = language;
    }

    public String getServerLanguage() {
        if (this.serverLanguage == null) {
            return "en";
        }
        return this.serverLanguage;
    }

    private EventEmailTemplate getDefaultEmailTemplate(SimpleHelpLogEvent event) {
        File emailFile = event.getEmailTemplateFile();
        EventEmailTemplate template = new EventEmailTemplate(event);
        if (emailFile != null && emailFile.exists()) {
            String[] result = EmailTemplateLoader.processTemplateFile(emailFile);
            template.setContent(result[0], result[1]);
        }
        return template;
    }

    public void migrateSettings(AlertRegistryAPI alertRegistry) throws IOException {
        Class<? extends LogEvent> c;
        ArrayList<EventEmailTemplate> templates;
        AbstractTarget target;
        Comparable[] eventIDs;
        ArrayList<LogMappingImpl> newLogMappings = new ArrayList<LogMappingImpl>();
        boolean migratedSettings = false;
        if (this.deprecated_logTechToFile || this.deprecated_logFilePerTech || this.deprecated_logTechEmail && this.deprecated_logTechEmailAddress != null && this.deprecated_logTechEmailAddress.length() > 0) {
            migratedSettings = true;
            eventIDs = new ArrayList();
            if (this.deprecated_logTechLogins) {
                eventIDs.add(SimpleHelpEventRepository.INSTANCE.getEventIDForClass(TechLoginEvent.class));
            }
            if (this.deprecated_logTechLogouts) {
                eventIDs.add(SimpleHelpEventRepository.INSTANCE.getEventIDForClass(TechLogoutEvent.class));
            }
            if (this.deprecated_logTechJoins) {
                eventIDs.add(SimpleHelpEventRepository.INSTANCE.getEventIDForClass(TechJoinSupportSessionEvent.class));
            }
            if (this.deprecated_logTechLeaves) {
                eventIDs.add(SimpleHelpEventRepository.INSTANCE.getEventIDForClass(TechLeaveSupportSessionEvent.class));
            }
            if (this.deprecated_logTechRemoteJoins) {
                eventIDs.add(SimpleHelpEventRepository.INSTANCE.getEventIDForClass(TechJoinAccessSessionEvent.class));
            }
            if (this.deprecated_logTechRemoteLeaves) {
                eventIDs.add(SimpleHelpEventRepository.INSTANCE.getEventIDForClass(TechLeaveAccessSessionEvent.class));
            }
            if (this.deprecated_logTechToFile) {
                target = new FileTarget();
                target.logFileName = "TechnicianActivity.log";
                target.logFileLocation = "./";
                target.timestamp = true;
                newLogMappings.add(new LogMappingImpl("Technician Activity Log", eventIDs.toArray(new String[0]), target));
            }
            if (this.deprecated_logTechEmail && this.deprecated_logTechEmailAddress != null && this.deprecated_logTechEmailAddress.length() > 0) {
                target = new EmailTarget();
                ((EmailTarget)target).toEmailAddresses = new String[]{this.deprecated_logTechEmailAddress};
                try {
                    templates = new ArrayList<EventEmailTemplate>();
                    for (String string : eventIDs) {
                        c = SimpleHelpEventRepository.INSTANCE.getEventClass(string);
                        templates.add(this.getDefaultEmailTemplate((SimpleHelpLogEvent)c.newInstance()));
                    }
                    ((EmailTarget)target).storedEmailTemplates = new EventEmailTemplate[templates.size()];
                    templates.toArray(((EmailTarget)target).storedEmailTemplates);
                }
                catch (Throwable t) {
                    System.out.println("[ServerConfig] Unable to succesfully migrate email logging. Please verify new settings in the Logging tab of the Administration console.");
                    t.printStackTrace();
                }
                newLogMappings.add(new LogMappingImpl("Technician Activity Email", eventIDs.toArray(new String[0]), target));
            }
        }
        if (this.deprecated_logCustToFile || this.deprecated_logFilePerCust || this.deprecated_logCustEmail && this.deprecated_logCustEmailAddress != null && this.deprecated_logCustEmailAddress.length() > 0) {
            migratedSettings = true;
            eventIDs = new ArrayList();
            if (this.deprecated_logCustJoinQueue) {
                eventIDs.add(SimpleHelpEventRepository.INSTANCE.getEventIDForClass(TechLoginEvent.class));
            }
            if (this.deprecated_logCustLeaveQueue) {
                eventIDs.add(SimpleHelpEventRepository.INSTANCE.getEventIDForClass(TechLogoutEvent.class));
            }
            if (this.deprecated_logCustJoins) {
                eventIDs.add(SimpleHelpEventRepository.INSTANCE.getEventIDForClass(TechJoinSupportSessionEvent.class));
            }
            if (this.deprecated_logCustLeaves) {
                eventIDs.add(SimpleHelpEventRepository.INSTANCE.getEventIDForClass(TechLeaveSupportSessionEvent.class));
            }
            if (this.deprecated_logCustToFile) {
                target = new FileTarget();
                target.logFileName = "CustomerActivity.log";
                target.logFileLocation = "./";
                target.timestamp = true;
                newLogMappings.add(new LogMappingImpl("Customer Activity Log", eventIDs.toArray(new String[0]), target));
            }
            if (this.deprecated_logCustEmail && this.deprecated_logCustEmailAddress != null && this.deprecated_logCustEmailAddress.length() > 0) {
                target = new EmailTarget();
                ((EmailTarget)target).toEmailAddresses = new String[]{this.deprecated_logCustEmailAddress};
                try {
                    templates = new ArrayList();
                    for (String string : eventIDs) {
                        c = SimpleHelpEventRepository.INSTANCE.getEventClass(string);
                        templates.add(this.getDefaultEmailTemplate((SimpleHelpLogEvent)c.newInstance()));
                    }
                    ((EmailTarget)target).storedEmailTemplates = new EventEmailTemplate[templates.size()];
                    templates.toArray(((EmailTarget)target).storedEmailTemplates);
                }
                catch (Throwable t) {
                    System.out.println("[ServerConfig] Unable to succesfully migrate email logging. Please verify new settings in the Logging tab of the Administration console.");
                    t.printStackTrace();
                }
                newLogMappings.add(new LogMappingImpl("Customer Activity Email", eventIDs.toArray(new String[0]), target));
            }
        }
        this.migrateFile("templates/technician/tech_leave_customer", "configuration/templates/support/technician_leave");
        this.migrateFile("templates/technician/tech_joins_customer", "configuration/templates/support/technician_join");
        this.migrateFile("templates/customer/customer_leave_tech", "configuration/templates/support/customer_leave");
        this.migrateFile("templates/customer/customer_join_tech", "configuration/templates/support/customer_join");
        this.migrateFile("templates/customer/customer_logout", "configuration/templates/support/customer_logout");
        this.migrateFile("templates/customer/customer_login", "configuration/templates/support/customer_login");
        this.migrateFile("templates/technician/tech_logout", "configuration/templates/technician/logout");
        this.migrateFile("templates/technician/tech_login", "configuration/templates/technician/login");
        this.migrateFile("templates/technician/tech_join_remote", "configuration/templates/access/technician_join");
        this.migrateFile("templates/technician/tech_leave_remote", "configuration/templates/access/technician_leave");
        this.migrateFile("templates/session/customer", "configuration/templates/support/session_summary");
        this.migrateFile("templates/session/remoteaccess", "configuration/templates/access/session_summary");
        for (TechGroup techGroup : this.groups) {
            if (techGroup.getGroupID() != -1) continue;
            techGroup.setGroupID(this.getTechnicianGroupID());
            migratedSettings = true;
        }
        for (Comparable comparable : this.technicians) {
            if (((TechUser)comparable).uniqueID != -1) continue;
            ((TechUser)comparable).uniqueID = this.getTechnicianID();
            migratedSettings = true;
        }
        for (Comparable comparable : this.anonymousTechnicians) {
            if (((TechUser)comparable).uniqueID != -1) continue;
            ((TechUser)comparable).uniqueID = this.getTechnicianID();
            migratedSettings = true;
        }
        File oldLicense = new File("shlicense.txt");
        File newLicense = new File("configuration/shlicense.txt");
        if (oldLicense.exists() && !newLicense.exists() && !oldLicense.renameTo(newLicense)) {
            FileUtil.copy(oldLicense, newLicense);
        }
        if (this.detailFields == null) {
            migratedSettings = true;
            String oldDetails = ServerConfig.loadDeprecatedDetails();
            if (oldDetails == null) {
                oldDetails = "Name\nCompany";
            }
            System.out.println("[ServerConfig] Detected old style details.txt file. Migrating settings.");
            String[] oldDetailsSplit = oldDetails.split("\\n");
            ArrayList<TextField> newFieldList = new ArrayList<TextField>();
            for (String anOldDetailsSplit : oldDetailsSplit) {
                String oldDetail = anOldDetailsSplit.trim();
                if (oldDetail == null || oldDetail.length() <= 0) continue;
                newFieldList.add(new TextField(oldDetail, null));
            }
            this.detailFields = new CUIField[newFieldList.size()];
            newFieldList.toArray(this.detailFields);
        }
        if (migratedSettings) {
            if (this.deprecated_logMappings == null) {
                this.deprecated_logMappings = new LogMappingImpl[0];
            }
            LogMapping[] newMappingsArray = new LogMapping[newLogMappings.size() + this.deprecated_logMappings.length];
            System.arraycopy(this.deprecated_logMappings, 0, newMappingsArray, 0, this.deprecated_logMappings.length);
            for (int i = 0; i < newLogMappings.size(); ++i) {
                newMappingsArray[i + this.deprecated_logMappings.length] = (LogMappingImpl)newLogMappings.get(i);
            }
            this.deprecated_logMappings = newMappingsArray;
            this.saveToConfig(new File(DEFAULT_FILENAME));
            ServerConfig.deleteDeprecatedDetails();
        }
        try {
            if (this.deprecated_logMappings != null && this.deprecated_logMappings.length > 0) {
                for (LogMapping logMapping : this.deprecated_logMappings) {
                    ServerEvent serverEvent = new ServerEvent();
                    serverEvent.setName(logMapping.getLogMappingDescription());
                    serverEvent.setTarget(logMapping.getTarget());
                    serverEvent.setLogEventIDs(logMapping.getLogEventIDs());
                    serverEvent.setFilters(logMapping.getFilters());
                    serverEvent.setActive(true);
                    alertRegistry.add(serverEvent);
                }
                alertRegistry.scheduleSaveInTenSeconds();
                this.saveToConfig(new File(DEFAULT_FILENAME));
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            this.deprecated_migrateToolBoxes();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public TechUser[] getAllTechUsersIncludingSimpleHelpAdmin() {
        ArrayList<TechUser> users = new ArrayList<TechUser>();
        if (ServerConfig.get().technicians != null) {
            Collections.addAll(users, ServerConfig.get().technicians);
        }
        users.add(this.serverAdmin);
        return users.toArray(new TechUser[0]);
    }

    public TechGroup[] getAllTechGroups() {
        ArrayList techgroups = new ArrayList();
        if (ServerConfig.get().groups != null) {
            Collections.addAll(techgroups, ServerConfig.get().groups);
        }
        return techgroups.toArray(new TechGroup[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deprecated_migrateToolBoxes() throws Exception {
        boolean save = false;
        for (TechUser user : this.getAllTechUsersIncludingSimpleHelpAdmin()) {
            File loadFile = TechPrefsFileUtil.getPrefsFileV2(user, "toolbox");
            if (!loadFile.exists()) continue;
            AtomicFileOutputStream.prepareForReading(loadFile);
            byte[] dat = FileUtil.readFile(loadFile);
            try {
                save = true;
                ToolBox toolBox = ToolBox.loadFromXML(new String(dat, "UTF-8"));
                ToolBoxRegistry.INSTANCE.setToolBoxFor(user, toolBox);
                ToolBoxRegistry.INSTANCE.registerToolBoxResources(toolBox);
                if (!CentralDebugging.PX_TOOLBOX) continue;
                System.out.println("[ProxyServer] Deprecated Loaded toolbox: ");
                System.out.println(toolBox.toXML());
            }
            finally {
                loadFile.delete();
            }
        }
        if (save) {
            ToolBoxRegistry.INSTANCE.saveImmediately();
        }
    }

    public void saveToDefaultFile() throws IOException {
        this.saveToConfig(new File(DEFAULT_FILENAME));
    }

    private void migrateFile(String oldFile, String newFile) {
        File oldFileHandle = new File(oldFile);
        if (!oldFileHandle.exists()) {
            return;
        }
        File newFileHandle = new File(newFile);
        try {
            FileCopyUtil.fastCopyFile(oldFileHandle, newFileHandle);
            oldFileHandle.delete();
        }
        catch (IOException e) {
            Debugger.warning("[ServerConfig] Unable to migrate old configuration file: " + oldFile);
        }
    }

    public static String getHostFromIpAndPort(String ipport) {
        int split = ipport.indexOf(58);
        return ipport.substring(0, split);
    }

    public static int getPortFromIpAndPort(String ipport) {
        int split = ipport.indexOf(58);
        return Integer.parseInt(ipport.substring(split + 1));
    }

    public void recreateIpAndPortLists() {
        if (this.ipPortPairsList != null) {
            int i;
            ArrayList<String> ipsOnly = new ArrayList<String>();
            ArrayList<String> portsOnly = new ArrayList<String>();
            for (i = 0; i < this.ipPortPairsList.length; ++i) {
                try {
                    String port;
                    String ip;
                    int split = this.ipPortPairsList[i].indexOf(58);
                    if (CentralDebugging.PX_VERBOSE_SERVER_CONFIG) {
                        System.out.println("[Server Config] Listening on specific IP:Port combo " + i + ": " + this.ipPortPairsList[i]);
                    }
                    if (!ipsOnly.contains(ip = this.ipPortPairsList[i].substring(0, split))) {
                        ipsOnly.add(ip);
                    }
                    if (portsOnly.contains(port = this.ipPortPairsList[i].substring(split + 1))) continue;
                    portsOnly.add(port);
                    continue;
                }
                catch (Exception e) {
                    Debugger.error("[Server Config] Invalid IpPort bind spec: " + this.ipPortPairsList[i]);
                    return;
                }
            }
            this.ipList = new String[ipsOnly.size()];
            ipsOnly.toArray(this.ipList);
            this.portList = new int[portsOnly.size()];
            for (i = 0; i < this.portList.length; ++i) {
                this.portList[i] = Integer.parseInt((String)portsOnly.get(i));
            }
        } else {
            this.ipList = null;
        }
    }

    public void loadConfig(String xmlData) throws IOException, ParserConfigurationException, SAXException, DOMException, ServerStartFailureException {
        Element messengerRouteMapElement;
        Element node;
        Element child;
        int i;
        Element root;
        block276: {
            Element childchild;
            Element settings;
            ArrayList<Element> email;
            block274: {
                ArrayList<Element> users;
                Object httpHeader;
                Object nextHostname;
                Object child2;
                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document dom = builder.parse(new InputSource(new StringReader(xmlData)));
                root = dom.getDocumentElement();
                this.loadTime = System.currentTimeMillis();
                this.serverAdminGroup.setMultiTierRememberMachine(false);
                this.simplehelp = false;
                this.simplegateway = false;
                this.simplesuite = false;
                if (root.getTagName().trim().equalsIgnoreCase("SimpleHelp")) {
                    this.simplehelp = true;
                }
                if (root.getTagName().trim().equalsIgnoreCase("SimpleGateway")) {
                    this.simplegateway = true;
                }
                if (root.getTagName().trim().equalsIgnoreCase("SimpleSuite")) {
                    this.simplesuite = true;
                }
                if (this.simplehelp) {
                    ServerManagement.SIMPLEGATEWAY = false;
                    ServerManagement.SIMPLEHELP = true;
                } else if (this.simplegateway) {
                    ServerManagement.SIMPLEGATEWAY = true;
                    ServerManagement.SIMPLEHELP = false;
                }
                if (this.simplesuite) {
                    ServerManagement.SIMPLEGATEWAY = true;
                    ServerManagement.SIMPLEHELP = true;
                }
                this.comment = this.simplehelp ? this.getComment(xmlData, "<SimpleHelp>") : (this.simplegateway ? this.getComment(xmlData, "<SimpleGateway>") : this.getComment(xmlData, "<SimpleSuite>"));
                this.enabledRemoteSupport = ServerManagement.SIMPLEHELP;
                this.enabledRemoteAccess = ServerManagement.SIMPLEGATEWAY;
                this.enabledPresentation = ServerManagement.SIMPLEDEMO;
                try {
                    Element child3 = XML14Util.getChildByName(root, "ServerFeatures");
                    if (child3 != null) {
                        Element remoteAccess = XML14Util.getChildByName(child3, "RemoteAccess");
                        Element remoteSupport = XML14Util.getChildByName(child3, "RemoteSupport");
                        Element presentation = XML14Util.getChildByName(child3, "Presentation");
                        Element mobileAccess = XML14Util.getChildByName(child3, "MobileAccess");
                        Element serviceRecovery = XML14Util.getChildByName(child3, "ServiceRecovery");
                        if (remoteAccess != null) {
                            this.enabledRemoteAccess = XML14Util.getTextContent(remoteAccess).equalsIgnoreCase("on");
                        }
                        if (remoteSupport != null) {
                            this.enabledRemoteSupport = XML14Util.getTextContent(remoteSupport).equalsIgnoreCase("on");
                        }
                        if (presentation != null) {
                            this.enabledPresentation = XML14Util.getTextContent(presentation).equalsIgnoreCase("on");
                        }
                        if (mobileAccess != null) {
                            this.enabledMobileAccess = XML14Util.getTextContent(mobileAccess).equalsIgnoreCase("on");
                        }
                        if (serviceRecovery != null) {
                            this.enabledServiceRecovery = XML14Util.getTextContent(serviceRecovery).equalsIgnoreCase("on");
                        }
                    }
                }
                catch (Exception x) {
                    x.printStackTrace();
                    Debugger.error("[Server Config] Unable to process server features.");
                }
                ServerManagement.SIMPLEHELP = this.enabledRemoteSupport;
                ServerManagement.SIMPLEGATEWAY = this.enabledRemoteAccess;
                ServerManagement.SIMPLEDEMO = this.enabledPresentation;
                try {
                    LazyPassword newPassword = ServerConfig.getPlaintextOrEncryptedPassword(root, "Password");
                    if (newPassword == null) {
                        throw new NullPointerException("");
                    }
                    this.serverPassword = newPassword;
                }
                catch (Exception x) {
                    Debugger.error("[Server Config] Invalid <Password> entry: the master <Password> tag is required, even when using LDAP authentication, please also note you should not set this password to blank.");
                }
                try {
                    this.detailFields = null;
                    Element parentElement = XML14Util.getChildByName(root, "DetailsList");
                    if (parentElement != null) {
                        this.detailFields = CUIFieldRepository.loadChildrenOfElement(parentElement, null);
                    }
                }
                catch (Exception x) {
                    x.printStackTrace();
                    Debugger.error("[Server Config] Unable to load customer detail fields configuration.");
                }
                try {
                    child2 = XML14Util.getChildByName(root, "Hostname");
                    if (child2 != null) {
                        nextHostname = XML14Util.getTextContent((Node)child2);
                        if ((this.hostname == null || nextHostname == null || !this.hostname.equals(nextHostname)) && CentralDebugging.PX_VERBOSE_SERVER_CONFIG) {
                            System.out.println("[Server Config] Set hostname of the server to " + this.hostname);
                        }
                        this.hostname = nextHostname;
                    }
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
                try {
                    child2 = XML14Util.getChildren(root, "HTTPHeader");
                    if (child2 != null) {
                        this.httpHeaders = new ArrayList<HTTPHeader>();
                        nextHostname = ((ArrayList)child2).iterator();
                        while (nextHostname.hasNext()) {
                            httpHeader = (Element)nextHostname.next();
                            String name = httpHeader.getAttribute("name");
                            String value = httpHeader.getAttribute("value");
                            this.httpHeaders.add(new HTTPHeader(name, value));
                            if (!CentralDebugging.PX_VERBOSE_SERVER_CONFIG) continue;
                            System.out.println("[Server Config] Loaded custom HTTP header " + name + "=" + value);
                        }
                    }
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
                this.autoForgetEnabled = ServerConfig.getElementContentsAsBoolean(root, "AutoForget", false);
                this.autoForgetTimeoutMS = Long.parseLong(XML14Util.getChildText(root, "AutoForgetTimeoutMS", "600000"));
                Element loggingParent = XML14Util.getChild(root, "Logging");
                if (loggingParent != null) {
                    this.archiveLogs = ServerConfig.getElementContentsAsBoolean(loggingParent, "Archive", true);
                    this.compressLogs = ServerConfig.getElementContentsAsBoolean(loggingParent, "Compress", true);
                    this.maxLogsFileSize = ServerConfig.getElementContentsAsLong(loggingParent, "MaxPartSize", 0x40000000L);
                }
                try {
                    child2 = XML14Util.getChildren(root, "BlockedURL");
                    if (child2 != null) {
                        this.blockedURLs = new ArrayList<String>();
                        this.blockedURLPatterns = new ArrayList<Pattern>();
                        int total = 0;
                        httpHeader = ((ArrayList)child2).iterator();
                        while (httpHeader.hasNext()) {
                            Element blockedURL = (Element)httpHeader.next();
                            String url = XML14Util.getTextContent(blockedURL);
                            try {
                                Pattern p = SimpleRegex.simpleToPattern(url, false);
                                this.blockedURLs.add(url);
                                this.blockedURLPatterns.add(p);
                                ++total;
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                        if (total > 0 && CentralDebugging.PX_VERBOSE_SERVER_CONFIG) {
                            System.out.println("[Server Config] Loaded " + total + " blocked URLs");
                        }
                    } else {
                        this.blockedURLs = null;
                        this.blockedURLPatterns = null;
                    }
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
                try {
                    child2 = XML14Util.getChildByName(root, "MachineAppearTimeoutMS");
                    long appearWaitMS = Long.parseLong(XML14Util.getTextContent((Node)child2));
                    if (appearWaitMS != this.appearWaitMS && CentralDebugging.PX_VERBOSE_SERVER_CONFIG) {
                        System.out.println("[Server Config] Machine appear wait specified " + appearWaitMS + "ms");
                    }
                    this.appearWaitMS = appearWaitMS;
                }
                catch (NumberFormatException x) {
                    Debugger.error("[Server Config] Invalid <MachineAppearTimeoutMS> entry: not a valid number");
                    this.appearWaitMS = 0L;
                }
                catch (Exception x) {
                    this.appearWaitMS = 0L;
                }
                try {
                    child2 = XML14Util.getChildByName(root, "MachineConnectTimeoutMS");
                    long connectWaitMS = Long.parseLong(XML14Util.getTextContent((Node)child2));
                    if (connectWaitMS != this.connectWaitMS && CentralDebugging.PX_VERBOSE_SERVER_CONFIG) {
                        System.out.println("[Server Config] Machine connect wait specified " + connectWaitMS + "ms");
                    }
                    this.connectWaitMS = connectWaitMS;
                }
                catch (NumberFormatException x) {
                    Debugger.error("[Server Config] Invalid <MachineConnectTimeoutMS> entry: not a valid number");
                    this.connectWaitMS = 0L;
                }
                catch (Exception x) {
                    this.connectWaitMS = 0L;
                }
                try {
                    child2 = XML14Util.getChildByName(root, "SslKeystore");
                    if (child2 != null) {
                        this.keystoreStorePassword = ServerConfig.getPlaintextOrEncryptedPassword((Element)child2, "KeystoreStorePassword");
                        this.keystoreKeyPassword = ServerConfig.getPlaintextOrEncryptedPassword((Element)child2, "KeystoreKeyPassword");
                        this.keystoreType = XML14Util.getChildText((Element)child2, "StoreType", null);
                        if (this.keystoreType == null) {
                            this.keystoreType = SslToTcp.KEYSTORE == null || SslToTcp.KEYSTORE.isSelfSigned() ? KEYSTORE_SELF_SIGNED : KEYSTORE_UPLOADED;
                        }
                        if (CentralDebugging.PX_VERBOSE_SERVER_CONFIG) {
                            System.out.println("[Server Config] SSL Keystore specified.");
                        }
                    } else if (CentralDebugging.PX_VERBOSE_SERVER_CONFIG) {
                        System.out.println("[Server Config] No SSL keystore specified");
                    }
                }
                catch (Exception x) {
                    Debugger.error("[Server Config] Invalid <SslKeystore> entry, the child tags <KeystorePath>, <[Secure]KeystoreStorePassword> and <[Secure]KeystoreKeyPassword> must be specified and valid");
                }
                try {
                    String text;
                    child2 = XML14Util.getChildByName(root, "RedirectDefaultUrlToWelcomePage");
                    this.redirectDefaultToWelcomePage = child2 != null ? (text = XML14Util.getTextContent((Node)child2)) == null || !text.equalsIgnoreCase("no") : true;
                }
                catch (Exception x) {
                    this.redirectDefaultToWelcomePage = false;
                }
                try {
                    child2 = XML14Util.getChildByName(root, "ServerLanguage");
                    this.serverLanguage = child2 != null ? XML14Util.getTextContent((Node)child2) : "en";
                }
                catch (Exception x) {
                    this.serverLanguage = "en";
                }
                try {
                    child2 = XML14Util.getChildByName(root, "StopRemoteServicesOnly");
                    if (child2 != null) {
                        this.stopButDontRemoveServices = true;
                        if (CentralDebugging.PX_VERBOSE_SERVER_CONFIG) {
                            System.out.println("[Server Config] Remote services are stopped but not removed.");
                        }
                    } else {
                        this.stopButDontRemoveServices = false;
                    }
                }
                catch (Exception x) {
                    this.stopButDontRemoveServices = false;
                }
                Element appChild = XML14Util.getChildByName(root, "AdminAppAuthentication");
                this.serverAdminGroup.setMultiTierApp(appChild != null);
                if (appChild != null) {
                    LazyPassword adminAppAuthenticationKey = ServerConfig.getPassword(appChild, null, "Key", "Keyv2");
                    this.serverAdmin.setTOTPKey(adminAppAuthenticationKey);
                }
                appChild = XML14Util.getChildByName(root, "AdminAuthenticationRememberMachine");
                this.serverAdminGroup.setMultiTierRememberMachine(this.serverAdminGroup.getMultiTierRememberMachine() || appChild != null);
                Element twoTierChild = XML14Util.getChildByName(root, "AdminTwoTier");
                if (twoTierChild != null) {
                    Element bodyElement;
                    Element emailElement;
                    this.serverAdminGroup.setMultiTierEmail(true);
                    Iterator<Element> codeLengthElement = XML14Util.getChildByName(twoTierChild, "CodeLength");
                    if (codeLengthElement != null) {
                        String codeLength = XML14Util.getTextContent((Node)((Object)codeLengthElement));
                        try {
                            this.serverAdminGroup.setTwoTierCodeLength(Integer.parseInt(codeLength));
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                            this.serverAdminGroup.setMultiTierEmail(false);
                        }
                    }
                    if ((emailElement = XML14Util.getChildByName(twoTierChild, "EmailAddress")) != null) {
                        this.serverAdmin.setEmail(XML14Util.getTextContent(emailElement));
                    }
                    String subject = null;
                    String body = null;
                    Element subjectElement = XML14Util.getChildByName(twoTierChild, "EmailSubject");
                    if (subjectElement != null) {
                        subject = XML14Util.getTextContent(subjectElement);
                    }
                    if ((bodyElement = XML14Util.getChildByName(twoTierChild, "EmailBody")) != null) {
                        body = new String(HexData.hexStringToByteArray(XML14Util.getTextContent(bodyElement)), "UTF-8");
                    }
                    this.serverAdminGroup.setTwoTierEmail(subject, body);
                    Element rememberElement = XML14Util.getChildByName(twoTierChild, "RememberMachine");
                    this.serverAdminGroup.setMultiTierRememberMachine(this.serverAdminGroup.getMultiTierRememberMachine() || rememberElement != null);
                } else {
                    this.serverAdminGroup.setMultiTierEmail(false);
                }
                try {
                    ArrayList<TechGroup> tmplist = new ArrayList<TechGroup>();
                    ArrayList<Element> allGroups = XML14Util.getChildrenByName(root, "TechnicianGroup");
                    for (Element groupElement : allGroups) {
                        Element filter;
                        Element filter2;
                        int k;
                        Element ldapChild;
                        String string;
                        Element appProfileIdElement;
                        String name = XML14Util.getTextContent(XML14Util.getChildByName(groupElement, "Name"));
                        int id = -1;
                        try {
                            id = Integer.parseInt(XML14Util.getTextContent(XML14Util.getChildByName(groupElement, "ID")));
                        }
                        catch (Throwable t) {
                            id = -1;
                        }
                        TechGroup group = new TechGroup(id, name);
                        LazyPassword password = ServerConfig.getPlaintextOrEncryptedPassword(groupElement, "Password");
                        if (password != null) {
                            group.setPassword(true);
                            group.setPassword(password);
                        }
                        if (Switches.SH_appProfiles && (appProfileIdElement = XML14Util.getChildByName(groupElement, "AssociatedAppProfileID")) != null && (string = XML14Util.getTextContent(appProfileIdElement)) != null) {
                            group.setAssociatedAppProfileID(string);
                        }
                        group.setHostname(XML14Util.getChildText(groupElement, "GroupHostname", null));
                        group.setDefaultSGServiceName(XML14Util.getChildText(groupElement, "DefaultSimpleGatewayName", null));
                        group.setDefaultVideoPassword(XML14Util.getChildText(groupElement, "DefaultRecordingPassword", null));
                        group.setRequestAccessTimeout(ServerConfig.getElementContentsAsLong(groupElement, "RequestAccessTimeoutMS", 0L));
                        group.setAllowAnonymousLogins(ServerConfig.getElementContentsAsBoolean(groupElement, "AnonymousLogins", true));
                        group.getPermissions().setCanInstallPersistentConnection(ServerConfig.getElementContentsAsBoolean(groupElement, "InstallServices", true));
                        group.getPermissions().setCanManagePersistentConnections(ServerConfig.getElementContentsAsBoolean(groupElement, "ManageServices", true));
                        group.getPermissions().setCanRemoteSupport(ServerConfig.getElementContentsAsBoolean(groupElement, "RemoteSupport", true));
                        group.getPermissions().setCanRemoteAccess(ServerConfig.getElementContentsAsBoolean(groupElement, "RemoteAccess", true));
                        Element techGroupPermissionsChild = XML14Util.getChildByName(groupElement, "TechGroupPermissions");
                        if (techGroupPermissionsChild != null) {
                            TechGroupPermissions.parseXML(group.getPermissions(), techGroupPermissionsChild);
                        }
                        group.setMaxShGroupConcurrency(ServerConfig.getElementContentsAsInteger(groupElement, "MaxShSessionsGroup", -1));
                        group.setMaxShUserConcurrency(ServerConfig.getElementContentsAsInteger(groupElement, "MaxShSessionsUser", -1));
                        group.setMaxSgGroupConcurrency(ServerConfig.getElementContentsAsInteger(groupElement, "MaxSgSessionsGroup", -1));
                        group.setMaxSgUserConcurrency(ServerConfig.getElementContentsAsInteger(groupElement, "MaxSgSessionsUser", -1));
                        group.setMaxFileTransferSize(ServerConfig.getElementContentsAsLong(groupElement, "MaxFileSize", -1L));
                        group.setFPSDelay(ServerConfig.getElementContentsAsInteger(groupElement, "FPSDelay", -1));
                        group.setFPSLimited(group.getFPSDelay() != -1L);
                        group.setSessionLimitKbps(ServerConfig.getElementContentsAsInteger(groupElement, "SessionSpeedLimit", -1));
                        group.setSessionLimited(group.getSessionLimitKbps() != -1);
                        group.setRadius(XML14Util.getChildByName(groupElement, "RADIUS") != null);
                        group.setMultiTierApp(XML14Util.getChildByName(groupElement, "AppAuthentication") != null);
                        group.setMultiTierRememberMachine(XML14Util.getChildByName(groupElement, "MultiTierRememberMachine") != null);
                        Element element = XML14Util.getChildByName(groupElement, "TwoTier");
                        if (element != null) {
                            Element bodyElement;
                            group.setMultiTierEmail(true);
                            Element codeLengthElement = XML14Util.getChildByName(element, "CodeLength");
                            if (codeLengthElement != null) {
                                String codeLength = XML14Util.getTextContent(codeLengthElement);
                                try {
                                    group.setTwoTierCodeLength(Integer.parseInt(codeLength));
                                }
                                catch (Throwable t) {
                                    t.printStackTrace();
                                    group.setMultiTierEmail(false);
                                }
                            }
                            String emailBody = null;
                            String emailSubject = null;
                            Element subjectElement = XML14Util.getChildByName(element, "EmailSubject");
                            if (subjectElement != null) {
                                emailSubject = XML14Util.getTextContent(subjectElement);
                            }
                            if ((bodyElement = XML14Util.getChildByName(element, "EmailBody")) != null) {
                                emailBody = new String(HexData.hexStringToByteArray(XML14Util.getTextContent(bodyElement)), "UTF-8");
                            }
                            group.setTwoTierEmail(emailSubject, emailBody);
                        }
                        if ((ldapChild = XML14Util.getChildByName(groupElement, "LDAP")) != null) {
                            LDAPProperties ldapProperties = new LDAPProperties();
                            group.setLDAP(true);
                            ldapProperties.filter = XML14Util.getChildText(ldapChild, "SearchFilter", null);
                            ldapProperties.baseDN = XML14Util.getChildText(ldapChild, "BaseDN", null);
                            Element groups = XML14Util.getChildByName(ldapChild, "Groups");
                            if (groups == null) {
                                ldapProperties.groups = null;
                            } else {
                                ArrayList<Element> groupList = XML14Util.getChildrenByName(groups, "Group");
                                ldapProperties.groups = new String[groupList.size()];
                                for (int i2 = 0; i2 < groupList.size(); ++i2) {
                                    Element e = groupList.get(i2);
                                    ldapProperties.groups[i2] = XML14Util.getTextContent(e);
                                }
                            }
                            if (XML14Util.getChildByName(ldapChild, "Advanced") != null) {
                                ldapProperties.setAdvanced();
                            } else if (ldapProperties.filter == null || ldapProperties.filter.length() == 0) {
                                ldapProperties.setSimple();
                            } else {
                                ldapProperties.setAdvanced();
                            }
                            group.setLdapProperties(ldapProperties);
                        }
                        group.setFilterByAllowedGroups(ServerConfig.getElementContentsAsBoolean(groupElement, "FilterByMachineGroup", false));
                        Element allowedGroupsChild = XML14Util.getChildByName(groupElement, "AllowedMachineGroups");
                        if (allowedGroupsChild != null) {
                            ArrayList<Element> allowedGroupChildren = XML14Util.getChildrenByName(allowedGroupsChild, "AllowedMachineGroup");
                            ArrayList<ArrayList<String>> allowedGroups = new ArrayList<ArrayList<String>>();
                            for (Element allowedGroupChild : allowedGroupChildren) {
                                ArrayList<String> groupPath = new ArrayList<String>();
                                ArrayList<Element> allowedGroupPaths = XML14Util.getChildrenByName(allowedGroupChild, "Path");
                                for (Element allowedPath : allowedGroupPaths) {
                                    groupPath.add(XML14Util.getTextContent(allowedPath));
                                }
                                allowedGroups.add(groupPath);
                            }
                            group.setRemoteAccessGroupRestrictions(allowedGroups);
                        }
                        String[] deprecated_shows = null;
                        String[] deprecated_hides = null;
                        String[] deprecated_machineShows = null;
                        String[] deprecated_machineHides = null;
                        ArrayList<Element> filters = XML14Util.getChildrenByName(groupElement, "ShowMatching");
                        deprecated_shows = new String[filters.size()];
                        for (k = 0; k < filters.size(); ++k) {
                            Element filter22 = filters.get(k);
                            deprecated_shows[k] = XML14Util.getTextContent(filter22).trim();
                        }
                        filters = XML14Util.getChildrenByName(groupElement, "HideMatching");
                        deprecated_hides = new String[filters.size()];
                        for (k = 0; k < filters.size(); ++k) {
                            filter2 = filters.get(k);
                            deprecated_hides[k] = XML14Util.getTextContent(filter2).trim();
                        }
                        filters = XML14Util.getChildrenByName(groupElement, "ShowMatchingMachines");
                        deprecated_machineShows = new String[filters.size()];
                        for (k = 0; k < filters.size(); ++k) {
                            filter2 = filters.get(k);
                            deprecated_machineShows[k] = XML14Util.getTextContent(filter2).trim();
                        }
                        filters = XML14Util.getChildrenByName(groupElement, "HideMatchingMachines");
                        deprecated_machineHides = new String[filters.size()];
                        for (k = 0; k < filters.size(); ++k) {
                            filter2 = filters.get(k);
                            deprecated_machineHides[k] = XML14Util.getTextContent(filter2).trim();
                        }
                        if (deprecated_shows.length == 0 && deprecated_hides.length == 0) {
                            filters = XML14Util.getChildrenByName(groupElement, "CustomerFilter");
                            CustomerFilter[] customerFilters = new CustomerFilter[filters.size()];
                            for (int k2 = 0; k2 < filters.size(); ++k2) {
                                filter = filters.get(k2);
                                CustomerFilter customerFilter = new CustomerFilter();
                                customerFilter.loadFromXML(filter);
                                customerFilters[k2] = customerFilter;
                            }
                            group.setCustomerFilters(customerFilters);
                        } else {
                            group.setCustomerFilters(ServerConfig.migrateDeprecatedCustomerFilters(deprecated_shows, deprecated_hides));
                        }
                        if (deprecated_machineShows.length == 0 && deprecated_machineHides.length == 0) {
                            filters = XML14Util.getChildrenByName(groupElement, "MachineFilter");
                            MachineFilter[] machineFilters = new MachineFilter[filters.size()];
                            for (int k3 = 0; k3 < filters.size(); ++k3) {
                                filter = filters.get(k3);
                                MachineFilter machineFilter = new MachineFilter();
                                machineFilter.loadFromXML(filter);
                                machineFilters[k3] = machineFilter;
                            }
                            group.setMachineFilters(machineFilters);
                        } else {
                            group.setMachineFilters(ServerConfig.migrateDeprecatedMachineFilters(deprecated_machineShows, deprecated_machineHides));
                        }
                        tmplist.add(group);
                    }
                    this.groups = new TechGroup[tmplist.size()];
                    tmplist.toArray(this.groups);
                }
                catch (Exception e) {
                    Debugger.error("[Server Config] Error reading <TechnicianGroup> entries");
                    e.printStackTrace();
                }
                try {
                    users = XML14Util.getChildrenByName(root, "Technician");
                    this.technicians = ServerConfig.loadTechnicianXML(users, false, this.groups);
                }
                catch (Exception e) {
                    Debugger.error("[Server Config] Error reading <Technician> entries");
                }
                try {
                    users = XML14Util.getChildrenByName(root, "AnonTechnician");
                    this.anonymousTechnicians = ServerConfig.loadTechnicianXML(users, true, this.groups);
                }
                catch (Exception e) {
                    Debugger.error("[Server Config] Error reading <AnonTechnician> entries");
                }
                this.deprecated_anonymousUserIDToTOTPKey.clear();
                Element allKeys = XML14Util.getChild(root, "AnonymousTOTPKeys");
                if (allKeys != null) {
                    ArrayList<Element> allEntries = XML14Util.getChildren(allKeys, "KeyEntry");
                    for (Element child4 : allEntries) {
                        String user = XML14Util.getChildText(child4, "User", null);
                        String keyEncrypted = XML14Util.getChildText(child4, "TOTPKey", null);
                        if (user == null || keyEncrypted == null) {
                            System.out.println("[ServerConfig] Expected an anonymous TOTP key, but a field was empty (user: " + user + ", key: " + keyEncrypted + ")");
                            continue;
                        }
                        this.deprecated_anonymousUserIDToTOTPKey.put(user, new LazyPassword(keyEncrypted, false));
                    }
                }
                this.remoteCustomersTechPresence = false;
                this.remoteMachinesTechPresence = false;
                String error = "";
                try {
                    ArrayList<Element> pres = XML14Util.getChildrenByName(root, "TechnicianPresenceDialog");
                    if (pres.size() > 1) {
                        Debugger.error("[Server Config] Error reading <TechnicianPresenceDialog> entry - only one <TechnicianPresenceDialog> entry allowed");
                    } else if (pres.size() == 1) {
                        Element settings2 = pres.get(0);
                        ArrayList<Element> custChildren = XML14Util.getChildrenByName(settings2, "RemoteCustomers");
                        if (custChildren.size() > 1) {
                            Debugger.error("[Server Config] Error reading <RemoteCustomers> entry - only one <RemoteCustomers> entry allowed");
                        } else if (custChildren.size() == 1) {
                            error = " (invalid <RemoteCustomers> tag)";
                            String rcust = XML14Util.getTextContent(custChildren.get(0));
                            this.remoteCustomersTechPresence = rcust.equalsIgnoreCase("on");
                        }
                        ArrayList<Element> techChildren = XML14Util.getChildrenByName(settings2, "RemoteMachines");
                        if (techChildren.size() > 1) {
                            Debugger.error("[Server Config] Error reading <RemoteMachines> entry - only one <RemoteMachines> entry allowed");
                        } else if (techChildren.size() == 1) {
                            error = " (invalid <RemoteMachines> tag)";
                            String rmach = XML14Util.getTextContent(techChildren.get(0));
                            this.remoteMachinesTechPresence = rmach.equalsIgnoreCase("on");
                        }
                    }
                }
                catch (Exception e) {
                    Debugger.error("[Server Config] Error reading <TechnicianPresenceDialog> entry" + error);
                }
                error = "";
                try {
                    ArrayList<Element> email2 = XML14Util.getChildrenByName(root, "EmailSettings");
                    if (email2.size() > 1) {
                        Debugger.error("[Server Config] Error reading <EmailSettings> entry - only one <EmailSettings> entry allowed");
                        break block274;
                    }
                    if (email2.size() != 1) break block274;
                    this.emailSettingsEnabled = true;
                    Element settings2 = email2.get(0);
                    try {
                        this.dateFormat = XML14Util.getTextContent(XML14Util.getChildrenByName(settings2, "DateFormat").get(0));
                        try {
                            String example = MasterLog.setDateFormat(this.dateFormat);
                            if (CentralDebugging.PX_VERBOSE_SERVER_CONFIG) {
                                System.out.println("[Server Config] Email log date format: (sample) " + example);
                            }
                        }
                        catch (Exception e) {
                            Debugger.error("[Server Config] Email log date format invalid: " + this.dateFormat + " (" + e.getMessage() + ")");
                        }
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                    error = " (invalid or missing <SmtpHost> tag)";
                    this.smtpHost = XML14Util.getTextContent(XML14Util.getChildByName(settings2, "SmtpHost"));
                    error = " (invalid or missing <SmtpPort> tag)";
                    String porty = XML14Util.getTextContent(XML14Util.getChildByName(settings2, "SmtpPort"));
                    this.smtpPort = Integer.parseInt(porty);
                    this.smtpUser = "";
                    this.smtpPassword = new LazyPassword(null);
                    this.smtpAuthentication = false;
                    if (XML14Util.getChildByName(settings2, "SmtpUser") != null) {
                        this.smtpAuthentication = true;
                        error = " (invalid or missing <SmtpUser> tag)";
                        this.smtpUser = XML14Util.getTextContent(XML14Util.getChildByName(settings2, "SmtpUser"));
                        error = " (invalid or missing <SmtpPass> tag)";
                        this.smtpPassword = ServerConfig.getPlaintextOrEncryptedPassword(settings2, "SmtpPass");
                    }
                    error = " (invalid or missing <SmtpFromEmail> tag)";
                    this.smtpFromEmail = XML14Util.getTextContent(XML14Util.getChildByName(settings2, "SmtpFromEmail"));
                    error = " (invalid or missing <SmtpFromName> tag)";
                    this.smtpFromName = XML14Util.getTextContent(XML14Util.getChildByName(settings2, "SmtpFromName"));
                    error = " (invalid or missing <SmtpTLS> tag)";
                    this.smtpTLS = XML14Util.getTextContent(XML14Util.getChildByName(settings2, "SmtpTLS")).equalsIgnoreCase("on");
                    error = " (invalid or missing <SmtpSSL> tag)";
                    this.smtpSSL = XML14Util.getTextContent(XML14Util.getChildByName(settings2, "SmtpSSL")).equalsIgnoreCase("on");
                    this.emailProperties = new Properties();
                    ArrayList<Element> emailPropertiesList = XML14Util.getChildrenByName(settings2, "EmailProperty");
                    if (emailPropertiesList != null) {
                        for (Element element : emailPropertiesList) {
                            String key = XML14Util.getTextContent(XML14Util.getChildByName(element, "Key"));
                            String value = XML14Util.getTextContent(XML14Util.getChildByName(element, "Value"));
                            if (key == null || value == null) continue;
                            this.emailProperties.put(key, value);
                        }
                    }
                    error = "";
                    if (CentralDebugging.PX_VERBOSE_SERVER_CONFIG) {
                        System.out.println("[Server Config] Email Settings: " + this.smtpHost + ":" + this.smtpPort + " (" + (this.smtpAuthentication ? "authenticated" : "not authenticated") + ") (" + (this.smtpSSL ? "SSL" : "no SSL") + ") (" + (this.smtpTLS ? "TLS" : "no TLS") + ")");
                    }
                }
                catch (Exception e) {
                    Debugger.error("[Server Config] Error reading <EmailSettings> entry" + error);
                }
            }
            try {
                Templates.loadTemplates();
            }
            catch (Exception e) {
                Debugger.error("[Server Config] Error reading Email Templates " + e);
            }
            try {
                email = XML14Util.getChildrenByName(root, "TechnicianActivityLog");
                if (email.size() > 1) {
                    Debugger.error("[Server Config] Error reading <TechnicianActivityLog> entry - only one <TechnicianActivityLog> entry allowed");
                } else if (email.size() == 0) {
                    this.deprecated_logTechEmail = false;
                    this.deprecated_logTechEmailAddress = null;
                    this.deprecated_logFilePerTech = false;
                    this.deprecated_logTechToFile = false;
                    this.deprecated_logTechLogins = false;
                    this.deprecated_logTechLogouts = false;
                    this.deprecated_logTechJoins = false;
                    this.deprecated_logTechLeaves = false;
                    this.deprecated_logTechRemoteJoins = false;
                    this.deprecated_logTechRemoteLeaves = false;
                } else if (email.size() == 1) {
                    settings = email.get(0);
                    Element child2 = XML14Util.getChildByName(settings, "LogToFile");
                    this.deprecated_logTechToFile = child2 != null && XML14Util.getTextContent(child2).equalsIgnoreCase("on");
                    child2 = XML14Util.getChildByName(settings, "LogToFilePerTechnician");
                    this.deprecated_logFilePerTech = child2 != null && XML14Util.getTextContent(child2).equalsIgnoreCase("on");
                    child2 = XML14Util.getChildByName(settings, "LogToEmail");
                    if (child2 != null) {
                        this.deprecated_logTechEmail = true;
                        this.deprecated_logTechEmailAddress = XML14Util.getTextContent(child2);
                    } else {
                        this.deprecated_logTechEmail = false;
                        this.deprecated_logTechEmailAddress = "";
                    }
                    child2 = XML14Util.getChildByName(settings, "WhatToLog");
                    if (child2 != null) {
                        childchild = XML14Util.getChildByName(child2, "Logins");
                        this.deprecated_logTechLogins = childchild != null && XML14Util.getTextContent(childchild).equalsIgnoreCase("on");
                        childchild = XML14Util.getChildByName(child2, "Logouts");
                        this.deprecated_logTechLogouts = childchild != null && XML14Util.getTextContent(childchild).equalsIgnoreCase("on");
                        childchild = XML14Util.getChildByName(child2, "JoinCustomer");
                        this.deprecated_logTechJoins = childchild != null && XML14Util.getTextContent(childchild).equalsIgnoreCase("on");
                        childchild = XML14Util.getChildByName(child2, "LeaveCustomer");
                        this.deprecated_logTechLeaves = childchild != null && XML14Util.getTextContent(childchild).equalsIgnoreCase("on");
                        childchild = XML14Util.getChildByName(child2, "JoinRemote");
                        this.deprecated_logTechRemoteJoins = childchild != null && XML14Util.getTextContent(childchild).equalsIgnoreCase("on");
                        childchild = XML14Util.getChildByName(child2, "LeaveRemote");
                        this.deprecated_logTechRemoteLeaves = childchild != null && XML14Util.getTextContent(childchild).equalsIgnoreCase("on");
                    } else {
                        this.deprecated_logTechLogins = true;
                        this.deprecated_logTechLogouts = true;
                        this.deprecated_logTechJoins = true;
                        this.deprecated_logTechLeaves = true;
                        this.deprecated_logTechRemoteJoins = true;
                        this.deprecated_logTechRemoteLeaves = true;
                    }
                }
            }
            catch (Exception e) {
                Debugger.error("[Server Config] Error reading <TechnicianActivityLog> entry");
            }
            try {
                email = XML14Util.getChildrenByName(root, "CustomerActivityLog");
                if (email.size() > 1) {
                    Debugger.error("[Server Config] Error reading <CustomerActivityLog> entry - only one <CustomerActivityLog> entry allowed");
                } else if (email.size() == 0) {
                    this.deprecated_logCustEmail = false;
                    this.deprecated_logCustEmailAddress = null;
                    this.deprecated_logFilePerCust = false;
                    this.deprecated_logCustToFile = false;
                    this.deprecated_logCustJoinQueue = false;
                    this.deprecated_logCustLeaveQueue = false;
                    this.deprecated_logCustJoins = false;
                    this.deprecated_logCustLeaves = false;
                } else if (email.size() == 1) {
                    settings = email.get(0);
                    Element child3 = XML14Util.getChildByName(settings, "LogToFile");
                    this.deprecated_logCustToFile = child3 != null && XML14Util.getTextContent(child3).equalsIgnoreCase("on");
                    child3 = XML14Util.getChildByName(settings, "LogToFilePerTechnician");
                    this.deprecated_logFilePerCust = child3 != null && XML14Util.getTextContent(child3).equalsIgnoreCase("on");
                    child3 = XML14Util.getChildByName(settings, "LogToEmail");
                    if (child3 != null) {
                        this.deprecated_logCustEmail = true;
                        this.deprecated_logCustEmailAddress = XML14Util.getTextContent(child3);
                    } else {
                        this.deprecated_logCustEmail = false;
                    }
                    child3 = XML14Util.getChildByName(settings, "WhatToLog");
                    if (child3 != null) {
                        childchild = XML14Util.getChildByName(child3, "JoinQueue");
                        this.deprecated_logCustJoinQueue = childchild != null && XML14Util.getTextContent(childchild).equalsIgnoreCase("on");
                        childchild = XML14Util.getChildByName(child3, "LeaveQueue");
                        this.deprecated_logCustLeaveQueue = childchild != null && XML14Util.getTextContent(childchild).equalsIgnoreCase("on");
                        childchild = XML14Util.getChildByName(child3, "JoinTechnician");
                        this.deprecated_logCustJoins = childchild != null && XML14Util.getTextContent(childchild).equalsIgnoreCase("on");
                        childchild = XML14Util.getChildByName(child3, "LeaveTechnician");
                        this.deprecated_logCustLeaves = childchild != null && XML14Util.getTextContent(childchild).equalsIgnoreCase("on");
                    } else {
                        this.deprecated_logCustJoinQueue = false;
                        this.deprecated_logCustLeaveQueue = false;
                        this.deprecated_logCustJoins = false;
                        this.deprecated_logCustLeaves = false;
                    }
                }
            }
            catch (Exception e) {
                Debugger.error("[Server Config] Error reading <CustomerActivityLog> entry");
            }
            try {
                ArrayList<Element> status = XML14Util.getChildrenByName(root, "StatusPage");
                if (status.size() > 1) {
                    Debugger.error("[Server Config] Error reading <StatusPage> entry - only one <StatusPage> entry allowed");
                } else if (status.size() == 1) {
                    settings = status.get(0);
                    this.statusPage = true;
                    this.statusPageIncludeMachines = ServerConfig.getElementContentsAsBoolean(settings, "IncludeMachines", true);
                    this.statusPageIncludeSessions = ServerConfig.getElementContentsAsBoolean(settings, "IncludeSessions", false);
                    this.statusPageIncludePerformance = ServerConfig.getElementContentsAsBoolean(settings, "IncludePerformance", false);
                    ArrayList<Element> restrictions = XML14Util.getChildrenByName(settings, "StatusPageRestriction");
                    this.statusPageRestrictions = new PatternWrapper[restrictions.size()];
                    StringBuilder sb = new StringBuilder();
                    for (int k = 0; k < restrictions.size(); ++k) {
                        Element restrict = restrictions.get(k);
                        try {
                            this.statusPageRestrictions[k] = new PatternWrapper(XML14Util.getTextContent(restrict).trim(), false);
                            sb.append("\t(Allowed Network) ").append(XML14Util.getTextContent(restrict).trim()).append("\n");
                            continue;
                        }
                        catch (Exception e) {
                            throw new ServerStartFailureException("Invalid StatusPageRestriction: " + XML14Util.getTextContent(restrict), e);
                        }
                    }
                    if (this.statusPageRestrictions.length == 0) {
                        this.statusPageRestrictions = null;
                    } else if (CentralDebugging.PX_VERBOSE_SERVER_CONFIG) {
                        System.out.println("[Server Config] Status Page Restrictions:\n" + sb);
                    }
                }
            }
            catch (Exception e) {
                Debugger.error("[Server Config] Error reading <StatusPage> entry");
            }
            Element radiusSettings = XML14Util.getChild(root, "RadiusSettings");
            try {
                if (radiusSettings == null) {
                    this.radiusAttempts = 3;
                    this.radiusTimeout = 10000L;
                    this.radiusStrategy = 1;
                } else {
                    this.radiusAttempts = Integer.parseInt(XML14Util.getChildText(radiusSettings, "Attempts", "3"));
                    this.radiusTimeout = Integer.parseInt(XML14Util.getChildText(radiusSettings, "TimeoutMS", "10000"));
                    this.radiusStrategy = Integer.parseInt(XML14Util.getChildText(radiusSettings, "Strategy", Integer.toString(1)));
                    this.radiusStaggeredTimeout = Integer.parseInt(XML14Util.getChildText(radiusSettings, "StaggeredTimeoutMS", Integer.toString(2000)));
                }
            }
            catch (Exception e) {
                Debugger.error("[Server Config] Error reading <RadiusAuthentication> entry");
            }
            try {
                this.radiusEnable = false;
                ArrayList<Element> radius = XML14Util.getChildrenByName(root, "RadiusAuthentication");
                ArrayList<RadiusConfig> result = new ArrayList<RadiusConfig>();
                for (Element radiusParent : radius) {
                    this.radiusEnable = true;
                    RadiusConfig config = new RadiusConfig();
                    try {
                        config.index = Integer.parseInt(radiusParent.getAttribute("id"));
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    config.radiusHostname = XML14Util.getChildText(radiusParent, "RadiusHostname", null);
                    config.radiusAuthProtocol = XML14Util.getChildText(radiusParent, "RadiusAuthenticationProtocol", null);
                    try {
                        config.radiusPort = Integer.parseInt(XML14Util.getChildText(radiusParent, "RadiusPort", null));
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    config.radiusSecret = XML14Util.getChildText(radiusParent, "RadiusSecret", null);
                    result.add(config);
                }
                this.radiusConfigs = result.toArray(new RadiusConfig[0]);
            }
            catch (Exception e) {
                Debugger.error("[Server Config] Error reading <RadiusAuthentication> entry");
            }
            try {
                ArrayList<Element> ldap = XML14Util.getChildrenByName(root, "LDAPAuthentication");
                if (ldap.size() > 1) {
                    Debugger.error("[Server Config] Error reading <LDAPAuthentication> entry - only one <LDAPAuthentication> entry allowed");
                    break block276;
                }
                if (ldap.size() != 1) break block276;
                settings = ldap.get(0);
                this.ldapEnable = true;
                ArrayList<Element> hostname = XML14Util.getChildrenByName(settings, "LDAPHostname");
                ArrayList<Element> port = XML14Util.getChildrenByName(settings, "LDAPPort");
                ArrayList<Element> authenticationMechanism = XML14Util.getChildrenByName(settings, "AuthenticationMechanism");
                ArrayList<Element> useSSL = XML14Util.getChildrenByName(settings, "UseSSL");
                ArrayList<Element> trustStore = XML14Util.getChildrenByName(settings, "TrustKeyStore");
                this.ldapIsAD = XML14Util.getChildByName(settings, "IsAD") != null;
                this.ldapUserClass = XML14Util.getChildText(settings, "UserClass", null);
                this.ldapGroupClass = XML14Util.getChildText(settings, "GroupClass", null);
                this.ldapLoginAttribute = XML14Util.getChildText(settings, "LoginAttribute", null);
                this.ldapMemberAttribute = XML14Util.getChildText(settings, "MemberAttribute", null);
                this.ldapFollowLinks = ServerConfig.getElementContentsAsBoolean(settings, "FollowReferrals", true);
                Element childchild2 = XML14Util.getChildByName(settings, "LDAPUsername");
                if (childchild2 != null) {
                    this.ldapUsername = XML14Util.getTextContent(childchild2);
                }
                this.ldapPassword = ServerConfig.getPlaintextOrEncryptedPassword(settings, "LDAPPassword");
                if (hostname.size() == 0) {
                    Debugger.error("[Server Config] Invalid <LDAPAuthentication> entry: <LDAPHostname> cannot be empty");
                } else if (hostname.size() > 1) {
                    Debugger.error("[Server Config] Invalid <LDAPAuthentication> entry: only one <LDAPHostname> entry allowed");
                } else {
                    this.ldapHostname = XML14Util.getTextContent(hostname.get(0));
                    if (CentralDebugging.PX_VERBOSE_SERVER_CONFIG) {
                        System.out.println("[Server Config] LDAP Authentication Server = " + this.ldapHostname);
                    }
                }
                if (port.size() == 0) {
                    Debugger.error("[Server Config] Invalid <LDAPAuthentication> entry: <LDAPPort> cannot be empty");
                } else if (port.size() > 1) {
                    Debugger.error("[Server Config] Invalid <LDAPAuthentication> entry: only one <LDAPPort> entry allowed");
                } else {
                    String portString = XML14Util.getTextContent(port.get(0));
                    try {
                        this.ldapPort = Integer.parseInt(portString);
                    }
                    catch (Throwable throwable) {
                        Debugger.error("[Server Config] Invalid <LDAPAuthentication> entry: <LDAPPort> must be a valid integer");
                    }
                    if (CentralDebugging.PX_VERBOSE_SERVER_CONFIG) {
                        System.out.println("[Server Config] LDAP Authentication Port = " + this.ldapPort);
                    }
                }
                if (authenticationMechanism.size() > 0) {
                    this.ldapAuthentication = XML14Util.getTextContent(authenticationMechanism.get(0));
                    if (this.ldapAuthentication != null) {
                        this.ldapAuthentication = this.ldapAuthentication.trim();
                    }
                }
                if (useSSL.size() > 0) {
                    this.ldapEnableSSL = true;
                }
                if (CentralDebugging.PX_VERBOSE_SERVER_CONFIG) {
                    System.out.println("[Server Config] LDAP Server Configured: " + (this.ldapAuthentication != null ? "'" + this.ldapAuthentication + "' " : "") + "LDAP Authentication on " + this.ldapHostname + ":" + this.ldapPort + (this.ldapEnableSSL ? " using SSL" : ""));
                }
            }
            catch (Exception e) {
                Debugger.error("[Server Config] Error reading <LDAPAuthentication> entry");
            }
        }
        ArrayList<Element> children = XML14Util.getChildrenByName(root, "IP");
        Object[] oldIPs = new String[children.size()];
        for (i = 0; i < children.size(); ++i) {
            child = children.get(i);
            oldIPs[i] = XML14Util.getTextContent(child).trim();
        }
        if (oldIPs.length == 0) {
            oldIPs = null;
        }
        children = XML14Util.getChildrenByName(root, "IpPort");
        this.ipPortPairsList = new String[children.size()];
        for (i = 0; i < children.size(); ++i) {
            child = children.get(i);
            this.ipPortPairsList[i] = XML14Util.getTextContent(child).trim();
        }
        if (this.ipPortPairsList.length == 0) {
            this.ipPortPairsList = null;
        }
        children = XML14Util.getChildrenByName(root, "Port");
        this.portList = new int[children.size()];
        for (i = 0; i < children.size(); ++i) {
            child = children.get(i);
            try {
                if (XML14Util.getTextContent(child).trim().equalsIgnoreCase("Auto")) {
                    this.portList = null;
                    break;
                }
                this.portList[i] = Integer.parseInt(XML14Util.getTextContent(child).trim());
                continue;
            }
            catch (Exception e) {
                Debugger.error("[Server Config] Invalid TechServer port: " + XML14Util.getTextContent(child));
            }
        }
        if (oldIPs != null) {
            ArrayList<String> list = new ArrayList<String>();
            Arrays.sort(oldIPs);
            Arrays.sort(this.portList);
            if (CentralDebugging.PX_VERBOSE_SERVER_CONFIG) {
                System.out.println("[Server Config] Found tags, converting...");
            }
            for (Object oldIP : oldIPs) {
                for (Object object : (ArrayList<Element>)this.portList) {
                    String ipPort = (String)oldIP + ":" + (int)object;
                    list.add(ipPort);
                    if (!CentralDebugging.PX_VERBOSE_SERVER_CONFIG) continue;
                    System.out.println("[Server Config] \tConversion added " + ipPort);
                }
            }
            this.ipPortPairsList = new String[list.size()];
            list.toArray(this.ipPortPairsList);
            this.ipList = null;
        }
        this.recreateIpAndPortLists();
        if (this.ipList == null) {
            if (CentralDebugging.PX_VERBOSE_SERVER_CONFIG) {
                System.out.println("[Server Config] No specific IP:Port combinations used, will bind to all IPs");
            }
        } else {
            for (int i3 = 0; i3 < this.ipList.length; ++i3) {
                if (!CentralDebugging.PX_VERBOSE_SERVER_CONFIG) continue;
                System.out.println("[Server Config] IP Used " + (1 + i3) + "/" + this.ipList.length + " = " + this.ipList[i3]);
            }
        }
        if (this.portList != null) {
            for (int i4 = 0; i4 < this.portList.length; ++i4) {
                if (!CentralDebugging.PX_VERBOSE_SERVER_CONFIG) continue;
                System.out.println("[Server Config] Port Used " + (1 + i4) + "/" + this.portList.length + " = " + this.portList[i4]);
            }
        }
        try {
            ArrayList<Element> sessionSummaryChildren = XML14Util.getChildrenByName(root, "SessionSummary");
            if (sessionSummaryChildren.size() > 1) {
                Debugger.error("[Server Config] Error reading <SessionSummary> entry - only one <SessionSummary> entry allowed");
            } else if (sessionSummaryChildren.size() == 1) {
                ArrayList<Element> emailList;
                boolean deprecated_sessionSummaryCustomer;
                boolean deprecated_sessionSummaryChat;
                Element settings = sessionSummaryChildren.get(0);
                boolean deprecated_sessionSummaryEnabled = true;
                Element childchild = XML14Util.getChildByName(settings, "IncludeTechComments");
                if (childchild != null && XML14Util.getTextContent(childchild).equalsIgnoreCase("on")) {
                    this.sessionSummaryTechComment = true;
                    if (CentralDebugging.PX_VERBOSE_SERVER_CONFIG) {
                        System.out.println("[Server Config] Technician Comments Enabled");
                    }
                } else {
                    this.sessionSummaryTechComment = false;
                }
                if ((childchild = XML14Util.getChildByName(settings, "SkipAllowed")) != null && XML14Util.getTextContent(childchild).equalsIgnoreCase("on")) {
                    this.sessionSummaryAllowSkip = true;
                    if (CentralDebugging.PX_VERBOSE_SERVER_CONFIG) {
                        System.out.println("[Server Config] Session Summary Skip Allowed");
                    }
                } else {
                    this.sessionSummaryAllowSkip = false;
                }
                if ((childchild = XML14Util.getChildByName(settings, "IncludeChat")) != null && XML14Util.getTextContent(childchild).equalsIgnoreCase("on")) {
                    deprecated_sessionSummaryChat = true;
                    if (CentralDebugging.PX_VERBOSE_SERVER_CONFIG) {
                        System.out.println("[Server Config] Session Chat Summary Enabled");
                    }
                } else {
                    deprecated_sessionSummaryChat = false;
                }
                if ((childchild = XML14Util.getChildByName(settings, "IncludeCustomerDetails")) != null && XML14Util.getTextContent(childchild).equalsIgnoreCase("on")) {
                    deprecated_sessionSummaryCustomer = true;
                    if (CentralDebugging.PX_VERBOSE_SERVER_CONFIG) {
                        System.out.println("[Server Config] Session Customer Details Summary Enabled");
                    }
                } else {
                    deprecated_sessionSummaryCustomer = false;
                }
                if ((emailList = XML14Util.getChildrenByName(settings, "EmailSummary")).size() > 0) {
                    boolean deprecated_sessionSummaryEmailTech;
                    boolean deprecated_sessionSummaryArbEmail;
                    Element element = emailList.get(0);
                    boolean deprecated_sessionSummaryEmailEnabled = true;
                    childchild = XML14Util.getChildByName(element, "Email");
                    if (childchild != null) {
                        deprecated_sessionSummaryArbEmail = true;
                        String deprecated_sessionSummaryArbEmailAddress = XML14Util.getTextContent(childchild);
                        if (CentralDebugging.PX_VERBOSE_SERVER_CONFIG) {
                            System.out.println("[Server Config] Session Summary Email Enabled: '" + deprecated_sessionSummaryArbEmailAddress + "'");
                        }
                    } else {
                        deprecated_sessionSummaryArbEmail = false;
                    }
                    childchild = XML14Util.getChildByName(element, "TechnicianEmail");
                    if (childchild != null && XML14Util.getTextContent(childchild).equalsIgnoreCase("on")) {
                        deprecated_sessionSummaryEmailTech = true;
                        if (CentralDebugging.PX_VERBOSE_SERVER_CONFIG) {
                            System.out.println("[Server Config] Session Technician Email Enabled.");
                        }
                    } else {
                        deprecated_sessionSummaryEmailTech = false;
                    }
                    if ((childchild = XML14Util.getChildByName(element, "CustomerEmailDetail")) != null) {
                        this.sessionSummaryCustEmail = true;
                        this.sessionSummaryEmailCustDetail = XML14Util.getTextContent(childchild);
                        if (CentralDebugging.PX_VERBOSE_SERVER_CONFIG) {
                            System.out.println("[Server Config] Session Customer Email Enabled: Detail '" + this.sessionSummaryEmailCustDetail + "'");
                        }
                    } else {
                        this.sessionSummaryCustEmail = false;
                    }
                } else {
                    boolean bl = false;
                }
            } else {
                boolean deprecated_sessionSummaryEnabled = false;
            }
        }
        catch (Exception e) {
            Debugger.error("[Server Config] Invalid SessionSummary Entry");
        }
        this.endOfSessionOption = ServerConfig.getElementContentsAsString(root, "EndOfSessionOption");
        this.endOfSessionURL = ServerConfig.getElementContentsAsString(root, "EndOfSessionURL");
        this.endOfSessionURLSupport = ServerConfig.getElementContentsAsBoolean(root, "EndOfSessionURLSupport", true);
        this.endOfSessionURLAccess = ServerConfig.getElementContentsAsBoolean(root, "EndOfSessionURLAccess", true);
        this.elevateSupportSessions = ServerConfig.getElementContentsAsBoolean(root, "WindowsElevation", true);
        StringBuilder sb = new StringBuilder();
        ArrayList<Element> children2 = XML14Util.getChildrenByName(root, "TechRestriction");
        this.techRestrictions = new PatternWrapper[children2.size()];
        for (int i5 = 0; i5 < children2.size(); ++i5) {
            Element child5 = children2.get(i5);
            try {
                this.techRestrictions[i5] = new PatternWrapper(XML14Util.getTextContent(child5).trim(), false);
                sb.append("\t(Allowed Network) ").append(XML14Util.getTextContent(child5).trim()).append("\n");
                continue;
            }
            catch (Exception e) {
                throw new ServerStartFailureException("Invalid TechRestriction: " + XML14Util.getTextContent(child5), e);
            }
        }
        if (this.techRestrictions.length == 0) {
            this.techRestrictions = null;
        } else if (CentralDebugging.PX_VERBOSE_SERVER_CONFIG) {
            System.out.println("[Server Config] Technician Client Network Restrictions:\n" + sb);
        }
        children = XML14Util.getChildrenByName(root, "LogInfo");
        if (children.size() > 0) {
            node = children.get(0);
            if (XML14Util.getTextContent(node).trim().equalsIgnoreCase("on")) {
                this.logInfo = true;
            } else {
                if (CentralDebugging.PX_VERBOSE_SERVER_CONFIG) {
                    System.out.println("[Server Config] INFO level logging disabled");
                }
                Debugger.PRINT_INFO = false;
                this.logInfo = false;
            }
        }
        if ((children = XML14Util.getChildrenByName(root, "CustomerAuthentication")).size() > 0) {
            node = children.get(0);
            if ((children = XML14Util.getChildrenByName(node, "CustomerPassword")).size() > 0) {
                Element passwordNode = children.get(0);
                String password = XML14Util.getTextContent(passwordNode).trim();
                if (CentralDebugging.PX_VERBOSE_SERVER_CONFIG) {
                    System.out.println("[Server Config] Customer authentication password enabled");
                }
                this.enabledQueuePassword = true;
                this.queuePassword = password;
            } else {
                this.enabledQueuePassword = false;
            }
        } else {
            this.enabledQueuePassword = false;
        }
        this.blockedRemoteAccessMachines = new ArrayList<BlockedRemoteMachine>();
        children = XML14Util.getChildrenByName(root, "BlockedRemoteMachine");
        if (children.size() > 0) {
            int count = 0;
            for (Element e : children) {
                ++count;
                BlockedRemoteMachine blockedMachine = new BlockedRemoteMachine();
                blockedMachine.machineID = ServerConfig.getElementContentsAsString(e, "ID");
                blockedMachine.name = MachineName.extractFromNameWithGroup(ServerConfig.getElementContentsAsString(e, "Name"));
                this.blockedRemoteAccessMachines.add(blockedMachine);
            }
            if (count > 0) {
                System.out.println("[ServerConfig] " + count + " machines are blocked.");
            }
        }
        if ((messengerRouteMapElement = XML14Util.getChildByName(root, "SecureMessengerRouteMapSize")) != null) {
            String textContent = XML14Util.getTextContent(messengerRouteMapElement);
            try {
                this.secureMessengerRouteMapSize = Integer.parseInt(textContent);
            }
            catch (Throwable t) {
                System.out.println("[ServerConfig] Unable to parse SecureMessengerRouteMapSize from " + textContent);
            }
        }
        this.feature_showPerformanceMetricsTechConsole = XML14Util.childExists(root, "FeaturePerformanceMetrics");
        this.defaultMaxAudioBitrate = ServerConfig.getElementContentsAsInteger(root, "MaxAudioBitrate", 0);
        this.defaultMachineTimeoutMS = ServerConfig.getElementContentsAsInteger(root, "MachineTimeoutMS", this.defaultMachineTimeoutMS);
        this.totpLength = ServerConfig.getElementContentsAsInteger(root, "TOTPLength", 6);
        this.totpWindowSize = ServerConfig.getElementContentsAsInteger(root, "TOTPWindowSize", 10);
        this.forwardToHTTPS = ServerConfig.getElementContentsAsBoolean(root, "ForwardHTTPtoHTTPS", false);
        this.failoverCheckURL = XML14Util.getChildTextAllowEmptyStr(root, "FailOverCheckURL", null);
        this.condenserForURL = XML14Util.getChildText(root, "CentralServerURL", null);
        this.uPnPPortForwardingEnabled = ServerConfig.getElementContentsAsBoolean(root, "UPnPPortForwarding", false);
        Element loggingConfigParent = XML14Util.getChildByName(root, "LoggingConfiguration");
        if (loggingConfigParent != null) {
            ArrayList<Element> loggingChildren = XML14Util.getChildrenByName(loggingConfigParent, "LogMapping");
            ArrayList<LogMappingImpl> mappings = new ArrayList<LogMappingImpl>();
            for (Element child6 : loggingChildren) {
                try {
                    LogMappingImpl logMapping = LogMappingImpl.loadFromXML(child6, (ResourceBundle)Language.DEFLANG);
                    mappings.add(logMapping);
                }
                catch (Throwable t) {
                    Debugger.error("[ServerConfig] Unable to load log mapping.");
                    t.printStackTrace();
                }
            }
            this.deprecated_logMappings = mappings.toArray(new LogMapping[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TechUser[] loadTechnicianXML(ArrayList<Element> users, boolean isAnonymous, TechGroup[] allGroups) {
        times.start("Technician load");
        try {
            ArrayList<TechUser> tmplist = new ArrayList<TechUser>();
            for (Element user : users) {
                try {
                    Element filter;
                    int k;
                    String value;
                    Element appProfilesElement;
                    String value2;
                    Element accountEnabledElement;
                    String value3;
                    Element allowLocalLogin;
                    int id;
                    String name = XML14Util.getTextContent(XML14Util.getChildByName(user, "Name"));
                    try {
                        id = Integer.parseInt(XML14Util.getTextContent(XML14Util.getChildByName(user, "ID")));
                    }
                    catch (Throwable t) {
                        id = -1;
                    }
                    String login = XML14Util.getTextContent(XML14Util.getChildByName(user, "Login"));
                    LazyPassword pword = new LazyPassword(null);
                    String email = null;
                    boolean allowLocalLogins = true;
                    boolean accountEnabled = true;
                    boolean appProfilesOnly = false;
                    LazyPassword totpKey = new LazyPassword(null);
                    try {
                        times.start("TOTP Password");
                        totpKey = ServerConfig.getPassword(user, null, "TOTPKey", "TOTPKeyv2");
                        times.stop("TOTP Password");
                    }
                    catch (Throwable t) {
                        System.out.println("[ServerConfig] WARNING. Unable to decrypt TOTP secure key for user " + login);
                    }
                    Element emailChild = XML14Util.getChildByName(user, "Email");
                    if (emailChild != null) {
                        email = XML14Util.getTextContent(emailChild);
                    }
                    if ((allowLocalLogin = XML14Util.getChildByName(user, "AllowLocallyAuthenticatedLogin")) != null && (value3 = XML14Util.getTextContent(allowLocalLogin)) != null) {
                        if (value3.equalsIgnoreCase("on")) {
                            allowLocalLogins = true;
                        } else if (value3.equalsIgnoreCase("off")) {
                            allowLocalLogins = false;
                        }
                    }
                    times.start("Password");
                    pword = ServerConfig.getPlaintextOrEncryptedPassword(user, "Password");
                    times.stop("Password");
                    if (pword == null) {
                        allowLocalLogins = false;
                        if (CentralDebugging.PX_VERBOSE_SERVER_CONFIG) {
                            System.out.println("[ServerConfig] Technician " + login + " has no password specific. Local logins have been disabled.");
                        }
                    }
                    if ((accountEnabledElement = XML14Util.getChildByName(user, "Enabled")) != null && (value2 = XML14Util.getTextContent(accountEnabledElement)) != null) {
                        if (value2.equalsIgnoreCase("on")) {
                            accountEnabled = true;
                        } else if (value2.equalsIgnoreCase("off")) {
                            accountEnabled = false;
                        }
                    }
                    if (Switches.SH_appProfiles && (appProfilesElement = XML14Util.getChildByName(user, "AppProfilesOnly")) != null && (value = XML14Util.getTextContent(appProfilesElement)) != null) {
                        if (value.equalsIgnoreCase("on")) {
                            appProfilesOnly = true;
                        } else if (value.equalsIgnoreCase("off")) {
                            appProfilesOnly = false;
                        }
                    }
                    if ((login = login.trim()).length() == 0) {
                        Debugger.error("[Server Config] Invalid <Technician> entry: <Login> cannot be empty");
                    }
                    if ((name = name.trim()).length() == 0) {
                        name = login;
                    }
                    TechUser techuser = new TechUser(id, name, login, pword, email, isAnonymous, allowLocalLogins, accountEnabled);
                    if (totpKey != null && !totpKey.isNull()) {
                        techuser.setTOTPKey(totpKey);
                    }
                    if (Switches.SH_appProfiles) {
                        techuser.setIsForAppProfilesOnly(appProfilesOnly);
                    }
                    ArrayList<TechGroup> tempList = new ArrayList<TechGroup>();
                    ArrayList<TechGroup> groupAdminList = new ArrayList<TechGroup>();
                    ArrayList<Element> groupList = XML14Util.getChildrenByName(user, "GroupMemberOf");
                    for (Element filter2 : groupList) {
                        String groupName = XML14Util.getTextContent(filter2).trim();
                        TechGroup group = null;
                        for (TechGroup allGroup : allGroups) {
                            if (!allGroup.getName().equals(groupName)) continue;
                            group = allGroup;
                            break;
                        }
                        if (group == null || tempList.contains(group)) continue;
                        tempList.add(group);
                    }
                    groupList = XML14Util.getChildrenByName(user, "GroupIDMemberOf");
                    for (Element filter2 : groupList) {
                        String groupID = XML14Util.getTextContent(filter2).trim();
                        try {
                            int intID = Integer.parseInt(groupID);
                            TechGroup group = null;
                            for (TechGroup allGroup : allGroups) {
                                if (allGroup.getGroupID() != intID) continue;
                                group = allGroup;
                                break;
                            }
                            if (group == null) continue;
                            String memberOverride = filter2.getAttribute("member");
                            String adminAttribute = filter2.getAttribute("admin");
                            if (!(memberOverride != null && memberOverride.equals("no") || tempList.contains(group))) {
                                tempList.add(group);
                            }
                            if (adminAttribute == null || !adminAttribute.equals("yes") || groupAdminList.contains(group)) continue;
                            groupAdminList.add(group);
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                    }
                    techuser.setGroups(tempList.toArray(new TechGroup[0]));
                    techuser.setGroupsToAdmin(groupAdminList.toArray(new TechGroup[0]));
                    String[] deprecated_shows = null;
                    String[] deprecated_hides = null;
                    String[] deprecated_machineShows = null;
                    String[] deprecated_machineHides = null;
                    ArrayList<Element> filters = XML14Util.getChildrenByName(user, "ShowMatching");
                    deprecated_shows = new String[filters.size()];
                    for (k = 0; k < filters.size(); ++k) {
                        Element filter3 = filters.get(k);
                        deprecated_shows[k] = XML14Util.getTextContent(filter3).trim();
                    }
                    filters = XML14Util.getChildrenByName(user, "HideMatching");
                    deprecated_hides = new String[filters.size()];
                    for (k = 0; k < filters.size(); ++k) {
                        Element filter4 = filters.get(k);
                        deprecated_hides[k] = XML14Util.getTextContent(filter4).trim();
                    }
                    filters = XML14Util.getChildrenByName(user, "ShowMatchingMachines");
                    deprecated_machineShows = new String[filters.size()];
                    for (k = 0; k < filters.size(); ++k) {
                        Element filter5 = filters.get(k);
                        deprecated_machineShows[k] = XML14Util.getTextContent(filter5).trim();
                    }
                    filters = XML14Util.getChildrenByName(user, "HideMatchingMachines");
                    deprecated_machineHides = new String[filters.size()];
                    for (k = 0; k < filters.size(); ++k) {
                        Element filter6 = filters.get(k);
                        deprecated_machineHides[k] = XML14Util.getTextContent(filter6).trim();
                    }
                    if (deprecated_shows.length == 0 && deprecated_hides.length == 0) {
                        filters = XML14Util.getChildrenByName(user, "CustomerFilter");
                        CustomerFilter[] customerFilters = new CustomerFilter[filters.size()];
                        for (int k2 = 0; k2 < filters.size(); ++k2) {
                            filter = filters.get(k2);
                            CustomerFilter customerFilter = new CustomerFilter();
                            customerFilter.loadFromXML(filter);
                            customerFilters[k2] = customerFilter;
                        }
                        techuser.setCustomerFilters(customerFilters);
                    } else {
                        techuser.setCustomerFilters(ServerConfig.migrateDeprecatedCustomerFilters(deprecated_shows, deprecated_hides));
                    }
                    if (deprecated_machineShows.length == 0 && deprecated_machineHides.length == 0) {
                        filters = XML14Util.getChildrenByName(user, "MachineFilter");
                        MachineFilter[] machineFilters = new MachineFilter[filters.size()];
                        for (int k3 = 0; k3 < filters.size(); ++k3) {
                            filter = filters.get(k3);
                            MachineFilter machineFilter = new MachineFilter();
                            machineFilter.loadFromXML(filter);
                            machineFilters[k3] = machineFilter;
                        }
                        techuser.setMachineFilters(machineFilters);
                    } else {
                        techuser.setMachineFilters(ServerConfig.migrateDeprecatedMachineFilters(deprecated_machineShows, deprecated_machineHides));
                    }
                    tmplist.add(techuser);
                    if (!CentralDebugging.PX_VERBOSE_SERVER_CONFIG) continue;
                    System.out.println("[Server Config] Technician User: \"" + techuser.getDefaultName() + "\" (" + techuser.getLogin() + ")");
                }
                catch (Exception e) {
                    Debugger.error("[Server Config] Invalid <Technician> entry: " + user.toString());
                }
            }
            TechUser[] techUserArray = tmplist.toArray(new TechUser[0]);
            return techUserArray;
        }
        finally {
            times.stop("Technician load");
        }
    }

    private static MachineFilter[] migrateDeprecatedMachineFilters(String[] deprecated_machineShows, String[] deprecated_machineHides) {
        MachineFilter[] filters = new MachineFilter[deprecated_machineShows.length + deprecated_machineHides.length];
        int index = 0;
        for (String filter : deprecated_machineHides) {
            filter = filter.replace("*", "");
            filters[index++] = new MachineFilter(false, "Filter_Details", 2, filter);
        }
        for (String filter : deprecated_machineShows) {
            filter = filter.replace("*", "");
            filters[index++] = new MachineFilter(true, "Filter_Details", 2, filter);
        }
        return filters;
    }

    private static CustomerFilter[] migrateDeprecatedCustomerFilters(String[] deprecated_shows, String[] deprecated_hides) {
        CustomerFilter[] filters = new CustomerFilter[deprecated_shows.length + deprecated_hides.length];
        int index = 0;
        for (String filter : deprecated_hides) {
            filter = filter.replace("*", "");
            filters[index++] = new CustomerFilter(false, "Filter_Details", 2, filter);
        }
        for (String filter : deprecated_shows) {
            filter = filter.replace("*", "");
            filters[index++] = new CustomerFilter(true, "Filter_Details", 2, filter);
        }
        return filters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToConfig(File file) throws IOException {
        Object object = this.SAVE_LOCK;
        synchronized (object) {
            String config = this.printConfig();
            BufferedOutputStream bout = new BufferedOutputStream(new FileOutputStream(file));
            try {
                bout.write(config.getBytes("UTF8"));
                bout.flush();
            }
            finally {
                bout.flush();
            }
        }
    }

    public String getXMLForTechniciansIn(TechGroup[] groups) {
        StringBuffer result = new StringBuffer();
        result.append("<Technicians>\n");
        block0: for (TechUser user : this.technicians) {
            for (TechGroup group : groups) {
                if (!user.isInGroup(group)) continue;
                this.saveTechnicianXML(result, user, "Technician");
                continue block0;
            }
        }
        block2: for (TechUser user : this.anonymousTechnicians) {
            for (TechGroup group : groups) {
                if (!user.isInGroup(group)) continue;
                this.saveTechnicianXML(result, user, "AnonTechnician");
                continue block2;
            }
        }
        result.append("</Technicians>\n");
        return result.toString();
    }

    public static TechUser[] loadTechnicianXMLOnly(String techXML, TechGroup[] groups) throws ParserConfigurationException, IOException, SAXException {
        ArrayList<Element> users;
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document dom = builder.parse(new InputSource(new StringReader(techXML)));
        Element root = dom.getDocumentElement();
        TechUser[] technicians = null;
        TechUser[] anonymousTechnicians = null;
        try {
            users = XML14Util.getChildrenByName(root, "Technician");
            technicians = ServerConfig.loadTechnicianXML(users, false, groups);
        }
        catch (Exception e) {
            Debugger.error("[Server Config] Error reading <Technician> entries");
        }
        try {
            users = XML14Util.getChildrenByName(root, "AnonTechnician");
            anonymousTechnicians = ServerConfig.loadTechnicianXML(users, true, groups);
        }
        catch (Exception e) {
            Debugger.error("[Server Config] Error reading <AnonTechnician> entries");
        }
        ArrayList results = new ArrayList();
        if (technicians != null) {
            Collections.addAll(results, technicians);
        }
        if (anonymousTechnicians != null) {
            Collections.addAll(results, anonymousTechnicians);
        }
        return results.toArray(new TechUser[0]);
    }

    private void appendXmlTag(StringBuffer sb, String tag, String contents) {
        this.appendXmlTag(sb, tag, contents, 1);
    }

    private void appendXmlTag(StringBuffer sb, String tag, String contents, int tabs) {
        this.appendXmlTag(sb, tag, contents, tabs, null, null);
    }

    private void appendXmlTag(StringBuffer sb, String tag, String contents, int tabs, String[] attNames, String[] attValues) {
        int i;
        if (contents == null) {
            return;
        }
        for (i = 0; i < tabs; ++i) {
            sb.append('\t');
        }
        sb.append("<").append(tag);
        if (attNames != null) {
            for (i = 0; i < attNames.length; ++i) {
                String attName = attNames[i];
                String attValue = attValues[i];
                if (attValue != null) {
                    sb.append(" ").append(attName).append("=\"").append(attValue).append("\"");
                    continue;
                }
                sb.append(" ").append(attName);
            }
        }
        if (contents.length() == 0) {
            sb.append("/>\n");
            return;
        }
        sb.append(">");
        char[] cs = contents.toCharArray();
        for (int i2 = 0; i2 < cs.length; ++i2) {
            char c = cs[i2];
            if (c == '&') {
                sb.append("&amp;");
                continue;
            }
            if (c == '<') {
                sb.append("&lt;");
                continue;
            }
            if (c == '>') {
                sb.append("&gt;");
                continue;
            }
            if (c == '\"') {
                sb.append("&quot;");
                continue;
            }
            if (c == '\'') {
                sb.append("&apos;");
                continue;
            }
            sb.append(c);
        }
        sb.append("</").append(tag).append(">\n");
    }

    /*
     * WARNING - void declaration
     */
    public String printConfig() {
        boolean atLeastOneUserHasATOTPKey = false;
        StringBuffer buffer = new StringBuffer();
        if (this.comment != null) {
            buffer.append(this.comment).append("\n");
        }
        if (this.simplehelp) {
            buffer.append("<SimpleHelp>\n");
        } else if (this.simplegateway) {
            buffer.append("<SimpleGateway>\n");
        } else {
            buffer.append("<SimpleSuite>\n");
        }
        buffer.append("\t<ServerFeatures>\n");
        if (this.enabledRemoteAccess) {
            this.appendXmlTag(buffer, "RemoteAccess", "on", 2);
        } else {
            this.appendXmlTag(buffer, "RemoteAccess", "off", 2);
        }
        if (this.enabledRemoteSupport) {
            this.appendXmlTag(buffer, "RemoteSupport", "on", 2);
        } else {
            this.appendXmlTag(buffer, "RemoteSupport", "off", 2);
        }
        if (this.enabledPresentation) {
            this.appendXmlTag(buffer, "Presentation", "on", 2);
        } else {
            this.appendXmlTag(buffer, "Presentation", "off", 2);
        }
        if (this.enabledMobileAccess) {
            this.appendXmlTag(buffer, "MobileAccess", "on", 2);
        } else {
            this.appendXmlTag(buffer, "MobileAccess", "off", 2);
        }
        if (this.enabledServiceRecovery) {
            this.appendXmlTag(buffer, "ServiceRecovery", "on", 2);
        } else {
            this.appendXmlTag(buffer, "ServiceRecovery", "off", 2);
        }
        buffer.append("\t</ServerFeatures>\n");
        if (this.detailFields != null) {
            buffer.append(CUIFieldRepository.fieldsToXML(this.detailFields, 1));
        }
        if (this.logInfo) {
            this.appendXmlTag(buffer, "LogInfo", "On");
        }
        if (this.serverPassword != null) {
            this.appendXmlTag(buffer, "SecurePasswordv2", ServerConfig.getEncryptedPasswordOrNull(this.serverPassword));
        }
        if (this.keystoreStorePassword != null && this.keystoreKeyPassword != null) {
            buffer.append("\t<SslKeystore>\n");
            this.appendXmlTag(buffer, "SecureKeystoreStorePasswordv2", ServerConfig.getEncryptedPasswordOrNull(this.keystoreStorePassword), 2);
            this.appendXmlTag(buffer, "SecureKeystoreKeyPasswordv2", ServerConfig.getEncryptedPasswordOrNull(this.keystoreKeyPassword), 2);
            this.appendXmlTag(buffer, "StoreType", this.keystoreType, 2);
            buffer.append("\t</SslKeystore>\n");
        }
        if (this.portList != null) {
            for (int aPortList : this.portList) {
                this.appendXmlTag(buffer, "Port", "" + aPortList);
            }
        }
        if (this.ipPortPairsList != null) {
            for (int anIpPortPairsList : (Object)this.ipPortPairsList) {
                this.appendXmlTag(buffer, "IpPort", "" + (String)anIpPortPairsList);
            }
        }
        if (this.hostname != null) {
            this.appendXmlTag(buffer, "Hostname", this.hostname);
        }
        if (this.appearWaitMS != 0L) {
            this.appendXmlTag(buffer, "MachineAppearTimeoutMS", "" + this.appearWaitMS);
        }
        if (this.httpHeaders != null) {
            Object object = this.httpHeaders.iterator();
            while (object.hasNext()) {
                HTTPHeader hTTPHeader = (HTTPHeader)object.next();
                this.appendXmlTag(buffer, "HTTPHeader", "", 1, new String[]{"name", "value"}, new String[]{hTTPHeader.name, hTTPHeader.value});
            }
        }
        if (this.blockedURLs != null) {
            for (String string : this.blockedURLs) {
                this.appendXmlTag(buffer, "BlockedURL", string);
            }
        }
        this.appendXmlTag(buffer, "AutoForget", Boolean.toString(this.autoForgetEnabled));
        this.appendXmlTag(buffer, "AutoForgetTimeoutMS", Long.toString(this.autoForgetTimeoutMS));
        buffer.append("\t<Logging>\n");
        this.appendXmlTag(buffer, "Archive", this.archiveLogs ? "on" : "off", 2);
        this.appendXmlTag(buffer, "Compress", this.compressLogs ? "on" : "off", 2);
        this.appendXmlTag(buffer, "MaxPartSize", Long.toString(this.maxLogsFileSize), 2);
        buffer.append("\t</Logging>\n");
        if (this.connectWaitMS != 0L) {
            this.appendXmlTag(buffer, "MachineConnectTimeoutMS", "" + this.connectWaitMS);
        }
        if (this.stopButDontRemoveServices) {
            buffer.append("\t<StopRemoteServicesOnly/>\n");
        }
        if (this.redirectDefaultToWelcomePage) {
            buffer.append("\t<RedirectDefaultUrlToWelcomePage>yes</RedirectDefaultUrlToWelcomePage>\n");
        } else {
            buffer.append("\t<RedirectDefaultUrlToWelcomePage>no</RedirectDefaultUrlToWelcomePage>\n");
        }
        if (this.serverLanguage != null) {
            buffer.append("\t<ServerLanguage>").append(this.serverLanguage).append("</ServerLanguage>\n");
        }
        for (TechGroup group : this.groups) {
            MachineFilter[] machineFilterArray;
            buffer.append("\t<TechnicianGroup>\n");
            this.appendXmlTag(buffer, "ID", "" + group.getGroupID(), 2);
            this.appendXmlTag(buffer, "Name", group.getName(), 2);
            if (group.getHostname() != null && group.getHostname().length() > 0) {
                this.appendXmlTag(buffer, "GroupHostname", group.getHostname(), 2);
            }
            if (group.getDefaultSGServiceName() != null && group.getDefaultSGServiceName().length() > 0) {
                this.appendXmlTag(buffer, "DefaultSimpleGatewayName", group.getDefaultSGServiceName(), 2);
            }
            if (group.getDefaultVideoPassword() != null && group.getDefaultVideoPassword().length() > 0) {
                this.appendXmlTag(buffer, "DefaultRecordingPassword", group.getDefaultVideoPassword(), 2);
            }
            this.appendXmlTag(buffer, "RequestAccessTimeoutMS", Long.toString(group.getRequestAccessTimeout()), 2);
            if (group.allowAnonymousLogins()) {
                this.appendXmlTag(buffer, "AnonymousLogins", "on", 2);
            } else {
                this.appendXmlTag(buffer, "AnonymousLogins", "off", 2);
            }
            if (Switches.SH_appProfiles && group.getAssociatedAppProfileID() != null) {
                this.appendXmlTag(buffer, "AssociatedAppProfileID", group.getAssociatedAppProfileID(), 2);
            }
            buffer.append(group.getPermissions().toXML(2));
            if (group.isMaxFileTransferSizeLimited()) {
                this.appendXmlTag(buffer, "MaxFileSize", "" + group.getMaxFileTransferSize(), 2);
            }
            if (group.isShConcurrencyLimited()) {
                this.appendXmlTag(buffer, "MaxShSessionsGroup", "" + group.getMaxShGroupConcurrency(), 2);
                this.appendXmlTag(buffer, "MaxShSessionsUser", "" + group.getMaxShUserConcurrency(), 2);
            }
            if (group.isSgConcurrencyLimited()) {
                this.appendXmlTag(buffer, "MaxSgSessionsGroup", "" + group.getMaxSgGroupConcurrency(), 2);
                this.appendXmlTag(buffer, "MaxSgSessionsUser", "" + group.getMaxSgUserConcurrency(), 2);
            }
            if (group.isFPSLimited()) {
                this.appendXmlTag(buffer, "FPSDelay", "" + group.getFPSDelay(), 2);
            }
            if (group.isSessionLimited()) {
                this.appendXmlTag(buffer, "SessionSpeedLimit", "" + group.getSessionLimitKbps(), 2);
            }
            if (group.isPassword()) {
                if (group.getPassword() != null) {
                    this.appendXmlTag(buffer, "SecurePasswordv2", ServerConfig.getEncryptedPasswordOrNull(group.getPassword()), 2);
                } else {
                    this.appendXmlTag(buffer, "Password", "", 2);
                }
            }
            if (group.isMultiTierApp()) {
                buffer.append("\t\t<AppAuthentication/>\n");
            }
            if (group.getMultiTierRememberMachine()) {
                buffer.append("\t\t<MultiTierRememberMachine/>\n");
            }
            if (group.isMultiTierEmail()) {
                buffer.append("\t\t<TwoTier>\n");
                this.appendXmlTag(buffer, "CodeLength", Integer.toString(group.getTwoTierCodeLength()), 3);
                if (group.getTwoTierSubject() != null) {
                    this.appendXmlTag(buffer, "EmailSubject", group.getTwoTierSubject(), 3);
                }
                try {
                    if (group.getTwoTierBody() != null) {
                        this.appendXmlTag(buffer, "EmailBody", HexData.byteArrayToHexString(group.getTwoTierBody().getBytes("UTF-8")), 3);
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                buffer.append("\t\t</TwoTier>\n");
            }
            if (group.isLDAP()) {
                buffer.append("\t\t<LDAP>\n");
                if (group.getLDAPProperties() != null) {
                    LDAPProperties props = group.getLDAPProperties();
                    if (props.baseDN != null) {
                        this.appendXmlTag(buffer, "BaseDN", props.baseDN, 3);
                    }
                    if (props.filter != null) {
                        this.appendXmlTag(buffer, "SearchFilter", props.filter, 3);
                    }
                    if (props.groups != null) {
                        buffer.append("\t\t\t<Groups>\n");
                        for (int i = 0; i < props.groups.length; ++i) {
                            this.appendXmlTag(buffer, "Group", props.groups[i], 4);
                        }
                        buffer.append("\t\t\t</Groups>\n");
                    }
                    if (!props.isSimple()) {
                        this.appendXmlTag(buffer, "Advanced", "", 3);
                    }
                }
                buffer.append("\t\t</LDAP>\n");
            }
            if (group.isRadius()) {
                buffer.append("\t\t<RADIUS>yes</RADIUS>\n");
            }
            if (group.getFilterByAllowedGroups()) {
                this.appendXmlTag(buffer, "FilterByMachineGroup", "on", 2);
            } else {
                this.appendXmlTag(buffer, "FilterByMachineGroup", "off", 2);
            }
            ArrayList<ArrayList<String>> allowedGroups = group.getRemoteAccessGroupRestrictions();
            buffer.append("\t\t<AllowedMachineGroups>\n");
            for (ArrayList<String> arrayList : allowedGroups) {
                buffer.append("\t\t\t<AllowedMachineGroup>\n");
                for (String string : arrayList) {
                    this.appendXmlTag(buffer, "Path", string, 4);
                }
                buffer.append("\t\t\t</AllowedMachineGroup>\n");
            }
            buffer.append("\t\t</AllowedMachineGroups>\n");
            CustomerFilter[] customerFilters = group.getCustomerFilters();
            if (customerFilters != null) {
                void var11_45;
                CustomerFilter[] customerFilterArray = customerFilters;
                int n = customerFilterArray.length;
                boolean bl = false;
                while (var11_45 < n) {
                    CustomerFilter filter = customerFilterArray[var11_45];
                    filter.saveToXML(buffer, 2);
                    ++var11_45;
                }
            }
            if ((machineFilterArray = group.getMachineFilters()) != null) {
                for (MachineFilter filter : machineFilterArray) {
                    filter.saveToXML(buffer, 2);
                }
            }
            buffer.append("\t</TechnicianGroup>\n");
        }
        for (TechUser tech : this.technicians) {
            this.saveTechnicianXML(buffer, tech, "Technician");
            if (tech.getTOTPKey() == null || tech.getTOTPKey().isNull()) continue;
            atLeastOneUserHasATOTPKey = true;
        }
        for (TechUser tech : this.anonymousTechnicians) {
            this.saveTechnicianXML(buffer, tech, "AnonTechnician");
            if (tech.getTOTPKey() == null || tech.getTOTPKey().isNull()) continue;
            atLeastOneUserHasATOTPKey = true;
        }
        this.appendXmlTag(buffer, "EndOfSessionOption", this.endOfSessionOption, 1);
        this.appendXmlTag(buffer, "EndOfSessionURL", this.endOfSessionURL, 1);
        this.appendXmlTag(buffer, "EndOfSessionURLSupport", this.endOfSessionURLSupport ? "true" : "false", 1);
        this.appendXmlTag(buffer, "EndOfSessionURLAccess", this.endOfSessionURLAccess ? "true" : "false", 1);
        if (this.elevateSupportSessions) {
            this.appendXmlTag(buffer, "WindowsElevation", "true", 1);
        } else {
            this.appendXmlTag(buffer, "WindowsElevation", "false", 1);
        }
        if (this.techRestrictions != null && this.techRestrictions.length > 0) {
            buffer.append("\n");
            for (PatternWrapper techRestriction : this.techRestrictions) {
                this.appendXmlTag(buffer, "TechRestriction", techRestriction.getRegularExpression());
            }
        }
        if (this.statusPage) {
            buffer.append("\n\t<StatusPage>\n");
            if (this.statusPageIncludeMachines) {
                this.appendXmlTag(buffer, "IncludeMachines", "on", 2);
            } else {
                this.appendXmlTag(buffer, "IncludeMachines", "off", 2);
            }
            if (this.statusPageIncludeSessions) {
                this.appendXmlTag(buffer, "IncludeSessions", "on", 2);
            } else {
                this.appendXmlTag(buffer, "IncludeSessions", "off", 2);
            }
            if (this.statusPageIncludePerformance) {
                this.appendXmlTag(buffer, "IncludePerformance", "on", 2);
            } else {
                this.appendXmlTag(buffer, "IncludePerformance", "off", 2);
            }
            if (this.statusPageRestrictions != null) {
                for (PatternWrapper statusPageRestriction : this.statusPageRestrictions) {
                    this.appendXmlTag(buffer, "StatusPageRestriction", "" + statusPageRestriction, 2);
                }
            }
            buffer.append("\t</StatusPage>\n");
        }
        if (this.serverAdminGroup.getMultiTierRememberMachine()) {
            buffer.append("\n\t<AdminAuthenticationRememberMachine/>\n");
        }
        if (this.serverAdminGroup.isMultiTierApp()) {
            LazyPassword adminAppAuthenticationKey = this.serverAdmin.getTOTPKey();
            if (adminAppAuthenticationKey == null || adminAppAuthenticationKey.isNull()) {
                buffer.append("\n\t<AdminAppAuthentication/>\n");
            } else {
                buffer.append("\n\t<AdminAppAuthentication>\n");
                this.appendXmlTag(buffer, "Keyv2", ServerConfig.getEncryptedPasswordOrNull(adminAppAuthenticationKey), 2);
                buffer.append("\t</AdminAppAuthentication>\n");
                atLeastOneUserHasATOTPKey = true;
            }
        }
        if (this.serverAdminGroup.isMultiTierEmail()) {
            buffer.append("\n\t<AdminTwoTier>\n");
            this.appendXmlTag(buffer, "CodeLength", Integer.toString(this.serverAdminGroup.getTwoTierCodeLength()), 2);
            if (this.serverAdmin.getEmail() != null) {
                this.appendXmlTag(buffer, "EmailAddress", this.serverAdmin.getEmail(), 2);
            }
            if (this.serverAdminGroup.getTwoTierSubject() != null) {
                this.appendXmlTag(buffer, "EmailSubject", this.serverAdminGroup.getTwoTierSubject(), 2);
            }
            try {
                if (this.serverAdminGroup.getTwoTierBody() != null) {
                    this.appendXmlTag(buffer, "EmailBody", HexData.byteArrayToHexString(this.serverAdminGroup.getTwoTierBody().getBytes("UTF-8")), 2);
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            buffer.append("\t</AdminTwoTier>\n");
        }
        if (this.emailSettingsEnabled) {
            buffer.append("\n\t<EmailSettings>\n");
            this.appendXmlTag(buffer, "SmtpHost", this.smtpHost, 2);
            this.appendXmlTag(buffer, "SmtpPort", "" + this.smtpPort, 2);
            if (this.smtpUser != null && this.smtpUser.trim().length() != 0) {
                this.appendXmlTag(buffer, "SmtpUser", this.smtpUser, 2);
                this.appendXmlTag(buffer, "SecureSmtpPassv2", ServerConfig.getEncryptedPasswordOrNull(this.smtpPassword), 2);
            }
            this.appendXmlTag(buffer, "SmtpFromEmail", this.smtpFromEmail, 2);
            this.appendXmlTag(buffer, "SmtpFromName", this.smtpFromName, 2);
            if (this.smtpSSL) {
                this.appendXmlTag(buffer, "SmtpSSL", "On", 2);
            } else {
                this.appendXmlTag(buffer, "SmtpSSL", "Off", 2);
            }
            if (this.smtpTLS) {
                this.appendXmlTag(buffer, "SmtpTLS", "On", 2);
            } else {
                this.appendXmlTag(buffer, "SmtpTLS", "Off", 2);
            }
            if (this.dateFormat != null) {
                this.appendXmlTag(buffer, "DateFormat", this.dateFormat, 2);
            }
            if (this.emailProperties != null) {
                for (Object e : this.emailProperties.keySet()) {
                    String value;
                    String key = (String)e;
                    if (key == null || (value = this.emailProperties.getProperty(key)) == null) continue;
                    buffer.append("\t\t<EmailProperty>\n");
                    this.appendXmlTag(buffer, "Key", key, 3);
                    this.appendXmlTag(buffer, "Value", value, 3);
                    buffer.append("\t\t</EmailProperty>\n");
                }
            }
            buffer.append("\t</EmailSettings>\n");
        }
        if (this.deprecated_anonymousUserIDToTOTPKey.size() > 0) {
            buffer.append("\t<AnonymousTOTPKeys>\n");
            for (String string : this.deprecated_anonymousUserIDToTOTPKey.keySet()) {
                LazyPassword decryptedKey = this.deprecated_anonymousUserIDToTOTPKey.get(string);
                String encryptedKey = ServerConfig.getEncryptedPasswordOrNull(decryptedKey);
                buffer.append("\t\t<KeyEntry>\n");
                XML14Util.appendTextNode(buffer, 3, "User", string);
                XML14Util.appendTextNode(buffer, 3, "TOTPKey", encryptedKey);
                buffer.append("\t\t</KeyEntry>\n");
            }
            buffer.append("\t</AnonymousTOTPKeys>\n");
        }
        if (this.remoteCustomersTechPresence || this.remoteMachinesTechPresence) {
            buffer.append("\n\t<TechnicianPresenceDialog>\n");
            if (this.remoteCustomersTechPresence) {
                this.appendXmlTag(buffer, "RemoteCustomers", "On", 2);
            }
            if (this.remoteMachinesTechPresence) {
                this.appendXmlTag(buffer, "RemoteMachines", "On", 2);
            }
            buffer.append("\t</TechnicianPresenceDialog>\n");
        }
        if (this.radiusEnable) {
            buffer.append("\n");
            buffer.append("\t<RadiusSettings>\n");
            this.appendXmlTag(buffer, "Attempts", String.valueOf(this.radiusAttempts), 2);
            this.appendXmlTag(buffer, "TimeoutMS", String.valueOf(this.radiusTimeout), 2);
            this.appendXmlTag(buffer, "Strategy", String.valueOf(this.radiusStrategy), 2);
            this.appendXmlTag(buffer, "StaggeredTimeoutMS", String.valueOf(this.radiusStaggeredTimeout), 2);
            buffer.append("\t</RadiusSettings>\n");
            if (this.radiusConfigs != null) {
                for (RadiusConfig config : this.radiusConfigs) {
                    buffer.append("\t<RadiusAuthentication id=\"").append(config.index).append("\">\n");
                    this.appendXmlTag(buffer, "RadiusHostname", config.radiusHostname, 2);
                    this.appendXmlTag(buffer, "RadiusSecret", config.radiusSecret, 2);
                    this.appendXmlTag(buffer, "RadiusPort", Integer.toString(config.radiusPort), 2);
                    this.appendXmlTag(buffer, "RadiusAuthenticationProtocol", config.radiusAuthProtocol, 2);
                    buffer.append("\t</RadiusAuthentication>\n");
                }
            }
        }
        if (this.ldapEnable) {
            buffer.append("\n");
            buffer.append("\t<LDAPAuthentication>\n");
            this.appendXmlTag(buffer, "LDAPHostname", this.ldapHostname, 2);
            this.appendXmlTag(buffer, "LDAPPort", "" + this.ldapPort, 2);
            if (this.ldapUsername != null) {
                this.appendXmlTag(buffer, "LDAPUsername", this.ldapUsername, 2);
            }
            if (this.ldapPassword != null) {
                this.appendXmlTag(buffer, "SecureLDAPPasswordv2", ServerConfig.getEncryptedPasswordOrNull(this.ldapPassword), 2);
            }
            if (this.ldapAuthentication != null) {
                this.appendXmlTag(buffer, "AuthenticationMechanism", this.ldapAuthentication, 2);
            }
            if (this.ldapEnableSSL) {
                this.appendXmlTag(buffer, "UseSSL", "", 2);
            }
            if (this.ldapIsAD) {
                this.appendXmlTag(buffer, "IsAD", "", 2);
            }
            this.appendXmlTag(buffer, "UserClass", this.ldapUserClass, 2);
            this.appendXmlTag(buffer, "GroupClass", this.ldapGroupClass, 2);
            this.appendXmlTag(buffer, "LoginAttribute", this.ldapLoginAttribute, 2);
            this.appendXmlTag(buffer, "MemberAttribute", this.ldapMemberAttribute, 2);
            this.appendXmlTag(buffer, "FollowReferrals", Boolean.toString(this.ldapFollowLinks), 2);
            buffer.append("\t</LDAPAuthentication>\n");
        }
        buffer.append("\n");
        buffer.append("\t<SessionSummary>\n");
        if (this.sessionSummaryTechComment) {
            this.appendXmlTag(buffer, "IncludeTechComments", "On", 2);
        }
        if (this.sessionSummaryAllowSkip) {
            this.appendXmlTag(buffer, "SkipAllowed", "On", 2);
        }
        buffer.append("\t\t<EmailSummary>\n");
        if (this.sessionSummaryCustEmail && this.sessionSummaryEmailCustDetail != null) {
            this.appendXmlTag(buffer, "CustomerEmailDetail", this.sessionSummaryEmailCustDetail, 3);
        }
        buffer.append("\t\t</EmailSummary>\n");
        buffer.append("\t</SessionSummary>\n");
        buffer.append("\t<CustomerAuthentication>\n");
        if (this.enabledQueuePassword) {
            buffer.append("\t\t<CustomerPassword>").append(this.queuePassword).append("</CustomerPassword>\n");
        }
        buffer.append("\t</CustomerAuthentication>\n");
        if (this.uPnPPortForwardingEnabled) {
            this.appendXmlTag(buffer, "UPnPPortForwarding", "On", 1);
        }
        if (this.forwardToHTTPS) {
            this.appendXmlTag(buffer, "ForwardHTTPtoHTTPS", "On");
        }
        this.appendXmlTag(buffer, "FailOverCheckURL", this.failoverCheckURL);
        this.appendXmlTag(buffer, "CentralServerURL", this.condenserForURL);
        this.appendXmlTag(buffer, "MachineTimeoutMS", Integer.toString(this.defaultMachineTimeoutMS));
        this.appendXmlTag(buffer, "SecureMessengerRouteMapSize", Integer.toString(this.secureMessengerRouteMapSize));
        if (atLeastOneUserHasATOTPKey) {
            this.appendXmlTag(buffer, "TOTPLength", Integer.toString(this.totpLength));
            this.appendXmlTag(buffer, "TOTPWindowSize", Integer.toString(this.totpWindowSize));
        }
        if (this.feature_showPerformanceMetricsTechConsole) {
            this.appendXmlTag(buffer, "FeaturePerformanceMetrics", "");
        }
        if (this.defaultMaxAudioBitrate > 0) {
            this.appendXmlTag(buffer, "MaxAudioBitrate", Integer.toString(this.defaultMaxAudioBitrate));
        }
        if (this.blockedRemoteAccessMachines != null) {
            for (BlockedRemoteMachine blockedRemoteMachine : this.blockedRemoteAccessMachines) {
                buffer.append("\t<BlockedRemoteMachine>\n");
                this.appendXmlTag(buffer, "ID", blockedRemoteMachine.machineID, 2);
                this.appendXmlTag(buffer, "Name", blockedRemoteMachine.name.toString(), 2);
                buffer.append("\t</BlockedRemoteMachine>\n");
            }
        }
        if (this.simplehelp) {
            buffer.append("</SimpleHelp>\n");
        } else if (this.simplegateway) {
            buffer.append("</SimpleGateway>\n");
        } else {
            buffer.append("</SimpleSuite>\n");
        }
        return buffer.toString();
    }

    private void saveTechnicianXML(StringBuffer buffer, TechUser tech, String tag) {
        MachineFilter[] machineFilters;
        CustomerFilter[] customerFilters;
        buffer.append("\t<" + tag + ">\n");
        this.appendXmlTag(buffer, "ID", "" + tech.uniqueID, 2);
        this.appendXmlTag(buffer, "Name", tech.getDefaultName(), 2);
        this.appendXmlTag(buffer, "Login", tech.getLogin(), 2);
        this.appendXmlTag(buffer, "SecurePasswordv2", ServerConfig.getEncryptedPasswordOrNull(tech.getPassword()), 2);
        this.appendXmlTag(buffer, "TOTPKeyv2", ServerConfig.getEncryptedPasswordOrNull(tech.getTOTPKey()), 2);
        if (Switches.SH_appProfiles) {
            if (tech.isForAppProfilesOnly()) {
                this.appendXmlTag(buffer, "AppProfilesOnly", "on", 2);
            } else {
                this.appendXmlTag(buffer, "AppProfilesOnly", "off", 2);
            }
        }
        if (tech.allowLocallyAuthenticatedLogins()) {
            this.appendXmlTag(buffer, "AllowLocallyAuthenticatedLogin", "on", 2);
        } else {
            this.appendXmlTag(buffer, "AllowLocallyAuthenticatedLogin", "off", 2);
        }
        if (tech.isAccountEnabled()) {
            this.appendXmlTag(buffer, "Enabled", "on", 2);
        } else {
            this.appendXmlTag(buffer, "Enabled", "off", 2);
        }
        String email = tech.getEmail();
        if (email != null && email.trim().length() > 0) {
            this.appendXmlTag(buffer, "Email", email, 2);
        }
        if ((customerFilters = tech.getCustomerFilters()) != null) {
            for (CustomerFilter filter : customerFilters) {
                filter.saveToXML(buffer, 2);
            }
        }
        if ((machineFilters = tech.getMachineFilters()) != null) {
            for (MachineFilter filter : machineFilters) {
                filter.saveToXML(buffer, 2);
            }
        }
        HashSet mergedGroups = new HashSet();
        Collections.addAll(mergedGroups, tech.groups);
        Collections.addAll(mergedGroups, tech.groupsUserCanAdmin);
        for (TechGroup group : mergedGroups) {
            boolean isAdmin = tech.isGroupAdminFor(group);
            boolean isMember = tech.isInGroup(group);
            if (isMember && isAdmin) {
                this.appendXmlTag(buffer, "GroupIDMemberOf", Integer.toString(group.getGroupID()), 2, new String[]{"admin"}, new String[]{"yes"});
                continue;
            }
            if (isAdmin) {
                this.appendXmlTag(buffer, "GroupIDMemberOf", Integer.toString(group.getGroupID()), 2, new String[]{"member", "admin"}, new String[]{"no", "yes"});
                continue;
            }
            if (!isMember) continue;
            this.appendXmlTag(buffer, "GroupIDMemberOf", Integer.toString(group.getGroupID()), 2);
        }
        buffer.append("\t</" + tag + ">\n");
    }

    public void saveToMessage(ProxyServerAPI proxyApi, Message ret, boolean readConfigFiles) {
        this.pruneUnusedProfileGroups(proxyApi);
        ret.append(this.printConfig());
        if (readConfigFiles) {
            ret.append(ServerConfig.loadDisclaimer());
        } else {
            ret.append(this.disclaimer);
        }
        if (ServerManagement.isServerJVM()) {
            TechGroup[] all;
            TypedMap profileNames = new TypedMap();
            TypedMap profileTypeNames = new TypedMap();
            for (TechGroup group : all = this.groups) {
                AppProfile profile;
                String profileID = group.getAssociatedAppProfileID();
                if (profileID == null || (profile = proxyApi.getAppProfile(profileID)) == null) continue;
                profileNames.setString(profileID, profile.getName());
                profileTypeNames.setString(profileID, profile.getType().getName());
            }
            Message m = profileNames.toCompressedMessage();
            m.setType(9900001);
            ret.append(m);
            m = profileTypeNames.toCompressedMessage();
            m.setType(9900002);
            ret.append(m);
        } else {
            ret.append(new Message(9900001));
            ret.append(new Message(9900002));
        }
    }

    private void pruneUnusedProfileGroups(ProxyServerAPI proxyApi) {
        if (ServerManagement.isServerJVM()) {
            ArrayList<TechGroup> allGroups = new ArrayList<TechGroup>();
            for (TechGroup group : this.groups) {
                AppProfile profile;
                String profileID = group.getAssociatedAppProfileID();
                if (profileID != null && (profile = proxyApi.getAppProfile(profileID)) == null) continue;
                allGroups.add(group);
            }
            this.groups = allGroups.toArray(new TechGroup[0]);
        }
    }

    public void fromMessage(Message m, boolean saveConfigFiles) throws DOMException, IOException, ParserConfigurationException, SAXException, ServerStartFailureException {
        String profileID;
        String configuration = (String)m.get(0);
        this.loadConfig(configuration);
        TypedMap profileNames = null;
        TypedMap profileTypeNames = null;
        for (int i = 0; i < m.length(); ++i) {
            if (m.getType(i) != 4) continue;
            Message tmp = m.getAsMessage(i);
            boolean mustpop = true;
            if (tmp.getType() == 9900001) {
                if (tmp.length() > 0) {
                    profileNames = TypedMap.fromCompressedMessage(tmp);
                }
            } else if (tmp.getType() == 9900002) {
                if (tmp.length() > 0) {
                    profileTypeNames = TypedMap.fromCompressedMessage(tmp);
                }
            } else {
                mustpop = false;
            }
            if (!mustpop) continue;
            m.remove(i--);
        }
        if (profileNames != null) {
            TechGroup[] techGroupArray = this.groups;
            int n = techGroupArray.length;
            for (int i = 0; i < n; ++i) {
                TechGroup group = techGroupArray[i];
                profileID = group.getAssociatedAppProfileID();
                if (profileID == null) continue;
                String profileName = profileNames.getString(profileID);
                group.setTransientAppProfileName(profileName);
            }
        }
        if (profileTypeNames != null) {
            for (TechGroup group : this.groups) {
                profileID = group.getAssociatedAppProfileID();
                if (profileID == null) continue;
                String profileTypeName = profileTypeNames.getString(profileID);
                group.setTransientAppProfileTypeName(profileTypeName);
            }
        }
        if (m.length() > 1) {
            this.disclaimer = (String)m.get(1);
        }
        if (saveConfigFiles) {
            ServerConfig.saveDisclaimer(this.disclaimer);
        }
    }

    private static String loadDisclaimer() {
        try {
            File file = new File("configuration/simplehelpdisclaimer.txt");
            File oldFile = new File("DEPLOY/simplehelpdisclaimer.txt");
            if (oldFile.exists() && !file.exists()) {
                System.out.println("[ServerConfig] Found legacy disclaimer in DEPLOY. Moving to configuration folder.");
                oldFile.renameTo(file);
            }
            if (!file.exists()) {
                if (!TEST_LOAD) {
                    FileOutputStream fout = new FileOutputStream(file);
                    fout.write(DefaultConfiguration.DEFAULT_DISCLAIMER.getBytes("UTF-8"));
                    fout.close();
                }
                return DefaultConfiguration.DEFAULT_DISCLAIMER;
            }
            FileInputStream fin = new FileInputStream(file);
            String result = StreamUtils.readAllAsStringUTF8(fin);
            fin.close();
            return result;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return "";
        }
    }

    private static String loadDeprecatedDetails() {
        try {
            File file = new File("configuration/simplehelpdetails.txt");
            File oldFile = new File("DEPLOY/simplehelpdetails.txt");
            if (oldFile.exists() && !file.exists()) {
                System.out.println("[ServerConfig] Found legacy details in DEPLOY. Moving to configuration folder.");
                oldFile.renameTo(file);
            }
            if (file.exists()) {
                FileInputStream fin = new FileInputStream(file);
                String result = StreamUtils.readAllAsStringUTF8(fin);
                fin.close();
                result = "Name\n" + result;
                return result;
            }
            return null;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    private static void deleteDeprecatedDetails() {
        try {
            File file = new File("configuration/simplehelpdetails.txt");
            if (file.exists()) {
                file.delete();
            }
        }
        finally {
            File oldFile = new File("DEPLOY/simplehelpdetails.txt");
            if (oldFile.exists()) {
                oldFile.delete();
            }
        }
    }

    private static void saveDisclaimer(String disclaimer2) {
        try {
            File file = new File("configuration/simplehelpdisclaimer.txt");
            FileOutputStream fout = new FileOutputStream(file);
            fout.write(disclaimer2.getBytes("UTF8"));
            fout.flush();
            fout.close();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public byte[] getCommonTechnicianProps() throws IOException {
        Properties props = new Properties();
        boolean isAdvancedSessionSummaryRequired = this.sessionSummaryTechComment;
        props.put("simplesuite_" + ServerProperties.PROP_SS_ENABLE, isAdvancedSessionSummaryRequired ? "true" : "false");
        props.put("simplesuite_" + ServerProperties.PROP_SS_TECH_COMMENT, this.sessionSummaryTechComment ? "true" : "false");
        props.put("simplesuite_" + ServerProperties.PROP_SS_ALLOW_SKIP, this.sessionSummaryAllowSkip ? "true" : "false");
        props.put("simplesuite_" + ServerProperties.PROP_SS_CUSTOM_EMAIL, this.sessionSummaryCustEmail ? "true" : "false");
        if (this.sessionSummaryEmailCustDetail != null) {
            props.put("simplesuite_" + ServerProperties.PROP_SS_CUSTOM_EMAIL_DETAIL, this.sessionSummaryEmailCustDetail);
        } else {
            props.put("simplesuite_" + ServerProperties.PROP_SS_CUSTOM_EMAIL_DETAIL, "");
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        GZIPOutputStream gout = new GZIPOutputStream(bout);
        props.store(gout, "SimpleSuite Properties");
        gout.finish();
        gout.close();
        return bout.toByteArray();
    }

    public boolean isDefaultPassword() {
        if (this.serverPassword == null) {
            return true;
        }
        String password = this.serverPassword.getDecryptedPassword();
        return password == null || password.length() == 0 || "password".equalsIgnoreCase(password);
    }

    public static boolean isDefaultPassword(LazyPassword password) {
        if (password == null) {
            return true;
        }
        return password.getDecryptedPassword().length() == 0 || "password".equalsIgnoreCase(password.getDecryptedPassword());
    }

    public TechGroup getGroupByName(String name) {
        if (this.groups == null || name == null) {
            return null;
        }
        for (TechGroup group : this.groups) {
            if (!group.getName().equals(name)) continue;
            return group;
        }
        if (this.serverAdminGroup.getName().equals(name)) {
            return this.serverAdminGroup;
        }
        return null;
    }

    public int getRelevantGroupCount() {
        String groups = this.getGroupListAsString();
        if (groups == null || groups.length() == 0) {
            return 0;
        }
        groups = groups.replaceAll("\\\\,", "");
        return groups.split(",").length;
    }

    public String getGroupListAsString() {
        boolean include = false;
        StringBuilder buffer = new StringBuilder();
        for (TechGroup group1 : this.groups) {
            TechUser[] technicians;
            if (group1.getAssociatedAppProfileID() != null) continue;
            for (TechUser tech : technicians = ServerConfig.get().technicians) {
                if (!tech.isInGroup(group1) || tech.groups.length < 2) continue;
                include = true;
                break;
            }
            if (include || !group1.allowAnonymousLogins() || !group1.isLDAP() && !group1.isPassword()) continue;
            include = true;
        }
        if (include) {
            for (TechGroup group : this.groups) {
                if (group.getAssociatedAppProfileID() != null) continue;
                if (buffer.length() > 0) {
                    buffer.append(",");
                }
                buffer.append(group.getName().replaceAll(",", "\\,"));
            }
        }
        return buffer.toString();
    }

    public TechUser getTechnicianByID(int techUserID) {
        if (techUserID == 0) {
            return ServerConfig.get().serverAdmin;
        }
        for (TechUser technician : this.technicians) {
            if (technician.getUserID() != techUserID) continue;
            return technician;
        }
        for (TechUser technician : this.anonymousTechnicians) {
            if (technician.getUserID() != techUserID) continue;
            return technician;
        }
        return null;
    }

    public TechUser getTechUserByUsername(String username) {
        if (username == null || username.equals(OemBranding.OEM_ADMIN_USERNAME)) {
            return this.serverAdmin;
        }
        for (TechUser technician : this.technicians) {
            if (!technician.getLogin().equals(username)) continue;
            return technician;
        }
        for (TechUser technician : this.anonymousTechnicians) {
            if (!technician.getLogin().equals(username)) continue;
            return technician;
        }
        return null;
    }

    public int getTechnicianID() {
        return this.getUniqueID(1, 1000000);
    }

    public int getTechnicianGroupID() {
        return this.getUniqueID(1000001, 2000000);
    }

    public static boolean isTechnicianID(int id) {
        return id >= 0 && id <= 1000000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getUniqueID(int min, int max) {
        Random random = ServerConfig.random;
        synchronized (random) {
            int next = -1;
            while (next == -1) {
                int i;
                next = Math.abs(ServerConfig.random.nextInt(max - min)) + min;
                for (i = 0; i < this.technicians.length && next != -1; ++i) {
                    if (this.technicians[i].uniqueID != next) continue;
                    next = -1;
                }
                for (i = 0; i < this.anonymousTechnicians.length && next != -1; ++i) {
                    if (this.anonymousTechnicians[i].uniqueID != next) continue;
                    next = -1;
                }
                for (i = 0; i < this.groups.length && next != -1; ++i) {
                    if (this.groups[i].getGroupID() != next) continue;
                    next = -1;
                }
            }
            return next;
        }
    }

    public TechGroup getGroupByID(int id) {
        if (this.groups == null) {
            return null;
        }
        for (TechGroup group : this.groups) {
            if (group.getGroupID() != id) continue;
            return group;
        }
        return null;
    }

    public String getHostname(MergedTechGroup loggedInContext) {
        if (loggedInContext == null) {
            return this.hostname;
        }
        if (loggedInContext.getHostname() == null || loggedInContext.getHostname().length() == 0) {
            return this.hostname;
        }
        return loggedInContext.getHostname();
    }

    public CommonEmailer getCommonEmailerUsingSettings(String fromAddress) {
        CommonEmailer.Settings settings = new CommonEmailer.Settings(this.smtpHost, "" + this.smtpPort, this.smtpAuthentication, this.smtpTLS, this.smtpSSL, this.emailProperties);
        return new HtmlEmailer(settings, this.smtpUser, this.smtpPassword.getDecryptedPassword(), fromAddress, "UTF-8");
    }

    public CommonEmailer getCommonEmailerUsingSettings() {
        return this.getCommonEmailerUsingSettings("\"" + this.smtpFromName + "\" <" + this.smtpFromEmail + ">");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CUIField[] getDetails() {
        Object object = this.detailFieldsLock;
        synchronized (object) {
            return this.detailFields;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDetails(CUIField[] fields) {
        Object object = this.detailFieldsLock;
        synchronized (object) {
            this.detailFields = fields;
            this.detailFieldsXML = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDetailsAsXML() {
        Object object = this.detailFieldsLock;
        synchronized (object) {
            if (this.detailFieldsXML == null) {
                this.detailFieldsXML = CUIFieldRepository.fieldsToXML(this.detailFields, 0);
            }
            return this.detailFieldsXML;
        }
    }

    public boolean isTechAllowed(String incomingIp) {
        PatternWrapper[] techIps = ServerConfig.get().techRestrictions;
        if (techIps == null || techIps.length == 0) {
            return true;
        }
        for (PatternWrapper techIp : techIps) {
            if (!techIp.getPattern().matcher(incomingIp).matches()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBlockedMachine(Machine machine) {
        ServerConfig serverConfig = this;
        synchronized (serverConfig) {
            String id = machine.getMachineID();
            BlockedRemoteMachine newBlockedMachine = new BlockedRemoteMachine();
            newBlockedMachine.machineID = id;
            newBlockedMachine.name = machine.getMachineName();
            if (this.blockedRemoteAccessMachines == null) {
                this.blockedRemoteAccessMachines = new ArrayList<BlockedRemoteMachine>();
                this.blockedRemoteAccessMachines.add(newBlockedMachine);
            } else {
                for (int i = 0; i < this.blockedRemoteAccessMachines.size(); ++i) {
                    BlockedRemoteMachine existing = this.blockedRemoteAccessMachines.get(i);
                    if (existing.machineID.compareTo(id) == 0) {
                        return;
                    }
                    if (existing.machineID.compareTo(id) <= 0) continue;
                    this.blockedRemoteAccessMachines.add(i, newBlockedMachine);
                    return;
                }
                this.blockedRemoteAccessMachines.add(newBlockedMachine);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMachineBlocked(String machineID) {
        ServerConfig serverConfig = this;
        synchronized (serverConfig) {
            if (this.blockedRemoteAccessMachines == null || machineID == null) {
                return false;
            }
            for (BlockedRemoteMachine blockedMachine : this.blockedRemoteAccessMachines) {
                if (blockedMachine.machineID == null || !blockedMachine.machineID.equals(machineID)) continue;
                return true;
            }
            return false;
        }
    }

    public boolean isValidTwoTierAdminConfiguration() {
        return this.serverAdminGroup.isValidTwoTierConfiguration() && this.serverAdmin.getEmail() != null && this.serverAdmin.getEmail().length() > 0;
    }

    public boolean isValidTechID(int intValue) {
        TechUser user = this.getTechnicianByID(intValue);
        return user != null;
    }

    public TechUser[] getUsersInGroup(int groupID) {
        ArrayList<TechUser> users = new ArrayList<TechUser>();
        TechGroup group = this.getGroupByID(groupID);
        for (TechUser tech : this.technicians) {
            if (!tech.isInGroup(group.getGroupID())) continue;
            users.add(tech);
        }
        return users.toArray(new TechUser[0]);
    }

    public ToolBoxGroup getToolBoxGroupFor(ToolBoxGroupRef groupRef) {
        TechUser user = this.getTechnicianByID(groupRef.techUserID);
        if (user == null) {
            return null;
        }
        ToolBox toolBoxFor = ToolBoxRegistry.INSTANCE.getToolBoxFor(user);
        if (toolBoxFor != null) {
            ToolBoxGroup group = toolBoxFor.getGroupByID(groupRef.groupID);
            if (group != null) {
                group.setSharedToolboxOwnerID(user.getDefaultName(), user.uniqueID);
                return group;
            }
            System.out.println("[ServerConfig] Cannot find toolbox group " + groupRef.groupID);
        }
        return null;
    }

    public boolean isListeningOnPort(int port) {
        for (int p : this.portList) {
            if (p != port) continue;
            return true;
        }
        return false;
    }

    public TOTPConfig getTOTPConfig() {
        return new TOTPConfig(this.totpLength, this.totpWindowSize);
    }

    public LazyPassword removeAnonymousUserTOTPKey(TechUser user, int groupID) {
        return this.deprecated_anonymousUserIDToTOTPKey.get(this.getAnonymousUserTOTPKeyID(user, groupID));
    }

    private String getAnonymousUserTOTPKeyID(TechUser user, int groupID) {
        if (user == null) {
            return null;
        }
        return user.getLogin() + " - " + groupID;
    }

    public String getLDAPMemberAttribute() {
        if (this.ldapIsAD) {
            return "memberof";
        }
        if (this.ldapMemberAttribute == null || this.ldapMemberAttribute.length() == 0) {
            return "memberof";
        }
        return this.ldapMemberAttribute;
    }

    public String getLDAPUserClass() {
        if (this.ldapIsAD) {
            return "user";
        }
        if (this.ldapUserClass == null || this.ldapUserClass.length() == 0) {
            return "user";
        }
        return this.ldapUserClass;
    }

    public String getLDAPGroupClass() {
        if (this.ldapIsAD) {
            return "group";
        }
        if (this.ldapGroupClass == null || this.ldapGroupClass.length() == 0) {
            return "group";
        }
        return this.ldapGroupClass;
    }

    public String getLDAPLogin() {
        if (this.ldapIsAD) {
            return "sAMAccountName";
        }
        if (this.ldapLoginAttribute == null || this.ldapLoginAttribute.length() == 0) {
            return "uid";
        }
        return this.ldapLoginAttribute;
    }

    public void setLDAPMemberAttribute(String LDAPMemberAttribute) {
        this.ldapMemberAttribute = LDAPMemberAttribute;
    }

    public void setLDAPLoginAttribute(String LDAPLoginAttribute) {
        this.ldapLoginAttribute = LDAPLoginAttribute;
    }

    public void setLDAPGroupClass(String LDAPGroupClass) {
        this.ldapGroupClass = LDAPGroupClass;
    }

    public TechUser registerAnonymousTechnician(TechUser techUser) {
        for (TechUser user : this.anonymousTechnicians) {
            if (!user.getLogin().equals(techUser.getLogin()) || !user.getGroups()[0].equals(techUser.getGroups()[0])) continue;
            return user;
        }
        System.out.println("[ServerConfig] Registering technician login for " + techUser.getLogin() + " / " + techUser.getGroupsAsString());
        techUser.uniqueID = -1;
        TechUser[] newSize = new TechUser[this.anonymousTechnicians.length + 1];
        System.arraycopy(this.anonymousTechnicians, 0, newSize, 0, this.anonymousTechnicians.length);
        newSize[newSize.length - 1] = techUser;
        this.anonymousTechnicians = newSize;
        techUser.uniqueID = this.getTechnicianID();
        techUser.setTOTPKey(ServerConfig.get().removeAnonymousUserTOTPKey(techUser, techUser.getGroups()[0].getGroupID()));
        try {
            ServerConfig.get().saveToDefaultFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return techUser;
    }

    public long getLastLoadTime() {
        return this.loadTime;
    }

    public static ServerConfig getTrimmedConfig(TechGroup[] groupsUserCanAdmin) {
        ServerConfig newConfig = new ServerConfig();
        ArrayList<TechUser> techniciansToAdminister = new ArrayList<TechUser>();
        block0: for (TechUser technician : ServerConfig.get().technicians) {
            for (TechGroup adminGroup : groupsUserCanAdmin) {
                if (!technician.isInGroup(adminGroup)) continue;
                techniciansToAdminister.add(technician);
                continue block0;
            }
        }
        block2: for (TechUser technician : ServerConfig.get().anonymousTechnicians) {
            for (TechGroup adminGroup : groupsUserCanAdmin) {
                if (!technician.isInGroup(adminGroup)) continue;
                techniciansToAdminister.add(technician);
                continue block2;
            }
        }
        newConfig.technicians = techniciansToAdminister.toArray(new TechUser[0]);
        newConfig.groups = groupsUserCanAdmin;
        return newConfig;
    }

    public void overwriteTechniciansInGroups(TechGroup[] groupsUserCanAdmin, TechUser[] newTechnicians, TechUser[] newAnonymousTechnicians) {
        this.technicians = this.overwriteTechniciansInGroupsStatic(groupsUserCanAdmin, this.technicians, newTechnicians);
        this.anonymousTechnicians = this.overwriteTechniciansInGroupsStatic(groupsUserCanAdmin, this.anonymousTechnicians, newAnonymousTechnicians);
    }

    private static boolean isInGroups(TechUser user, TechGroup[] groups) {
        for (TechGroup group : groups) {
            if (!user.isInGroup(group)) continue;
            return true;
        }
        return false;
    }

    private TechUser[] overwriteTechniciansInGroupsStatic(TechGroup[] groupsUserCanAdmin, TechUser[] technicians, TechUser[] newTechnicians) {
        ArrayList<TechUser> result = new ArrayList<TechUser>();
        for (TechUser existingTechnician : technicians) {
            if (ServerConfig.isInGroups(existingTechnician, groupsUserCanAdmin)) continue;
            result.add(existingTechnician);
        }
        Collections.addAll(result, newTechnicians);
        return result.toArray(new TechUser[0]);
    }

    public static class ServerStartFailureException
    extends Exception {
        public ServerStartFailureException(String string, Exception e) {
            super(string, e);
        }
    }

    public static class RadiusConfig
    implements MultiServerPanel.ServerConfiguration {
        public int index;
        public String radiusHostname = null;
        public String radiusSecret = null;
        public int radiusPort = 1812;
        public String radiusAuthProtocol = null;

        @Override
        public String getSummary() {
            return this.radiusHostname;
        }

        public void fromMessage(Message m) {
            this.radiusHostname = m.getNextString();
            this.radiusSecret = m.getNextString();
            this.radiusPort = m.getNextInt();
            this.radiusAuthProtocol = m.getNextString();
        }

        public Message toMessage() {
            Message m = new Message();
            m.append(this.radiusHostname);
            m.append(this.radiusSecret);
            m.append(this.radiusPort);
            m.append(this.radiusAuthProtocol);
            return m;
        }
    }

    public class HTTPHeader {
        public final String name;
        public final String value;

        public HTTPHeader(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }

    public static class BlockedRemoteMachine {
        public MachineName name;
        public String machineID;

        public String toString() {
            return this.name.toString();
        }
    }
}

