/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.config;

import com.aem.shelp.proxy.TechGroupPermissions;
import com.aem.shelp.proxy.config.TechGroup;
import java.util.Arrays;
import java.util.Iterator;

public class MergedTechGroup
implements Iterable<TechGroup> {
    private TechGroup[] groups;
    private TechGroupPermissions mergedPermissions = null;

    public static MergedTechGroup createMergedGroup(TechGroup[] groups) {
        return new MergedTechGroup(groups);
    }

    public boolean equals(Object o) {
        if (o instanceof MergedTechGroup) {
            MergedTechGroup group = (MergedTechGroup)o;
            return Arrays.equals(this.groups, group.groups);
        }
        return false;
    }

    public MergedTechGroup(TechGroup[] groups) {
        if (groups == null) {
            groups = new TechGroup[]{};
        }
        this.groups = groups;
        if (groups.length > 0) {
            for (TechGroup group : groups) {
                this.mergedPermissions = this.mergedPermissions == null ? group.getPermissions() : this.mergedPermissions.mergeWithAndCopy(group.getPermissions());
            }
        } else {
            this.mergedPermissions = new TechGroupPermissions();
        }
    }

    public long getRequestAccessTimeout() {
        long minTimeout = 0L;
        for (TechGroup group : this.groups) {
            long groupTimeout = group.getRequestAccessTimeout();
            if (groupTimeout <= 0L) continue;
            minTimeout = minTimeout == 0L ? groupTimeout : Math.min(groupTimeout, minTimeout);
        }
        return minTimeout;
    }

    public boolean isSessionLimited() {
        if (this.groups == null) {
            return false;
        }
        for (TechGroup group : this.groups) {
            if (group.isSessionLimited()) continue;
            return false;
        }
        return true;
    }

    public boolean isFPSLimited() {
        if (this.groups == null) {
            return false;
        }
        for (TechGroup group : this.groups) {
            if (group.isFPSLimited()) continue;
            return false;
        }
        return true;
    }

    public long getFPSDelay() {
        long min = -1L;
        if (this.groups == null) {
            return min;
        }
        for (TechGroup group : this.groups) {
            if (!group.isFPSLimited()) {
                return -1L;
            }
            long fpsDelay = group.getFPSDelay();
            min = min == -1L ? fpsDelay : Math.min(min, fpsDelay);
        }
        return min;
    }

    public int getSessionLimitKbps() {
        int max = -1;
        if (this.groups == null) {
            return max;
        }
        for (TechGroup group : this.groups) {
            if (!group.isSessionLimited()) {
                return -1;
            }
            max = Math.max(max, group.getSessionLimitKbps());
        }
        return max;
    }

    public boolean isShConcurrencyLimited() {
        if (this.groups == null) {
            return false;
        }
        for (TechGroup group : this.groups) {
            if (group.isShConcurrencyLimited()) continue;
            return false;
        }
        return true;
    }

    public boolean isSgConcurrencyLimited() {
        if (this.groups == null) {
            return false;
        }
        for (TechGroup group : this.groups) {
            if (group.isSgConcurrencyLimited()) continue;
            return false;
        }
        return true;
    }

    public boolean isMaxFileTransferSizeLimited() {
        if (this.groups == null) {
            return false;
        }
        for (TechGroup group : this.groups) {
            if (group.isMaxFileTransferSizeLimited()) continue;
            return false;
        }
        return true;
    }

    public long getMaxFileTransferSize() {
        long max = -1L;
        if (this.groups == null) {
            return max;
        }
        for (TechGroup group : this.groups) {
            if (!group.isMaxFileTransferSizeLimited()) {
                return -1L;
            }
            max = Math.max(max, group.getMaxFileTransferSize());
        }
        return max;
    }

    public int getMaxShGroupConcurrency() {
        int max = -1;
        if (this.groups == null) {
            return max;
        }
        for (TechGroup group : this.groups) {
            if (group.getMaxShGroupConcurrency() == -1) {
                return -1;
            }
            max = Math.max(max, group.getMaxShGroupConcurrency());
        }
        return max;
    }

    public int getMaxShUserConcurrency() {
        int max = -1;
        if (this.groups == null) {
            return max;
        }
        for (TechGroup group : this.groups) {
            if (group.getMaxShUserConcurrency() == -1) {
                return -1;
            }
            max = Math.max(max, group.getMaxShUserConcurrency());
        }
        return max;
    }

    public int getMaxSgGroupConcurrency() {
        int max = -1;
        if (this.groups == null) {
            return max;
        }
        for (TechGroup group : this.groups) {
            if (group.getMaxSgGroupConcurrency() == -1) {
                return -1;
            }
            max = Math.max(max, group.getMaxSgGroupConcurrency());
        }
        return max;
    }

    public int getMaxSgUserConcurrency() {
        int max = -1;
        if (this.groups == null) {
            return max;
        }
        for (TechGroup group : this.groups) {
            if (group.getMaxSgUserConcurrency() == -1) {
                return -1;
            }
            max = Math.max(max, group.getMaxSgUserConcurrency());
        }
        return max;
    }

    public String toString() {
        if (this.groups != null) {
            return "Group " + Arrays.toString(this.groups);
        }
        return "Group []";
    }

    public TechGroupPermissions getPermissions() {
        return this.mergedPermissions;
    }

    public String getHostname() {
        for (TechGroup group : this.groups) {
            String hostname = group.getHostname();
            if (hostname == null) continue;
            return hostname;
        }
        return null;
    }

    public String getDefaultSGServiceName() {
        for (TechGroup group : this.groups) {
            String hostname = group.getDefaultSGServiceName();
            if (hostname == null) continue;
            return hostname;
        }
        return null;
    }

    public String getDefaultVideoPassword() {
        for (TechGroup group : this.groups) {
            String hostname = group.getDefaultVideoPassword();
            if (hostname == null) continue;
            return hostname;
        }
        return null;
    }

    @Override
    public Iterator<TechGroup> iterator() {
        return Arrays.asList(this.groups).iterator();
    }

    public boolean containsGroupByName(String group) {
        for (TechGroup g : this.groups) {
            if (!g.getName().equalsIgnoreCase(group)) continue;
            return true;
        }
        return false;
    }

    public boolean containsGroupByID(String ID) {
        for (TechGroup g : this.groups) {
            if (!Integer.toString(g.getGroupID()).equals(ID)) continue;
            return true;
        }
        return false;
    }

    public boolean containsGroupByIntID(int ID) {
        for (TechGroup g : this.groups) {
            if (g.getGroupID() != ID) continue;
            return true;
        }
        return false;
    }

    public TechGroup getFirstGroup() {
        return this.groups[0];
    }

    public boolean requiresAppAuthentication() {
        for (TechGroup g : this.groups) {
            if (!g.isMultiTierApp()) continue;
            return true;
        }
        return false;
    }

    public boolean requiresEmailAuthentication() {
        for (TechGroup g : this.groups) {
            if (!g.isMultiTierEmail()) continue;
            return true;
        }
        return false;
    }

    public boolean allowedToUseMFAKeyForApp() {
        for (TechGroup g : this.groups) {
            if (!g.isMultiTierApp() || !g.getMultiTierRememberMachine()) continue;
            return true;
        }
        return false;
    }

    public boolean allowedToUseMFAKeyForEmail() {
        for (TechGroup g : this.groups) {
            if (!g.isMultiTierEmail() || !g.getMultiTierRememberMachine()) continue;
            return true;
        }
        return false;
    }

    public TechGroup getGroupForEmailAuthentication() {
        for (TechGroup g : this.groups) {
            if (!g.isMultiTierEmail()) continue;
            return g;
        }
        return null;
    }

    public int[] getGroupIDs() {
        int[] result = new int[this.groups.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.groups[i].getGroupID();
        }
        return result;
    }

    public String[] getGroupNames() {
        String[] result = new String[this.groups.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.groups[i].getName();
        }
        return result;
    }

    public boolean canAdministerServer() {
        for (TechGroup group : this.groups) {
            if (!group.getPermissions().canAdminServer()) continue;
            return true;
        }
        return false;
    }
}

