/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.common;

import com.aem.shelp.common.toolbox.ToolBoxItem;
import com.aem.shelp.common.toolbox.ToolBoxResource;
import com.aem.shelp.common.toolbox.ToolBoxUIInterface;
import com.aem.shelp.mdupload.fs.AbstractTechFS;
import com.aem.shelp.mdupload.fs.FSMirror;
import com.aem.shelp.mdupload.fs.FSUtils;
import com.aem.shelp.mdupload.fs.GFile;
import com.aem.shelp.mdupload.fs.LocalFS;
import com.aem.shelp.mdupload.fs.TechClientFS;
import com.aem.shelp.proxy.techclient.TechClient;
import java.io.File;
import java.util.ArrayList;
import utils.files.FileUtil;

public class ToolBoxConstants {
    private static final File RESOURCES_FOLDER = new File("configuration/toolbox-resources");

    public static File getToolBoxItemFolder(String itemID) {
        return new File(RESOURCES_FOLDER, itemID);
    }

    public static File getResourceFile(String itemID, String resourceID) {
        File itemFolder = ToolBoxConstants.getToolBoxItemFolder(itemID);
        File resourceFile = new File(itemFolder, resourceID);
        return resourceFile;
    }

    public static File getResourcesFile(File toolboxFolder, ToolBoxResource resource) {
        return new File(toolboxFolder, resource.getID());
    }

    public static void syncResourcesHeadless(AbstractTechFS serverFS, ToolBoxItem item) {
        ToolBoxConstants.syncResources(serverFS, null, item, null);
    }

    public static void syncResources(TechClient techClient, ToolBoxUIInterface toolBoxUI, ToolBoxItem item, FSMirror.ProgressListener listener) {
        TechClientFS techFS = new TechClientFS(techClient, "SG_Server");
        ToolBoxConstants.syncResources(techFS, toolBoxUI, item, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void syncResources(AbstractTechFS serverFS, ToolBoxUIInterface toolBoxUI, ToolBoxItem item, FSMirror.ProgressListener listener) {
        if (toolBoxUI != null) {
            toolBoxUI.startSynchronisation(item);
        }
        try {
            ArrayList<ToolBoxResource> requiredResources = item.getResources();
            long totalFileSizeForAllResources = 0L;
            for (ToolBoxResource requiredResource : requiredResources) {
                File sourceFile = requiredResource.getSourceFile();
                if (requiredResource.isDirectory()) {
                    totalFileSizeForAllResources += FileUtil.recursiveSize(sourceFile);
                    continue;
                }
                totalFileSizeForAllResources += requiredResource.getSize();
            }
            if (listener != null) {
                listener.totalSize(totalFileSizeForAllResources);
            }
            LocalFS localFS = new LocalFS();
            FSMirror mirrorer = new FSMirror(FSMirror.IGNORE_HIDDEN_FILES, listener);
            for (ToolBoxResource requiredResource : requiredResources) {
                if (listener.cancelled()) {
                    return;
                }
                File sourceFile = requiredResource.getSourceFile();
                if (!sourceFile.exists()) continue;
                long offset = requiredResource.getOffset();
                long size = requiredResource.getSize();
                GFile sourceGFile = LocalFS.getFile(sourceFile);
                File targetFile = ToolBoxConstants.getResourceFile(item.getID(), requiredResource.getID());
                GFile targetGFile = new GFile(targetFile.getPath(), targetFile.getName(), sourceFile.lastModified(), targetFile.length(), sourceFile.isDirectory(), sourceFile.isHidden());
                mirrorer.mirror(localFS, sourceGFile, offset, size, serverFS, targetGFile);
                if (listener.cancelled()) {
                    return;
                }
                if (!sourceFile.isDirectory()) continue;
                File catalogueFile = new File(sourceFile, requiredResource.getID() + ".catalogue");
                try {
                    StringBuffer buffer = new StringBuffer();
                    File[] sourceFiles = sourceFile.listFiles();
                    if (sourceFiles != null) {
                        for (File f : sourceFiles) {
                            ToolBoxConstants.addFilesToList(f, "", buffer);
                        }
                    }
                    try {
                        FileUtil.writeFileAsStringUTF8(catalogueFile, buffer.toString());
                        GFile catalogueGFile = serverFS.isWindowsFS() ? new GFile(targetGFile.path() + "\\" + catalogueFile.getName(), catalogueFile.getName(), catalogueFile.lastModified(), catalogueFile.length(), catalogueFile.isDirectory(), catalogueFile.isHidden()) : new GFile(targetGFile.path() + "/" + catalogueFile.getName(), catalogueFile.getName(), catalogueFile.lastModified(), catalogueFile.length(), catalogueFile.isDirectory(), catalogueFile.isHidden());
                        FSUtils.upload(serverFS, catalogueFile, catalogueGFile);
                    }
                    finally {
                        catalogueFile.delete();
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (toolBoxUI != null) {
                toolBoxUI.endSynchronisation(item);
            }
        }
    }

    private static void addFilesToList(File currentFileOrFolder, String pathToFolder, StringBuffer buffer) {
        if (currentFileOrFolder.isDirectory()) {
            File[] files = currentFileOrFolder.listFiles();
            if (files != null) {
                for (File f : files) {
                    ToolBoxConstants.addFilesToList(f, pathToFolder + currentFileOrFolder.getName() + "/", buffer);
                }
            }
        } else if (!currentFileOrFolder.isHidden()) {
            buffer.append(pathToFolder + currentFileOrFolder.getName() + "\t" + currentFileOrFolder.length() + "\n");
        }
    }
}

