/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.alerts;

import bcutil.BCUtil;
import com.aem.CentralDebugging;
import com.aem.sdesktop.util.Version;
import com.aem.shelp.common.PC;
import com.aem.shelp.proxy.alerts.AlertRegistryAPI;
import com.aem.shelp.proxy.alerts.AlertStateManager;
import com.aem.shelp.proxy.common.AlertClock;
import com.aem.shelp.proxy.types.Alert;
import com.aem.shelp.proxy.types.AlertAllocationListener;
import com.aem.shelp.proxy.types.AlertLocation;
import com.aem.shelp.proxy.types.LocatedAlert;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.proxy.types.MachineInfo;
import com.aem.shelp.proxy.types.ResourceContainer;
import com.aem.shelp.proxy.types.ServerEvent;
import com.aem.shelp.proxy.types.alertlocs.AllMachinesAloc;
import com.aem.shelp.proxy.types.alerts.BasicAlert;
import com.aem.shelp.proxy.types.alerts.ResourceSerialiser;
import com.aem.shelp.proxy.types.alerts.threshold.CPUThreshold;
import com.aem.shelp.util.ResourceContainerComparator;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import utils.encryption.aes.RijndaelDecryptionStream;
import utils.encryption.aes.RijndaelEncryptionStream;
import utils.files.AtomicFileOutputStream;
import utils.loggingframework.LoggingFramework;
import utils.message.Message;
import utils.message.MessageUtils;
import utils.stream.StreamUtils;
import utils.switches.Switches;

public class AlertRegistry
implements AlertRegistryAPI {
    static boolean TESTING = false;
    public static int CLOCK_EMPTY = -99;
    public static int CLOCK_RESET = 0;
    AlertClock clock = new AlertClock();
    private File DBDIR = new File("configuration", "alertsdb");
    private File ALERTSDB = new File(this.DBDIR, "alertsdb");
    private final Object map_LOCK = new Object();
    HashMap<String, ResourceContainer> all = new HashMap();
    long allocationRound = 0L;
    private Object machineCount_LOCK = new Object();
    private int alertedMachineCount = 0;
    private final Object THREAD_LOCK = new Object();
    private SaveThread saveThread;

    public void saveChanges(LocatedAlert la) {
        la.getAlert().updateModifiedClock(this);
        this.scheduleSaveInTenSeconds();
    }

    @Override
    public AlertClock getClock() {
        return this.clock;
    }

    public Object getMapLOCK() {
        return this.map_LOCK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAll() {
        Object object = this.map_LOCK;
        synchronized (object) {
            this.all.clear();
            LoggingFramework.INSTANCE.getLogMappingRepository().clear();
        }
    }

    public void setAlertDbDir(File dbDir) {
        this.DBDIR = dbDir;
        this.ALERTSDB = new File(this.DBDIR, "alertsdb");
        this.DBDIR.mkdirs();
        if (this.ALERTSDB.isDirectory()) {
            this.ALERTSDB.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(ResourceContainer la) {
        Object object = this.map_LOCK;
        synchronized (object) {
            if (CentralDebugging.ALERT_REGISTRY) {
                System.out.println("[AlertRegistry] Removing " + la.getName());
            }
            this.all.remove(la.getID());
            if (la instanceof ServerEvent) {
                LoggingFramework.INSTANCE.getLogMappingRepository().removeMapping((ServerEvent)la);
            }
            this.scheduleSaveInTenSeconds();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(ResourceContainer rc, boolean isTriggerOrReset) {
        Object object = this.map_LOCK;
        synchronized (object) {
            if (CentralDebugging.ALERT_REGISTRY) {
                System.out.println("[AlertRegistry] Updating " + rc.getName());
            }
            if (rc instanceof LocatedAlert) {
                LocatedAlert mine;
                LocatedAlert la = (LocatedAlert)rc;
                if (!isTriggerOrReset) {
                    la.getAlert().updateModifiedClock(this);
                }
                if ((mine = (LocatedAlert)this.all.get(la.getID())) != null) {
                    la.setTriggeredMachines(mine.getTriggeredMachines());
                }
            }
            this.all.put(rc.getID(), rc);
            if (rc instanceof ServerEvent) {
                LoggingFramework.INSTANCE.getLogMappingRepository().update((ServerEvent)rc);
            }
            this.scheduleSaveInTenSeconds();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateState(LocatedAlert la) {
        Object object = this.map_LOCK;
        synchronized (object) {
            if (CentralDebugging.ALERT_REGISTRY) {
                System.out.println("[AlertRegistry] Updating " + la.getName());
            }
            this.all.put(la.getID(), la);
            this.scheduleSaveInTenSeconds();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(ResourceContainer la) {
        Object object = this.map_LOCK;
        synchronized (object) {
            if (CentralDebugging.ALERT_REGISTRY) {
                System.out.println("[AlertRegistry] Adding " + la.getName());
            }
            if (la instanceof LocatedAlert && !Alert.isReadOnly()) {
                ((LocatedAlert)la).getAlert().updateModifiedClock(this);
            }
            this.all.put(la.getID(), la);
            if (la instanceof ServerEvent) {
                LoggingFramework.INSTANCE.getLogMappingRepository().addMapping((ServerEvent)la);
            }
            this.scheduleSaveInTenSeconds();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceContainer get(String id) {
        Object object = this.map_LOCK;
        synchronized (object) {
            return this.all.get(id);
        }
    }

    public ArrayList<ResourceContainer> getAll() {
        return this.getAll(0L);
    }

    public int size() {
        return this.all.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ResourceContainer> getAll(long logicalClock) {
        Object[] alerts;
        if (logicalClock > this.clock.getCurrentClock()) {
            if (CentralDebugging.PX_ALERT_ALLOCATIONS) {
                System.out.println("[AlertsDB] ***Warning: clock requested was later than ours");
            }
            return new ArrayList<ResourceContainer>();
        }
        if (logicalClock == this.clock.getCurrentClock()) {
            return new ArrayList<ResourceContainer>();
        }
        if (CentralDebugging.PX_ALERT_LIST) {
            System.out.println("[AlertsList] Total " + this.all.size());
        }
        Object object = this.map_LOCK;
        synchronized (object) {
            alerts = this.all.values().toArray();
        }
        ArrayList<ResourceContainer> list = new ArrayList<ResourceContainer>();
        for (Object o : alerts) {
            ResourceContainer rc = (ResourceContainer)o;
            if (CentralDebugging.PX_ALERT_LIST) {
                System.out.println("[AlertsList] Checking " + rc + "...");
            }
            if (rc instanceof LocatedAlert) {
                LocatedAlert la = (LocatedAlert)rc;
                if (la.getAlert().getModifiedClock() < logicalClock) continue;
                if (CentralDebugging.PX_ALERT_LIST) {
                    System.out.println("[AlertsList] Adding");
                }
                list.add(la);
                continue;
            }
            list.add(rc);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAlertedMachineCount() {
        Object object = this.machineCount_LOCK;
        synchronized (object) {
            return this.alertedMachineCount;
        }
    }

    public void dumpAlertState(AlertAllocationListener listener, String machineID) {
        this.runAllocations(listener, true, machineID);
    }

    public HashMap<String, Integer> runAllocations(AlertAllocationListener listener) {
        return this.runAllocations(listener, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap<String, Integer> runAllocations(AlertAllocationListener listener, boolean dumpOnly, String dumpMachineID) {
        String prefix = "AlertsDB";
        if (dumpOnly) {
            prefix = "StateDump";
        }
        if (CentralDebugging.PX_ALERT_ALLOCATIONS) {
            System.out.println("[" + prefix + "] Checking for Alert updates to be sent out to machines");
        }
        long modClock = this.clock.getCurrentClock();
        ++this.allocationRound;
        Machine[] allMachines = listener.getMachineRegistry().getMachineNamesAdvanced();
        ArrayList<Machine> online = new ArrayList<Machine>();
        for (Machine machine : allMachines) {
            if (!dumpOnly && (!machine.isAvailable() || !machine.supportsAlerts())) continue;
            online.add(machine);
        }
        if (CentralDebugging.PX_ALERT_ALLOCATIONS) {
            System.out.println("[" + prefix + "] Allocation round " + this.allocationRound + ", " + online.size() + " online machines have alerts");
        }
        HashMap<String, String> licensingMap = new HashMap<String, String>();
        HashMap<String, MachineAlerts> machineAlertsMap = new HashMap<String, MachineAlerts>();
        ArrayList<ResourceContainer> big = this.getAll();
        Collections.sort(big, new ResourceContainerComparator());
        HashMap<String, Integer> targetCounts = new HashMap<String, Integer>();
        int total = big.size();
        int inactive = 0;
        int serverside = 0;
        int active = 0;
        if (dumpOnly || CentralDebugging.PX_ALERT_ALLOCATIONS) {
            System.out.println("[" + prefix + "] " + total + " alerts or events present in total");
        }
        for (ResourceContainer rc : big) {
            if (rc instanceof LocatedAlert) {
                LocatedAlert alert = (LocatedAlert)rc;
                AlertLocation aloc = alert.getLocation();
                if (aloc.isServerLocated()) {
                    if (CentralDebugging.PX_ALERT_ALLOCATIONS_ADDS) {
                        System.out.println("[" + prefix + "] " + alert + " is server located");
                    }
                    ++serverside;
                    continue;
                }
                if (!alert.isActive()) {
                    if (CentralDebugging.PX_ALERT_ALLOCATIONS_ADDS) {
                        System.out.println("[" + prefix + "] " + alert + " is inactive");
                    }
                    ++inactive;
                    AlertStateManager.verifyState(listener, alert, false);
                    continue;
                }
                String[] machines = alert.getLocation().getTargetMachines(listener.getMachineRegistry(), online, this.allocationRound);
                targetCounts.put(alert.getID(), machines.length);
                if (dumpOnly) {
                    System.out.println("[" + prefix + "] " + alert + " (" + alert.getID() + ") targets " + machines.length + " machines - " + alert.getAlert());
                } else if (CentralDebugging.PX_ALERT_ALLOCATIONS) {
                    System.out.println("[" + prefix + "] " + alert + " (" + alert.getID() + ") targets " + machines.length + " machines");
                }
                ++active;
                long newsha = 0L;
                long oldsha = 0L;
                if (machines.length > 0) {
                    if (CentralDebugging.PX_ALERT_HASHES) {
                        System.out.println("[AlertsHash] Hashing: id=" + alert.getAlert().getID() + " clock=" + alert.getAlert().getModifiedClock());
                    }
                    try {
                        Message hashy = new Message();
                        alert.getAlert().toMessage(hashy);
                        if (CentralDebugging.PX_ALERT_HASHES) {
                            System.out.println("[AlertsHash] Hash message: " + hashy);
                        }
                        newsha = BCUtil.getPartialSha256of(MessageUtils.messageToBytes(hashy));
                        oldsha = BCUtil.getPartialSha256of(alert.getAlert().getID().getBytes("ASCII"));
                        if (CentralDebugging.PX_ALERT_HASHES) {
                            System.out.println("[AlertsHash] " + alert + " hash (+ID:" + alert.getAlert().getID() + ") is new=" + newsha + " old=" + oldsha);
                        }
                    }
                    catch (UnsupportedEncodingException hashy) {
                        // empty catch block
                    }
                }
                HashMap<String, String> unmatchedTriggers = new HashMap<String, String>();
                for (String id : alert.getTriggeredMachines()) {
                    unmatchedTriggers.put(id, id);
                }
                for (String machineID : machines) {
                    long machineModtime;
                    MachineAlerts maclerts;
                    unmatchedTriggers.remove(machineID);
                    if (alert.isActive()) {
                        licensingMap.put(machineID, machineID);
                    }
                    if ((maclerts = (MachineAlerts)machineAlertsMap.get(machineID)) == null) {
                        maclerts = new MachineAlerts(listener.getMachineRegistry().getMachineByID(machineID));
                        machineAlertsMap.put(machineID, maclerts);
                    }
                    String machineBuild = maclerts.machine.getBuild();
                    boolean useNewHash = false;
                    if (machineBuild != null && Version.isBuildNewer(Version.BUILD_USES_NEW_ALERTS_HASHING, machineBuild)) {
                        useNewHash = true;
                    }
                    maclerts.allhash = useNewHash ? (maclerts.allhash += newsha) : (maclerts.allhash += oldsha);
                    if (CentralDebugging.PX_ALERT_HASHES) {
                        System.out.println("[" + prefix + "] Machine " + maclerts.machine.getName().getName() + " (" + machineID + ") hash is now " + maclerts.allhash);
                    }
                    if ((machineModtime = listener.getAlertModtimeForMachine(machineID)) > modClock) {
                        System.out.println("[" + prefix + "] Resetting alert clock for " + machineID);
                        machineModtime = 0L;
                        listener.resetAlertModtimeForMachine(machineID);
                    }
                    long alertModtime = alert.getAlert().getModifiedClock();
                    maclerts.machineModtime = machineModtime;
                    maclerts.allAlerts.add(alert.getAlert());
                    if (alertModtime >= machineModtime || machineModtime > modClock) {
                        maclerts.alertsToUpdate.add(alert.getAlert());
                        if (!CentralDebugging.PX_ALERT_ALLOCATIONS_ADDS) continue;
                        System.out.println("[" + prefix + "] Adding " + alert + " to machine ID " + machineID);
                        continue;
                    }
                    if (!CentralDebugging.PX_ALERT_ALLOCATIONS_ADDS) continue;
                    System.out.println("[" + prefix + "] Not adding " + alert + " to " + machineID + " (AlertMod=" + alertModtime + ", MachineMod=" + machineModtime + ", RegistryClock=" + modClock + ")");
                }
                if (unmatchedTriggers.size() <= 0) continue;
                for (String idRemove : unmatchedTriggers.values()) {
                    AlertStateManager.setAlertReset(alert.getID(), idRemove, listener, "alert lists machine as triggered but alert does not match machine");
                }
                this.updateState(alert);
                listener.pushUpdatedAlertState(alert);
                continue;
            }
            ++serverside;
        }
        if (dumpOnly || CentralDebugging.PX_ALERT_ALLOCATIONS) {
            System.out.println("[" + prefix + "] " + active + "/" + total + " alerts are active (see above)");
        }
        if (dumpOnly || CentralDebugging.PX_ALERT_ALLOCATIONS) {
            System.out.println("[" + prefix + "] " + inactive + "/" + total + " alerts are inactive");
        }
        if (dumpOnly || CentralDebugging.PX_ALERT_ALLOCATIONS) {
            System.out.println("[" + prefix + "] " + serverside + "/" + total + " alerts are server side");
        }
        Object object = this.machineCount_LOCK;
        synchronized (object) {
            this.alertedMachineCount = licensingMap.size();
        }
        HashMap<String, Machine> sentStructuralReset = new HashMap<String, Machine>();
        for (String machineID : machineAlertsMap.keySet()) {
            boolean fullList;
            MachineAlerts maclerts = (MachineAlerts)machineAlertsMap.get(machineID);
            MachineInfo macinfo = maclerts.machine.getMachineInfo();
            boolean bl = fullList = maclerts.machineModtime == 0L;
            if (dumpOnly && machineID.equalsIgnoreCase(dumpMachineID) || CentralDebugging.PX_ALERT_ALLOCATIONS) {
                System.out.println("[" + prefix + "] Machine " + maclerts.machine.getName() + " " + machineID + " (aclock=" + maclerts.machineModtime + ") has " + maclerts.allAlerts.size() + " alerts total, " + maclerts.alertsToUpdate.size() + " to be updated");
                System.out.println("    Registry Clock =" + modClock);
                System.out.println("    Machine Clock =" + maclerts.machineModtime);
                System.out.println("    Our Machine Reg Hash =" + maclerts.allhash);
                ArrayList<String> triggered = macinfo.getTriggeredAlertIDs();
                System.out.println("    Triggered Alerts (n=" + triggered.size() + ")");
                for (String id : triggered) {
                    ResourceContainer rc = this.get(id);
                    if (rc instanceof LocatedAlert) {
                        LocatedAlert la = (LocatedAlert)rc;
                        ArrayList<String> alMachines = la.getTriggeredMachines();
                        boolean machineTriggered = false;
                        for (String alMachineID : alMachines) {
                            if (!alMachineID.equals(machineID)) continue;
                            machineTriggered = true;
                        }
                        System.out.println("      " + la.getAlert().getName() + " (" + id + ") (" + (machineTriggered ? "alert agrees" : "WARNING alert does NOT show this machine as triggered") + ")");
                        if (machineTriggered) continue;
                        for (String alMachineID : alMachines) {
                            Machine triggeredMachine = listener.getMachineRegistry().getMachineByID(alMachineID);
                            System.out.println("        Triggered Machine: " + triggeredMachine.getName().getName() + " (" + alMachineID + ")");
                        }
                        continue;
                    }
                    System.out.println("      " + id + " " + rc);
                }
                if (macinfo.haveAlertRegistryHash()) {
                    System.out.println("    Remote Machine Reg Hash =" + macinfo.getAlertRegistryHash());
                } else {
                    System.out.println("    Remote Machine Reg Hash =(none,0)");
                }
                for (Alert alert : maclerts.alertsToUpdate) {
                    System.out.println(alert.toString(4));
                }
            }
            if (maclerts.alertsToUpdate.size() > 0) {
                if (dumpOnly) continue;
                listener.pushAlertsToMachine(machineID, fullList, modClock, maclerts.allhash, maclerts.alertsToUpdate);
                continue;
            }
            if (!macinfo.haveAlertRegistryHash() || maclerts.allhash == macinfo.getAlertRegistryHash()) continue;
            if (dumpOnly || CentralDebugging.PX_ALERT_ALLOCATIONS) {
                System.out.println("[" + prefix + "] " + active + "/" + total + " alerts are active (see above)");
            }
            if (dumpOnly) continue;
            if (macinfo.transientAlertStructureCount < 12) {
                listener.pushAlertStructureReset(machineID, maclerts.allAlerts);
                if (dumpOnly || CentralDebugging.PX_ALERT_ALLOCATIONS) {
                    System.out.println("[" + prefix + "] Sending full alert structure to " + maclerts.machine.getName() + " n=" + macinfo.transientAlertStructureCount);
                }
                sentStructuralReset.put(machineID, maclerts.machine);
                ++macinfo.transientAlertStructureCount;
                continue;
            }
            if (dumpOnly || CentralDebugging.PX_ALERT_ALLOCATIONS) {
                System.out.println("[" + prefix + "] Requesting full alert registry reset for " + maclerts.machine.getName());
            }
            listener.resetAlertModtimeForMachine(machineID);
        }
        ArrayList<Alert> empty = new ArrayList<Alert>();
        for (Machine machine : online) {
            String machineID = machine.getID();
            if (dumpOnly && !machineID.equalsIgnoreCase(dumpMachineID)) continue;
            if (!sentStructuralReset.containsKey(machineID)) {
                machine.getMachineInfo().transientAlertStructureCount = 0;
            }
            if (machineAlertsMap.containsKey(machineID)) continue;
            long machineModtime = listener.getAlertModtimeForMachine(machineID);
            try {
                MachineInfo info = listener.getMachineRegistry().getMachineInfo(machineID);
                if (info.hasTriggeredAlerts()) {
                    ArrayList<String> alertIDs = info.getTriggeredAlertIDs();
                    for (String alertID : alertIDs) {
                        AlertStateManager.setAlertReset(alertID, machineID, listener, "machine lists alert as triggered but no alerts match this machine");
                    }
                    if (!dumpOnly) {
                        listener.pushUpdatedMachineAlertState(machineID);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (machineModtime != (long)CLOCK_EMPTY) {
                if (dumpOnly || CentralDebugging.PX_ALERT_ALLOCATIONS) {
                    System.out.println("[" + prefix + "] Machine " + machine.getName() + " (" + machineID + ") (clock=" + machineModtime + ") has no alerts and needs to be updated");
                }
                if (dumpOnly) continue;
                listener.pushAlertsToMachine(machineID, true, CLOCK_EMPTY, 0L, empty);
                continue;
            }
            if (!dumpOnly && !CentralDebugging.PX_ALERT_ALLOCATIONS) continue;
            System.out.println("[" + prefix + "] Machine " + machine.getName() + " (" + machineID + ") (clock=" + machineModtime + ") has no alerts, is up to date");
        }
        return targetCounts;
    }

    @Override
    public void scheduleSaveInTenSeconds() {
        this.initSaveThread();
        this.saveThread.requestSave();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSaveThread() {
        Object object = this.THREAD_LOCK;
        synchronized (object) {
            if (this.saveThread == null) {
                this.saveThread = new SaveThread();
                this.saveThread.start();
            }
        }
    }

    private byte[] saveToBytes() {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        this.saveAllToDisk(bout, false);
        return bout.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveAllToDisk() {
        Object object = this.map_LOCK;
        synchronized (object) {
            if (this.all == null) {
                return;
            }
            if (this.ALERTSDB.isDirectory()) {
                this.ALERTSDB.delete();
            }
            if (!this.DBDIR.exists()) {
                this.DBDIR.mkdirs();
            }
            try {
                RijndaelEncryptionStream fout = new RijndaelEncryptionStream((OutputStream)new BufferedOutputStream(new AtomicFileOutputStream(this.ALERTSDB)), "s73732163891840530242014gi14y980---4377sdhai20000ffuhher8295678235ibdjhsv bbnnbdieai20000ffuhher[pq;q,zmznbvy");
                this.saveAllToDisk(fout, true);
            }
            catch (IOException ex) {
                System.out.println("[AlertsDB] WARNING: Unable to save alerts database to file.");
                ex.printStackTrace();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveAllToDisk(OutputStream out, boolean closeOnFinish) {
        long T = System.currentTimeMillis();
        Object object = this.map_LOCK;
        synchronized (object) {
            long A = System.currentTimeMillis() - T;
            long B = -1L;
            long C = -1L;
            if (this.all == null) {
                return;
            }
            try {
                B = System.currentTimeMillis() - T;
                try {
                    Iterator<String> iterator = this.clock.clock_LOCK;
                    synchronized (iterator) {
                        if (Switches.SH_bumpAlertRegistryClockOnSave && !Alert.isReadOnly()) {
                            StreamUtils.writeLong(out, this.clock.globalClock + 100000L);
                        } else {
                            StreamUtils.writeLong(out, this.clock.globalClock);
                        }
                    }
                    StreamUtils.writeInt(out, this.all.size());
                    for (String id : this.all.keySet()) {
                        ResourceContainer ra = this.all.get(id);
                        if (ra == null) continue;
                        Message m = ra.toMessage();
                        if (CentralDebugging.PX_ALERT_SAVING_LOADING) {
                            System.out.println("[Alerts] Saved alert:\n" + m.toPretty(PC.REFS));
                        }
                        MessageUtils.writeMessageNoFlush(out, m);
                    }
                }
                finally {
                    if (closeOnFinish) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable) {}
                    }
                }
            }
            catch (IOException ex) {
                System.out.println("[AlertsDB] WARNING: Unable to save alerts database to file.");
                ex.printStackTrace();
                return;
            }
            C = System.currentTimeMillis() - T;
            if (!CentralDebugging.PX_ALERT_TEST_SAVING) {
                System.out.println("[AlertsDB] Saved " + A + "ms, " + B + "ms, " + C + "ms");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAllFromDisk() {
        Object object = this.map_LOCK;
        synchronized (object) {
            boolean resaveRequired = false;
            if (this.all == null) {
                this.all = new HashMap();
            } else {
                this.clearAll();
            }
            if (this.DBDIR.exists() && this.ALERTSDB.exists()) {
                try {
                    long start = System.currentTimeMillis();
                    AtomicFileOutputStream.prepareForReading(this.ALERTSDB);
                    RijndaelDecryptionStream fin = new RijndaelDecryptionStream((InputStream)new BufferedInputStream(new FileInputStream(this.ALERTSDB)), "s73732163891840530242014gi14y980---4377sdhai20000ffuhher8295678235ibdjhsv bbnnbdieai20000ffuhher[pq;q,zmznbvy");
                    try {
                        Object object2 = this.clock.clock_LOCK;
                        synchronized (object2) {
                            this.clock.globalClock = StreamUtils.readLong(fin);
                            System.out.println("[AlertsDB] Logical Clock " + this.clock.globalClock);
                        }
                        int size = StreamUtils.readInt(fin);
                        for (int i = 0; i < size; ++i) {
                            Message m = MessageUtils.readMessage(fin);
                            try {
                                ResourceContainer rc = ResourceSerialiser.resourceContainerFromMessage(m);
                                if (CentralDebugging.PX_ALERT_SAVING_LOADING) {
                                    System.out.println("[Alerts] Loaded alert:\n" + m.toPretty(PC.REFS));
                                }
                                if (Switches.SH_1531_ALERT_ID_DUPLICATES_FIX && rc instanceof LocatedAlert) {
                                    LocatedAlert la = (LocatedAlert)rc;
                                    boolean saveRequired = AlertRegistry.sh1531_ensureAlertHasUniqueIDs(la);
                                    resaveRequired = resaveRequired || saveRequired;
                                }
                                this.all.put(rc.getID(), rc);
                                if (!(rc instanceof ServerEvent)) continue;
                                LoggingFramework.INSTANCE.getLogMappingRepository().addMapping((ServerEvent)rc);
                                continue;
                            }
                            catch (Exception x) {
                                System.out.println("[Alerts] ***Warning, failed to load alert " + m);
                            }
                        }
                        System.out.println("[AlertsDB] Loaded " + size + " alerts. Took " + (System.currentTimeMillis() - start) + "ms");
                    }
                    finally {
                        try {
                            fin.close();
                        }
                        catch (Throwable throwable) {}
                    }
                }
                catch (IOException ex) {
                    System.out.println("[AlertsDB] WARNING: Unable to process alerts database file, even though it exists (" + this.ALERTSDB.getAbsolutePath() + ")");
                    ex.printStackTrace();
                }
            }
            if (resaveRequired) {
                System.out.println("[AlertRegistry] A resave has been requested. Perfoming the save now.");
                this.saveAllToDisk();
            }
        }
        System.out.println("[AlertsDB] " + this.all.size() + " alerts loaded.");
        if (TESTING) {
            this.all.clear();
            CPUThreshold cpuHigh = new CPUThreshold();
            cpuHigh.setName("CPU High");
            cpuHigh.setTriggerPercent(75.0);
            cpuHigh.setTriggerOnOver(true);
            CPUThreshold cpuLow = new CPUThreshold();
            cpuLow.setName("CPU Low");
            cpuLow.setTriggerOnOver(false);
            cpuLow.setTriggerPercent(50.0);
            BasicAlert simple = new BasicAlert();
            simple.setName("CPU Alert");
            this.add(new LocatedAlert(cpuHigh, new AllMachinesAloc()));
            this.add(new LocatedAlert(cpuLow, new AllMachinesAloc()));
            this.add(new LocatedAlert(simple, new AllMachinesAloc()));
        }
    }

    public static boolean sh1531_ensureAlertHasUniqueIDs(LocatedAlert la) {
        boolean changed = false;
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(la.getID());
        if (la.getAlert() instanceof BasicAlert) {
            BasicAlert ba = (BasicAlert)la.getAlert();
            ArrayList<ArrayList<Alert>> triggers = ba.getTriggers();
            for (ArrayList<Alert> alertList : triggers) {
                for (int i = 0; i < alertList.size(); ++i) {
                    Alert a = alertList.get(i);
                    if (ids.contains(a.getID())) {
                        System.out.println("[AlertRegistry] [SH1531] Warning: duplicate IDs found");
                        a = a.cloneWithNewID();
                        alertList.set(i, a);
                        changed = true;
                    }
                    ids.add(a.getID());
                }
            }
            ArrayList<ArrayList<Alert>> resets = ba.getResets();
            for (ArrayList<Alert> alertList : resets) {
                for (int i = 0; i < alertList.size(); ++i) {
                    Alert a = alertList.get(i);
                    if (ids.contains(a.getID())) {
                        System.out.println("[AlertRegistry] [SH1531] Warning: duplicate IDs found");
                        a = a.cloneWithNewID();
                        alertList.set(i, a);
                        changed = true;
                    }
                    ids.add(a.getID());
                }
            }
        }
        return changed;
    }

    private class SaveThread
    extends Thread {
        private boolean requestSave;

        public SaveThread() {
            super("AlertsDB - Save Thread");
            this.requestSave = false;
            this.setDaemon(true);
        }

        public void requestSave() {
            this.requestSave = true;
        }

        @Override
        public void run() {
            byte[] currentData = AlertRegistry.this.saveToBytes();
            while (true) {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                byte[] latestData = AlertRegistry.this.saveToBytes();
                if (CentralDebugging.PX_ALERT_TEST_SAVING) {
                    long T = System.currentTimeMillis() + 500L;
                    long N = 0L;
                    while (System.currentTimeMillis() < T) {
                        AlertRegistry.this.saveToBytes();
                        ++N;
                    }
                    System.out.println("[AlertsDB] " + N * 2L + " alert registry saves per second");
                }
                if (Arrays.equals(currentData, latestData)) continue;
                currentData = latestData;
                this.requestSave = false;
                AlertRegistry.this.saveAllToDisk();
            }
        }
    }

    class MachineAlerts {
        long machineModtime = 0L;
        ArrayList<Alert> alertsToUpdate = new ArrayList();
        ArrayList<Alert> allAlerts = new ArrayList();
        long allhash;
        Machine machine;

        public MachineAlerts(Machine machine) {
            this.machine = machine;
        }
    }
}

