/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.adminclient;

import bcutil.BCUtil;
import com.aem.BuildDateUtil;
import com.aem.nodelink.NodeLink;
import com.aem.nodelink.NodeLinkStatusListener;
import com.aem.shelp.common.PC;
import com.aem.shelp.tech.admin.enterprise.PeerConfig;
import com.aem.shelp.util.BCUtilMessenger;
import com.aem.shelp.util.SHelpNodelinkConnector;
import java.io.IOException;
import java.io.InputStream;
import utils.message.Message;
import utils.stream.StreamUtils;

public class AdminClient
implements NodeLinkStatusListener,
PC {
    public static int ADMIN_CLIENT_PROTOCOL_VERSION = 1;
    NodeLink sock;
    BCUtil bcu;
    int serverVersion;

    public AdminClient(String hostname, int port, String adminPass) throws Exception {
        this.sock = SHelpNodelinkConnector.getConnection(hostname, port, this);
        StreamUtils.writeLong(this.sock.getOutputStream(), BuildDateUtil.getAdminClientMagicBuildDate());
        this.sock.getOutputStream().flush();
        InputStream in = this.sock.getInputStream();
        try {
            long remoteMagic = StreamUtils.readLong(in);
            if (BuildDateUtil.getAdminClientMagicBuildDate() != remoteMagic) {
                System.out.println(BuildDateUtil.getAdminClientMagicBuildDate() + " != " + remoteMagic);
                throw new Exception();
            }
        }
        catch (Exception e) {
            this.sock.stop("Server does not support Peer Admin services, may be too old");
            throw new IOException("Server does not support Peer Admin services, may be too old");
        }
        this.bcu = new BCUtil();
        this.bcu.setValidHashRequired(false);
        this.bcu.handshake(this.sock.getInputStream(), this.sock.getOutputStream(), true, null);
        System.out.println("[AdminClient] Handshake done");
        Message login = new Message(5002000);
        login.append(adminPass);
        BCUtilMessenger.writeMsg(this.bcu, this.sock.getOutputStream(), login);
        this.sock.getOutputStream().flush();
        int success = StreamUtils.readInt(this.sock.getInputStream());
        if (success != 1) {
            this.sock.stop("AdminClient login failed");
            throw new Exception("AdminClient login failed");
        }
        this.serverVersion = StreamUtils.readInt(this.sock.getInputStream());
    }

    public String getPubkeyHashFromConnect() {
        return this.bcu.getSavedPublicKeyAuthHash();
    }

    public byte[] getServerKeysDat() throws IOException {
        Message m = new Message(5008000);
        BCUtilMessenger.writeMsg(this.bcu, this.sock.getOutputStream(), m);
        this.sock.getOutputStream().flush();
        return StreamUtils.readNBytes(this.sock.getInputStream(), 10000000);
    }

    public String getServerPeerName() throws IOException {
        Message m = new Message(5007000);
        BCUtilMessenger.writeMsg(this.bcu, this.sock.getOutputStream(), m);
        this.sock.getOutputStream().flush();
        String response = StreamUtils.readStringUTF8(this.sock.getInputStream());
        return response;
    }

    public void setUpPeer(PeerConfig config) throws IOException {
        Message m = new Message(5003000);
        m.append(config.toMessage());
        BCUtilMessenger.writeMsg(this.bcu, this.sock.getOutputStream(), m);
        this.sock.getOutputStream().flush();
        int response = StreamUtils.readInt(this.sock.getInputStream());
    }

    public void reloadPeers() throws IOException {
        Message m = new Message(5005000);
        BCUtilMessenger.writeMsg(this.bcu, this.sock.getOutputStream(), m);
        this.sock.getOutputStream().flush();
    }

    public void shutdown() {
        try {
            Message m = new Message(5001000);
            BCUtilMessenger.writeMsg(this.bcu, this.sock.getOutputStream(), m);
            this.sock.getOutputStream().flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Thread.sleep(5000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.sock.stop("AdminClient shut down as requested");
    }

    @Override
    public void linkDown(NodeLink link, Throwable reason) {
    }

    @Override
    public void linkOK(NodeLink link) {
    }

    @Override
    public void linkDead(NodeLink link, String reason) {
    }
}

